// Users.cpp : implementation file
//

#include "stdafx.h"
#include "AspNTUser.h"
#include "Users.h"
#include "User.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUsers

IMPLEMENT_DYNCREATE(CUsers, CCmdTarget)

CUsers::CUsers()
{
	EnableAutomation();
//	LoadAllUsers();
}

CUsers::~CUsers()
{
}

void CUsers::RemoveAll()
{
	LPDISPATCH pDisp;
	int nSize, i;

	nSize = m_ptrUsers.GetSize();
	for( i = 0; i < nSize; i++ )
	{
		pDisp = (LPDISPATCH)m_ptrUsers.GetAt(i);
		pDisp->Release();
	}

	m_ptrUsers.RemoveAll();
}

void CUsers::OnFinalRelease()
{
	RemoveAll();
	CCmdTarget::OnFinalRelease();
}

long CUsers::LoadUsersForGroup( CString strName )
{
	LPWSTR lpszPrimaryDC = NULL;
	DWORD dwCount, dw2, dwResume = 0;
	NET_API_STATUS res;
	USES_CONVERSION;

	if( m_bIsLocal )
	{
		lpszPrimaryDC = T2OLE( m_strServer );
		
		// First determine local server name to trim it from the user name
		CString strLocalServer;
		SERVER_INFO_100 * si100;
		HandleError( ::NetServerGetInfo( NULL, 100, (LPBYTE *)&si100 ) );
		strLocalServer = (LPWSTR)si100->sv100_name;
		::NetApiBufferFree( si100 );
		
		LOCALGROUP_MEMBERS_INFO_2 * lgm;
		
		while( TRUE )
		{
			USES_CONVERSION;
			res = ::NetLocalGroupGetMembers( lpszPrimaryDC, T2OLE( strName ), 2, 
				(LPBYTE *)&lgm, 512, &dwCount, &dw2, &dwResume );

			if( res == ERROR_ACCESS_DENIED )
				THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

			for( UINT i = 0; i < dwCount; i++ )
			{	
				//if( lgm[i].lgrmi1_sidusage == SidTypeUser )
				{
					CUser * pUser = new CUser;
					pUser->m_strName = CString( lgm[i].lgrmi2_domainandname );
					if( CUser::ExtractDomain( pUser->m_strName ) == strLocalServer )
					{
						pUser->m_strName = CUser::ExtractName( pUser->m_strName );
					}
					pUser->m_bIsLocal = m_bIsLocal;
					pUser->m_strServer = m_strServer;
					pUser->m_strDomain = m_strDomain;

					// This may be a domain group, not a user. In this case do not call UserGetInfo
					if( lgm[i].lgrmi2_sidusage == SidTypeUser )
						pUser->GetInfo();
					
					LPDISPATCH pDisp = pUser->GetIDispatch( FALSE );
					m_ptrUsers.Add( pDisp );
				}
			}
			
			::NetApiBufferFree( lgm );
			if( res != ERROR_MORE_DATA )
				break;
		}		
	}
	else
	{
		GROUP_USERS_INFO_1 * gui;
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		
		while( TRUE )
		{
			USES_CONVERSION;
			res = ::NetGroupGetUsers( lpszPrimaryDC, T2OLE( strName ), 1, 
				(LPBYTE *)&gui, 512, &dwCount, &dw2, &dwResume );

			if( res == ERROR_ACCESS_DENIED )
				THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

			for( UINT i = 0; i < dwCount; i++ )
			{
				CUser * pUser = new CUser;
				pUser->m_strName = CString( gui[i].grui1_name );
				pUser->m_bIsLocal = m_bIsLocal;
				pUser->m_strServer = lpszPrimaryDC;
				pUser->m_strDomain = m_strDomain;
				pUser->GetInfo();
				
				LPDISPATCH pDisp = pUser->GetIDispatch( FALSE );
				m_ptrUsers.Add( pDisp );
			}

			::NetApiBufferFree( gui );
			if( res != ERROR_MORE_DATA )
				break;
		}	
		
		::NetApiBufferFree( lpszPrimaryDC );
	}

	return res;
}

void CUsers::LoadAllUsers()
{
	DWORD dwCount;
	NET_DISPLAY_USER * pUsers;

	RemoveAll();

	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;

	if( !m_bIsLocal )
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	else
		lpszPrimaryDC = T2OLE( m_strServer );
	
	// Load Users
	DWORD nIndex = 0;
	while( TRUE )
	{
		NET_API_STATUS res = ::NetQueryDisplayInformation( lpszPrimaryDC, 1,
			nIndex, 100, 512, &dwCount, (PVOID*)&pUsers );

		if( res == ERROR_ACCESS_DENIED )
			THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

		for( UINT i = 0; i < dwCount; i++ )
		{
			CUser * pUser = new CUser;
			pUser->m_strName = CString( pUsers[i].usri1_name );
			pUser->m_strServer = lpszPrimaryDC;
			pUser->m_strDomain = m_strDomain;
			pUser->m_bIsLocal = m_bIsLocal;
			pUser->GetInfo();
			
			LPDISPATCH pDisp = pUser->GetIDispatch( FALSE );
			m_ptrUsers.Add( pDisp );
		}
		
		nIndex = pUsers[dwCount-1].usri1_next_index;
		::NetApiBufferFree( pUsers );
		
		if( res != ERROR_MORE_DATA )
			break;
	}
	
	if( !m_bIsLocal )
		::NetApiBufferFree( lpszPrimaryDC );
}



BEGIN_MESSAGE_MAP(CUsers, CCmdTarget)
	//{{AFX_MSG_MAP(CUsers)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CUsers, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CUsers)
	DISP_PROPERTY_EX(CUsers, "Count", GetCount, SetCount, VT_I4)
	DISP_FUNCTION(CUsers, "Item", Item, VT_DISPATCH, VTS_VARIANT)
	DISP_DEFVALUE(CUsers, "Item")
	//}}AFX_DISPATCH_MAP
	DISP_PROPERTY_EX_ID(CUsers, "_NewEnum", DISPID_NEWENUM, _NewEnum, SetNotSupported, VT_UNKNOWN )
END_DISPATCH_MAP()

// Note: we add support for IID_IUsers to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D30E8DD0-65A8-11D1-9149-006008123235}
static const IID IID_IUsers =
{ 0xd30e8dd0, 0x65a8, 0x11d1, { 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35 } };

BEGIN_INTERFACE_MAP(CUsers, CCmdTarget)
	INTERFACE_PART(CUsers, IID_IUsers, Dispatch)
	INTERFACE_PART(CUsers, IID_IEnumVARIANT, EnumVARIANT)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUsers message handlers
IUnknown* CUsers::_NewEnum()
{
	m_xEnumVARIANT.m_nCurPos = 0;
	return GetIDispatch( TRUE );
}

CUsers::XEnumVARIANT::XEnumVARIANT()
{    
	m_nCurPos = 0;
}

STDMETHODIMP_(ULONG) CUsers::XEnumVARIANT::AddRef()
{   
    METHOD_PROLOGUE(CUsers, EnumVARIANT)
    return pThis->ExternalAddRef() ;
}   

STDMETHODIMP_(ULONG) CUsers::XEnumVARIANT::Release()
{   
    METHOD_PROLOGUE(CUsers, EnumVARIANT)
    return pThis->ExternalRelease() ;
}   

STDMETHODIMP CUsers::XEnumVARIANT::QueryInterface( REFIID iid, void FAR* FAR* ppvObj )
{   
    METHOD_PROLOGUE(CUsers, EnumVARIANT)
    return (HRESULT)pThis->ExternalQueryInterface( (void FAR*)&iid, ppvObj) ;
}   

// IEnumVARIANT::Next
// 
STDMETHODIMP CUsers::XEnumVARIANT::Next( ULONG celt, VARIANT FAR* rgvar, ULONG FAR* pceltFetched)
{
    METHOD_PROLOGUE(CUsers, EnumVARIANT)

    HRESULT hr;
    ULONG   l ;

    if (pceltFetched != NULL)
        *pceltFetched = 0;
    else if (celt > 1)
    {   
        return ResultFromScode( E_INVALIDARG ) ;   
    }

    for (l=0; l < celt; l++)
        VariantInit( &rgvar[l] ) ;

    // Retrieve the next celt elements.
    hr = NOERROR ;
	int i = 0;
    for (l = m_nCurPos ; m_nCurPos < pThis->m_ptrUsers.GetSize() && celt != 0 ; l++)
    {   
        LPDISPATCH pDisp = (LPDISPATCH)pThis->m_ptrUsers.GetAt(l);
        celt-- ;
        if (pDisp )
        {
            rgvar[i].vt = VT_DISPATCH ;
			pDisp->AddRef();
            rgvar[i].pdispVal = pDisp;
            if (pceltFetched != NULL)
                (*pceltFetched)++ ;

			m_nCurPos++;
			i++;
        }
        else 
            return ResultFromScode( E_UNEXPECTED ) ;
    }
    
    if (celt != 0)
       hr = ResultFromScode( S_FALSE ) ;

    return hr ;
}

// IEnumVARIANT::Skip
//
STDMETHODIMP CUsers::XEnumVARIANT::Skip(unsigned long celt) 
{
    METHOD_PROLOGUE(CUsers, EnumVARIANT)
    
	while (m_nCurPos < pThis->m_ptrUsers.GetSize() && celt--)
        m_nCurPos++;

    return (celt == 0 ? NOERROR : ResultFromScode( S_FALSE )) ;
}

STDMETHODIMP CUsers::XEnumVARIANT::Reset()
{
    METHOD_PROLOGUE(CUsers, EnumVARIANT)
	m_nCurPos = 0;
    return NOERROR ;
}

STDMETHODIMP CUsers::XEnumVARIANT::Clone(IEnumVARIANT FAR* FAR* ppenum) 
{
    METHOD_PROLOGUE(CUsers, EnumVARIANT)   
    CUsers* p = new CUsers ;
    if (p)
    {
        p->m_xEnumVARIANT.m_nCurPos = m_nCurPos ;
        return NOERROR ;    
    }
    else
        return ResultFromScode( E_OUTOFMEMORY ) ;
}

long CUsers::GetCount() 
{
	return m_ptrUsers.GetSize();
}

void CUsers::SetCount(long nNewValue) 
{
	SetNotSupported();
}

LPDISPATCH CUsers::Item(const VARIANT FAR& Index) 
{
	long nIndex = 0, i;
	if( Index.vt == VT_I4 )
		nIndex = Index.lVal;
	else
	if( Index.vt == VT_I2 )
		nIndex = Index.iVal;
	else
	if( Index.vt == (VT_I4 | VT_BYREF) )
		nIndex = *Index.plVal;
	else
	if( Index.vt == (VT_I2 | VT_BYREF) )
		nIndex = *Index.piVal;
	else
	if( Index.vt == VT_DISPATCH )
	{
		COleVariant v( Index );
		v.ChangeType( VT_BSTR, NULL );
		return Item( v );
	}
	else
	if( Index.vt == VT_BSTR || Index.vt == (VT_BSTR | VT_BYREF ) )
	{
		CString s;
		if( Index.vt & VT_BYREF )
			s = *Index.pbstrVal;
		else
			s = Index.bstrVal;
		for( i = 0; i < m_ptrUsers.GetSize(); i++ )
		{
			CUser * pUser = (CUser *)FromIDispatch( (LPDISPATCH)m_ptrUsers.GetAt( i ) );			
			if( pUser->m_strName.CompareNoCase( pUser->ExtractName( s ) ) == 0 )
			{
				nIndex = i + 1;
				break;
			}
		}
	}
	else
	if( Index.vt == (VT_VARIANT | VT_BYREF) )
	{
		return Item( *Index.pvarVal );
	}
	else
	{
		CString s;
		s.Format( "Invalid index type %lu (must be string or integer). Try using CStr or CInt.", Index.vt );
		THROW_EXCEPTION( _ERROR_UNKNOWNTYPE, s );
	}

		
	if( nIndex < 1 || nIndex > m_ptrUsers.GetSize() )
		return NULL;

	LPDISPATCH pDisp = (LPDISPATCH)m_ptrUsers.GetAt( nIndex - 1 );
	pDisp->AddRef();
	return pDisp; 
}
