// UserManager.cpp : implementation file
//

#include "stdafx.h"
#include "AspNTUser.h"
#include "Users.h"
#include "UserManager.h"
#include "User.h"
#include "Groups.h"
#include "Group.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUserManager

IMPLEMENT_DYNCREATE(CUserManager, CCmdTarget)

CUserManager::CUserManager()
{
	EnableAutomation();
	AfxOleLockApp();

	m_dtToday = COleDateTime::GetCurrentTime();
}

CUserManager::~CUserManager()
{
	AfxOleUnlockApp();
}

void CUserManager::OnFinalRelease()
{
	//::RevertToSelf();
	
	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CUserManager, CCmdTarget)
	//{{AFX_MSG_MAP(CUserManager)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CUserManager, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CUserManager)	
	DISP_PROPERTY_NOTIFY(CUserManager, "Server", m_strServer, OnServerChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUserManager, "Domain", m_strDomain, OnDomainChanged, VT_BSTR)
	DISP_PROPERTY_EX(CUserManager, "DomainController", GetDomainController, SetDomainController, VT_BSTR)
	DISP_FUNCTION( CUserManager, "AddUser", AddUser, VT_DISPATCH, VTS_BSTR VTS_BSTR VTS_BSTR )
	DISP_FUNCTION( CUserManager, "AddLocalUser", AddLocalUser, VT_DISPATCH, VTS_BSTR VTS_BSTR VTS_BSTR )
	DISP_FUNCTION(CUserManager, "DeleteUser", DeleteUser, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUserManager, "DeleteLocalUser", DeleteLocalUser, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUserManager, "AddGroup", AddGroup, VT_DISPATCH, VTS_BSTR VTS_BSTR)
	DISP_FUNCTION(CUserManager, "AddLocalGroup", AddLocalGroup, VT_DISPATCH, VTS_BSTR VTS_BSTR)
	DISP_FUNCTION(CUserManager, "DeleteGroup", DeleteGroup, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUserManager, "DeleteLocalGroup", DeleteLocalGroup, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUserManager, "LogonUser", LogonUser, VT_I4, VTS_BSTR VTS_BSTR VTS_BSTR)
	DISP_FUNCTION(CUserManager, "ChangePassword", ChangePassword, VT_I4, VTS_BSTR VTS_BSTR VTS_BSTR VTS_BSTR)
	DISP_FUNCTION(CUserManager, "RevertToSelf", RevertToSelf, VT_I4, VTS_NONE)
	DISP_FUNCTION(CUserManager, "GetUser", GetUser, VT_DISPATCH, VTS_BSTR VTS_VARIANT)
	DISP_FUNCTION(CUserManager, "AddUser2", AddUser2, VT_DISPATCH, VTS_BSTR VTS_BSTR VTS_BSTR)
	DISP_FUNCTION(CUserManager, "GetGroup", GetGroup, VT_DISPATCH, VTS_BSTR VTS_VARIANT)
	//}}AFX_DISPATCH_MAP
	DISP_PROPERTY_EX(CUserManager, "Users", GetUsers, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CUserManager, "LocalUsers", GetLocalUsers, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CUserManager, "Groups", GetGroups, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CUserManager, "LocalGroups", GetLocalGroups, SetNotSupported, VT_DISPATCH)
END_DISPATCH_MAP()

// Note: we add support for IID_IUserManager to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D30E8DC7-65A8-11D1-9149-006008123235}
static const IID IID_IUserManager =
{ 0xd30e8dc7, 0x65a8, 0x11d1, { 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35 } };

BEGIN_INTERFACE_MAP(CUserManager, CCmdTarget)
	INTERFACE_PART(CUserManager, IID_IUserManager, Dispatch)
END_INTERFACE_MAP()

// {D30E8DC8-65A8-11D1-9149-006008123235}
IMPLEMENT_OLECREATE(CUserManager, "Persits.UserManager.1", 0xd30e8dc8, 0x65a8, 0x11d1, 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35)

/////////////////////////////////////////////////////////////////////////////
// CUserManager message handlers
LPDISPATCH CUserManager::GetUsers()
{
	CheckExpiration();

	CUsers * pUsers = new CUsers();
	pUsers->m_bIsLocal = FALSE;
	pUsers->m_strServer = m_strServer;
	pUsers->m_strDomain = m_strDomain;
	pUsers->LoadAllUsers();
	return pUsers->GetIDispatch( FALSE );
}

LPDISPATCH CUserManager::GetLocalUsers()
{
	CheckExpiration();

	CUsers * pUsers = new CUsers();
	pUsers->m_bIsLocal = TRUE;
	pUsers->m_strServer = m_strServer;
	pUsers->m_strDomain = m_strDomain;
	pUsers->LoadAllUsers();
	return pUsers->GetIDispatch( FALSE );
}

LPDISPATCH CUserManager::GetLocalGroups()
{
	CheckExpiration();
	
	CGroups * pGroups = new CGroups();
	pGroups->m_bIsLocal = TRUE;
	pGroups->m_strServer = m_strServer;
	pGroups->m_strDomain = m_strDomain;
	pGroups->LoadAllGroups();
	return pGroups->GetIDispatch( FALSE );
}

LPDISPATCH CUserManager::GetGroups()
{
	CheckExpiration();
	
	CGroups * pGroups = new CGroups();
	pGroups->m_bIsLocal = FALSE;
	pGroups->m_strServer = m_strServer;
	pGroups->m_strDomain = m_strDomain;
	pGroups->LoadAllGroups();
	return pGroups->GetIDispatch( FALSE );
}

LPDISPATCH CUserManager::AddUser(LPCTSTR Name, LPCTSTR Password, LPCTSTR Comment)
{
	CheckExpiration();
	CheckDemo();
	
	USER_INFO_2 ui2;
	DWORD error;
	memset( &ui2, 0, sizeof( USER_INFO_2 ) );

	USES_CONVERSION;
	LPWSTR lpszPrimaryDC = NULL;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	
	ui2.usri2_name = T2OLE( Name );
	ui2.usri2_password = T2OLE( Password );
	ui2.usri2_priv = USER_PRIV_USER;
	ui2.usri2_comment = T2OLE( Comment );
	ui2.usri2_flags = UF_SCRIPT;
	ui2.usri2_auth_flags = 0;
	ui2.usri2_acct_expires =  TIMEQ_FOREVER;
	ui2.usri2_max_storage = USER_MAXSTORAGE_UNLIMITED;
	ui2.usri2_logon_hours = NULL;
	ui2.usri2_logon_server = NULL;


	CString strServer = lpszPrimaryDC;

	NET_API_STATUS res = ::NetUserAdd( lpszPrimaryDC, 2, (LPBYTE)&ui2, &error );
	::NetApiBufferFree( lpszPrimaryDC );
	
	if( res == NERR_Success )
	{
		CUser * pUser = new CUser;
		pUser->m_strName = Name;
		pUser->m_strServer = strServer;
		pUser->m_strDomain = m_strDomain;
		pUser->m_bIsLocal = FALSE;
		pUser->GetInfo();

		return pUser->GetIDispatch( FALSE );
	}
	else
		HandleError( res );
	
	
	return NULL;	
}

LPDISPATCH CUserManager::AddUser2(LPCTSTR Name, LPCTSTR Password, LPCTSTR Comment) 
{
	CheckExpiration();
	CheckDemo();
	
	USER_INFO_1 ui1;
	DWORD error;
	memset( &ui1, 0, sizeof( USER_INFO_1 ) );

	USES_CONVERSION;
	LPWSTR lpszPrimaryDC = NULL;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	
	ui1.usri1_name = T2OLE( Name );
	ui1.usri1_password = T2OLE( Password );
	ui1.usri1_password_age = 0;
	ui1.usri1_priv = USER_PRIV_USER;
	ui1.usri1_home_dir = NULL;
	ui1.usri1_comment = T2OLE( Comment );
	ui1.usri1_flags = UF_SCRIPT;
	ui1.usri1_script_path = NULL;

	CString strServer = lpszPrimaryDC;

	NET_API_STATUS res = ::NetUserAdd( lpszPrimaryDC, 1, (LPBYTE)&ui1, &error );
	::NetApiBufferFree( lpszPrimaryDC );
	
	if( res == NERR_Success )
	{
		CUser * pUser = new CUser;
		pUser->m_strName = Name;
		pUser->m_strServer = strServer;
		pUser->m_strDomain = m_strDomain;
		pUser->m_bIsLocal = FALSE;
		pUser->GetInfo();

		return pUser->GetIDispatch( FALSE );
	}
	else
		HandleError( res );
	
	
	return NULL;	

}


LPDISPATCH CUserManager::AddLocalUser(LPCTSTR Name, LPCTSTR Password, LPCTSTR Comment)
{		
	CheckExpiration();
	CheckDemo();
	
	USER_INFO_2 ui2;
	DWORD error;
	memset( &ui2, 0, sizeof( USER_INFO_2 ) );

	USES_CONVERSION;
	ui2.usri2_name = T2OLE( Name );
	ui2.usri2_password = T2OLE( Password );
	ui2.usri2_priv = USER_PRIV_USER;
	ui2.usri2_comment = T2OLE( Comment );
	ui2.usri2_flags = UF_SCRIPT;
	ui2.usri2_auth_flags = 0;
	ui2.usri2_acct_expires =  TIMEQ_FOREVER;
	ui2.usri2_max_storage = USER_MAXSTORAGE_UNLIMITED;
	ui2.usri2_logon_hours = NULL;
	ui2.usri2_logon_server = NULL;

	NET_API_STATUS res = ::NetUserAdd( T2OLE( m_strServer ), 2, (LPBYTE)&ui2, &error );
	if( res == NERR_Success )
	{
		CUser * pUser = new CUser;
		pUser->m_strName = Name;
		pUser->m_bIsLocal = TRUE;
		pUser->m_strServer = m_strServer;
		pUser->m_strDomain = m_strDomain;
		pUser->GetInfo();

		return pUser->GetIDispatch( FALSE );
	}
	else
		HandleError( res );
	
	return NULL;
}

long CUserManager::DeleteUser(LPCTSTR Name) 
{
	CheckExpiration();
	
	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	
	NET_API_STATUS res = ::NetUserDel( lpszPrimaryDC, T2OLE( Name ) );
	::NetApiBufferFree( lpszPrimaryDC );

	if( res != NERR_Success )
		HandleError( res );

	return 0;
}

long CUserManager::DeleteLocalUser(LPCTSTR Name) 
{
	CheckExpiration();
	
	USES_CONVERSION;
	NET_API_STATUS res = ::NetUserDel( T2OLE( m_strServer ), T2OLE( Name ) );
	if( res != NERR_Success )
		HandleError( res );

	return 0;
}

LPDISPATCH CUserManager::AddGroup(LPCTSTR Name, LPCTSTR Comment) 
{
	CheckExpiration();
	CheckDemo();

	DWORD error;
	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );

	GROUP_INFO_1 gi1;
	gi1.grpi1_name = T2OLE( Name );
	gi1.grpi1_comment = T2OLE( Comment );

	NET_API_STATUS res = ::NetGroupAdd( lpszPrimaryDC, 1, (LPBYTE)&gi1, &error );

	::NetApiBufferFree( lpszPrimaryDC );

	if( res == NERR_Success )
	{
		CGroup * pGroup = new CGroup;
		pGroup->m_strName = Name;
		pGroup->m_strComment = Comment;
		pGroup->m_bIsLocal = FALSE;
		pGroup->m_strDomain = m_strDomain;
		return pGroup->GetIDispatch( FALSE );
	}
	else
		HandleError( res );

	return NULL;
}

LPDISPATCH CUserManager::AddLocalGroup(LPCTSTR Name, LPCTSTR Comment) 
{
	CheckExpiration();
	CheckDemo();
	
	DWORD error;

	LOCALGROUP_INFO_1 lgi1;
	USES_CONVERSION;
	lgi1.lgrpi1_name = T2OLE( Name );
	lgi1.lgrpi1_comment = T2OLE( Comment );

	NET_API_STATUS res = ::NetLocalGroupAdd( T2OLE( m_strServer ), 1, (LPBYTE)&lgi1, &error );

	if( res == NERR_Success )
	{
		CGroup * pGroup = new CGroup;
		pGroup->m_strName = Name;
		pGroup->m_strComment = Comment;
		pGroup->m_bIsLocal = TRUE;
		pGroup->m_strDomain = m_strDomain;
		return pGroup->GetIDispatch( FALSE );
	}
	else
		HandleError( res );

	return NULL;
}

long CUserManager::DeleteGroup(LPCTSTR Name) 
{
	CheckExpiration();
	
	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	
	NET_API_STATUS res = ::NetGroupDel( lpszPrimaryDC, T2OLE( Name ) );
	::NetApiBufferFree( lpszPrimaryDC );

	if( res != NERR_Success )
		HandleError( res );

	return 0;

}

long CUserManager::DeleteLocalGroup(LPCTSTR Name) 
{
	CheckExpiration();
	
	USES_CONVERSION;
	NET_API_STATUS res = ::NetLocalGroupDel( T2OLE( m_strServer ), T2OLE( Name ) );
	if( res != NERR_Success )
		HandleError( res );

	return 0;
}

/*BSTR CUserManager::GetLocalServer() 
{
	CString strResult;
	SERVER_INFO_100 * si100;
	NET_API_STATUS res = ::NetServerGetInfo( NULL, 100, (LPBYTE *)&si100 );
	strResult = (LPWSTR)si100->sv100_name;
	::NetApiBufferFree( si100 );

	return strResult.AllocSysString();
}*/


long CUserManager::LogonUser(LPCTSTR Domain, LPCTSTR UserID, LPCTSTR Password) 
{
	CheckExpiration();
	DWORD err;

	if( !::RevertToSelf() )
	{
		err = ::GetLastError();
		HandleError( err );
		return -1;
	}
	
	HANDLE hToken;
	if( !::LogonUser( (LPTSTR)UserID, (LPTSTR)Domain, (LPTSTR)Password, LOGON32_LOGON_INTERACTIVE, 
		LOGON32_PROVIDER_DEFAULT, &hToken ) )
	{
		err = ::GetLastError();
		HandleError( err );
		return -1;
	}
	 
	if( !ImpersonateLoggedOnUser( hToken ) )
	{
		THROW_EXCEPTION( _ERROR_LOGONUSERFAILED, "Logon failed." );
	}

	CloseHandle( hToken );

	return 0;
}

long CUserManager::RevertToSelf() 
{
	if( !::RevertToSelf() )
	{
		DWORD err = ::GetLastError();
		HandleError( err );
		return -1;
	}

	return 0;
}

long CUserManager::ChangePassword(LPCTSTR Domain, LPCTSTR Name, LPCTSTR OldPassword, LPCTSTR NewPassword) 
{
	CheckExpiration();
	
	USES_CONVERSION;

	CString strDomain = Domain;
	
	// If domain is not specified get local server name
	// For some reason, omitting server name in ::NetUserChPwd causes an error
	if( strDomain == "" )
	{
		SERVER_INFO_100 * si100;
		NET_API_STATUS res = ::NetServerGetInfo( NULL, 100, (LPBYTE *)&si100 );
		strDomain = CString("\\\\") + (LPWSTR)si100->sv100_name;
		::NetApiBufferFree( si100 );
	}

	NET_API_STATUS res = ::NetUserChangePassword( T2OLE(strDomain), T2OLE(Name),
							T2OLE( OldPassword ), T2OLE( NewPassword ) );

	HandleError( res );

	return 0;
}

void CUserManager::OnServerChanged() 
{
	CheckExpiration();
}

BSTR CUserManager::GetDomainController() 
{
	CheckExpiration();
	
	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );	
	CString strResult = lpszPrimaryDC;
	::NetApiBufferFree( lpszPrimaryDC );

	return strResult.AllocSysString();
}

void CUserManager::SetDomainController(LPCTSTR lpszNewValue) 
{
	SetNotSupported();
}

void CUserManager::CheckExpiration( void )
{
#ifndef NOEXPIRE
	COleDateTime dtExpiration;
	dtExpiration.SetDate( 1998, 9, 15 );
	if( m_dtToday > dtExpiration )
		THROW_EXCEPTION( _ERROR_COMPONENTEXPIRED, "The Component has expired. Please visit Persits Software, Inc. at http://www.persits.com to purchase a copy that will not expire." );
#endif
}

void CUserManager::CheckDemo( void )
{
#ifdef FORDUMMIES
	THROW_EXCEPTION( _ERROR_FEATURE_DISABLED, "This feature is disabled "
				"in the demo version. A fully-functional version "
				"of AspNTUser can be downloaded from the Persits Software, Inc. "
				"Web site at http://www.persits.com." );
#endif
}

LPDISPATCH CUserManager::GetGroup(LPCTSTR Name, const VARIANT FAR& Domain) 
{
	BOOL bDomain = TRUE;
	if( Domain.vt != VT_ERROR )
		bDomain = Domain.bVal;

	CGroup * pGroup = new CGroup;
	pGroup->m_strDomain = m_strDomain;

	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	if( bDomain )
	{
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		pGroup->m_strServer = lpszPrimaryDC;
		::NetApiBufferFree( lpszPrimaryDC );
	}
	else
		pGroup->m_strServer = m_strServer;

	pGroup->m_strName = Name;
	pGroup->m_bIsLocal = !bDomain;
	
	GROUP_INFO_1 * pgr1;
	NET_API_STATUS res;
	if( pGroup->m_bIsLocal )
		res = ::NetLocalGroupGetInfo( T2OLE( pGroup->m_strServer ),
									T2OLE( pGroup->m_strName ),
									1, (LPBYTE *)&pgr1 );
	else
		res = ::NetGroupGetInfo( T2OLE( pGroup->m_strServer ),
									T2OLE( pGroup->m_strName ),
									1, (LPBYTE *)&pgr1 );

	if( res != NERR_Success )
	{
		delete pGroup;
		::NetApiBufferFree( pgr1 );
		HandleError( res );
		return NULL;
	}
	
	pGroup->m_strComment = pgr1->grpi1_comment;

	::NetApiBufferFree( pgr1 );

	return pGroup->GetIDispatch( FALSE );
}



LPDISPATCH CUserManager::GetUser(LPCTSTR Name, const VARIANT FAR& Domain) 
{
	BOOL bDomain = TRUE;
	if( Domain.vt != VT_ERROR )
		bDomain = Domain.bVal;

	CUser * pUser = new CUser;
	pUser->m_strDomain = m_strDomain;
	
	LPWSTR lpszPrimaryDC = NULL;
	USES_CONVERSION;
	if( bDomain )
	{
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		pUser->m_strServer = lpszPrimaryDC;
		::NetApiBufferFree( lpszPrimaryDC );
	}
	else
		pUser->m_strServer = m_strServer;

	pUser->m_strName = Name;
	pUser->m_bIsLocal = !bDomain;
	
	pUser->GetInfo();

	return pUser->GetIDispatch( FALSE );
}

void CUserManager::OnDomainChanged() 
{
	// TODO: Add notification handler code

}


