// User.cpp : implementation file
//

#include "stdafx.h"
#include "AspNTUser.h"
#include "User.h"
#include "groups.h"
#include "Group.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUser

IMPLEMENT_DYNCREATE(CUser, CCmdTarget)

CUser::CUser()
{
	EnableAutomation();
	m_bMustChangePassword = TRUE;
}

CUser::~CUser()
{
}


void CUser::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CUser, CCmdTarget)
	//{{AFX_MSG_MAP(CUser)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CUser, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CUser)
	DISP_PROPERTY_NOTIFY(CUser, "Name", m_strName, OnNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "Comment", m_strComment, OnCommentChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "Flags", m_nFlags, OnFlagsChanged, VT_I4)
	DISP_PROPERTY_NOTIFY(CUser, "FullName", m_strFullName, OnFullNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "Server", m_strServer, OnServerChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "PasswordAge", m_nPasswordAge, OnPasswordAgeChanged, VT_I4)
	DISP_PROPERTY_NOTIFY(CUser, "Privilege", m_nPrivilege, OnPrivilegeChanged, VT_I4)
	DISP_PROPERTY_NOTIFY(CUser, "HomeDir", m_strHomeDir, OnHomeDirChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "ScriptPath", m_strScriptPath, OnScriptPathChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "Workstations", m_strWorkstations, OnWorkstationsChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CUser, "LastLogon", m_dateLastLogon, OnLastLogonChanged, VT_DATE)
	DISP_PROPERTY_NOTIFY(CUser, "LastLogoff", m_dateLastLogoff, OnLastLogoffChanged, VT_DATE)
	DISP_PROPERTY_NOTIFY(CUser, "IsLocal", m_bIsLocal, OnIsLocalChanged, VT_BOOL)
	DISP_PROPERTY_NOTIFY(CUser, "AccountExpires", m_dtAccountExpires, OnAccountExpiresChanged, VT_DATE)
	DISP_PROPERTY_EX(CUser, "Groups", GetGroups, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CUser, "LocalGroups", GetLocalGroups, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CUser, "CannotChangePassword", GetCannotChangePassword, SetCannotChangePassword, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "PasswordNeverExpires", GetPasswordNeverExpires, SetPasswordNeverExpires, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "AccountDisabled", GetAccountDisabled, SetAccountDisabled, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "AccountLockedOut", GetAccountLockedOut, SetAccountLockedOut, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "MustChangePassword", GetMustChangePassword, SetMustChangePassword, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "Password", GetPassword, SetPassword, VT_BSTR)
	DISP_PROPERTY_EX(CUser, "Dialin", GetDialin, SetDialin, VT_BOOL)
	DISP_PROPERTY_EX(CUser, "CallBackType", GetCallBackType, SetCallBackType, VT_I2)
	DISP_PROPERTY_EX(CUser, "PhoneNumber", GetPhoneNumber, SetPhoneNumber, VT_BSTR)
	DISP_FUNCTION(CUser, "SetInfo", SetInfo, VT_I4, VTS_NONE)
	DISP_FUNCTION(CUser, "AddToGroup", AddToGroup, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUser, "DeleteFromGroup", DeleteFromGroup, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUser, "Rename", Rename, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CUser, "SetDialinPermission", SetDialinPermission, VT_I4, VTS_I2 VTS_VARIANT VTS_VARIANT)
	DISP_DEFVALUE(CUser, "Name")
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IUser to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D30E8DCA-65A8-11D1-9149-006008123235}
static const IID IID_IUser =
{ 0xd30e8dca, 0x65a8, 0x11d1, { 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35 } };

BEGIN_INTERFACE_MAP(CUser, CCmdTarget)
	INTERFACE_PART(CUser, IID_IUser, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUser message handlers

void CUser::OnNameChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnCommentChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnFlagsChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnFullNameChanged() 
{
	// TODO: Add notification handler code

}

LPDISPATCH CUser::GetGroups() 
{
	CGroups * pGroups = new CGroups();
	pGroups->m_bIsLocal = FALSE;
	pGroups->m_strServer = m_strServer;
	pGroups->m_strDomain = m_strDomain;
	if( pGroups->LoadGroupsForUser( m_strName ) != NERR_Success )
	{
//		delete pGroups;
//		AfxThrowOleDispatchException( ERROR_USERNOTFOUND, "User not found." );
	}
	return pGroups->GetIDispatch( FALSE );
}

LPDISPATCH CUser::GetLocalGroups() 
{
	CGroups * pGroups = new CGroups();
	pGroups->m_bIsLocal = TRUE;
	pGroups->m_strServer = m_strServer;
	pGroups->m_strDomain = m_strDomain;
	if( pGroups->LoadGroupsForUser( m_strName ) != NERR_Success )
	{
//		delete pGroups;
//		AfxThrowOleDispatchException( ERROR_USERNOTFOUND, "User not found." );
	}

	return pGroups->GetIDispatch( FALSE );
}

void CUser::OnServerChanged() 
{
	// TODO: Add notification handler code

}

short CUser::GetInfo( void )
{
	NET_API_STATUS res;
	USER_INFO_3 * pui;
	USES_CONVERSION;

	// If the user name incudes a domain name we need to determine the corr. server
	// Also in this case we may need to avoid callign NetGetUserInfo to avoid error 1326
	CString m_strDomain = ExtractDomain(m_strName);
	if( m_strDomain != "" )
	{
		//LPWSTR lpszPrimaryDC = NULL;
		//res = ::NetGetDCName(	NULL, T2OLE(m_strDomain), (LPBYTE *)&lpszPrimaryDC );		
		//m_strServer = lpszPrimaryDC;
		//::NetApiBufferFree( lpszPrimaryDC );
		//m_strName = ExtractName(m_strName);
		return 0;
	}

	CString strName = ExtractName(m_strName);
	res = ::NetUserGetInfo( T2OLE( m_strServer ), 
						T2OLE(strName), 3, (LPBYTE *)&pui );

	if( res != NERR_Success )
	{
		CString s;
		s.Format("NetUserGetInfo failed. Error code %lu. User: ", res );
		THROW_EXCEPTION( _ERROR_GETINFOFAILED, s + strName + ", Server: " + m_strServer );
	}

	m_nPasswordAge =	pui->usri3_password_age;
	m_nPrivilege =		pui->usri3_priv;
	m_strHomeDir =		pui->usri3_home_dir;
	m_strComment =		pui->usri3_comment;
	m_nFlags =			pui->usri3_flags;
	m_strScriptPath =	pui->usri3_script_path;
	m_strFullName =		pui->usri3_full_name;
	m_strWorkstations = pui->usri3_workstations;

	COleDateTime dtLastLogon( (time_t)pui->usri3_last_logon );
	COleDateTime dtLastLogoff( (time_t)pui->usri3_last_logoff );
	m_dateLastLogon =	dtLastLogon.m_dt;
	m_dateLastLogoff =	dtLastLogoff.m_dt;

	m_bMustChangePassword = pui->usri3_password_expired;

	COleDateTime dtAcctExpires;
	if( pui->usri3_acct_expires == TIMEQ_FOREVER )
	{
		COleDateTime dtNever;
		dtNever.SetDateTime( 9999, 9, 9, 0, 0, 0 );
		m_dtAccountExpires = dtNever.m_dt;
	}
	else
	{
		COleDateTime dtAcctExpires((time_t) pui->usri3_acct_expires ); 
		m_dtAccountExpires = dtAcctExpires.m_dt;
	}

	::NetApiBufferFree( pui );

	return 0;
}


void CUser::OnPasswordAgeChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnPrivilegeChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnHomeDirChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnScriptPathChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnWorkstationsChanged() 
{
	// TODO: Add notification handler code

}

void CUser::OnIsLocalChanged() 
{
	SetNotSupported();
}


void CUser::OnLastLogonChanged() 
{
	SetNotSupported();
}

void CUser::OnLastLogoffChanged() 
{
	SetNotSupported();
}

long CUser::SetInfo() 
{
	USER_INFO_1 ui;
	USES_CONVERSION;

	memset( (void *)&ui, 0, sizeof(USER_INFO_1) );
	
	ui.usri1_flags =		m_nFlags;
	ui.usri1_comment =		T2OLE( m_strComment );
	ui.usri1_password =		NULL;
	ui.usri1_priv =			m_nPrivilege;
	ui.usri1_script_path =	T2OLE( m_strScriptPath );
	ui.usri1_home_dir =		T2OLE( m_strHomeDir );

	DWORD error;
	NET_API_STATUS res = ::NetUserSetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 1, 
		(LPBYTE)&ui, &error );
	HandleError( res );

	// Take care of full name separately
	USER_INFO_1011 ui1011;
	ui1011.usri1011_full_name = T2OLE( m_strFullName );
	res = ::NetUserSetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 1011, 
		(LPBYTE)&ui1011, &error );
	HandleError( res );

	// Take care of password expire separately
	USER_INFO_3 * pui3;
	res = ::NetUserGetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 3, (LPBYTE *)&pui3 );
	pui3->usri3_password_expired = m_bMustChangePassword;
	res = ::NetUserSetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 3, 
		(LPBYTE)pui3, &error );
	::NetApiBufferFree( pui3 );
	HandleError( res );

	// Change password if it is set
	if( m_strPassword != "" )
	{
		USER_INFO_1003 ui1003;
		ui1003.usri1003_password = T2OLE( m_strPassword );
		res = ::NetUserSetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 1003, 
			(LPBYTE)&ui1003, &error );
		m_strPassword = "";
	}

	GetInfo();

	return res;
}

BOOL CUser::GetCannotChangePassword() 
{
	return m_nFlags & UF_PASSWD_CANT_CHANGE;
}

void CUser::SetCannotChangePassword(BOOL bNewValue) 
{
	if( bNewValue )
		m_nFlags |= UF_PASSWD_CANT_CHANGE;
	else
		m_nFlags &= ~UF_PASSWD_CANT_CHANGE;
}

BOOL CUser::GetPasswordNeverExpires() 
{
	return m_nFlags & UF_DONT_EXPIRE_PASSWD;
}

void CUser::SetPasswordNeverExpires(BOOL bNewValue) 
{
	if( bNewValue )
		m_nFlags |= UF_DONT_EXPIRE_PASSWD;
	else
		m_nFlags &= ~UF_DONT_EXPIRE_PASSWD;
}

BOOL CUser::GetAccountDisabled() 
{
	return m_nFlags & UF_ACCOUNTDISABLE;
}

void CUser::SetAccountDisabled(BOOL bNewValue) 
{
	if( bNewValue )
		m_nFlags |= UF_ACCOUNTDISABLE;
	else
		m_nFlags &= ~UF_ACCOUNTDISABLE;
}

BOOL CUser::GetAccountLockedOut() 
{
	return m_nFlags & UF_LOCKOUT;
}

void CUser::SetAccountLockedOut(BOOL bNewValue) 
{
	if( bNewValue )
		m_nFlags |= UF_LOCKOUT;
	else
		m_nFlags &= ~UF_LOCKOUT;
}

BOOL CUser::GetMustChangePassword() 
{
	return m_bMustChangePassword;
}

void CUser::SetMustChangePassword(BOOL bNewValue) 
{
	m_bMustChangePassword = bNewValue;
}

BSTR CUser::GetPassword() 
{
	GetNotSupported();
	CString strResult;
	return strResult.AllocSysString();
}

void CUser::SetPassword(LPCTSTR lpszNewValue) 
{
	m_strPassword = lpszNewValue;
}

long CUser::AddToGroup(LPCTSTR Name) 
{
	CGroup * pGroup = new CGroup;
	pGroup->m_strName = Name;
	pGroup->m_bIsLocal = m_bIsLocal;
	pGroup->m_strServer = m_strServer;
	pGroup->m_strDomain = m_strDomain;
	pGroup->AddMember( m_strName );
	delete pGroup;
	GetInfo();

	return 0;
}

long CUser::DeleteFromGroup(LPCTSTR Name) 
{
	CGroup * pGroup = new CGroup;
	pGroup->m_strName = Name;
	pGroup->m_bIsLocal = m_bIsLocal;
	pGroup->m_strServer = m_strServer;
	pGroup->m_strDomain = m_strDomain;
	pGroup->DeleteMember( m_strName );
	delete pGroup;
	GetInfo();

	return 0;
}

/* static */
CString CUser::ExtractName( CString& strLongName )
{
	int nPos = strLongName.Find('\\');
	if( nPos == -1 )
		return strLongName;
	else
		return strLongName.Right( strLongName.GetLength() - nPos - 1 );
}

/* static */
CString CUser::ExtractDomain( CString& strLongName )
{
	int nPos = strLongName.Find('\\');
	if( nPos == -1 )
		return "";
	else
		return strLongName.Left( nPos );
}

long CUser::Rename(LPCTSTR NewName) 
{
	USER_INFO_0 ui;
	USES_CONVERSION;

	ui.usri0_name =	T2OLE( NewName );

	DWORD error;
	NET_API_STATUS res = ::NetUserSetInfo( T2OLE( m_strServer ), T2OLE(m_strName), 0, 
		(LPBYTE)&ui, &error );
	HandleError( res );

	return 0;
}

void CUser::OnAccountExpiresChanged() 
{
	SetNotSupported();
}

long CUser::SetDialinPermission(short Flag, const VARIANT FAR& GrantRevoke, const VARIANT FAR& PhoneNumber) 
{
	CString strComputer;
	CString strPhoneNumber;

	BOOL bGrantRevoke = TRUE;
	if( GrantRevoke.vt != VT_ERROR )
	{
		COleVariant var( GrantRevoke );
		var.ChangeType( VT_BOOL, NULL );			
		bGrantRevoke = var.boolVal;
	}

	
	if( PhoneNumber.vt != VT_ERROR )
	{
		COleVariant var( PhoneNumber );
		var.ChangeType( VT_BSTR, NULL );			
		strPhoneNumber = var.bstrVal;
	}

//	CString s;
//	s.Format( "Flag=%d, GrabtRevode = %d, Phone=%s", Flag, bGrantRevoke, strPhoneNumber.GetBuffer(0) );
//	THROW_EXCEPTION( 1, s );
	
	USES_CONVERSION;
	LPWSTR lpszPrimaryDC = NULL;
	
	if( !m_bIsLocal )
	{
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		strComputer = lpszPrimaryDC;
		::NetApiBufferFree( lpszPrimaryDC );
	}
	else
		strComputer = m_strServer;
	

	RAS_USER_0 rasuser;
	memset( &rasuser, 0, sizeof( RAS_USER_0 ) );

	if( bGrantRevoke )
		rasuser.bfPrivilege |= RASPRIV_DialinPrivilege;

	
	if( Flag == 1 )
		rasuser.bfPrivilege |= RASPRIV_NoCallback;
	else
	if( Flag == 2 )
		rasuser.bfPrivilege |= RASPRIV_CallerSetCallback;
	else
	if( Flag == 3 )
		rasuser.bfPrivilege |= RASPRIV_AdminSetCallback;

	if( rasuser.bfPrivilege & RASPRIV_AdminSetCallback )
		wcscpy( rasuser.szPhoneNumber, T2OLE( strPhoneNumber ) );
	
	DWORD res = ::RasAdminUserSetInfo( T2OLE(strComputer), T2OLE( m_strName ), &rasuser );
	HandleError( res );

	return 0;
}


long CUser::GetDialinPermission(short * pFlag, BOOL * pGrantRevoke, CString * pstrPhoneNumber) 
{
	CString strComputer;
	
	USES_CONVERSION;
	LPWSTR lpszPrimaryDC = NULL;
	
	if( !m_bIsLocal )
	{
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		strComputer = lpszPrimaryDC;
		::NetApiBufferFree( lpszPrimaryDC );
	}
	else
		strComputer = m_strServer;
	

	RAS_USER_0 rasuser;
	memset( &rasuser, 0, sizeof( RAS_USER_0 ) );
	
	DWORD res = ::RasAdminUserGetInfo( T2OLE(strComputer), T2OLE( m_strName ), &rasuser );
	HandleError( res );

	if( pGrantRevoke )
	{
		if( rasuser.bfPrivilege & RASPRIV_DialinPrivilege )
			*pGrantRevoke = TRUE;
		else
			*pGrantRevoke = FALSE;
	}

	if( pFlag )
	{
		if( rasuser.bfPrivilege & RASPRIV_NoCallback )
			*pFlag = 1;
		else
		if( rasuser.bfPrivilege & RASPRIV_CallerSetCallback )
			*pFlag = 2;
		else
		if( rasuser.bfPrivilege & RASPRIV_AdminSetCallback )
			*pFlag = 3;
	}

	if( ( rasuser.bfPrivilege & RASPRIV_AdminSetCallback ) && pstrPhoneNumber )
	{
		*pstrPhoneNumber = rasuser.szPhoneNumber;
	}

	return 0;
}

BOOL CUser::GetDialin() 
{
	BOOL bDial;
	GetDialinPermission( NULL, &bDial, NULL );
	return bDial;
}

void CUser::SetDialin(BOOL bNewValue) 
{
	SetNotSupported();
}

short CUser::GetCallBackType() 
{
	short nType;
	GetDialinPermission( &nType, NULL, NULL );
	return nType;
}

void CUser::SetCallBackType(short nNewValue) 
{
	SetNotSupported();
}

BSTR CUser::GetPhoneNumber() 
{
	CString strResult;
	GetDialinPermission( NULL, NULL, &strResult );
	return strResult.AllocSysString();
}

void CUser::SetPhoneNumber(LPCTSTR lpszNewValue) 
{
	SetNotSupported();
}
