// Groups.cpp : implementation file
//

#include "stdafx.h"
#include "AspNTUser.h"
#include "Groups.h"
#include "Group.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGroups

IMPLEMENT_DYNCREATE(CGroups, CCmdTarget)

CGroups::CGroups()
{
	EnableAutomation();
}

CGroups::~CGroups()
{
}

void CGroups::RemoveAll()
{
	LPDISPATCH pDisp;
	int nSize, i;

	nSize = m_ptrGroups.GetSize();
	for( i = 0; i < nSize; i++ )
	{
		pDisp = (LPDISPATCH)m_ptrGroups.GetAt(i);
		pDisp->Release();
	}

	m_ptrGroups.RemoveAll();
}

void CGroups::OnFinalRelease()
{
	RemoveAll();
	CCmdTarget::OnFinalRelease();
}

long CGroups::LoadGroupsForUser( CString strName )
{
	LPWSTR lpszPrimaryDC = NULL;
	DWORD dwCount, dwTotal;

	if( m_bIsLocal )
	{
		LOCALGROUP_USERS_INFO_0 * gri;
	
		USES_CONVERSION;
		lpszPrimaryDC = T2OLE( m_strServer );
		NET_API_STATUS res = ::NetUserGetLocalGroups( lpszPrimaryDC, T2OLE(strName), 
								0,  NULL, (LPBYTE*)&gri, 5120, &dwCount, &dwTotal );
		
		if( res == ERROR_ACCESS_DENIED )
			THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );
		
		if( res !=  NERR_Success )
			return res;

		for( UINT i = 0; i < dwCount; i++ )
		{
			CGroup * pGroup = new CGroup;
			pGroup->m_strName = CString( gri[i]. lgrui0_name );
			pGroup->m_nAttributes = 0;
			pGroup->m_bIsLocal = m_bIsLocal;
			pGroup->m_strServer = m_strServer;
			pGroup->m_strDomain = m_strDomain;
			
			LPDISPATCH pDisp = pGroup->GetIDispatch( FALSE );
			m_ptrGroups.Add( pDisp );
		}

		::NetApiBufferFree( gri );
	} 
	else	// Global Groups
	{
		GROUP_USERS_INFO_1 * gri;
		USES_CONVERSION;
		
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		
		NET_API_STATUS res = ::NetUserGetGroups( lpszPrimaryDC, T2OLE(strName), 
								1,  (LPBYTE*)&gri, 5120, &dwCount, &dwTotal );
		
		if( res == ERROR_ACCESS_DENIED )
			THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

		if( res != NERR_Success )
			return res;

		for( UINT i = 0; i < dwCount; i++ )
		{
			CGroup * pGroup = new CGroup;
			pGroup->m_strName = CString( gri[i]. grui1_name );
			pGroup->m_nAttributes = gri[i]. grui1_attributes;
			pGroup->m_bIsLocal = m_bIsLocal;
			pGroup->m_strServer = m_strServer;
			pGroup->m_strDomain = m_strDomain;
			
			LPDISPATCH pDisp = pGroup->GetIDispatch( FALSE );
			m_ptrGroups.Add( pDisp );
		}

		::NetApiBufferFree( gri );
		::NetApiBufferFree( lpszPrimaryDC );
	}

	return NERR_Success;
}

long CGroups::LoadAllGroups()
{
	DWORD dwCount;
	NET_DISPLAY_GROUP * pGroups;

	RemoveAll();

	LPWSTR lpszPrimaryDC = NULL;

	if( !m_bIsLocal )		// Global (Domain) Groups
	{
		USES_CONVERSION;
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
	
		// Load Groups
		DWORD nIndex = 0;
		while( TRUE )
		{
			NET_API_STATUS res = ::NetQueryDisplayInformation( lpszPrimaryDC, 3,
				nIndex, 100, 512, &dwCount, (PVOID*)&pGroups );

			if( res == ERROR_ACCESS_DENIED )
				THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

			for( UINT i = 0; i < dwCount; i++ )
			{
				CGroup * pGroup = new CGroup;
				pGroup->m_strName = CString( pGroups[i].grpi3_name );
				pGroup->m_strComment = CString( pGroups[i].grpi3_comment );
				pGroup->m_nAttributes = pGroups[i].grpi3_attributes;
				pGroup->m_bIsLocal = m_bIsLocal;
				pGroup->m_strServer = m_strServer;
				pGroup->m_strDomain = m_strDomain;
				
				LPDISPATCH pDisp = pGroup->GetIDispatch( FALSE );
				m_ptrGroups.Add( pDisp );
			}
			
			nIndex = pGroups[dwCount-1].grpi3_next_index;
			::NetApiBufferFree( pGroups );
			
			if( res != ERROR_MORE_DATA )
				break;
		}
		::NetApiBufferFree( lpszPrimaryDC );
	}
	else			// Local Groups
	{
		LOCALGROUP_INFO_1 * lgi;
		DWORD dwCount, dw2, dwResume = 0;

		USES_CONVERSION;

		LPWSTR lpszPrimaryDC = T2OLE( m_strServer );
//		NetApiBufferAllocate( 2 * m_strServer.GetLength() + 10, (LPVOID*)&lpszPrimaryDC );
//		wcscpy( lpszPrimaryDC, T2OLE( m_strServer ) );
		
		while( TRUE )
		{
			NET_API_STATUS res =::NetLocalGroupEnum( lpszPrimaryDC, 1,
				(LPBYTE *)&lgi, 512, &dwCount, &dw2, &dwResume );

			if( res == ERROR_ACCESS_DENIED )
				THROW_EXCEPTION( _ERROR_ACCESSDENIED, "Access Denied." );

			for( UINT i = 0; i < dwCount; i++ )
			{
				CGroup * pGroup = new CGroup;
				pGroup->m_strName = CString( lgi[i]. lgrpi1_name );
				pGroup->m_strComment = CString( lgi[i].lgrpi1_comment );
				pGroup->m_nAttributes = 0;
				pGroup->m_bIsLocal = m_bIsLocal;
				pGroup->m_strServer = m_strServer;
				pGroup->m_strDomain = m_strDomain;
				
				LPDISPATCH pDisp = pGroup->GetIDispatch( FALSE );
				m_ptrGroups.Add( pDisp );
			}

			if( res == 0 )
				break;
		}// while	
//		::NetApiBufferFree( lpszPrimaryDC );
	} // else

	return NERR_Success;
}


BEGIN_MESSAGE_MAP(CGroups, CCmdTarget)
	//{{AFX_MSG_MAP(CGroups)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CGroups, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CGroups)
	DISP_PROPERTY_EX(CGroups, "Count", GetCount, SetCount, VT_I4)
	DISP_FUNCTION(CGroups, "Item", Item, VT_DISPATCH, VTS_VARIANT)
	DISP_DEFVALUE(CGroups, "Item")
	//}}AFX_DISPATCH_MAP
	DISP_PROPERTY_EX_ID(CGroups, "_NewEnum", DISPID_NEWENUM, _NewEnum, SetNotSupported, VT_UNKNOWN )
END_DISPATCH_MAP()

// Note: we add support for IID_IGroups to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D30E8DD4-65A8-11D1-9149-006008123235}
static const IID IID_IGroups =
{ 0xd30e8dd4, 0x65a8, 0x11d1, { 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35 } };

BEGIN_INTERFACE_MAP(CGroups, CCmdTarget)
	INTERFACE_PART(CGroups, IID_IGroups, Dispatch)
	INTERFACE_PART(CGroups, IID_IEnumVARIANT, EnumVARIANT)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGroups message handlers
IUnknown* CGroups::_NewEnum()
{
	m_xEnumVARIANT.m_nCurPos = 0;
	return GetIDispatch( TRUE );
}

CGroups::XEnumVARIANT::XEnumVARIANT()
{    
	m_nCurPos = 0;  
}

STDMETHODIMP_(ULONG) CGroups::XEnumVARIANT::AddRef()
{   
    METHOD_PROLOGUE(CGroups, EnumVARIANT)
    return pThis->ExternalAddRef() ;
}   

STDMETHODIMP_(ULONG) CGroups::XEnumVARIANT::Release()
{   
    METHOD_PROLOGUE(CGroups, EnumVARIANT)
    return pThis->ExternalRelease() ;
}   

STDMETHODIMP CGroups::XEnumVARIANT::QueryInterface( REFIID iid, void FAR* FAR* ppvObj )
{   
    METHOD_PROLOGUE(CGroups, EnumVARIANT)
    return (HRESULT)pThis->ExternalQueryInterface( (void FAR*)&iid, ppvObj) ;
}   

STDMETHODIMP CGroups::XEnumVARIANT::Next( ULONG celt, VARIANT FAR* rgvar, ULONG FAR* pceltFetched)
{
    METHOD_PROLOGUE(CGroups, EnumVARIANT)

    HRESULT hr;
    ULONG   l ;

    if (pceltFetched != NULL)
        *pceltFetched = 0;
    else if (celt > 1)
    {   
        return ResultFromScode( E_INVALIDARG ) ;   
    }

    for (l=0; l < celt; l++)
        VariantInit( &rgvar[l] ) ;

    // Retrieve the next celt elements.
    hr = NOERROR ;
	int i = 0;
    for (l = m_nCurPos ; m_nCurPos < pThis->m_ptrGroups.GetSize() && celt != 0 ; l++)
    {   
        LPDISPATCH pDisp = (LPDISPATCH)pThis->m_ptrGroups.GetAt(l);
        celt-- ;
        if (pDisp )
        {
            rgvar[i].vt = VT_DISPATCH ;
			pDisp->AddRef();
            rgvar[i].pdispVal = pDisp;
            if (pceltFetched != NULL)
                (*pceltFetched)++ ;

			m_nCurPos++;
			i++;
        }
        else 
            return ResultFromScode( E_UNEXPECTED ) ;
    }
    
    if (celt != 0)
       hr = ResultFromScode( S_FALSE ) ;

    return hr ;
}

STDMETHODIMP CGroups::XEnumVARIANT::Skip(unsigned long celt) 
{
    METHOD_PROLOGUE(CGroups, EnumVARIANT)
    
	while (m_nCurPos < pThis->m_ptrGroups.GetSize() && celt--)
        m_nCurPos++;

    return (celt == 0 ? NOERROR : ResultFromScode( S_FALSE )) ;
}

STDMETHODIMP CGroups::XEnumVARIANT::Reset()
{
    METHOD_PROLOGUE(CGroups, EnumVARIANT)
	m_nCurPos = 0;
    return NOERROR ;
}

STDMETHODIMP CGroups::XEnumVARIANT::Clone(IEnumVARIANT FAR* FAR* ppenum) 
{
    METHOD_PROLOGUE(CGroups, EnumVARIANT)   
    CGroups* p = new CGroups ;
    if (p)
    {
        p->m_xEnumVARIANT.m_nCurPos = m_nCurPos ;
        return NOERROR ;    
    }
    else
        return ResultFromScode( E_OUTOFMEMORY ) ;
}


long CGroups::GetCount() 
{
	return m_ptrGroups.GetSize();
}

void CGroups::SetCount(long nNewValue) 
{
	SetNotSupported();
}

LPDISPATCH CGroups::Item(const VARIANT FAR& Index) 
{
	long nIndex = 0, i;
	if( Index.vt == VT_I4 )
		nIndex = Index.lVal;
	else
	if( Index.vt == VT_I2 )
		nIndex = Index.iVal;
	else
	if( Index.vt == (VT_I4 | VT_BYREF) )
		nIndex = *Index.plVal;
	else
	if( Index.vt == (VT_I2 | VT_BYREF) )
		nIndex = *Index.piVal;
	else
	if( Index.vt == VT_DISPATCH )
	{
		COleVariant v( Index );
		v.ChangeType( VT_BSTR, NULL );
		return Item( v );
	}
	else
	if( Index.vt == VT_BSTR )
	{
		CString s( Index.bstrVal );
		for( i = 0; i < m_ptrGroups.GetSize(); i++ )
		{
			CGroup * pGroup = (CGroup *)FromIDispatch( (LPDISPATCH)m_ptrGroups.GetAt( i ) );
			if( pGroup->m_strName.CompareNoCase( s ) == 0 )
			{
				nIndex = i + 1;
				break;
			}
		}
	}
	else
	if( Index.vt == (VT_VARIANT | VT_BYREF) )
	{
		return Item( *Index.pvarVal );
	}

		
	if( nIndex < 1 || nIndex > m_ptrGroups.GetSize() )
		return NULL;

	LPDISPATCH pDisp = (LPDISPATCH)m_ptrGroups.GetAt( nIndex - 1 );
	pDisp->AddRef();
	return pDisp; 
}
