// Group.cpp : implementation file
//

#include "stdafx.h"
#include "AspNTUser.h"
#include "Group.h"
#include "Users.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGroup

IMPLEMENT_DYNCREATE(CGroup, CCmdTarget)

CGroup::CGroup()
{
	EnableAutomation();
}

CGroup::~CGroup()
{
}


void CGroup::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CGroup, CCmdTarget)
	//{{AFX_MSG_MAP(CGroup)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CGroup, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CGroup)
	DISP_PROPERTY_NOTIFY(CGroup, "Name", m_strName, OnNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CGroup, "Comment", m_strComment, OnCommentChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CGroup, "Attributes", m_nAttributes, OnAttributesChanged, VT_I4)
	DISP_PROPERTY_NOTIFY(CGroup, "IsLocal", m_bIsLocal, OnIsLocalChanged, VT_BOOL)
	DISP_FUNCTION(CGroup, "AddMember", AddMember, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CGroup, "DeleteMember", DeleteMember, VT_I4, VTS_BSTR)
	DISP_FUNCTION(CGroup, "SetInfo", SetInfo, VT_I4, VTS_NONE)
	DISP_DEFVALUE(CGroup, "Name")
	//}}AFX_DISPATCH_MAP
	DISP_PROPERTY_EX(CGroup, "LocalUsers", GetLocalUsers, SetNotSupported, VT_DISPATCH)
	DISP_PROPERTY_EX(CGroup, "Users", GetUsers, SetNotSupported, VT_DISPATCH)
END_DISPATCH_MAP()

// Note: we add support for IID_IGroup to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D30E8DCD-65A8-11D1-9149-006008123235}
static const IID IID_IGroup =
{ 0xd30e8dcd, 0x65a8, 0x11d1, { 0x91, 0x49, 0x0, 0x60, 0x8, 0x12, 0x32, 0x35 } };

BEGIN_INTERFACE_MAP(CGroup, CCmdTarget)
	INTERFACE_PART(CGroup, IID_IGroup, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGroup message handlers

void CGroup::OnNameChanged() 
{
	SetNotSupported();
}

void CGroup::OnCommentChanged() 
{
	// TODO: Add notification handler code

}

void CGroup::OnAttributesChanged() 
{
	// TODO: Add notification handler code

}


LPDISPATCH CGroup::GetLocalUsers() 
{
	CUsers * pUsers = new CUsers();
	pUsers->m_bIsLocal = TRUE;
	pUsers->m_strServer = m_strServer;
	pUsers->m_strDomain = m_strDomain;
	if( pUsers->LoadUsersForGroup( m_strName ) != NERR_Success )
	{
//		delete pUsers;
//		AfxThrowOleDispatchException( ERROR_GROUPNOTFOUND, "Group not found." );
	}

	return pUsers->GetIDispatch( FALSE );
}


LPDISPATCH CGroup::GetUsers() 
{
	CUsers * pUsers = new CUsers();
	pUsers->m_bIsLocal = FALSE;
	pUsers->m_strServer = m_strServer;
	pUsers->m_strDomain = m_strDomain;
	if( pUsers->LoadUsersForGroup( m_strName ) != NERR_Success )
	{
//		delete pUsers;
//		AfxThrowOleDispatchException( ERROR_GROUPNOTFOUND, "Group not found." );
	}

	return pUsers->GetIDispatch( FALSE );
}

void CGroup::OnIsLocalChanged() 
{
	SetNotSupported();
}

long CGroup::AddMember(LPCTSTR Name) 
{	
	NET_API_STATUS res;
	USES_CONVERSION;
	if( m_bIsLocal )
	{
		LOCALGROUP_MEMBERS_INFO_3 lgmi3;
		lgmi3.lgrmi3_domainandname = T2OLE( Name );
		res = ::NetLocalGroupAddMembers( T2OLE(m_strServer), 
			T2OLE( m_strName ), 3, (LPBYTE)&lgmi3, 1 );
		if( res != NERR_Success )
			HandleError( res );
	}
	else
	{
		LPWSTR lpszPrimaryDC = NULL;
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		res = ::NetGroupAddUser( lpszPrimaryDC, T2OLE( m_strName ), T2OLE( Name ) ); 
		::NetApiBufferFree( lpszPrimaryDC );
		if( res != NERR_Success )
			HandleError( res );
	}
	
	return 0;
}

long CGroup::DeleteMember(LPCTSTR Name) 
{
	NET_API_STATUS res;
	USES_CONVERSION;

	if( m_bIsLocal )
	{
		LOCALGROUP_MEMBERS_INFO_3 lgmi3;
		lgmi3.lgrmi3_domainandname = T2OLE( Name );
		res = ::NetLocalGroupDelMembers( T2OLE(m_strServer), 
			T2OLE( m_strName ), 3, (LPBYTE)&lgmi3, 1 );
		if( res != NERR_Success )
			HandleError( res );
	}
	else
	{
		LPWSTR lpszPrimaryDC = NULL;
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		res = ::NetGroupDelUser( lpszPrimaryDC, T2OLE( m_strName ), T2OLE( Name ) ); 
		::NetApiBufferFree( lpszPrimaryDC );
		if( res != NERR_Success )
			HandleError( res );
	}

	return 0;
}

long CGroup::SetInfo() 
{
	DWORD error;
	
	USES_CONVERSION;
	if( m_bIsLocal )
	{
		LOCALGROUP_INFO_1 lgi1;
		lgi1.lgrpi1_name = T2OLE( m_strName );
		lgi1.lgrpi1_comment = T2OLE( m_strComment );
		NET_API_STATUS res = ::NetLocalGroupSetInfo( T2OLE(m_strServer), T2OLE(m_strName), 1, (LPBYTE)&lgi1, &error );
		if( res != NERR_Success )
			HandleError( res );
	}
	else
	{
		GROUP_INFO_1 gi1;
		LPWSTR lpszPrimaryDC = NULL;
		::NetGetDCName(	NULL, T2OLE( m_strDomain), (LPBYTE *)&lpszPrimaryDC );
		gi1.grpi1_name = T2OLE( m_strName );
		gi1.grpi1_comment = T2OLE( m_strComment );
		NET_API_STATUS res = ::NetGroupSetInfo( lpszPrimaryDC, T2OLE(m_strName), 1, (LPBYTE)&gi1, &error );
		::NetApiBufferFree( lpszPrimaryDC );
		if( res != NERR_Success )
			HandleError( res );
		
	}

	return 0;
}
