// MailSender.h : Declaration of the CMailSender

#ifndef __MAILSENDER_H_
#define __MAILSENDER_H_

#include "resource.h"       // main symbols
#define		_ERROR_OPENFILE					1
#define		_ERROR_NOTENOUGH_MEMORY			2
#define		_ERROR_FILEREAD_FAILED			3
#define		_ERROR_NOADDRESSES				4
#define		_ERROR_SOCKET_CREATION_FAILED	5
#define		_ERROR_CONNECTION_FAILED		6
#define		_ERROR_SEND_FAILED				7
#define		_ERROR_INDEX_OUTOFRANGE			8
#define		_ERROR_CREATESOCKET_FAILED		9
#define		_ERROR_CONNECT_FAILED			10
#define		_ERROR_POP3HOST_NOTSET			11
#define		_ERROR_RECEIVE_FAILED			12
#define		_ERROR_POP3ERROR				13
#define		_ERROR_FROM_SERVER				14

typedef struct _BUFFER 
				{     
					PBYTE pBuf;
					DWORD cLen; 
				} BUFFER;  


#define DISP_ERROR(n) MAKE_HRESULT(1, FACILITY_WINDOWS | FACILITY_DISPATCH, (n) )

#define HANDLE_ERROR	\
			LPVOID lpMsgBuf;	\
			FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,	\
				NULL, ::GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),	\
				(LPTSTR) &lpMsgBuf, 0, NULL );	\
												\
			CComBSTR bstrError = (char*)lpMsgBuf;\
			LocalFree( lpMsgBuf );

/////////////////////////////////////////////////////////////////////////////
// CMailSender
class ATL_NO_VTABLE CMailSender : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CMailSender, &CLSID_MailSender>,
	public ISupportErrorInfo,
	public IDispatchImpl<IMailSender, &IID_IMailSender, &LIBID_ASPEMAILLib>
{
public:
	CMailSender()
	{
		m_nPort = 25;
		m_bHTML = FALSE;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_MAILSENDER)

BEGIN_COM_MAP(CMailSender)
	COM_INTERFACE_ENTRY(IMailSender)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

public:
	CComBSTR m_bstrHost;
	CComBSTR m_bstrFrom, m_bstrFromName, m_bstrBody, m_bstrSubject;
	short m_nPort, m_nPop3Port;

	BOOL m_bHTML;

	CComBSTR m_bstrPopUser, m_bstrPopPassword, m_bstrPopTempDirectory;

	std::vector<CString> m_arrTo, m_arrToName, m_arrReplyTo, m_arrReplyToName,
		m_arrFiles, m_arrCC, m_arrCCName, m_arrBCC, m_arrBCCName, m_arrAttachment;

	


	HRESULT ReadAndEncodeFile( CString& Path, CString * pRetVal );
	CString ExtractContentType( CString& strPath );
	CString ExtractFileName( CString& strPath );

	static const int pr2six[];
	static char six2pr[];
	static PBYTE BufferQueryPtr( BUFFER * pB ) { return pB->pBuf; }   
	static BOOL BufferResize( BUFFER *pB, DWORD cNewL );
	static BOOL UUEncode( BYTE * bufin, DWORD nbytes, BUFFER * pbuffEncoded );


// IMailSender
public:
	STDMETHOD(get_IsHTML)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_IsHTML)(/*[in]*/ BOOL newVal);
	STDMETHOD(Send)(/*[out]*/VARIANT_BOOL * pVal);
	STDMETHOD(Reset)();
	STDMETHOD(AddAttachment)(/*[in]*/BSTR Path);
	STDMETHOD(AddBcc)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddCC)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddReplyTo)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddAddress)(/*[in]*/BSTR Address, /*[in, optonial]*/VARIANT Name);
	STDMETHOD(get_Subject)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Subject)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Body)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Body)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_FromName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FromName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_From)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_From)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Port)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Port)(/*[in]*/ short newVal);
	STDMETHOD(get_Host)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Host)(/*[in]*/ BSTR newVal);
};

#endif //__MAILSENDER_H_
