// MailSender.cpp : Implementation of CMailSender
#include "stdafx.h"
#include "AspEmail.h"
#include "MailSender.h"

// UUEncode arrays
const int CMailSender::pr2six[256]={ 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,62,64,64,64,63, 
    52,53,54,55,56,57,58,59,60,61,64,64,64,64,64,64,64,0,1,2,3,4,5,6,7,8,9, 
    10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,64,64,64,64,64,64,26,27, 
    28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64 };  
	
char CMailSender::six2pr[64] = { 
    'A','B','C','D','E','F','G','H','I','J','K','L','M', 
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z', 
    'a','b','c','d','e','f','g','h','i','j','k','l','m', 
    'n','o','p','q','r','s','t','u','v','w','x','y','z', 
    '0','1','2','3','4','5','6','7','8','9','+','/' }; 

/////////////////////////////////////////////////////////////////////////////
// CMailSender

STDMETHODIMP CMailSender::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IMailSender,
	};
	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

/* Static */
BOOL CMailSender::BufferResize( BUFFER *pB, DWORD cNewL ) 
{     
	PBYTE pN; 
    if ( cNewL > pB->cLen )     
	{
		pN = (unsigned char *)malloc( cNewL ); 
        if ( pB->pBuf )         
		{
			memcpy( pN, pB->pBuf, pB->cLen ); 
            free( pB->pBuf );
		}         
		pB->pBuf = pN; 
        pB->cLen = cNewL;     
	}      
	return TRUE; 
}
 
/* Static */
BOOL CMailSender::UUEncode( BYTE * bufin, DWORD nbytes, BUFFER * pbuffEncoded ) 
{ 
   unsigned char *outptr; 
   unsigned int i; 
 
   //  Resize the buffer to 133% of the incoming data    
   if ( !BufferResize( pbuffEncoded, nbytes + ((nbytes + 3) / 3) + 4)) 
        return FALSE; 
 
   outptr = (unsigned char *) BufferQueryPtr(pbuffEncoded); 
 
   for (i=0; i<nbytes; i += 3) 
   { 
      *(outptr++) = six2pr[*bufin >> 2];            /* c1 */ 
      *(outptr++) = six2pr[((*bufin << 4) & 060) | ((bufin[1] >> 4) & 017)]; /*c2*/ 
      *(outptr++) = six2pr[((bufin[1] << 2) & 074) | ((bufin[2] >> 6) & 03)];/*c3*/ 
      *(outptr++) = six2pr[bufin[2] & 077];         /* c4 */ 
 
      bufin += 3; 
   } 
 
   /* If nbytes was not a multiple of 3, then we have encoded too 
    * many characters.  Adjust appropriately. 
    */ 
	if(i == nbytes+1) 
	{ 
	  /* There were only 2 bytes in that last group */ 
	  outptr[-1] = '='; 
	} 
	else 
	if(i == nbytes+2) 
	{ 
		/* There was only 1 byte in that last group */ 
		outptr[-1] = '='; 
		outptr[-2] = '='; 
	} 
 
   *outptr = '\0'; 
 
   return TRUE; 
} 

HRESULT CMailSender::ReadAndEncodeFile( CString& Path, CString * pRetVal )
{		
	USES_CONVERSION;
	
	HANDLE hFile = ::CreateFile( Path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile == INVALID_HANDLE_VALUE )
	{			
		HANDLE_ERROR;
		return Error( bstrError, GetObjectCLSID(), DISP_ERROR(_ERROR_OPENFILE) );
	}

	long nSize = ::GetFileSize( hFile, NULL );
	ULONG nBytesRead;
	
	BYTE * buf = new BYTE[nSize + 10];

	if( !buf )
		return Error( "Creating memory buffer failed. Not enough memory.", GetObjectCLSID(), DISP_ERROR(_ERROR_NOTENOUGH_MEMORY) );
	
	if( !::ReadFile( hFile, buf, nSize, &nBytesRead, NULL ) )
	{
		HANDLE_ERROR;
		::CloseHandle( hFile );
		return Error( bstrError, GetObjectCLSID(), DISP_ERROR(_ERROR_FILEREAD_FAILED) );
	}

	::CloseHandle( hFile );
	
	BUFFER resbuf;
	resbuf.pBuf = NULL;
	resbuf.cLen = 0;

	UUEncode( buf, nSize, &resbuf );

	char * szBuf76 = new char[resbuf.cLen + resbuf.cLen / 38 + 200];
		
	if( !szBuf76 )
	{
		delete [] buf;
		return Error( "Creating memory buffer 2 failed. Not enough memory.", GetObjectCLSID(), DISP_ERROR(_ERROR_NOTENOUGH_MEMORY) );
	}
	
	// Cut the string into pieces of 76 characters
	int nCount = 0, nBufCount = 0;
	int nLen = resbuf.cLen;
	while( nCount + 76 <= nLen )
	{
		lstrcpyn( szBuf76 + nBufCount, (const char *)resbuf.pBuf + nCount, 77 );	// incl. term. 0
		nBufCount += 76;
		lstrcpyn( szBuf76 + nBufCount, "\r\n", 3 );
		nBufCount += 2;
		nCount += 76;
	}

	if( nLen > nCount )
	{
		lstrcat( szBuf76, (const char *)resbuf.pBuf + nCount );	// incl. term. 0
		lstrcat( szBuf76, "\r\n" );
	}

	CString res( szBuf76);

	* pRetVal = res;

	delete [] szBuf76;
	free( resbuf.pBuf ); 
	delete [] buf;

	return S_OK;
}

STDMETHODIMP CMailSender::get_Host(BSTR * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bstrHost.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Host(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bstrHost = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Port(short * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_nPort;
	return S_OK;
}

STDMETHODIMP CMailSender::put_Port(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_nPort = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_From(BSTR * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bstrFrom.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_From(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bstrFrom = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_FromName(BSTR * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bstrFromName.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_FromName(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bstrFromName = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Body(BSTR * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bstrBody.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Body(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bstrBody = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Subject(BSTR * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bstrSubject.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Subject(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bstrSubject = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::AddAddress(BSTR Address, VARIANT Name)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrTo.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		::VariantChangeType( &Name, &Name, NULL, VT_BSTR );
		m_arrToName.push_back( Name.bstrVal );
	}
	else
		m_arrToName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddReplyTo(BSTR Address, VARIANT Name)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrReplyTo.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		::VariantChangeType( &Name, &Name, NULL, VT_BSTR );
		m_arrReplyToName.push_back( Name.bstrVal );
	}
	else
		m_arrReplyToName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddCC(BSTR Address, VARIANT Name)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrCC.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		::VariantChangeType( &Name, &Name, NULL, VT_BSTR );
		m_arrCCName.push_back( Name.bstrVal );
	}
	else
		m_arrCCName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddBcc(BSTR Address, VARIANT Name)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrBCC.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		::VariantChangeType( &Name, &Name, NULL, VT_BSTR );
		m_arrBCCName.push_back( Name.bstrVal );
	}
	else
		m_arrBCCName.push_back( L"" );
	
	return S_OK;
}

STDMETHODIMP CMailSender::AddAttachment(BSTR Path)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrAttachment.push_back( Path );

	return S_OK;
}

STDMETHODIMP CMailSender::Reset()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_arrTo.clear();
	m_arrToName.clear();

	m_arrReplyTo.clear();
	m_arrReplyToName.clear();

	m_arrCC.clear();
	m_arrCCName.clear();

	m_arrBCC.clear();
	m_arrBCCName.clear();

	m_arrAttachment.clear();

	return S_OK;
}

STDMETHODIMP CMailSender::Send(VARIANT_BOOL * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	USES_CONVERSION;

	* pVal = VARIANT_FALSE;

	CSocket	MailSocket;
	char b[400];

	int nSize = m_arrTo.size();
	int nCCSize = m_arrCC.size();
	int nBccSize = m_arrBCC.size();

	if( nSize + nBccSize == 0 )
	{
		return Error( "No addesses specified.", GetObjectCLSID(), DISP_ERROR(_ERROR_NOADDRESSES) );
	}

	if( !MailSocket.Create() )
	{
		return Error( "Socket creation failed.", GetObjectCLSID(), DISP_ERROR(_ERROR_SOCKET_CREATION_FAILED) );
	}

	if( !MailSocket.Connect( OLE2T(m_bstrHost), m_nPort ) )
	{
		return Error( "Connection to host failed.", GetObjectCLSID(), DISP_ERROR(_ERROR_CONNECTION_FAILED) );
	}

	MailSocket.Receive( b, 198, 0 );
	CString s[200];
	int n = 0;


	s[n++] = "HELO AspPostOffice\r\n";
	s[n++] = CString("MAIL FROM:<") + OLE2T(m_bstrFrom) + ">\r\n";
	
	// Add recipients
	std::vector<CString>::iterator it, it2;
	for( it = m_arrTo.begin(); it != m_arrTo.end(); it++ )
	{
		s[n++] = CString("RCPT TO:<") + (*it) + ">\r\n";
	}

	for( it = m_arrCC.begin(); it != m_arrCC.end(); it++ )
	{
		s[n++] = CString("RCPT TO:<") + (*it) + ">\r\n";
	}

	for( it = m_arrBCC.begin(); it != m_arrBCC.end(); it++ )
	{
		s[n++] = CString("RCPT TO:<") + (*it) + ">\r\n";
	}



	s[n++] = "DATA\r\n";

	s[n++] = m_bstrFromName.Length() == 0 ? CString("FROM: ") + OLE2T(m_bstrFrom) + "\r\n" : 
								 CString("FROM: \"") + OLE2T(m_bstrFromName) + CString("\" <")+ OLE2T(m_bstrFrom) + ">\r\n";

	// Build the "TO:" list
	if( m_arrToName.size() > 0 )
	{
		CString strTo;
		for( it = m_arrToName.begin(), it2 = m_arrTo.begin(); it != m_arrToName.end(); it++, it2++ )
		{
			if( strTo != "" )
				strTo += ",";
			strTo += it->GetLength() == 0 ? 
							(*it2) :	
							CString("\"") + (*it) + CString("\" <") + (*it2) + ">";
		}
		s[n++] = "TO: " + strTo + "\r\n";
	}


	// Build the CC list
	if( m_arrCCName.size() > 0 )
	{
		CString strCC;
		for( it = m_arrCCName.begin(), it2 = m_arrCC.begin(); it != m_arrCCName.end(); it++, it2++ )
		{
			if( strCC != "" )
				strCC += ",";
			strCC += it->GetLength() == 0 ? 
							(*it2) :	
							CString("\"") + (*it) + CString("\" <") + (*it2) + ">";
		}
		s[n++] = "CC: " + strCC + "\r\n";
	}

	// Handle BCCs. If there were no TOs, we say "Undisclosed Recipients
	//if( m_arrBCCName.size() > 0 && m_arrToName.size() == 0 )
	//{
	//	s[n++] = "TO:<Undisclosed.Recipients>\r\n";
	//}


	// Build the "REPLY-TO:" list
	if( m_arrReplyToName.size() > 0 )
	{
		CString strReplyTo;
		for( it = m_arrReplyToName.begin(), it2 = m_arrReplyTo.begin(); it != m_arrReplyToName.end(); it++, it2++ )
		{
			if( strReplyTo != "" )
				strReplyTo += ",";
			strReplyTo += it->GetLength() == 0 ? 
							(*it2) :	
							CString("\"") + (*it) + CString("\" <") + (*it2) + ">";
		}
		s[n++] = "REPLY-TO: " + strReplyTo + "\r\n";
	}


	s[n++] = CString("SUBJECT: ") + OLE2T(m_bstrSubject) + "\r\n";

	CString strTimeZone;
	_tzset();
	BOOL bNegative = FALSE;
	int zone = _timezone;
	if( zone < 0 )
	{
		bNegative = TRUE;
		zone = -zone;
	}

	strTimeZone.Format( "%02d00", zone / 3600 );
	if( bNegative )
		strTimeZone = " +" + strTimeZone;
	else
		strTimeZone = " -" + strTimeZone;

	COleDateTime dt = COleDateTime::GetCurrentTime();
	s[n++] = "DATE: " + dt.Format("%a, %d %b %Y %H:%M:%S") + strTimeZone + "\r\n";

	if( m_arrAttachment.size() > 0 || m_bHTML )
	{
		// Generate separator
		GUID g;
		CoCreateGuid( &g );
		CString strBoundary;
		strBoundary.Format("%04X_%04X_%04X_%04X_%02X%02X_%02X%02X_%02X%02X_%02X%02X", HIWORD(g.Data1), LOWORD(g.Data1), g.Data2, g.Data3, g.Data4[0], g.Data4[1], g.Data4[2], g.Data4[3], g.Data4[4], g.Data4[5], g.Data4[6], g.Data4[7] );

		s[n++] = "MIME-Version: 1.0\r\n";
		s[n++] = "Content-Type: multipart/mixed;boundary=\"" + strBoundary + "\"\r\n\r\n";

		
		s[n++] = "This is a multi-part message in MIME format.\r\n\r\n";

		// Body in the MIME format
		s[n++] = "--" + strBoundary + "\r\n";
		s[n++] = m_bHTML ? "Content-Type: text/html; charset=ISO-8859-1\r\n"
			: "Content-Type: text/plain; charset=ISO-8859-1\r\n";
		s[n++] = "Content-Transfer-Encoding: 7bit\r\n\r\n";
		s[n++] = CString(OLE2T(m_bstrBody)) + "\r\n\r\n";

		for( it = m_arrAttachment.begin(); it != m_arrAttachment.end(); it++ )
		{
			s[n++] = "--" + strBoundary + "\r\n";
			s[n++] = "Content-Type: " + ExtractContentType( CString(*it) ) + 
				";name=\"" + ExtractFileName( CString(*it) ) + "\"\r\n";
			s[n++] = "Content-Transfer-Encoding: base64\r\n";
			s[n++] = "Content-Disposition: attachment;filename=\"" + ExtractFileName( CString(*it) ) + "\"\r\n\r\n";

			CString res;
			HRESULT hr = ReadAndEncodeFile( *it, &res );
			if( FAILED( hr ) )
				return hr;
			s[n++] = res + "\r\n\r\n";
		}

		s[n++] = "--" + strBoundary + "--\r\n.\r\n";
	}
	else	// body in the plain format
	{
		s[n++] = "\r\n";
		s[n++] = OLE2T(m_bstrBody) + CString("\r\n.\r\n");
	}

	s[n++] = "QUIT\r\n";

	int nQuitLine = n - 1;

	// Start sendind info
	for( int i = 0; i < n; i++ )
	{		
		int res = MailSocket.Send( s[i], s[i].GetLength() );
		if( res == SOCKET_ERROR  )
			return Error( "Send failed.", GetObjectCLSID(), DISP_ERROR(_ERROR_SEND_FAILED) );
		
		if( i < 3 + nSize + nCCSize + nBccSize || i == nQuitLine - 1 || i == nQuitLine  )
		{			
			int nRes = MailSocket.Receive( b, 198, 0 );
			if( nRes > 0 )
				b[nRes] = '\0';
			
			//OutputDebugString( b );
			//OutputDebugString( "\r\n" );

			// Error handling
			if( b[0] == '5' )
				return Error( b, GetObjectCLSID(), DISP_ERROR(_ERROR_FROM_SERVER) );

		}
	}

	* pVal = VARIANT_TRUE;

	return S_OK;
}


CString CMailSender::ExtractContentType( CString& strPath )
{
	char ext[_MAX_EXT];
	_splitpath( strPath.GetBuffer(0), NULL, NULL, NULL, ext );
	if( *ext )
	{
		UCHAR szVal[250];
		ULONG nSize = 240;
		ULONG nType = REG_SZ;
		HKEY hKey;

		::RegOpenKey( HKEY_CLASSES_ROOT, ext, &hKey );
		LONG res = ::RegQueryValueEx( hKey, "Content Type", NULL, &nType, szVal, &nSize );
		::RegCloseKey( hKey );

		if( res != ERROR_SUCCESS )
			return "application/octet-stream";
		else
			return szVal;
	}
	else
		return "application/octet-stream";
}

CString CMailSender::ExtractFileName( CString& strPath )
{
  
	char fname[_MAX_FNAME];   
	char ext[_MAX_EXT];
   
	_splitpath( strPath.GetBuffer(0), NULL, NULL, fname, ext );
	return CString(fname) + ext;
}

STDMETHODIMP CMailSender::get_IsHTML(BOOL * pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	* pVal = m_bHTML;
	return S_OK;
}

STDMETHODIMP CMailSender::put_IsHTML(BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bHTML = newVal;
	return S_OK;
}
