  /*
 * @(#)DelegatingSecurityManager.java	1.1 97/11/10 Matthew Shilts
 *
 * Copyright (c) 1996-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

import java.net.URL;

import java.io.File;
import java.io.IOException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;

import sunw.hotjava.bean.BeanDelegateSecurityManager;



/**
 *
 * This class implements a security model where someone who wants to use the bean but also
 * wants to use their own security manager can do so.  The resulting security policy is the
 * intersection of the two security models.
 *
 * When using this security manager the Foreign Security manager should pass responsibility for
 * checking any classloaders that are instances of sunw.hotjava.applet.AppletClassLoader or
 * instance's of sun.applet.AppletClassLoader on to us to deal with.
 *
 * This class is a singleton.  This just makes us a bit more restrictive in what we allow.  Plus
 * it avoids people making the mistake of trying to instantiate another SecurityManager once one
 * is created and designated default.
 *
 * @version 	1.1, 11/10/97
 * @author	Matthew Shilts
 */

public class DelegatingSecurityManager extends SecurityManager {

    private static SecurityManager DSM;

    public static SecurityManager getDelegateSecurityManager(SecurityManager foreignSM) {

        if (DSM == null) {
            DSM = new DelegatingSecurityManager(foreignSM);
        }

        return DSM;
    }


    // these are our delegate security managers that we pass checks onto
    private SecurityManager beanSecurityManager;
    private SecurityManager foreignSecurityManager;

    private DelegatingSecurityManager(SecurityManager foreignSM) {
    	super();

    	foreignSecurityManager = foreignSM;
    	beanSecurityManager = new BeanDelegateSecurityManager();
    }


    /**
     * The following check methods are the ones that I must implement as a security manager.
     * The checks are actually passed onto the delegates.
     */
    public void checkAccess(Thread t) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkAccess(t);
        }
        beanSecurityManager.checkAccess(t);
    }

    public void checkAccess(ThreadGroup g) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkAccess(g);
        }
        beanSecurityManager.checkAccess(g);
    }

    public void checkExit(int status) {
    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkExit(status);
        }
        beanSecurityManager.checkExit(status);
    }

    public void checkExec(String cmd) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkExec(cmd);
        }
        beanSecurityManager.checkExec(cmd);
    }

    public void checkLink(String lib){

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkLink(lib);
        }
        beanSecurityManager.checkLink(lib);
    }

    public void checkPropertiesAccess() {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkPropertiesAccess();
        }
        beanSecurityManager.checkPropertiesAccess();
    }

    public void checkPropertyAccess(String key) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkPropertyAccess(key);
        }
        beanSecurityManager.checkPropertyAccess(key);
    }

    public void checkRead(String file) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkRead(file);
        }
        beanSecurityManager.checkRead(file);
    }


    public void checkRead(String file, Object context) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkRead(file, context);
        }
        beanSecurityManager.checkRead(file, context);
    }

    public void checkRead(FileDescriptor fd) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkRead(fd);
        }
        beanSecurityManager.checkRead(fd);
    }

    public void checkWrite(String file) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkWrite(file);
        }
        beanSecurityManager.checkWrite(file);
    }

    public void checkWrite(FileDescriptor fd) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkWrite(fd);
        }
        beanSecurityManager.checkWrite(fd);
    }

    public void checkDelete(String file) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkDelete(file);
        }
        beanSecurityManager.checkDelete(file);
    }

    public void checkListen(int port) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkListen(port);
        }
        beanSecurityManager.checkListen(port);
    }

    public void checkAccept(String host, int port) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkAccept(host, port);
        }
        beanSecurityManager.checkAccept(host, port);
    }

    public void checkMulticast(InetAddress maddr) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkMulticast(maddr);
        }
        beanSecurityManager.checkMulticast(maddr);
    }

    public void checkMulticast(InetAddress maddr, byte b) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkMulticast(maddr, b);
        }
        beanSecurityManager.checkMulticast(maddr, b);
    }


    public void checkConnect(String host, int port) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkConnect(host, port);
        }
        beanSecurityManager.checkConnect(host, port);
    }
    
    public void checkConnect(String host, int port, Object j) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkConnect(host, port, j);
        }
        beanSecurityManager.checkConnect(host, port, j);
    }
    

    public boolean checkTopLevelWindow(Object window) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return true;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	if (!foreignSecurityManager.checkTopLevelWindow(window)) {
        		return false;
        	}
        }
        return beanSecurityManager.checkTopLevelWindow(window);
    }
    
    public void checkCreateClassLoader() {
    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkCreateClassLoader();
        }
        beanSecurityManager.checkCreateClassLoader();
    }
    

    public void checkPackageAccess(String pkg) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkPackageAccess(pkg);
        }
        beanSecurityManager.checkPackageAccess(pkg);
    }

    public void checkPackageDefinition(String pkg) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkPackageDefinition(pkg);
        }
        beanSecurityManager.checkPackageDefinition(pkg);
    }


    public void checkSetFactory() {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkSetFactory();
        }
        beanSecurityManager.checkSetFactory();
    }

    public void checkMemberAccess(Class clazz, int which) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkMemberAccess(clazz, which);
        }
        beanSecurityManager.checkMemberAccess(clazz, which);
    }

    public void checkPrintJobAccess() {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkPrintJobAccess();
        }
        beanSecurityManager.checkPrintJobAccess();
    }

    public void checkSystemClipboardAccess() {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkSystemClipboardAccess();
        }
        beanSecurityManager.checkSystemClipboardAccess();
    }

    public void checkAwtEventQueueAccess() {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkAwtEventQueueAccess();
        }
        beanSecurityManager.checkAwtEventQueueAccess();
    }

    public void checkSecurityAccess(String provider) {

    	/**
    	* This check makes an assumption that any user defined security manager uses
    	* a class loader to determine that code is untrusted, but gains us a preformance
    	* advantage in that 90% of the time when trusted code is initiating the check we
    	* avoid the method overhead and the security checks imposed by the beanSecurityManager
    	* and the foreignSecurityManager.
    	*/
        ClassLoader loader = currentClassLoader();
	if (loader == null) {
		return;
        }

        // if there is a foreign security manager present let it check this.
        if (foreignSecurityManager != null) {
        	foreignSecurityManager.checkSecurityAccess(provider);
        }
        beanSecurityManager.checkSecurityAccess(provider);
    }

} // end of DelegatingSecurityManager.
