unit voxpdem;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  voxplay, EnhWave, FileCtrl, StdCtrls;

type
  TForm1 = class(TForm)
    EnhWaveOut1: TEnhWaveOut;
    VoxPlayer1: TVoxPlayer;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    FilterComboBox1: TFilterComboBox;
    DriveComboBox1: TDriveComboBox;
    EnhWaveIn1: TEnhWaveIn;
    Button1: TButton;
    Button2: TButton;
    SaveDialog1: TSaveDialog;
    Button3: TButton;
    ComboBox1: TComboBox;
    Label1: TLabel;
    ComboBox2: TComboBox;
    Label2: TLabel;
    Button4: TButton;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FileListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
savedialog1.initialdir:=directorylistbox1.directory;
if savedialog1.execute then voxplayer1.startrecording(savedialog1.filename,VT_ADPCM);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
voxplayer1.stoprecording;
filelistbox1.update;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
voxplayer1.wavtovox(filelistbox1.filename,changefileext(filelistbox1.filename,'.vox'));
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
case combobox1.itemindex of
 0: voxplayer1.voxtype:=VT_ADPCM;
 1: voxplayer1.voxtype:=VT_PCM;
 2: voxplayer1.voxtype:=VT_EURISTIC;
end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
combobox1.itemindex:=2;
combobox2.itemindex:=1;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
enhwaveout1.close;
enhwavein1.close;
enhwaveout1.samples:=strtoint(combobox2.text);
enhwavein1.samples:=strtoint(combobox2.text);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
voxplayer1.voxtowav(filelistbox1.filename,changefileext(filelistbox1.filename,'.wav'), strtoint(combobox2.text));
end;

procedure TForm1.FileListBox1Click(Sender: TObject);
var
tipo: playmodes;
begin
if not voxplayer1.euristiccheck(filelistbox1.filename,tipo)
   then label3.caption:='Euristic guess: RIFF file'
   else if tipo=vt_PCM then label3.caption:='Euristic guess: PCM encoded file'
                       else label3.caption:='Euristic guess: ADPCM encoded file';

if not voxplayer1.play(filelistbox1.filename) then beep;
end;

end.
