unit maintest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, wwwcheck, NMHTTP;

type
  TForm1 = class(TForm)
    WWWCheck1: TWWWCheck;
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit2: TEdit;
    ListView1: TListView;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure WWWCheck1RequestCompleted(Cmd: CmdType);
    procedure ListView1DblClick(Sender: TObject);
    procedure WWWCheck1ListCompleted(Cmd: CmdType);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses showform;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 screen.cursor:=crHourGlass;
 WWWCheck1.url:=edit1.text;
 WWWCheck1.port:=strtoint(edit2.text);
 WWWCheck1.GetList;
end;


procedure TForm1.WWWCheck1RequestCompleted(Cmd: CmdType);
begin
 screen.cursor:=crDefault;
 form2.memo1.clear;
 if not WWWCheck1.TextTransfer then form2.memo1.lines.add('This is a BINARY transmission. Check for file in current directory')
                               else form2.memo1.lines.add(WWWCheck1.buffer);
 form2.showmodal;
end;

procedure TForm1.ListView1DblClick(Sender: TObject);
var idx:integer;
    v1,v2,v3:string;
    v4:integer;
begin
 screen.cursor:=crHourGlass;

 idx:=listview1.selected.index;
 WWWCheck1.split(WWWCheck1.items[idx],v1,v2,v3,v4);
 WWWCheck1.params:='name='+v1;
 if v4 and TWC_BINARY=TWC_BINARY then WWWCheck1.TextTransfer:=false
                                 else WWWCheck1.TextTransfer:=true;
 WWWCheck1.LocalFile:=v3;
 WWWCheck1.PostRequest;
end;

procedure TForm1.WWWCheck1ListCompleted(Cmd: CmdType);
var i:integer;
    f1,f2,f3,flgs:string;
    f4:integer;
begin
 if WWWCheck1.buffer='' then
           begin
            application.messagebox('No items available.','Information',MB_OK);
            exit;
           end;

 listview1.items.beginupdate;
 listview1.items.clear;

 for i:=0 to WWWCheck1.items.count-1 do
  begin
    WWWCheck1.Split(WWWCheck1.items[i],f1,f2,f3,f4);

    with listview1.items.add do
      begin
        caption:=f1;
        subitems.add(f2);
        subitems.add(f3);
        flgs:='';
        if f4 and TWC_TEXT = TWC_TEXT then flgs:='TXT';
        if f4 and TWC_BINARY = TWC_BINARY then flgs:='BIN';

        if f4 and TWC_EXECUTE = TWC_EXECUTE then flgs:=flgs+', EXEC';
        if f4 and TWC_CLOSEAPP= TWC_CLOSEAPP then flgs:=flgs+', CLOSEAPP';
        subitems.add(flgs);
      end;
  end;

 listview1.items.endupdate;
  screen.cursor:=crDefault;
end;

end.
