unit macro_rec_f;
  /////////////////////////////////////////////////////////
  //                                                     //
  //           TMagicMacros-Component v2.0               //
  //                                                     //
  // (C) Niels Vanspauwen, 15/10/98                      //
  //     E-mail: Niels.Vanspauwen@Kagi.com               //
  //     Homepage: http://magicmacros.8m.com             //
  //                                                     //
  /////////////////////////////////////////////////////////
  {This is another demoproject that comes with TMagicMacros component.
   This one demonstrates how easy it is to include macro support for
   your users in no time !
   Following methods are clearly illustrated in this demoproject:
   Play, StartRecording, StopRecording, Pause, Resume, ShowInfoBox,
   WaitForInfoBox.
   Most events are illustrated also.

   USAGE:
   ------
   Click on File-New to assign a name to your macro. (extension is
   automatically set to .mcr, regardless of the extension you give)
   Now press the "Record"-button and move around with the mouse a bit.
   Click on the "Test Auto-speed Addaption"-button. This performs a
   very simple loop: the computer starts counting from 1 to 1000.
   Notice that you cannot move the cursor while the PC is performing
   this loop.
   When the loop is done, click on the "Stop Recording"-button.
   The macro is automatically saved to disk.
   Now press the "Play"-button and playback will start.
   Not impressed ? After the playback has ended, set one of the
   radio-buttons to "Simulate 5x slower" or "Simulate 5x faster" and
   press play again. As you'll notice, the macro nicely waits untill
   the PC is done counting before playback continues !
   Be sure to check the docs that come with this component to read all
   about the "how and why" of this feature.
   }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, Buttons, Gauges;

type
  TRecorderForm = class(TForm)
    RecordButton: TButton;
    StopButton: TButton;
    PlayButton: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    Gauge: TGauge;
    MagicMacros: TMagicMacros;
    procedure RecordButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure PlayButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MagicMacrosPlayEnded(Sender: TObject);
    procedure MagicMacrosRecordEnded(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure MagicMacrosPlay(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure MagicMacrosProgress(PercentDone: Integer);
  end;

var
  RecorderForm: TRecorderForm;

implementation

{$R *.DFM}

procedure TRecorderForm.RecordButtonClick(Sender: TObject);
begin
  RecordButton.Enabled := false;
  PlayButton.Enabled := False;
  StopButton.Enabled := true;
  MagicMacros.StartRecording;
end; {procedure RecordButtonClick}


procedure TRecorderForm.StopButtonClick(Sender: TObject);
begin
  Gauge.Progress := 0;
  Gauge.Visible := true;
  MagicMacros.StopRecording;
end; {procedure StopButtonClick}


procedure TRecorderForm.PlayButtonClick(Sender: TObject);
begin
  try
    Gauge.Progress := 0;
    Gauge.Visible := true;
    MagicMacros.Play;
  except on ENoSuchMacro do
    ShowMessage('Macro does not exist !');
  end; {exception handler}
end; {procedure PlayButtonClick}


procedure TRecorderForm.FormCreate(Sender: TObject);
begin
  RecordButton.Enabled := false;
  PlayButton.Enabled := false;
  StopButton.Enabled := false;
end;

procedure TRecorderForm.New1Click(Sender: TObject);
var
  Filename: String;
begin
  if InputQuery('New macro', 'Enter name for macro:', Filename) then begin
    //Check if file already exists:
    if FileExists(ChangeFileExt(Filename, '.mcr')) and
      (MessageDlg('A macro with the name '+ChangeFileExt(Filename, '.mcr')+#13+
                  'already exists! Do you want to overwrite it ?', mtWarning,
                  [mbYes, mbNo], 0)=idNo) then exit;
    MagicMacros.MacroName := ChangeFileExt(Filename, '.mcr');
    Caption := ChangeFileExt(Filename, '');
    RecordButton.Enabled := true;
    PlayButton.Enabled := true;
    StopButton.Enabled := false;
  end;
end;

procedure TRecorderForm.Open1Click(Sender: TObject);
begin
  if OpenDialog1.execute then begin
    MagicMacros.MacroName := OpenDialog1.Filename;
    Caption := ChangeFileExt(OpenDialog1.Filename, '');
    RecordButton.Enabled := true;
    PlayButton.Enabled := true;
    StopButton.Enabled := false;
  end;
end;

procedure TRecorderForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TRecorderForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if MessageDlg('Are you sure you want to exit ?', mtConfirmation,
                [mbYes, mbNo],0)=idYes then
    CanClose := true
    else CanClose := false;
end;

procedure TRecorderForm.MagicMacrosPlayEnded(Sender: TObject);
begin
  RecordButton.Enabled := true;
  PlayButton.Enabled := true;
end;

procedure TRecorderForm.MagicMacrosRecordEnded(Sender: TObject);
begin
  RecordButton.Enabled := true;
  PlayButton.Enabled := true;
  StopButton.Enabled := false;
  Gauge.Visible := false;
end;

procedure TRecorderForm.Button1Click(Sender: TObject);
var
  i: integer;
  Counter: integer;
  Text: string;
begin
  MagicMacros.Pause; //This method-call is needed for the auto-speed adaption.
  Text := 'Just testing this great new feature: use idle time to give the user'+
          'some information about your application. The macro waits for the '+
          'box to disappear before continuing playback!'+#13+
          'Note that you have to call Pause and Resume before, resp. after'+
          'making a call to the ShowInfoBox-method for this...';
  MagicMacros.ShowInfoBox('Testing', Text, 5000);
  if RadioGroup1.ItemIndex = 0 then
    Counter := 5000
  else if RadioGroup1.ItemIndex = 1 then
    Counter := 1000
  else Counter := 200;
  for i := 1 to Counter do begin
    Caption := IntToStr(i);
  end;
  MagicMacros.WaitForInfoBox;
  MagicMacros.Resume; //This method-call is needed for the auto-speed adaption.
end;

procedure TRecorderForm.MagicMacrosPlay(Sender: TObject);
begin
  PlayButton.Enabled := false;
  RecordButton.Enabled := False;
  StopButton.Enabled := false;
  Gauge.Visible := false;
end;


procedure TRecorderForm.Edit1Click(Sender: TObject);
begin
  {Select the text in the editbox}
  Edit1.SelStart := 0;
  Edit1.SelLength := Length(Edit1.Text);
end;


procedure TRecorderForm.MagicMacrosProgress(PercentDone: Integer);
begin
  if (PercentDone mod 5) = 0 then
    Gauge.Progress := PercentDone;
end;

end.
