unit SimpleEdit_f;
  /////////////////////////////////////////////////////////
  //                                                     //
  //           TMagicMacros-Component v2.0               //
  //                                                     //
  // (C) Niels Vanspauwen, 15/10/98                      //
  //     E-mail: Niels.Vanspauwen@Kagi.com               //
  //     Homepage: http://magicmacros.8m.com             //
  //                                                     //
  /////////////////////////////////////////////////////////
  {This is a demo-project that comes with TMagicMacros 2.0.

   It's a VERY simple texteditor (appropriatly called SimpleEdit),
   which supports VisualHelp to explain some of it's features.
   Just open the helpfile, select a topic and press the "Show Me" button
   to experience a whole other approach to help!

   If you want, you can also call VisualHelp directly (in this app,
   from a menu under the "How can I..." section in the Help menu).

   The last example of how you can use TMagicMacros is to make a
   demo of your application. I did this for SimpleEdit: just click on
   "Tourguide" in the Help menu. (Of course, you can also make it so
   that a macro is started automatically when you start your application.
   This is great for mailings: busy managers don't have the time to experiment
   with every demoprogram they receive in the mail, nor are they likely to
   read every advertisment letter you send them, but they always have time
   to watch a 5 minute show, that clearly illustrates the power of your app!)

   Following methods, properties and events are clearly illustrated by this
   demo-project: Play, PlayVH, Pause, Resume, ShowInfoBox, WaitForInfoBox,
   BeforePlay, OnPlayEnded, OnPlayCancelled, BeforeVisualHelp, OnVisualHelp,
   OnVisualHelpEnded, OnVisualHelpCancelled, OnProgress.
  }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, StdCtrls, ComCtrls, Menus;

type
  TSimpleEditForm = class(TForm)
    RichEdit1: TRichEdit;
    Panel1: TPanel;
    btnItalic: TSpeedButton;
    btnBold: TSpeedButton;
    btnFont: TSpeedButton;
    MagicMacros1: TMagicMacros;
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Options1: TMenuItem;
    Italic1: TMenuItem;
    Bold1: TMenuItem;
    N1: TMenuItem;
    Font1: TMenuItem;
    Help1: TMenuItem;
    Index1: TMenuItem;
    StatusBar1: TStatusBar;
    N2: TMenuItem;
    HowcanI1: TMenuItem;
    Maketextbold1: TMenuItem;
    Maketextitalic1: TMenuItem;
    Changethefont1: TMenuItem;
    Tourguide1: TMenuItem;
    procedure btnFontClick(Sender: TObject);
    procedure btnItalicClick(Sender: TObject);
    procedure btnBoldClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Index1Click(Sender: TObject);
    procedure MagicMacros1Progress(PercentDone: Integer);
    procedure Maketextbold1Click(Sender: TObject);
    procedure Maketextitalic1Click(Sender: TObject);
    procedure Changethefont1Click(Sender: TObject);
    procedure Panel1DblClick(Sender: TObject);
    procedure Tourguide1Click(Sender: TObject);
    procedure MagicMacros1PlayCancelled(Sender: TObject);
    procedure MagicMacros1PlayEnded(Sender: TObject);
    procedure MagicMacros1VisualHelp(Sender: TObject; ID: Integer);
    procedure MagicMacros1VisualHelpCancelled(Sender: TObject;
      ID: Integer);
    procedure MagicMacros1VisualHelpEnded(Sender: TObject; ID: Integer);
    procedure MagicMacros1BeforePlay(Sender: TObject);
    procedure MagicMacros1BeforeVisualHelp(Sender: TObject; ID: Integer);
  private
    BackupEdit: TRichEdit;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SimpleEditForm: TSimpleEditForm;

implementation

{$R *.DFM}

{-------------------------------------------------------------------------------
 Following eventhandlers interact with the TMagicMacros component to provide
 VisualHelp directly from the "How can I..." menu-item.
 -------------------------------------------------------------------------------}
const
  {ID's of VisualHelp macro's}
  BOLD_TEXT_MACRO = -1001;
  ITALIC_TEXT_MACRO = -1002;
  CHANGE_FONT_MACRO = -1003;
  TOURGUIDE = 'tour.mcr';

procedure TSimpleEditForm.MagicMacros1BeforeVisualHelp(Sender: TObject;
  ID: Integer);
begin
  {Backup the contents of the RichEdit}
  BackupEdit := TRichEdit.Create(Self);
  BackupEdit.Parent := Self;
  BackupEdit.Height := 0;
  BackupEdit.Width := 0;
  RichEdit1.SelectAll;
  RichEdit1.CopyToClipboard;
  BackupEdit.PasteFromClipboard;
  RichEdit1.Clear;
  {Clear out contents of RichEdit1, so we can safely run our show, without
   wrecking the user's data}
  RichEdit1.Clear;
end;

procedure TSimpleEditForm.Maketextbold1Click(Sender: TObject);
begin
  with MagicMacros1 do begin
    PlayVH(BOLD_TEXT_MACRO); //Play the VisualHelp file
    Pause; //Pause playback immediatly to inform the user what we're about to do
    ShowInfoBox('VisualHelp: How can I make text bold?',
                'We''re about to show you how to make text appear bold...'+#13+
                'Just sit back and enjoy the show!', 5000);
    WaitForInfoBox; //Wait until the Infobox is closed before resuming
    Resume; //Let the show begin
  end;
end;

procedure TSimpleEditForm.Maketextitalic1Click(Sender: TObject);
begin
  with MagicMacros1 do begin
    PlayVH(ITALIC_TEXT_MACRO); //Play the VisualHelp file
    Pause; //Pause playback immediatly to inform the user what we're about to do
    ShowInfoBox('VisualHelp: How can I make text italic?',
                'We''re about to show you how to make text appear italic...'+#13+
                'Just sit back and enjoy the show!', 5000);
    WaitForInfoBox; //Wait until the Infobox is closed before resuming
    Resume; //Let the show begin
  end;
end;

procedure TSimpleEditForm.Changethefont1Click(Sender: TObject);
begin
  with MagicMacros1 do begin
    PlayVH(CHANGE_FONT_MACRO); //Play the VisualHelp file
    Pause; //Pause playback immediatly to inform the user what we're about to do
    ShowInfoBox('VisualHelp: How can I change the font?',
                'We''re about to show you how you can change the fontsettings...'+#13+
                'Just sit back and enjoy the show!', 5000);
    WaitForInfoBox; //Wait until the Infobox is closed before resuming
    Resume; //Let the show begin
  end;
end;


{-------------------------------------------------------------------------------
 The code below was used to implement the Tourguide feature.
 -------------------------------------------------------------------------------}
procedure TSimpleEditForm.MagicMacros1BeforePlay(Sender: TObject);
begin
  {Backup the contents of the RichEdit}
  BackupEdit := TRichEdit.Create(Self);
  BackupEdit.Parent := Self;
  BackupEdit.Height := 0;
  BackupEdit.Width := 0;
  RichEdit1.SelectAll;
  RichEdit1.CopyToClipboard;
  BackupEdit.PasteFromClipboard;
  RichEdit1.Clear;
  {Clear out contents of RichEdit1, so we can safely run our show, without
   wrecking the user's data}
  RichEdit1.Clear;
end;

procedure TSimpleEditForm.Tourguide1Click(Sender: TObject);
begin
  with MagicMacros1 do begin
    Macroname := TOURGUIDE;
    Play; //Start the tourguide
    Pause; //Pause immediatly to let the user know what we're about to do
    ShowInfoBox('SimpleEdit: Tourguide',
                'Welcome to SimpleEdit, the easiest texteditor in the world!'+#13+
                'In this short tour, we''ll show the most important features'+#13+
                'of SimpleEdit, so just sit back, put your feet up and learn!',
                8000);
    {Update the statusbar}
    StatusBar1.SimpleText := 'Playing tourguide.';
    StatusBar1.Repaint;
    WaitForInfoBox; //Wait untill the infobox is closed before resuming
    Resume; //Carry on
  end;
end;


{-------------------------------------------------------------------------------
 The eventhandlers below are used to update the statusbar and restore the
 user's data.
 -------------------------------------------------------------------------------}
procedure TSimpleEditForm.MagicMacros1Progress(PercentDone: Integer);
begin
  if msPlaying in MagicMacros1.State then
    StatusBar1.SimpleText := Format('Loading: %d%%',
                                    [PercentDone]);
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.MagicMacros1VisualHelp(Sender: TObject;
  ID: Integer);
begin
  {Update the statusbar}
  StatusBar1.SimpleText := 'Playing VisualHelp.';
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.MagicMacros1VisualHelpCancelled(Sender: TObject;
  ID: Integer);
begin
  {Update the statusbar}
  StatusBar1.SimpleText := 'VisualHelp cancelled.';
  StatusBar1.Repaint;
  MessageDlg('There you go!'+#13+'Click OK to continue...', mtInformation, [mbOK], 0);
  {Copy the user's data back}
  BackupEdit.SelectAll;
  BackupEdit.CopyToClipboard;
  BackupEdit.Free;
  RichEdit1.Clear;
  RichEdit1.PasteFromClipboard;
  StatusBar1.SimpleText := '';
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.MagicMacros1VisualHelpEnded(Sender: TObject;
  ID: Integer);
begin
  {Update the statusbar}
  StatusBar1.SimpleText := 'VisualHelp finished.';
  StatusBar1.Repaint;
  MessageDlg('There you go!'+#13+'Click OK to continue...', mtInformation, [mbOK], 0);
  {Copy the user's data back}
  BackupEdit.SelectAll;
  BackupEdit.CopyToClipboard;
  BackupEdit.Free;
  RichEdit1.Clear;
  RichEdit1.PasteFromClipboard;
  StatusBar1.SimpleText := '';
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.MagicMacros1PlayCancelled(Sender: TObject);
begin
  {Update the statusbar}
  StatusBar1.SimpleText := 'Tourguide cancelled.';
  StatusBar1.Repaint;
  MessageDlg('Thank you for watching the tourguide and enjoy SimpleEdit!'+#13+'Click OK to continue...', mtInformation, [mbOK], 0);
  {Copy the user's data back}
  BackupEdit.SelectAll;
  BackupEdit.CopyToClipboard;
  BackupEdit.Free;
  RichEdit1.Clear;
  RichEdit1.PasteFromClipboard;
  StatusBar1.SimpleText := '';
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.MagicMacros1PlayEnded(Sender: TObject);
begin
  {Update the statusbar}
  StatusBar1.SimpleText := 'Tourguide finished.';
  StatusBar1.Repaint;
  MessageDlg('Thank you for watching the tourguide and enjoy SimpleEdit!'+#13+'Click OK to continue...', mtInformation, [mbOK], 0);
  {Copy the user's data back}
  BackupEdit.SelectAll;
  BackupEdit.CopyToClipboard;
  BackupEdit.Free;
  RichEdit1.Clear;
  RichEdit1.PasteFromClipboard;
  StatusBar1.SimpleText := '';
  StatusBar1.Repaint;
end;

procedure TSimpleEditForm.Panel1DblClick(Sender: TObject);
begin
{ THIS IS THE CODE I USED TO RECORD THE MACRO's
var
  Name: string;
begin
  if not InputQuery('VisualHelp', 'Enter name', Name) then EXIT;
  MagicMacros1.Macroname := Name;
  MagicMacros1.StartRecording;
}
end;

{-------------------------------------------------------------------------------
 The methods below contain the code that pops up the InfoBoxes while playing
 a macro or VisualHelp.
 -------------------------------------------------------------------------------}
procedure TSimpleEditForm.btnFontClick(Sender: TObject);
begin
  with MagicMacros1 do begin
    {All the methods below will return immediatly if we are not currently
     playing a macro or VisualHelp}
    Pause; //Pause playback
    ShowInfoBox('Change font',
                'Clicking the speedbutton or the menu-item will bring up '+
                'a Font-dialog, which you can use to change the font of '+
                'the selected text.', 3000);
    WaitForInfoBox; //Wait untill the box is closed
    Resume; //Resume playback
  end;
  if not FontDialog1.Execute then EXIT;
  with RichEdit1.SelAttributes do begin
    Name := FontDialog1.Font.Name;
    Color := FontDialog1.Font.Color;
    Pitch := FontDialog1.Font.Pitch;
    Size := FontDialog1.Font.Size;
    Style := FontDialog1.Font.Style;
    Height := FontDialog1.Font.Height;
  end;
end;

procedure TSimpleEditForm.btnItalicClick(Sender: TObject);
begin
  with MagicMacros1 do begin
    {All the methods below will return immediatly if we are not currently
     playing a macro or VisualHelp}
    Pause; //Pause playback
    ShowInfoBox('Italic',
                'Clicking the speedbutton or the menu-item will cause '+
                'the selected text to appear in italic.', 3000);
    WaitForInfoBox; //Wait untill the box is closed
    Resume; //Resume playback
  end;
  with RichEdit1.SelAttributes do
    if (fsItalic in Style) then begin
      Style := Style - [fsItalic];
    end
    else begin
      Style := Style + [fsItalic];
    end;
end;

procedure TSimpleEditForm.btnBoldClick(Sender: TObject);
begin
  with MagicMacros1 do begin
    {All the methods below will return immediatly if we are not currently
     playing a macro or VisualHelp}
    Pause; //Pause playback
    ShowInfoBox('Bold',
                'Clicking the speedbutton or the menu-item will cause '+
                'the selected text to appear in bold.', 3000);
    WaitForInfoBox; //Wait untill the box is closed
    Resume; //Resume playback
  end;
  with RichEdit1.SelAttributes do
    if (fsBold in Style) then begin
      Style := Style - [fsBold];
    end
    else begin
      Style := Style + [fsBold];
    end;
end;

procedure TSimpleEditForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TSimpleEditForm.Index1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

end.
