//------------------------------------------------------------------------------
// TBoFilenameEdit : example component about how to use a integrated
//                   button in derived components
//
// Author :   Benny Otten
//
// Version :  $JustDate: 30/11/98 $    $Revision: 4 $
//------------------------------------------------------------------------------

unit BoSpEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ExtDlgs,

  BoEdit;

type

//------------------------------------------------------------------------------
  TBoFilenameEdit = class(TBoSpecialEdit)
  private
    FBoOpenDialog: TOpenDialog;
    procedure   SetBoOpenDialog(const Value: TOpenDialog);
  protected
    procedure   BoDoSearchButtonClick; override;
    procedure   Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(aOwner : TComponent); override;
  published
    property    BoOpenDialog : TOpenDialog read FBoOpenDialog write SetBoOpenDialog;
  end;

implementation

{ TBoFilenameEdit }

procedure TBoFilenameEdit.BoDoSearchButtonClick;
begin
  if assigned(BoOpenDialog) then
    if BoOpenDialog.Execute then
      self.text := BoOpenDialog.filename;   
end;

constructor TBoFilenameEdit.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  BoMainButton.BoResBmpName := 'bobmp_fileopen';
end;

procedure TBoFilenameEdit.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = BoOpenDialog) then
    BoOpenDialog := nil;
end;

procedure TBoFilenameEdit.SetBoOpenDialog(const Value: TOpenDialog);
begin
  FBoOpenDialog := Value;
  if Value <> nil then
    Value.FreeNotification(Self);
end;

end.
