NETMON                      NETMON Manual Page                      NETMON

NAME
        netmon - monitor filtered network traffic
        
SYNOPSIS
        netmon unit [filter] [wc]
        units
        kill unit handle
        
DESCRIPTION
        Netmon is a simple network monitoring tool based on Dan Lanciani's
        NDIS3PKT driver. Netmon will promiscuously monitor filtered network 
        traffic on any Network Adapter to which NDIS3PKT is bound.
        
        NDIS3PKT bindings are known as Units, and each Unit has a Handle.
        When Netmon is started, the desired Unit must be specified, as 
        determined by the Units command. Typical ouput of this command is:
        
            Unit: 0 Windowsname: 0000 MAC Address: 00:aa:00:3d:e4:c4
            Unit: 1 Windowsname: 0002 MAC Address: 44:45:53:54:00:00
            Unit: 2 Windowsname: 0001 MAC Address: 00:40:05:4e:8b:ad
        
        Therefore, to monitor the traffic on the PPP Adapter, the following
        command is needed:
        
            netmon 1 
            
        The above command produces the following output:
        
            Windowsname: 0002 MAC Address: 44:45:53:54:00:00 Handle: 2
            
        To kill this invocation of Netmon, press Enter, and Netmon will exit
        on the next received packet. If no further packets arrive, open a
        second Windows Console and type:
        
            kill 1 2
            
        Netmon output is formatted as follows:
        
            [0 1514 16015294 1 2] 44 45 53 54 00 00 00 00 00 00 00 00 00 00 
            00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

        The values enclosed with [...] are:
        
            Packet sequence number.
            Packet length.
            Time at which the packet was received (in msec).
            Unit
            Handle
            
        A filter packet may be specified to allow selective packet tracing.
        If no filter is specified, the first 34 bytes of all packets are 
        printed.

        A filter packet is stored as a text file in the following format:
        
            FF FF FF FF FF FF FF FF FF FF FF FF 08 00  
        
        The above filter will match ALL IP packets transferred over the 
        specified interface, irrespective of their Ethernet source and 
        destination addresses. The number of bytes printed is always equal 
        to min(packet_length, filter_length).

        The filter value FF matches ANY byte. This is a feature, not a bug.
        This convention greatly simplifies the overhead associated with
        packet filtering and results in minimal impact on performance.
        In cases where Broadcast Packets are to be traced, any desired
        wild-card value can be specified (in decimal) via the wc argument.  
        
        Output is printed to stdout, therefore, shell redirection can be used
        to print to a disk file. When Netmon terminates, the disk file is
        closed.
        
NOTES
        The following filter files are included in the distribution:
        
            ip      - filters IP packets,   34 bytes displayed
            udp     - filters UDP packets,  42 bytes displayed
            tcp     - filters TCP packets,  54 bytes displayed
            icmp    - filters ICMP packets, 38 bytes displayed
            arp     - filters ARP packets,  42 bytes displayed
            
        Any number of invocations of Netmon are allowed, each within its own
        Windows Console. If Netmon is bound to the same Unit more than once,
        each invocation will have a distinct handle.
        
        Netmon places the Adapter in promiscuous mode so that all packets 
        will be captured.
        
        Netmon works ONLY with the version of NDIS3PKT distributed with the
        NAT32 package and is only available to registered NAT32 users.
        
SEE ALSO
        ptrace(1) in the NAT32 man pages.
        
        http://www.nat32.com
