/*
 * Native Library for Java System Toolkit
 *
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

// jst-win32.cpp

#include <windows.h>
#include <iostream.h>

#include <fstream.h>

#include <jni.h>
#include "..\compiled\com_jobjects_jst_win32_SCM.h"
#include "..\compiled\com_jobjects_jst_win32_Win32RegKey.h"



//****  com.jobjects.jst.win32.SCM native code ****


#define THIS_MODULE "jni.dll"


#define JST_REG_ROOT "Software\\JObjects\\JavaSystemToolkit"

#define WIN95_SRVC_KEY "Software\\Microsoft\\Windows\\CurrentVersion\\RunServices"


#define LOGMSG( msg ) {ofstream fout; fout.open("jstlog.txt",ios::ate); fout << msg << endl; fout.close();}


jboolean saveServiceData( const char *name, 
         const char *sclass, const char *classpath, const char *wdir );


DWORD lastError = 0;
char lastErrorMsg[500];


void FormatErrorMessage( const char *msg, BOOL fm )
{
  if( msg )  {  // error message provided

    if( fm )  {

      lastError = GetLastError();
	  LPVOID lpMsgBuf;
	  
      FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
        NULL, lastError, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
        (LPTSTR) &lpMsgBuf, 0, NULL );

      sprintf( lastErrorMsg, "%s %s", msg, lpMsgBuf );
	  
      LocalFree( lpMsgBuf );
	}
    else
	  strcpy( lastErrorMsg, msg );  
  
  }
  else  {  // get last error

    lastError = GetLastError();
    FormatMessage( 
      FORMAT_MESSAGE_FROM_SYSTEM, NULL, lastError,
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &lastErrorMsg, 0, NULL );  
  
  }
}

/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _createService
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_jobjects_jst_win32_SCM__1createService
  (JNIEnv *env, jobject obj, jobject settings )
{
  jmethodID mtd;
  
  // collect data from ServiceSettings objects...
  
  jclass objClass = env->GetObjectClass( settings );
  
  mtd = env->GetMethodID( objClass, "getName", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getServiceClassName", "()Ljava/lang/String;" );
  jstring sclass = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getDescription", "()Ljava/lang/String;" );
  jstring desc = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getClasspath", "()Ljava/lang/String;" );
  jstring classpath = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getAutoStart", "()Z" );
  jboolean autos = (jboolean) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getUsername", "()Ljava/lang/String;" );
  jstring uname = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getPassword", "()Ljava/lang/String;" );
  jstring passwd = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getWorkingDirectory", "()Ljava/lang/String;" );
  jstring wrkdir = (jstring) env->CallObjectMethod( settings, mtd );
  
  // unpack java objects to native types...
  
  const char *_name = env->GetStringUTFChars( name, 0 );
  const char *_sclass = env->GetStringUTFChars( sclass, 0 );
  const char *_desc = env->GetStringUTFChars( desc, 0 );
  const char *_classpath = env->GetStringUTFChars( classpath, 0 );

  char *_uname = NULL;
  if( uname )
    _uname = (char *) env->GetStringUTFChars( uname, 0 );  
  
  char *_passwd = NULL;
  if( passwd )
    _passwd = (char *) env->GetStringUTFChars( passwd, 0 );  


  jclass cls = env->GetObjectClass( obj );
  mtd = env->GetStaticMethodID( cls, "lookupForFile", 
                                     "(Ljava/lang/String;I)Ljava/lang/String;" );
  if(!mtd) {
    LOGMSG( "can't find lookupForFile" )
  }
  

  jstring exePath = (jstring) env->CallStaticObjectMethod( cls, mtd, 
                    env->NewStringUTF( "srvcl.exe" ), 3 );
  if( !exePath )  {
    FormatErrorMessage( "Can't find file srvcl.exe.", FALSE );
    return JNI_FALSE;
  }
  
  const char *_exePath = env->GetStringUTFChars( exePath, 0 );

  char *_wrkdir = NULL;
  if( wrkdir )
    _wrkdir = (char *) env->GetStringUTFChars( wrkdir, 0 );

  
  // Prepare data...
  
  DWORD startOption = SERVICE_DEMAND_START;
  if( autos )
    startOption = SERVICE_AUTO_START;


  // open a connection to the SCM...

  SC_HANDLE newService, scm;

  scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE);
  if (!scm)  {
    FormatErrorMessage( "Can't open SCM.", TRUE );
	return JNI_FALSE;
  }

  // Save specific data
  
  if( !saveServiceData( _name, _sclass, _classpath, _wrkdir ) )  {
    FormatErrorMessage( "Can't save service properties in registry.", FALSE );
	return JNI_FALSE;
  }
  
  
  // Install the new service

  newService = CreateService( scm, _name, _desc,

               SERVICE_ALL_ACCESS, SERVICE_WIN32_OWN_PROCESS,

               startOption, SERVICE_ERROR_NORMAL,

               _exePath, 0, 0, 0, _uname, _passwd );

  if (!newService)  {
    FormatErrorMessage( "Can't create service.", TRUE );
	return JNI_FALSE;
  }

  // clean up

  CloseServiceHandle(newService);
  CloseServiceHandle(scm);

  // release memory
  
  env->ReleaseStringUTFChars( name, _name );
  env->ReleaseStringUTFChars( sclass, _sclass );
  env->ReleaseStringUTFChars( desc, _desc );
  env->ReleaseStringUTFChars( classpath, _classpath );
  if( _uname ) env->ReleaseStringUTFChars( uname, _uname );
  if( _passwd ) env->ReleaseStringUTFChars( passwd, _passwd );
  env->ReleaseStringUTFChars( exePath, _exePath );
  if( _wrkdir ) env->ReleaseStringUTFChars( wrkdir, _wrkdir );

  // return result

  return JNI_TRUE; 
}

/*
 * Saves additional service data in registry
 */
jboolean saveServiceData( const char *name, 
         const char *sclass, const char *classpath, const char *wdir )
{
  HKEY key;
  DWORD res;
  jboolean r = JNI_TRUE;

  if( RegCreateKeyEx(HKEY_LOCAL_MACHINE, JST_REG_ROOT, 0, 
       "REG_SZ", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &key, &res ) == 0)
  {
    HKEY skey;

    if( RegCreateKeyEx( key, name, 0, 
       "REG_SZ", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &skey, &res ) == 0)
	{

      if( sclass )
        if( RegSetValueEx( skey, "ServiceClassName", 0, REG_SZ, 
                  (const unsigned char*) sclass, strlen(sclass)+1 ) ) {
		  r = JNI_FALSE;
		}
	
      if( classpath )
        if( RegSetValueEx( skey, "ClassPath", 0, REG_SZ, 
                  (const unsigned char*) classpath, strlen(classpath)+1 ) ) {
		  r = JNI_FALSE;
		}
	
      if( wdir )
        if( RegSetValueEx( skey, "WorkingDir", 0, REG_SZ, 
                  (const unsigned char*) wdir, strlen(wdir)+1 ) )  {
		  r = JNI_FALSE;
		}
	
      RegCloseKey(skey);
	}
	else
	  r = JNI_FALSE;
	  

    RegCloseKey(key);
  }
  else
    r = JNI_FALSE;

  return r;
}

/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _deleteService
 * Signature: (Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_jobjects_jst_win32_SCM__1deleteService
  (JNIEnv *env, jobject obj, jstring name )
{
  SC_HANDLE service, scm;
  BOOL success;
  SERVICE_STATUS status;

  // Open a connection to the SCM...

  scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE);
  if (!scm)  {
    FormatErrorMessage( "Can't open SCM.", TRUE );
	return JNI_FALSE;
  }

  // Get the service's handle...

  const char *_name = env->GetStringUTFChars( name, 0 );

  service = OpenService(scm, _name, SERVICE_ALL_ACCESS | DELETE);

  if (!service)  {
    FormatErrorMessage( "Can't open service.", TRUE );
    return JNI_FALSE;
  }

  env->ReleaseStringUTFChars( name, _name );

  // Stop the service if necessary...

  success = QueryServiceStatus(service, &status);

  if (!success)  {
    FormatErrorMessage( "Can't query service status.", TRUE );
	return JNI_FALSE;
  }

  if (status.dwCurrentState != SERVICE_STOPPED)  {

    success = ControlService(service, SERVICE_CONTROL_STOP, &status);

    if (!success)  {
      FormatErrorMessage( "Can't stop service.", TRUE );
	  return JNI_FALSE;
	}
  }

  // Remove the service

  success = DeleteService(service);

  if (!success)  {
    FormatErrorMessage( "Can't delete service.", TRUE );
    return JNI_FALSE;
  }

  // Clean up
  CloseServiceHandle(service);
  CloseServiceHandle(scm);

  // Success. Return true.
  return JNI_TRUE;
}

/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _getLastErrorDescription
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_jobjects_jst_win32_SCM__1getLastErrorDescription
  (JNIEnv *env, jobject obj )
{
  return env->NewStringUTF( lastErrorMsg );
}

/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _getPathVariable
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_jobjects_jst_win32_SCM__1getPathVariable
  (JNIEnv *env, jclass cls)
{
  char pathBuff[300];
  DWORD l;

  l = GetEnvironmentVariable( "PATH", pathBuff, 300 );

  return env->NewStringUTF( pathBuff );
}


//****  com.jobjects.jst.win32.Win32RegKey native code ****

/*
 * Returns appropriate top lebel key handle for a specified key type.
 */
HKEY mapTopLevelKey( jint ktype )
{
  HKEY topKey;
  
  if( ktype == 1 )
    topKey = HKEY_LOCAL_MACHINE;

  else if( ktype == 2 )
    topKey = HKEY_CURRENT_USER;

  else if( ktype == 3 )
    topKey = HKEY_USERS;

  else if( ktype == 4 )
    topKey = HKEY_CLASSES_ROOT;

  return topKey;
}

/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _putString
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1putString
  (JNIEnv *env, jobject obj, jstring property, jstring value)
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  const char *_property = env->GetStringUTFChars( property, 0 );
  const char *_value = env->GetStringUTFChars( value, 0 );

  // try to open key
  
  HKEY topKey;
  HKEY key;
  DWORD res;

  topKey = mapTopLevelKey( ktype );
  
  if( RegCreateKeyEx( topKey, _name, 0, 
       "REG_SZ", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &key, &res ) == 0)
  {
    if( RegSetValueEx( key, _property, 0, REG_SZ, 
        (const unsigned char*) _value, strlen(_value)+1 ) != 0 )
	{
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( name, _name );
  env->ReleaseStringUTFChars( property, _property );
  env->ReleaseStringUTFChars( value, _value );

  return;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _remove
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1remove
  (JNIEnv *env, jobject obj, jstring property)
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  const char *_property = env->GetStringUTFChars( property, 0 );

  // try to open key
  
  HKEY topKey;
  HKEY key;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _name, 0, KEY_SET_VALUE, &key ) == 0)
  {
    if( RegDeleteValue( key, _property ) != 0 )
    {
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( name, _name );
  env->ReleaseStringUTFChars( property, _property );

  return;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _getString
 * Signature: (Ljava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1getString
  (JNIEnv *env, jobject obj, jstring property )
{
  jstring rv = NULL;
  
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  const char *_property = env->GetStringUTFChars( property, 0 );

  // try to open key
  
  HKEY topKey;
  HKEY key;
  jboolean res = JNI_FALSE;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _name, 0, KEY_READ, &key ) == 0)
  {
    DWORD dwSize, dwType;
	unsigned char *value;

    if( RegQueryValueEx( key, _property, NULL, &dwType, NULL, &dwSize) == 0 )
    {
      value = (unsigned char *) malloc(dwSize);
      RegQueryValueEx( key, _property, NULL, &dwType, 
         (unsigned char *) value, &dwSize);
		 
	  rv = env->NewStringUTF( (const char *) value ); // set return value
	  free( value );
    }
    else  {
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( name, _name );
  env->ReleaseStringUTFChars( property, _property );

  return rv;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _exists
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1exists
  (JNIEnv *env, jobject obj)
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  // try to open key
  
  HKEY topKey;
  HKEY key;
  jboolean res = JNI_FALSE;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _name, 0, KEY_READ, &key ) == 0)
  {
    RegCloseKey(key);
	res = JNI_TRUE;
  }
  else  {
    if( GetLastError() == 0 )
	  res = JNI_FALSE;
	
	// FIX: throw exception if error occurs.
  }

  // release memory
  
  env->ReleaseStringUTFChars( name, _name );

  // return result
  return res;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _removeKey
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1removeKey
  (JNIEnv *env, jobject obj, jstring parent, jstring kname )
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  const char *_parent = env->GetStringUTFChars( parent, 0 );
  const char *_kname = env->GetStringUTFChars( kname, 0 );

  // try to open key
  
  HKEY topKey;
  HKEY key;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _parent, 0, KEY_SET_VALUE, &key ) == 0)
  {
    if( RegDeleteKey( key, _kname ) != 0 )
    {
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( parent, _parent );
  env->ReleaseStringUTFChars( kname, _kname );

  return;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _keys
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1keys
  (JNIEnv *env, jobject obj)
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  jmethodID emtd = env->GetMethodID( objClass, "addValueToEnumBuff", "(Ljava/lang/String;)V" );
	
  // try to open key
  
  HKEY topKey;
  HKEY key;
  jboolean res = JNI_FALSE;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _name, 0, KEY_ENUMERATE_SUB_KEYS, &key ) == 0)
  {
	int counter = 0;
	LONG res;
    unsigned char nameBuf[100];
	
    DWORD dwSize, dwType;
	FILETIME lastUse;

    do
	{
	  dwSize = 100;
	  
	  res = RegEnumKeyEx( key, counter, (char *) nameBuf, &dwSize, 0, NULL, NULL, &lastUse);
      if( res != ERROR_NO_MORE_ITEMS )
	  {
        env->CallVoidMethod( obj, emtd, 
             env->NewStringUTF( (const char *) nameBuf ) );
      }

      ++counter;
    }
	while( res != ERROR_NO_MORE_ITEMS );

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( name, _name );

  return;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _properties
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1properties
  (JNIEnv *env, jobject obj)
{
  // get key information
  
  jmethodID mtd;
  jclass objClass = env->GetObjectClass( obj );
  
  mtd = env->GetMethodID( objClass, "getFullKeyPath", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( obj, mtd );
  const char *_name = env->GetStringUTFChars( name, 0 );

  mtd = env->GetMethodID( objClass, "getTopLevelKeyType", "()I" );
  jint ktype = env->CallIntMethod( obj, mtd );

  jmethodID emtd = env->GetMethodID( objClass, "addValueToEnumBuff", "(Ljava/lang/String;)V" );
	
  // try to open key
  
  HKEY topKey;
  HKEY key;
  jboolean res = JNI_FALSE;

  topKey = mapTopLevelKey( ktype );
  
  if( RegOpenKeyEx( topKey, _name, 0, KEY_QUERY_VALUE, &key ) == 0)
  {
	int counter = 0;
	LONG res;
    unsigned char nameBuf[100];
	
    DWORD dwSize, dwType;

    do
	{
	  dwSize = 100;
	  
	  res = RegEnumValue( key, counter, (char *) nameBuf, &dwSize, 0, &dwType, NULL, NULL);
      if( ( res != ERROR_NO_MORE_ITEMS ) && ( dwType == REG_SZ ) )
	  {
        env->CallVoidMethod( obj, emtd, 
             env->NewStringUTF( (const char *) nameBuf ) );
      }

      ++counter;
    }
	while( res != ERROR_NO_MORE_ITEMS );

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }

  env->ReleaseStringUTFChars( name, _name );

  return;
}


/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _getLastErrorDescription
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1getLastErrorDescription
  (JNIEnv *env, jobject obj)
{
  return env->NewStringUTF( lastErrorMsg );
}

/*
 * Class:     com_jobjects_jst_win32_Win32RegKey
 * Method:    _getPathVariable
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_jobjects_jst_win32_Win32RegKey__1getPathVariable
  (JNIEnv *env, jclass cls)
{
  char pathBuff[300];
  DWORD l;

  l = GetEnvironmentVariable( "PATH", pathBuff, 300 );

  return env->NewStringUTF( pathBuff );
}


/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _createService95
 * Signature: (Lcom/jobjects/jst/ServiceSettings;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_jobjects_jst_win32_SCM__1createService95
  (JNIEnv *env, jobject obj, jobject settings)
{
  jmethodID mtd;
  
  // collect data from ServiceSettings objects...
  
  jclass objClass = env->GetObjectClass( settings );
  
  mtd = env->GetMethodID( objClass, "getName", "()Ljava/lang/String;" );
  jstring name = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getServiceClassName", "()Ljava/lang/String;" );
  jstring sclass = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getDescription", "()Ljava/lang/String;" );
  jstring desc = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getClasspath", "()Ljava/lang/String;" );
  jstring classpath = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getAutoStart", "()Z" );
  jboolean autos = (jboolean) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getUsername", "()Ljava/lang/String;" );
  jstring uname = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getPassword", "()Ljava/lang/String;" );
  jstring passwd = (jstring) env->CallObjectMethod( settings, mtd );
  
  mtd = env->GetMethodID( objClass, "getWorkingDirectory", "()Ljava/lang/String;" );
  jstring wrkdir = (jstring) env->CallObjectMethod( settings, mtd );
  
  // unpack java objects to native types...
  
  const char *_name = env->GetStringUTFChars( name, 0 );
  const char *_sclass = env->GetStringUTFChars( sclass, 0 );
  const char *_desc = env->GetStringUTFChars( desc, 0 );
  const char *_classpath = env->GetStringUTFChars( classpath, 0 );

  char *_uname = NULL;
  if( uname )
    _uname = (char *) env->GetStringUTFChars( uname, 0 );  
  
  char *_passwd = NULL;
  if( passwd )
    _passwd = (char *) env->GetStringUTFChars( passwd, 0 );  


  jclass cls = env->GetObjectClass( obj );
  mtd = env->GetStaticMethodID( cls, "lookupForFile", 
                                     "(Ljava/lang/String;I)Ljava/lang/String;" );
  if(!mtd) {
    LOGMSG( "can't find lookupForFile" )
  }
  

  jstring exePath = (jstring) env->CallStaticObjectMethod( cls, mtd, 
                    env->NewStringUTF( "srvcl.exe" ), 3 );
  if( !exePath )  {
    FormatErrorMessage( "Can't find file srvcl.exe.", FALSE );
    return JNI_FALSE;
  }
  
  const char *_exePath = env->GetStringUTFChars( exePath, 0 );

  char *_wrkdir = NULL;
  if( wrkdir )
    _wrkdir = (char *) env->GetStringUTFChars( wrkdir, 0 );


  // Save specific data
  
  if( !saveServiceData( _name, _sclass, _classpath, _wrkdir ) )  {
    LOGMSG( "Failed to save service parameters." )
  }
  
  
  // Install the new service

  HKEY key;
  DWORD res;
  
  char srvcpath[300];
  sprintf( srvcpath, "%s %s", _exePath, _name );

  if( RegCreateKeyEx( HKEY_LOCAL_MACHINE, WIN95_SRVC_KEY, 0, 
       "REG_SZ", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &key, &res ) == 0)
  {
    if( RegSetValueEx( key, _name, 0, REG_SZ, 
        (const unsigned char*) srvcpath, strlen(srvcpath)+1 ) != 0 )
	{
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
  }


  // release memory
  
  env->ReleaseStringUTFChars( name, _name );
  env->ReleaseStringUTFChars( sclass, _sclass );
  env->ReleaseStringUTFChars( desc, _desc );
  env->ReleaseStringUTFChars( classpath, _classpath );
  if( _uname ) env->ReleaseStringUTFChars( uname, _uname );
  if( _passwd ) env->ReleaseStringUTFChars( passwd, _passwd );
  env->ReleaseStringUTFChars( exePath, _exePath );
  if( _wrkdir ) env->ReleaseStringUTFChars( wrkdir, _wrkdir );

  // return result

  return JNI_TRUE; 
}


/*
 * Class:     com_jobjects_jst_win32_SCM
 * Method:    _deleteService95
 * Signature: (Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_jobjects_jst_win32_SCM__1deleteService95
  (JNIEnv *env, jobject obj, jstring name )
{
  jboolean rv = JNI_TRUE;
  const char *_name = env->GetStringUTFChars( name, 0 );

  // try to open key
  
  HKEY key;

  if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, WIN95_SRVC_KEY, 0, KEY_SET_VALUE, &key ) == 0)
  {
    if( RegDeleteValue( key, _name ) != 0 )
    {
      // TODO: catch error and throw exception
    }

    RegCloseKey(key);
  }
  else  {
    // TODO: catch error and throw exception
	rv = JNI_FALSE;
  }

  env->ReleaseStringUTFChars( name, _name );

  return rv;
}


