/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst.win32;

import com.jobjects.jst.*;
import java.util.*;

/**
   Win32 implementation of RegistryManager.
*/
public class Win32RegManager implements RegistryManager
{

  public Win32RegManager()
  {
  }

  /**
     @param keyID
     @return registry key or null if key does not exist
  */
  public RegistryKey getTopLevelRegistryKey( int keyID )
  {
    if( keyID != RegistryKey.KEY_LOCAL_MACHINE &&
        keyID != RegistryKey.KEY_CURRENT_USER &&
        keyID != RegistryKey.KEY_USERS &&
        keyID != RegistryKey.KEY_CLASSES_ROOT
       )
      return null;

    return new Win32RegKey( keyID );
  }

  public RegistryKey openRegistryKey( int keyID, String subkey )
  {
    RegistryKey top = getTopLevelRegistryKey( keyID );
    if( top == null )
      return null;

    return openRegistryKey( top, subkey );
  }

  public RegistryKey openRegistryKey( RegistryKey key, String subkey )
  {
    RegistryKey k = key;

    int ind = subkey.indexOf( '\\' );
    if( ind != -1 )  {

      StringTokenizer tok = new StringTokenizer( subkey, "\\" );
      while( tok.hasMoreTokens() )  {
        k = new Win32RegKey( k, tok.nextToken() );
      }

      return k;
    }

    return new Win32RegKey( k, subkey );
  }

}