/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst.win32;

import com.jobjects.jst.*;
import java.util.*;
import java.io.*;

/**
   Win32 implementation of RegistryKey.
*/
public class Win32RegKey implements RegistryKey
{
  private RegistryKey parent;

  private int keyType;

  private String name;

  private Vector enumBuffer;


  /** load native library */
  static {

    String fullpath = lookupForFile( "jst.dll", 1 );
    if( fullpath != null )  {
      //System.out.println( "full path found" );
      System.load( fullpath );
    }
    else  {
      //System.out.println( "full path not found" );
      System.loadLibrary( "jst" ); // Can't rely on default path
    }
  }

  /**
     Constructs top level key.
  */
  protected Win32RegKey( int type )
  {
    keyType = type;
    parent = null;
    name = null;
  }

  /**
     Constructs top level key.
  */
  protected Win32RegKey( RegistryKey parent, String name )
  {
    keyType = KEY_SUBKEY;
    this.parent = parent;
    this.name = name;
  }

  public synchronized void putStringProperty( String name, String value )
         throws RegistryException
  {
    if( name == null )
      throw new RegistryException( "Property name is null." );

    if( value == null )
      throw new RegistryException( "Can't set value to null." );

    _putString( name, value );
  }

  public synchronized
         String getStringProperty( String name ) throws RegistryException
  {
    if( name == null )
      throw new RegistryException( "Property value is not specified (null)" );

    return _getString( name );
  }

  public synchronized
         void removeProperty( String name ) throws RegistryException
  {
    if( name == null )
      throw new RegistryException( "Property value is not specified (null)" );

    _remove( name );
  }

  /**
     Returns parent key or null if it doesn't exist.
  */
  public RegistryKey getParent()
  {
    /*if( keyType != KEY_SUBKEY ) // no need for check
      return null;*/

    return parent;
  }

  /**
     Returns true if key exists.
  */
  public synchronized boolean exists() throws RegistryException
  {
    return _exists();
  }

  public synchronized void removeKey() throws RegistryException
  {
    if( keyType != KEY_SUBKEY )
      throw new RegistryException( "Can't delete top level registry key." );

    _removeKey( ((Win32RegKey) parent).getFullKeyPath(), name );
  }

  protected synchronized void addValueToEnumBuff( String val )
  {
    if( enumBuffer == null )
      return;

    enumBuffer.addElement( val );
  }

  synchronized public Enumeration properties() throws RegistryException
  {
    enumBuffer = new Vector();

    _properties();

    return enumBuffer.elements();
  }

  synchronized public Enumeration subkeys() throws RegistryException
  {
    enumBuffer = new Vector();

    _keys();

    return enumBuffer.elements();
  }

  protected int getKeyType()
  {
    return keyType;
  }

  public int getTopLevelKeyType()
  {
    if( keyType != KEY_SUBKEY )
      return keyType;

    return parent.getTopLevelKeyType();
  }

  protected String getFullKeyPath()
  {
    if( keyType != KEY_SUBKEY )
      return "";

    Win32RegKey p = (Win32RegKey) getParent();
    if( p.getKeyType() != KEY_SUBKEY )
      return name;

    return (p.getFullKeyPath() + "\\" + name);
  }


  native void _putString( String name, String value )
         throws RegistryException;

  native String _getString( String name ) throws RegistryException;

  native void _remove( String name ) throws RegistryException;

  native void _removeKey( String parent, String name ) throws RegistryException;

  native boolean _exists();

  native void _properties();

  native void _keys();

  private native String _getLastErrorDescription();

  private native static String _getPathVariable();

  /**
     @param name file name
     @param where where to look
            (0x01 -> classpath, 0x02 -> path)
     @return full file path or null if not found
  */
  protected static String lookupForFile( String name, int where )
  {
    // get path...

    String path = "";
    if( (where & 0x01) != 0 )
      path += System.getProperty( "java.class.path" ); // get java CLASSPATH
    if( (where & 0x02) != 0 )  {
      path += File.pathSeparator + "." +
              File.pathSeparator + _getPathVariable(); // get system PATH
    }

    StringTokenizer tok = new StringTokenizer( path, File.pathSeparator );
    while( tok.hasMoreTokens() )  {

      String t = tok.nextToken().toLowerCase();  // Windows is case insensitive
      if( t.equals( "." ) )
        t = System.getProperty( "user.dir" ); // get current directory

      File f = new File( t );
      if( f.isFile() || t.endsWith( ".zip" ) || t.endsWith( ".jar" ) ) {
        t = f.getParent();
        f = new File( t );
      }

      // check in directory
      File lf = new File( f, name );
      if( lf.exists() && lf.isFile() )
        return lf.getAbsolutePath();

      // check in ..\lib
      lf = new File( new File( f, "..\\lib" ), name );
      if( lf.exists() && lf.isFile() )
        return lf.getAbsolutePath();

      // check in ..\bin
      lf = new File( new File( f, "..\\bin" ), name );
      if( lf.exists() && lf.isFile() )
        return lf.getAbsolutePath();
    }

    return null;
  }

}
