/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst.win32;

import com.jobjects.jst.*;
import java.lang.reflect.*;
import java.io.*;

public class ControlMessagePeer
{
  private static SCM scm = null;


  static class ServiceThreadRunner implements Runnable
  {
    String srvcClassName;

    ServiceThreadRunner( String className )
    {
      srvcClassName = className;
    }

    public void run()
    {
      try  {
        // get service class
        Class srvcClass = Class.forName( srvcClassName );

        // get main method
        Class[] params = new Class[1];
        params[0] = new String[0].getClass();
        Method mainMtd = srvcClass.getMethod( "main", params );
        if( ( mainMtd.getModifiers() & Modifier.STATIC ) == 0 )  {
          throw new Exception( "Service main method must be 'static'." );
        }

        // prepare main method parameters
        Object[] paramList = new Object[1];
        String[] param = new String[0];
        paramList[0] = param;

        // invoke main method
        mainMtd.invoke( null, paramList );
      }
      catch( Exception e )  {

        /*try {
        String logFile = "e:\\test\\log.txt";

        PrintStream ps = new PrintStream(
                         new FileOutputStream( logFile ) );

        ps.println( e.getMessage() );
        ps.println( e.toString() );

        e.printStackTrace( ps );

        ps.println( "class " + srvcClassName );


        ps.close();
        }
        catch( IOException ee ) {}*/

        e.printStackTrace();
      }
    }
  }

  public static void onStart( String mainClass )
  {
    // initialize scm variable for later...
    scm = (SCM) SystemToolkit.getServiceControlManager();

    // start service in a separate thread
    new Thread( new ServiceThreadRunner( mainClass ) ).start();
  }

  public static void onStop()
  {
    if( scm == null )
      return;

    scm.notifyOnStop();
  }

  public static void onPause()
  {
    if( scm == null )
      return;

    scm.notifyOnPause();
  }

  public static void onContinue()
  {
    if( scm == null )
      return;

    scm.notifyOnContinue();
  }

  public static void onShutdown()
  {
    if( scm == null )
      return;

    scm.notifyOnShutdown();
  }

}

