

package com.jobjects.jst.test;

import com.jobjects.jst.*;
import java.io.*;
import java.util.*;


public class TestService
       implements ServiceControlListener, Runnable
{
  String logFile = "service-log.txt";

  boolean isActive = true;
  boolean isStopped = false;

  public TestService()
  {
    logEvent( "Starting service..." );

    // register as a service control listener
    ServiceControlManager scm = SystemToolkit.getServiceControlManager();
    scm.addServiceControlListener( this );
    logEvent( "Registered listener." );

    // starting service thread
    new Thread( this ).start();
    logEvent( "Service thread started." );
  }

  public void run()
  {
    while( true )
    {
      if( isActive )
        logEvent( "Service running." );

      sleep();

      if( isStopped )  {
        logEvent( "Service stopped." );
        return; // stop thread
      }
    }
  }

  synchronized void sleep()
  {
    if( isStopped )
      return;

    try  { wait( 15000 ); }
    catch( InterruptedException ie ) {}
  }

  synchronized public void stopService()
  {
    logEvent( "Received STOP message." );

    isStopped = true;
    notifyAll();
  }

  synchronized public void pauseService()
  {
    logEvent( "Received PAUSE message." );

    isActive = false;
    notifyAll();
  }

  synchronized public void continueService()
  {
    logEvent( "Received CONTINUE message." );

    isActive = true;
    notifyAll();
  }

  synchronized public void shutdownService()
  {
    logEvent( "Received SHUTDOWN message." );

    isStopped = true;
    notifyAll();
  }

  void logEvent( String msg )
  {
    try  {
      RandomAccessFile raf = new RandomAccessFile( logFile, "rw" );
      raf.seek( raf.length() );

      raf.writeBytes( (new Date()) + " " + msg + "\r\n" );

      raf.close();
    }
    catch( IOException e )  {
      e.printStackTrace();
    }
  }

  /** service entry point */
  public static void main( String[] argv )
  {
    new TestService();
  }
}

