

package com.jobjects.jst.test;

import com.jobjects.jst.*;
import java.util.*;

public class RegistryTest
{

  public RegistryTest( String[] args )
  {
    // check registry support
    if( !SystemToolkit.doesSupportRegistry() )  {
      System.out.println( "No registry support." );
      return;
    }

    // get command line parameters
    String fullKey = args[0];
    String prop_name = null;
    String prop_value = null;
    if( args.length > 1 )
      prop_name = args[1];
    if( args.length > 2 )
      prop_value = args[2];

    // split given full key to top and a subkey
    String subkey = "", topkey = "";
    int ind = fullKey.indexOf( '\\' );
    if( ind != -1 )  {
      subkey = fullKey.substring( ind+1 );
      topkey = fullKey.substring( 0, ind );
    }

    // get ID of top level key
    int topKey = mapTopLevelKey( topkey );
    if( topKey == 0 )  {
      System.out.println( "Key " + topkey + " does not exist." );
      return;
    }


    try  {

      // get registry manager instance
      RegistryManager regm = SystemToolkit.getRegistryManager();

      // create key reference
      RegistryKey key = regm.openRegistryKey( topKey, subkey );


      if( prop_name == null )  {  // if property name is not defined

        // check key existance
        if( !key.exists() )  {
          System.out.println( "Key " + fullKey + " doesn't exist." );
          return;
        }

        // enumerate subkeys

        System.out.println();
        System.out.println( "Subkeys:" );
        for( Enumeration e = key.subkeys(); e.hasMoreElements(); )
        {
          String sk = (String) e.nextElement();
          System.out.println( "  " + sk );
        }

        // enumerate properties

        System.out.println();
        System.out.println( "Properties:" );

        for( Enumeration e = key.properties(); e.hasMoreElements(); )
        {
          String name = (String) e.nextElement();
          String val = key.getStringProperty( name );
          System.out.println( "  " + name + " = " + val );
        }

      }
      else if( prop_value == null )  {

        // just get the requested value

        String val = key.getStringProperty( prop_name );
        if( val == null )
          System.out.println( "Can't find property " + prop_name );
        else
          System.out.println( prop_name + " = " + val );

      }
      else if( prop_value.equals( "-" ) )  {

        // remove value from registry key
        key.removeProperty( prop_name );
        System.out.println( "Property " + prop_name + " removed" );

      }
      else  {

        // put property
        key.putStringProperty( prop_name, prop_value );
        System.out.println( "Property " + prop_name + " set to " + prop_value );

      }

    }
    catch( RegistryException re )  {
      re.printStackTrace();
    }

  }

  int mapTopLevelKey( String key )
  {
    if( key.equals( "HKEY_LOCAL_MACHINE" ) )
      return RegistryKey.KEY_LOCAL_MACHINE;

    if( key.equals( "HKEY_CURRENT_USER" ) )
      return RegistryKey.KEY_CURRENT_USER;

    if( key.equals( "HKEY_USERS" ) )
      return RegistryKey.KEY_USERS;

    if( key.equals( "HKEY_CLASSES_ROOT" ) )
      return RegistryKey.KEY_CLASSES_ROOT;

    return 0;
  }

  public static void main(String[] args)
  {
    //java.awt.Toolkit.getDefaultToolkit().beep();

    if( args.length == 0 || args.length > 3 )  {

      System.out.println( "Usage:" );

      //System.out.println( "To put value in registry:" );
      System.out.println( "java com.jobjects.jst.test.RegistryTest " +
                          "key [ name [ value | - ]]" );
      System.out.println();
      System.out.println( "Examples:" );
      System.out.println( "java com.jobjects.jst.test.RegistryTest ..." );
      System.out.println( " to observe key node" );
      System.out.println( "  ... HKEY_LOCAL_MACHINE\\Software\\JObjects" );
      System.out.println( " to set property value" );
      System.out.println( "  ... HKEY_LOCAL_MACHINE\\Software\\JObjects PropName PropValue" );
      System.out.println( " to get property value" );
      System.out.println( "  ... HKEY_LOCAL_MACHINE\\Software\\JObjects PropName" );
      System.out.println( " to delete property" );
      System.out.println( " ... HKEY_LOCAL_MACHINE\\Software\\JObjects PropName -" );
    
      return;
    }

    RegistryTest registryTest = new RegistryTest( args );

    System.out.println();
    System.out.println( "Success." );
  }
}
