

package com.jobjects.jst.test;

import com.jobjects.jst.*;

public class DeleteServiceTest
{
  public static void main(String[] args)
  {
    String srvname = "JSTTestSrvc"; // default service name

    if( args.length != 0 )
      srvname = args[0]; // get service name from command line

    if( !SystemToolkit.doesSupportServices() )  {
      System.out.println( "Services are not supported." );
      return;
    }

    ServiceControlManager scm = SystemToolkit.getServiceControlManager();

    try  {

      System.out.println( "Deleting service " + srvname );

      // deleting service
      scm.deleteService( srvname );

      System.out.println( "Success." );
    }
    catch( ServiceControlException e )  {
      System.out.println( e.getMessage() );
    }
  }
}
