/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst;

/**
   SystemToolkit provides a collection of static methods
   that represent the entry point to all system services
   supported by JObjects' JST library.
*/
public class SystemToolkit
{
  private static ServiceControlManager scm = null;

  private static RegistryManager regman = null;

  /**
     Returns true if there is a support for system services.
  */
  public static boolean doesSupportServices()
  {
    if( !checkArch() )
      return false;

    String os = System.getProperty( "os.name" );

    //if( os == null || os.indexOf( "Windows" ) == -1 )
    if( os == null || os.indexOf( "NT" ) == -1 )
      return false;

    return true;
  }

  /**
     Returns an instance of ServiceControlManager or null if
     not supported.
  */
  public static synchronized
         ServiceControlManager getServiceControlManager()
  {
    if( !doesSupportServices() )
      return null;

    if( scm != null )  // allow only one instance of SCM
      return scm;

    boolean isNT = true;
    String os = System.getProperty( "os.name" );
    if( os == null || os.indexOf( "NT" ) == -1 )
      isNT = false;

    if( !isNT ) // Win95 services are not supported yet
      return null;

    scm = new com.jobjects.jst.win32.SCM( isNT );

    return scm;
  }


  /**
     Returns true if there is a registry support.
  */
  public static boolean doesSupportRegistry()
  {
    if( !checkArch() )
      return false;

    String os = System.getProperty( "os.name" );
    if( os == null || os.indexOf( "Windows" ) == -1 )
      return false;

    return true;
  }

  /**
     Returns an instance of RegistryManager or null if
     not supported.
  */
  public static synchronized RegistryManager getRegistryManager()
  {
    if( !doesSupportRegistry() )
      return null;

    if( regman != null )  // allow only one instance
      return regman;

    regman = new com.jobjects.jst.win32.Win32RegManager();

    return regman;
  }

  /**
     Platform check.
  */
  private static boolean checkArch()
  {
    String arch = System.getProperty( "os.arch" );
    if( arch == null || !arch.equals( "x86" ) )
      return false;

    return true;
  }
}
