/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst;

/**
   ServiceSettings class manages properties for a new
   system service.
   <p>
   The entry point of the service class is its main method
   whose signature looks just like the main method of Java
   aplications.<br>
   <pre>
          public static void main(String[] args)
   </pre>
   <br>
   If you don't specify the class path required by the
   service current class path value will be taken. 

   @see com.jobjects.jst.ServiceControlManager#createService
*/
public class ServiceSettings
{
  /**
     Service name.
  */
  private String name;

  /**
     Service class name. Method <i>main</i> will be invoked
     for start.
  */
  private String serviceClassName;

  /**
     Descriptive name.
  */
  private String desc;

  /**
     Service classpath. Default value is current classpath.
  */
  private String classpath;

  /**
     If <i>true</i>, service will service will be started
     automatically during system startup.
  */
  private boolean autoStart = false;

  private String username;
  private String passwd;

  private String wrkDir;


  /**
     Initializes the ServiceSettings class.

     @param name the service name
     @param srvcClass the name of the service class
  */
  public ServiceSettings( String name, String srvcClass )
  {
    if( name == null || name.length() == 0 )
      throw new IllegalAccessError( "Service name empty or not defined." );

    if( srvcClass == null || srvcClass.length() == 0 )
      throw new IllegalAccessError( "Service class name empty or not defined." );

    this.name = name;
    serviceClassName = srvcClass;
    desc = name;
  }

  /**
     Returns service name.
  */
  public String getName()
  {
    return name;
  }

  /**
     Returns service class name.
  */
  public String getServiceClassName()
  {
    return serviceClassName;
  }

  /**
     Returns descriptive name of the service.
  */
  public String getDescription()
  {
    return desc;
  }

  /**
     Sets descriptive name of the service.
  */
  public void setDescription( String desc )
  {
    this.desc = desc;
  }

  /**
     Return classpath.
  */
  public String getClasspath()
  {
    return classpath;
  }

  /**
     Sets service classpath.
  */
  public void setClasspath( String cp )
  {
    classpath = cp;
  }

  public boolean getAutoStart()
  {
    return autoStart;
  }

  /**
     Specifies a service to be started automatically by
     the service control manager during system startup. 
  */
  public void setAutoStart( boolean auto )
  {
    autoStart = auto;
  }

  /**
     The service process should be logged on as a
     specified user.

     @param user user name. On the Windows NT form
            <i>DomainName\UserName</i> is required.
     @param password user password
  */
  public void setAuthorization( String user, String password )
  {
    username = user;
    passwd = password;
  }

  public String getUsername()
  {
    return username;
  }

  public String getPassword()
  {
    return passwd;
  }

  public String getWorkingDirectory()
  {
    return wrkDir;
  }

  /**
     Sets working directory for the service.

     @param dir full directory path
  */
  public void setWorkingDirectory( String dir )
  {
    wrkDir = dir;
  }

}