/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst;

/**
   The listener interface for receiving events from the
   service control manager.

   @see com.jobjects.jst.ServiceControlManager#addServiceControlListener
*/
public interface ServiceControlListener
{
  /**
     Request from the service control manager to stop
     the service. Service application should make a
     cleanup here.
     <br>
     When this method returns it is assumed
     that the service has been stopped.
  */
  public void stopService();

  /**
     Request from the service control manager to pause
     the service.
  */
  public void pauseService();

  /**
     Request from the service control manager to continue
     the service.
  */
  public void continueService();

  /**
     Signals that machine has being shut down.
     Service application have to perform a fast cleanup.
  */
  public void shutdownService();
}

