/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst;

/**
   RegistryManager interface provides methods for
   registry key creation.
   <br>
   To get the appropriate instance of RegistryManager for
   a system use SystemToolkit class.

   @see com.jobjects.jst.SystemToolkit
   @see com.jobjects.jst.RegistryKey
*/
public interface RegistryManager
{

  /**
     Returns the top level registry key for a specified
     key ID (one of values defined in the RegistryKey).

     @param keyID top level key
     @return registry key or null if keyID does not exist
  */
  public RegistryKey getTopLevelRegistryKey( int keyID );

  /**
     Creates the registry key instance for a specified
     top level key and a subkey.
     Subkey can be specified as either one ("foo")
     or multilevel key ("foo\bar").

     @param keyID top level key
     @param subkey
  */
  public RegistryKey openRegistryKey( int keyID, String subkey );

  /**
     Creates the registry key instance as a subkey of
     a specified key.
     Subkey can be specified as either one ("foo")
     or multilevel key ("foo\bar").

     @param key parent key
     @param subkey subkey name
  */
  public RegistryKey openRegistryKey( RegistryKey key, String subkey );

}