/*
 * Copyright (c) 1998 JObjects, All Rights Reserved.
 *
 * This software is the confidential and proprietary information 
 * of JObjects ("Confidential Information").  You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered 
 * into with JObjects.
 *
 * JOBJECTS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * JOBJECTS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS
 * SOFTWARE OR ITS DERIVATIVES.
 *
 * JObjects
 * Web: http://www.jobjects.com
 * Email: contact@jobjects.com
 */

package com.jobjects.jst;

import java.util.Enumeration;

/**
   RegistryKey provides access to all methods associated
   with the registry key. To get an appropriate instance of
   the registry key for a system use RegistryManager.
   <br>
   <b>Note:</b> Only string values are supported at this time.
   <br>
   @see com.jobjects.jst.RegistryManager
   @see com.jobjects.jst.SystemToolkit#getServiceControlManager
*/
public interface RegistryKey
{
  // value 0 is reserved for internal use
  public static final int KEY_SUBKEY = 0;

  public static final int KEY_LOCAL_MACHINE = 1;
  public static final int KEY_CURRENT_USER = 2;
  public static final int KEY_USERS = 3;
  public static final int KEY_CLASSES_ROOT = 4;


  /**
     Stores string value for a specified property name
     associated with this registry key.

     @param name property name
     @param value property value
  */
  public void putStringProperty( String name, String value )
         throws RegistryException;

  /**
      Retrieves the string value for a specified property name
      associated with this registry key.

      @param name property name
      @return property value or null if does not exist
  */
  public String getStringProperty( String name )
         throws RegistryException;

  /**
     Removes property from this registry key.
  */
  public void removeProperty( String name ) throws RegistryException;

  /**
     Deletes this key.
     This method cannot delete a key that has subkeys.
  */
  public void removeKey() throws RegistryException;

  /**
     Enumerates the properties of this registry key.

     @return enumeration of property names
  */
  public Enumeration properties() throws RegistryException;

  /**
     Enumerates the subkeys of this registry key.

     @return enumeration of subkey names
  */
  public Enumeration subkeys() throws RegistryException;

  /**
     Returns parent registry key or null if it doesn't exist.
  */
  public RegistryKey getParent();

  /**
     Returns true if this key exists.
  */
  public boolean exists() throws RegistryException;

  /**
     Returns the type of the top level key.
  */
  public int getTopLevelKeyType();

}