// Exe2dpr Version 2.0 (02/10/98). Copyright (c) 1997,98 by Dmitriy Goldobin

#include "exe2dpr.h"

HANDLE  outFile;
DWord   openFlag = CREATE_NEW;

//
// Write data to output without any preprocessing
//
void Write( char *buf, int len )
{
    DWord tmp;
    WriteFile( outFile ? outFile : GetStdHandle( STD_OUTPUT_HANDLE ),
                                                            buf, len, &tmp, 0 );
}

//
// Write string to output with '\n' -> '\r\n' replacements
//
void print( char *str )
{
    char buf[120];
    char *out = buf;

    while( *str ) {
        if( *str == '\n' )
            *out++ = '\r';
        *out++ = *str++;
        }
    Write( buf, out - buf );
}

//
// Write data to output with 'sprintf' preprocessing and '\n' replacement
//
void printf( char *form, ... )
{
    char    buf[120];

    va_list v; va_start(v, form); wvsprintf( buf, form, v );
    print( buf );
}

//
// Print pascal-style (length prefixed) string
//
char *PrintPasString( char *str )
{
    char *p = str+1;
    str += *str + 1;
    char save = *str;
    *str = 0;
    print( p );
    *str = save;
    return str;
}

//
// Print error string and immediate exit
//
void Fatal( char *str )
{
    outFile = 0;
    printf( "%s\n", str );
    exit( 1 );
}

//
// Create output file and replace standart output to it
//
void CreateOutput( char *fileName, char *extension )
{
    char buf[120];

    wsprintf( buf, "%s.%s", fileName, extension );
    HANDLE h = CreateFile( buf, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
                                        0, openFlag, FILE_ATTRIBUTE_NORMAL, 0 );
    if( h == INVALID_HANDLE_VALUE ) {
        printf( "Can't create '%s'.", buf );
        if( openFlag == CREATE_NEW )
            Fatal( " Try to use -o option." );
        exit( 1 );
        }
    outFile = h;
}

//
// Close output file and return standart output to console
//
void CloseOutput()
{
    CloseHandle( outFile );
    outFile = 0;
}
