// Exe2dpr Version 2.0 (02/10/98). Copyright (c) 1997,98 by Dmitriy Goldobin

#include "exe2dpr.h"

PROCESS_INFORMATION procInfo;

DWord   codeBase;
DWord   codeSize;

//
// Load input executable and its resources for DFMs
//
int OpenInput( char *name )
{

// Start program and wait for all dll loading

    static STARTUPINFO      si;
    DEBUG_EVENT             debug;
    DWord                   imageBase;

    if( !CreateProcess( name, 0, 0, 0, 0, DEBUG_PROCESS, 0, 0, &si, &procInfo ) )
        return 1;
    while( 1 ) {
        WaitForDebugEvent( &debug, INFINITE );
        switch( debug.dwDebugEventCode ) {
            case CREATE_PROCESS_DEBUG_EVENT:
                imageBase = DWord(debug.u.CreateProcessInfo.lpBaseOfImage);
            case LOAD_DLL_DEBUG_EVENT:
            case OUTPUT_DEBUG_STRING_EVENT:
                ContinueDebugEvent( debug.dwProcessId, debug.dwThreadId, DBG_CONTINUE );
                continue;
            }
        break;
        }

// Parse NT-EXE header. Determine code section bounds.

    struct {
        IMAGE_NT_HEADERS        nh;
        IMAGE_SECTION_HEADER    sh;
        } hdr;

    Read( imageBase + Read( imageBase + 0x3C ), sizeof(hdr), &hdr );
    if( hdr.nh.Signature != IMAGE_NT_SIGNATURE || *(DWord*)&hdr.sh.Name != 'EDOC' )
        return 1;
    codeBase = imageBase + hdr.sh.VirtualAddress;
    codeSize = hdr.sh.SizeOfRawData;

// Search RT_RCDATA directory in resources

    DWord resBase = imageBase + hdr.nh.OptionalHeader.DataDirectory
                                [IMAGE_DIRECTORY_ENTRY_RESOURCE].VirtualAddress;
    Word count =  ReadWord( resBase+0xC ) + ReadWord( resBase+0xE );
    DWord ptr = resBase + 0x10;
    while( count-- ) {
        if( Read( ptr ) == DWORD(RT_RCDATA) )
            goto found;
        ptr += 8;
        }
    return 1;

// Scan RCDATA resources for DFMs

found:
    char **dfmPtr = dfmTab;
#ifdef DEMO
    DWord dim[2*(MAX_FORMS+2)+1];
    ptr = resBase + (Read( ptr + 4 ) & 0x7FFFFFFF) + 0x14;
    count = ReadWord( ptr-8 ) + ReadWord( ptr-6 );
    if( count > MAX_FORMS + 2 ) {
        ptr += 8 * (count - MAX_FORMS - 3);
        count = MAX_FORMS + 2;
        }
    Read( ptr, sizeof( dim ), dim );
    while( count-- ) {
        DWord data = resBase + Read(resBase + (dim[count*2] & 0x7FFFFFFF) + 0x14);
        DWord size = Read(data+4);
        data = imageBase + Read(data);
        if( Read(data) == DFM_MAGIC ) {
            if( dfmPtr == &dfmTab[MAX_FORMS] ) {
                restrict = " (restricted in demo)";
                break;
                }
            char *dfm = Read( data-4, size + 4 );
            *(DWord*)dfm = size;
            *dfmPtr++ = dfm;
            }
        }
#else
    ptr = resBase + (Read( ptr + 4 ) & 0x7FFFFFFF) + 0x14;
    count = ReadWord( ptr-8 ) + ReadWord( ptr-6 );
    int cnt = 0;
    while( count-- ) {
        DWord data = resBase + Read(resBase + (Read( ptr ) & 0x7FFFFFFF) + 0x14);
        DWord size = Read(data+4);
        data = imageBase + Read(data);
        if( Read(data) == DFM_MAGIC ) {
            char *dfm = Read( data-4, size + 4 );
            *(DWord*)dfm = size;
            dfmTab[cnt++] = dfm;
            }
        ptr += 8;
        }
#endif
    return 0;
}

//
// Close input file
//
void CloseInput()
{
}


//
// Read data from input file
//
void Read( DWord addr, DWord size, void *buf )
{
    if( !ReadProcessMemory( procInfo.hProcess, (void*)addr, buf, size, NULL ) )
        Fatal( "File parsing error" );
}

//
// Read data from input file to allocated buffer
//
char *Read( DWord addr, DWord size )
{
    char *buf = alloc( size );
    Read( addr, size, buf );
    return buf;
}

//
// Read DWord from input file
//
DWord Read( DWord addr )
{
    DWord result;
    Read( addr, 4, &result );
    return result;
}

//
// Read Word from input file
//
DWord ReadWord( DWord addr )
{
    return Word( Read( addr ) );
}

//
// Read Pascal-style name and convert it to C-style
//
char *ReadName( DWord addr )
{
    int len = Byte( Read( addr ) );
    char *buf = Read( addr, len+2 );
    ++buf;
    buf[len] = 0;
    return buf;
}

