// Exe2dpr Version 2.0 (02/10/98). Copyright (c) 1997,98 by Dmitriy Goldobin

#include "exe2dpr.h"

char   *restrict = "";              // demo restriction message
int     delphiVer;                  // version of Delphi 2,3,4

// Static dims is a bad way, but is very good for demo protection

char   *dfmTab[MAX_FORMS+1];        // list of DFM resources
Class   classes[MAX_CLASSES+1];     // list of persistent classes info
char   *uses[MAX_USES+1];           // list of 'uses' in current unit

// offset of vmtTimeInfo from TClass in different Delphi versions

int     vmtTypeInfo[3] = { 44, 48, 60 };

//
// Allocate memory. Good for size-optimized propgram, but not for time-optimized
//
char *alloc( int size )
{
    return (char*)GlobalAlloc( GPTR, size );
}

//
// Case unsensitiver compare pascal-style and c-style strings.
//
int comp( char *n1, char *n2 )
{
    int len = *n1++;
    while( len-- )
        if( (*n1++ ^ *n2++) & 0xDF )
            return 0;
    if( *n2 )
        return 0;
    return 1;
}


//
// Parse TClass structure and save class address, name, unit name, properties,
// fields and methods. Also parse all parent classes
//
Class *ScanClass( DWord addr )
{
    DWord i, j;

    if( delphiVer > 2 )
        addr = Read(addr);              // In delphi > 2 TClass pointers is **
    addr -= vmtTypeInfo[delphiVer-2];   // Shift to TClass.vmtTypeInfo

// If this address already scaned, return old result

    for( Class *cl = classes; cl->addr; ++cl )
        if( cl->addr == addr )
            return cl;

// Create new descriptor. Save address and name. Recursive scan parents.

    cl->addr = addr;
    cl->name = ReadName( Read( addr+vmtClassName ) );
    if( (i = Read( addr + vmtParent )) != 0 )
        cl->parent = ScanClass( i );

// Get unit name from TTypeInfo

    if( (i = Read(addr)) != 0 ) {                   // TTypeInfo
        i += Byte( Read(i+1) ) + 12;                // Skip all before UnitName
        cl->unit = ReadName( i );                   // Read unit name
        i += cl->unit[-1] + 1;
        if( comp( cl->unit-1, cl->name+1 ) )
            cl->nameConflict = 1;

// Get published properties name-typInfo pairs for parsing event procedures.

        j = ReadWord( i );
        Property *ptr = cl->props = (Property*)alloc( sizeof(Property) * (j+1) );
        i += 2;
        while( j-- ) {
            DWord t = Read( i );                // PropInfo.PTypeInfo
            if( delphiVer > 2 ) t = Read( t );  // PropInfo.PPTypeInfo
            ptr->typeInfo = t;
            i += 0x1B + (ptr->name = ReadName( i + 0x1A ))[-1];
            ++ptr;
            }
        }

// Get published fields

    j = (i = Read( addr + vmtFieldTable )) != 0 ? ReadWord( i ) : 0;
    Field *fptr = cl->fields = (Field*)alloc( sizeof(Field) * (j+1) );
    if( j ) {
        DWord types = Read(i+2) + 2;
        while( j-- ) {
            fptr->type = ScanClass( Read( types + ReadWord( i+10 ) * 4 ) );
            i += 7 + (fptr->name = ReadName( i+12 ))[-1];
            ++fptr;
            }
        }

// Get published methods

    j = (i = Read( addr + vmtMethodTable )) != 0 ? ReadWord( i ) : 0;
    Method *ptr = cl->methods = (Method*)alloc( sizeof(Method) * (j+1) );
    while( j-- ) {
        ptr->name = ReadName( i+8 );
        ptr->address = Read( i+4 );
        ptr->typeInfo = 0;
        i += ReadWord( i+2 );
        ++ptr;
        }
    return cl;
}


//
// Parse DFM. Find all published class-fields and methods assignments
//
char *DfmSkipValue( char *p );

char *DfmParse( char *p, Class *base )
{
    int  i;
    char flag = 0;


// Save flag (if exist) and skip ChildPosition (if exist)

    if( *p >= 0xF0 && ((flag = *p++) & dfmChildPos) )
        p = DfmSkipValue( p );

// Search appropriate class by class name and then skip class name

    for( Class *cl = classes; cl->addr && !comp( p, cl->name ); ++cl );
    p += *p+1;

// If this included object and it not inherited, then search appropriate field
// in our class by object name and mark it as published. Skip object name.

    if( cl != base && !(flag & dfmInherited) ) {
        for( Field *f = base->fields; f->name; ++f )
            if( comp( p, f->name ) ) {
                f->published = 1;
                break;
                }
        }
    p += *p+1;

// Scan properties for named assignments and then search this name in class
// methods. If found, search appropriate property name in class and its parent.
// If also found, copy type of property to type of method.

    while( *p ) {
        char *n = p + *p + 1;
        if( cl->addr && *n++ == vaIdent ) {
            for( Method *m = base->methods; m->name; ++m )
                if( comp( n, m->name ) )
                    for( Class *c = cl; c; c = c->parent )
                        for( Property *prop = c->props; prop->name; ++prop )
                            if( comp( p, prop->name ) ) {
                                m->typeInfo = prop->typeInfo;
                                goto ok;
                                }
            }
ok:     p = DfmSkipValue( p + *p + 1 );
        }
    ++p;    // skip end of properties list

// Recursive parsing of contained controls

    while( *p )
        p = DfmParse( p, base );
    return p+1;
}

//
// Skip DFM packed value.
//
char *DfmSkipValue( char *p )
{
    static Byte sizes[] = {0,0,1,2,4,10,0,0,0,0,0,0,0,0,0,4,8,8};
    switch( *p++ ) {
        default:
            return p + sizes[p[-1]];
        case vaList:
            while( *p )
                p = DfmSkipValue( p );
        case vaString:
        case vaIdent:
            return p + *p + 1;
        case vaBinary:
        case vaLString:
            return p + 4 + *(int*)p;
        case vaWString:
            return p + 4 + (*(int*)p) * 2;
        case vaSet:
            while( *p )
                p += *p + 1;
            return p+1;
        case vaCollection:
            while( *p ) {
                if( *p >= vaInt8 && *p <= vaInt32 )
                    p = DfmSkipValue( p );
                ++p;
                while( *p )
                    p = DfmSkipValue( p + *p + 1 );
                ++p;
                }
            return p+1;
        }
    return p;
}

//
// Print procedures declaration or implementation
//
void PrintProcedures( Class *cl, int implement )
{
    static char buf[4096];

    for( Method *method = cl->methods; method->name; ++method ) {

// if method's type is not defined, then search type in parent forms

        for( Class *c = cl->parent; !method->typeInfo && c; c = c->parent )
            for( Method *m = c->methods; m->name; ++m )
                if( comp( method->name-1, m->name ) ) {
                    method->typeInfo = m->typeInfo;
                    break;
                    }


// If TypeInfo present, then load it, else make stub 'procedure name;'

        char *t = "\000\000";
        if( method->typeInfo ) {
            Read( method->typeInfo, 4096, buf );
            if( buf[0] == 8 )
                t = &buf[buf[1]+2];
            }

// Print [    ]function/procedure [class.]name

        if( !implement )
            print( "    " );
        char flag = *t++;
        print( (flag & 1) ? "function " : "procedure " );
        if( implement )
            printf( "%s.", cl->name );
        print( method->name );

// Cicle of argumets printing

        int cnt = *t++;
        if( cnt ) {
            print( "(" );
            while( cnt-- ) {
                switch( *t++ & 7 ) {
                    case 1:
                        print( "var " );
                        break;
                    case 2:
                        print( "const " );
                        break;
                    case 4:
                        print( "array of " );
                    }
                t = PrintPasString( t );
                if( *t )
                    print( ": " );
                t = PrintPasString( t );
                print( cnt ? "; " : ")" );
                }
            }

// Print result type for functions and 'safecall' if need

        if( flag & 1 ) {
            print( ": " );
            PrintPasString( t );
            }
        if( flag & 2 )
            print( "; safecall" );
        print( ";\n" );

// Printf procedure body, if in implementation section

        if( implement )
            printf( "begin\n// Address $%X\nend;\n\n", method->address );
        }
}

//
// Add name to 'uses' list w/o duplicates.
//
void AddUses( char *unit )
{
    for( char **u = uses; *u; ++u )
        if( comp( unit-1, *u ) )
            return;
    u[0] = unit;
    u[1] = 0;
}


//
// Main procedure
//
void Main()
{
    print( "Delphi project sources Rescuer. Version 2.0"
#ifdef DEMO
                                                              " (demo)"
#endif
            ".\nCopyright (c) 1997,98 by Dmitriy Goldobin (gold@ems.ru).\n\n" );

// Parse command line

    char *inpName;
    char *projName;
    int i = 0;
    for( char *p = GetCommandLine(); *p; ++p ) {
        char c = ' ';
        switch( *p ) {
            case '-':
                if( (*(Word*)(p+1) | 0x2020) != 0x206F ) {
                    i = 0;
                    break;
                    }
                openFlag = CREATE_ALWAYS;
                ++p;
            case ' ':
                continue;
            case '"':
                c = '"';
                ++p;
            default:
                ++i;
                projName = inpName = p;
                while( *p && *p != c ) {
                    if( *p == ':' || *p == '\\' )
                        projName = p+1;
                    ++p;
                    }
                if( *p == 0 )
                    break;
                *p = 0;
                continue;
            }
        break;
        }
    if( i != 2 )
        Fatal( "Usage: exe2dpr [-o] exeFileName" );

// Load input file and search all DFM

    if( OpenInput( inpName ) )
        Fatal( "File loading error" );

// Search classes TTypeInfo in code section by DFM names

    char *code = Read( codeBase, codeSize );
    for( i = codeBase; i < codeBase + codeSize; ++i )
        if( *code++ == 7 ) {
            char **dfmPtr = dfmTab;
            for( int j = 0; j < MAX_FORMS; ++j ) {
                char *dfm = *dfmPtr++;
                if( !dfm )
                    break;
                char *dfmName = dfm + 8;
                if( *dfmName >= 0xF0 )
                    ++dfmName;
                if( memcmp( code, dfmName, 1 + *code ) )
                    continue;

// Get TClass structure address from TTypeInfo. Detect delphi version if need.

                DWord addr = i + 2 + *code;
                if( !delphiVer ) {
                    for( int ver = 2; ver < 5; ++ver )
                        if( Read( Read(addr) - vmtTypeInfo[ver-2] ) == i )
                            break;
                    if( ver == 5 )
                        continue;
                    delphiVer = ver;
                    }
                if( delphiVer == 2 )
                    addr = Read(addr);

// Parse TClass structure and all its parents.

                Class *cl = ScanClass( addr );
#ifdef DEMO
                cl->dfm = (char*)(j - MAX_FORMS - 1);
#else
                cl->dfm  = dfm;
#endif
                }
            }

// Scan DFMs for event procedures type

    for( Class *cl = classes; cl->addr; ++cl )
        if( cl->dfm ) {
#ifdef DEMO
            cl->dfm = ((char**)&classes[0])[int(cl->dfm)];
#endif
            DfmParse( cl->dfm + 8, cl );
            }

// Cicle for all classes with DFM

    int genCnt = 0;
    for( cl = classes; cl->name; ++cl ) {
        if( !cl->dfm )
            continue;

// Write DFM file. FF 0A <uppercase class name> 00 30 10 <dfm size> <dfm body>

        CreateOutput( cl->unit, "dfm" );
        Write( "\377\012", 3 );
        for( char *p = cl->name; *p; ++p ) {
            char c = *p;
            if( c >= 'a' ) c -= 0x20;
            Write( &c, 1 );
            }
        Write( "\000\060\020", 3 );
        Write( cl->dfm, 4 + *(DWord*)cl->dfm );
        CloseOutput();

// Make unit list for 'Uses'. It is 8 predefined units, unit of parent class and
// units of all published objects.

        p = "\007Windows\000\010Messages\000\010SysUtils\000\007Classes\000"
            "\010Graphics\000\010Controls\000\005Forms\000\007Dialogs\000";
        char **u = uses;
        while( *p ) {
            *u++ = p + 1;
            p += *p + 2;
            }
        *u = 0;
        AddUses( cl->parent->unit );
        for( Field *f = cl->fields; f->name; ++f )
            if( f->published )
                AddUses( f->type->unit );

// Create unit file. Print header and 'Uses' with line width control.

        CreateOutput( cl->unit, "pas" );
        printf( "unit %s;\n\ninterface\n\nuses\n  ", cl->unit );
        i = 0;
        for( u = uses; *u; ++u ) {
            int len = (*u)[-1];
            if( (i + len) > 75 ) {
                print( ",\n  " );
                i = 0;
                }
            if( i ) {
                print( ", " );
                i += 2;
                }
            print( *u );
            i += len;
            }


// Print class declaration

        printf( ";\n\ntype\n  %s = class(%s)\n", cl->name, cl->parent->name );
        for( f = cl->fields; f->name; ++f )
            if( f->name[0] && f->published )
                printf( "    %s: %s;\n", f->name, f->type->name );
        PrintProcedures( cl, 0 );
        print( "  private\n"
                "    { Private declarations }\n"
                "  public\n"
                "    { Public declarations }\n"
                "  end;\n\n" );

// Print object variable, if is not names conflict

        if( !cl->nameConflict )
            printf( "var\n  %s: %s;\n\n", cl->name+1, cl->name );


// Print implementation section and close unit file

        print( "implementation\n\n"
                "{$R *.DFM}\n\n" );
        PrintProcedures( cl, 1 );
        print( "end.\n" );
        CloseOutput();
        ++genCnt;
        }
    if( !genCnt )
        Fatal( "Forms not found" );

// Create DPR file

    for( p = projName; *p && *p != '.'; ++p );
    *p = 0;
    CreateOutput( projName, "dpr" );
    printf( "program %s;\n\nuses\n  Forms", projName );
    for( cl = classes; cl->name; ++cl )
        if( cl->dfm )
            printf( ",\n  %s in '%s.pas' {%s}", cl->unit, cl->unit, cl->name+1 );
    print( ";\n\n{$R *.RES}\n\nbegin\n  Application.Initialize;\n" );
    for( cl = classes; cl->name; ++cl )
        if( cl->dfm && !cl->nameConflict )
            printf( "  Application.CreateForm(%s, %s);\n", cl->name, cl->name+1 );
    print( "  Application.Run;\nend.\n" );
    CloseOutput();
    printf( "Created %d units%s of Delphi %d.0 project '%s'\n", genCnt, restrict, delphiVer, projName );
}

#pragma aux Main "main"
