###
#Translator 1.1 by dw (dw@mindless.com)
#           1.2 by VR_Dude/t00nie
#
# For eggdrop1.x.x and tcl8.x (uses babelfish at altavista)
# v1.0 (19/12-98) -- first release
# v1.1 (21/12-98) -- added some user settings
#                    added bindings for msg and dcc
#                    made it friendly with multichanbots
# v1.2 (24/01-99) -- rewritten by VR_Dude/t00nie
#                    added auto-translation
#                    removed external script
#
# Usage: !translate <fromlang> <tolang> <text> (PUB)
#        /msg <botnick> translate <fromlang> <tolang> <text> (MSG)
#        .translate <fromlang> <tolang> <text> (DCC)
#        !transadd <nick> <fromlang> <tolang> (PUB)
#        !transdel <nick> (PUB)
# 
###
package require http

####SETTINGS####

#set channels (seporated by space) that !translate should work in
set chans "#yourchannel #otherchannel"

# private responce: 
# 0 - respond to !public queries in the channel
# 1 - respond to !public queries in private notice
# default in channel 1
set privresp 0

# userflag needed to use pub and msg translation
# default "o" (global or channel op)
# use "-" to let everyone use it
set pflag o

# userflag needed to add/remove auto-translation (default "o")
set atpflag "o"

#userflag needed to use translation in dcc (default "-")
set dflag "-"

###END OF SETTINGS####

bind pub $pflag !translate pubm_transl
bind msg $pflag translate msgm_transl
bind dcc $dflag translate dcc_transl
bind pub $atpflag !transadd puba_add
bind pub $atpflag !transrem puba_rem
bind pubm - * puba_transl


proc pubm_transl {nick uhost hand chan args} {
  global privresp chans helptext
  if {[lsearch [string tolower $chans] [string tolower $chan]] == -1} {return 0}
  set args [lindex $args 0]
  if {$args == "help"} {
    putserv "NOTICE $nick :\002U\002sage\037:\037 \002PUB:\002 !translate <fromlang> <tolang> <text to translate>"
    putserv "NOTICE $nick :       \002DCC:\002 .translate <fromlang> <tolang> <text to translate>"
    putserv "NOTICE $nick :       \002MSG:\002 /msg <botnick> translate <fromlang> <tolang> <text to translate>"
    return 0
  }
  if {[llength $args] < 3} {
    putserv "NOTICE $nick :\002U\002sage\037:\037 !translate <fromlang> <tolang> <text to translate>"
    return 0
  }
  set froml [string tolower [lindex $args 0]]
  set tol [string tolower [lindex $args 1]]  
  set args [lrange $args 2 end]
  if {$privresp} { set cmd "NOTICE $nick" } {set cmd "PRIVMSG $chan"}
  putserv "$cmd :Translating '\002[join $args]\002' from '\002$froml\002' to '\002$tol\002' wait.."
  putserv "$cmd :Translated: \002[transl $froml $tol $args]\002"
}

proc msgm_transl {nick uhost hand args} {
  global helptext
  set args [lindex $args 0]
  if {[llength $args] < 3} {
    putserv "PRIVMSG $nick :\002U\002sage\037:\037 translate <fromlang> <tolang> <text to translate>"
    return 0
  }
  set froml [string tolower [lindex $args 0]]
  set tol [string tolower [lindex $args 1]]  
  set args [lrange $args 2 end]
  putserv "PRIVMSG $nick :Translating '[join $args]' from '$froml' to '$tol' wait.."
  putserv "$cmd :[transl $froml $tol $args]"
}

proc dcc_transl {hand idx args} {
  global helptext
  set args [lindex $args 0]
  if {[llength $args] < 3} {
    putdcc $idx "\002U\002sage\037:\037 .translate <fromlang> <tolang> <text to translate>"
  } else {
    set froml [string tolower [lindex $args 0]]
    set tol [string tolower [lindex $args 1]]  
    set args [lrange $args 2 end]
    putdcc $idx "Translating '[join $args]' from '$froml' to '$tol' wait.."
    putdcc $idx "[transl $froml $tol $args]"
  }
}

proc puba_transl {nick uhost hand chan args} {
  global chans atrans
  if {[lsearch [string tolower $chans] [string tolower $chan]] == -1} {return 0}
  set tnick [string tolower $nick]
  if {![info exists atrans($tnick)]} {return 0}
  set froml [lindex $atrans($tnick) 0]
  set tol [lindex $atrans($tnick) 1]
  putserv "PRIVMSG $chan :<$nick> [transl $froml $tol $args]"
}

proc puba_add {nick uhost hand chan args} {
  global atrans
  set args [lindex $args 0]
  if {[llength $args] < 3} {
    putserv "NOTICE $nick :\002U\002sage\037:\037 !transadd <nick> <froml> <tol>"
    return 0
  }
  set tnick [string tolower [lindex $args 0]]
  set froml [lindex $args 1]
  set tol [lindex $args 2]
  set atrans($tnick) "$froml $tol"
  putserv "PRIVMSG $chan :Enabled auto-translate for \002$tnick\002: $froml -> $tol"
}

proc puba_rem {nick uhost hand chan args} {
  global atrans
  set args [lindex $args 0]
  if {[llength $args] < 1} {
    putserv "NOTICE $nick :\002U\002sage\037:\037 !transrem <nick>"
    return 0
  }
  set tnick [string tolower [lindex $args 0]]
  if {[info exists atrans($tnick)]} {
    unset atrans($tnick)
    putserv "PRIVMSG $chan :Disabled auto-translate for \002$tnick\002."
  } else {
    putserv "PRIVMSG $chan :There is no auto-translation for \002$tnick\002."
  }
}

proc transl {froml tol args} {
  if {$froml == "english"} {
    switch $tol {
      french { set lp en_fr }
      german { set lp en_de }
      italian { set lp en_it }
      portuguese { set lp en_pt }
      spanish { set lp en_es }
    }
  } elseif {$tol == "english"} {
    switch $froml {
      french { set lp fr_en }
      german { set lp de_en }
      italian { set lp it_en }
      portuguese { set lp pt_en }
      spanish { set lp es_en }
    }
  }
  if {![info exists lp]} { 
    return "One of the languages is invalid. One has to be English and the other can be French, German, Italian, Portuguese and Spanish."
  }
  set query [::http::formatQuery doit done urltext "[join $args]" lp $lp]
  set mytoken [::http::geturl http://babelfish.altavista.com/cgi-bin/translate? -query $query -blocksize 1024]
  set pdata [::http::data $mytoken]
  set pdata [string range $pdata [expr [string first {<td align="left"><br>} $pdata]+53] [expr [string first "<br><br></font></td></tr>" $pdata]-1]]
  return "[join $pdata]"
}

putlog "Translator v1.2 by VR_Dude/t00nie loaded."
