


import java.awt.*;
import java.io.*;
import java.net.*;

				/** 
   * This class is a Filter that removes HTML tags
   **/
  public class NotagsFilter extends PipeFilter {
   
	/** Constructor just calls superclass */
	public NotagsFilter(Pipe filter2) throws IOException { 
	  super(filter2); 
	}
	/**
	 * Read characters from the reader, one at a time (using a BufferedReader
	 * for efficiency).  Output printable ASCII characters filtered for HTML tags. 
	 **/
	public void filter(Reader r, Writer w) throws IOException {
	  BufferedReader in = new BufferedReader(r);
	  PrintWriter out = new PrintWriter(new BufferedWriter(w));
	  int c;
	  String s;
	  boolean insideTag = false;

	 while((c = in.read()) != -1){
		// Just remove HTML tags
			   
	     if (c == '<') 
			insideTag = true;
		
		  else if (c == '>')
	      insideTag = false;

		   else if ( insideTag == false )
			  out.write( c );
  
				
		   }
	  out.flush();  // flush the output buffer we create
	}
}                  