/* default bindings to load into the Tcl hash-tables */
/*
   This file is part of the eggdrop source code
   copyright (c) 1997 Robey Pointer
   and is distributed according to the GNU general public license.
   For full details, read the top of 'main.c' or the file called
   COPYING that was distributed with this code.
*/

/*************************************************************************/
/*  it's a waste of time to edit this file now -- you can do a binding   */
/*  to get the same effect:                                              */
/*    bind dcc o status *status     <- makes '.status' only require 'o'  */
/*  that's easier to do and doesn't require a recompile.                 */
/*************************************************************************/


/* access required */
#define NEED_PARTY  1
#define NEED_XFER   2
#define NEED_OP     4
#define NEED_MASTER 8
#define NEED_OWNER  16

#define END_FIELD   { NULL, NULL, -1 }

#ifndef NO_IRC
/* stupid function prototypes */
int msg_die(), msg_hello(), msg_help(), msg_ident(), msg_info(), msg_invite(),
  msg_jump(), msg_memory(), msg_op(), msg_pass(), msg_rehash(), msg_reset(),
  msg_status(), msg_who(), msg_whois(), msg_email(), msg_notes(), msg_go();

/* MSG COMMANDS */
/* function call should be:
   int msg_cmd("handle","nick","user@host","params");
   function is responsible for any logging
   (return 1 if successful, 0 if not) */
cmd_t C_msg[]={
  { "die", msg_die, NEED_OWNER },
  { "email", msg_email, 0 },
  { "go", msg_go, NEED_OP },
  { "hello", msg_hello, 0 },
  { "help", msg_help, 0 },
  { "ident", msg_ident, 0 },
  { "info", msg_info, 0 },
  { "invite", msg_invite, NEED_OP },
  { "jump", msg_jump, NEED_MASTER },
  { "memory", msg_memory, NEED_MASTER },
  { "notes", msg_notes, 0 },
  { "op", msg_op, NEED_OP },
  { "pass", msg_pass, 0 },
  { "rehash", msg_rehash, NEED_MASTER },
  { "reset", msg_reset, NEED_MASTER },
  { "status", msg_status, NEED_MASTER },
  { "who", msg_who, 0 },
  { "whois", msg_whois, 0 },
  END_FIELD
};
#endif  /* NO_IRC */

/* function prototypes, take two */
void cmd_pls_ban(), cmd_pls_bot(), cmd_chat(), cmd_pls_host(), cmd_pls_ignore(),
  cmd_pls_user(), cmd_mns_ban(), cmd_mns_host(), cmd_botinfo(), cmd_chinfo(),
  cmd_mns_ignore(), cmd_mns_user(), cmd_addlog(), cmd_away(), cmd_bans(),
  cmd_boot(), cmd_bots(), cmd_chaddr(), cmd_chpass(), cmd_comment(),
  cmd_console(), cmd_dccstat(), cmd_debug(), cmd_die(), cmd_email(), 
  cmd_reload(), cmd_chnick(), cmd_help(), cmd_ignores(), cmd_info(),
  cmd_link(), cmd_match(), cmd_me(), cmd_motd(), cmd_newpass(), cmd_note(),
  cmd_rehash(), cmd_relay(), cmd_reset(), cmd_resetbans(), cmd_save(),
  cmd_set(), cmd_simul(), cmd_status(), cmd_trace(), cmd_unlink(), cmd_who(),
  cmd_whois(), cmd_whom(), cmd_chemail(), cmd_echo(), cmd_bottree(),
  cmd_notes(), cmd_banner(), cmd_nick(), cmd_chattr(),
  cmd_assoc(), cmd_tcl(), cmd_binds(), cmd_flush(),
#ifndef NO_IRC
  cmd_say(), cmd_act(), cmd_servers(), cmd_msg(), cmd_channel(), cmd_files(),
  cmd_op(), cmd_deop(), cmd_dump(), cmd_kick(), cmd_kickban(), cmd_jump(),
  cmd_invite(), cmd_topic(), cmd_adduser(),
#endif
  cmd_fries(), cmd_restart();

/* DCC CHAT COMMANDS */
/* function call should be:
   int cmd_whatever(idx,z,"parameters");
   as with msg commands, function is responsible for any logging
*/
cmd_t C_dcc[]={
  { "+ban", (Function)cmd_pls_ban, NEED_OP },
  { "+bot", (Function)cmd_pls_bot, NEED_MASTER },
  { "+host", (Function)cmd_pls_host, NEED_MASTER },
  { "+ignore", (Function)cmd_pls_ignore, NEED_MASTER },
  { "+user", (Function)cmd_pls_user, NEED_MASTER },
  { "-ban", (Function)cmd_mns_ban, NEED_OP },
  { "-bot", (Function)cmd_mns_user, NEED_MASTER },
  { "-host", (Function)cmd_mns_host, NEED_MASTER },
  { "-ignore", (Function)cmd_mns_ignore, NEED_MASTER },
  { "-user", (Function)cmd_mns_user, NEED_MASTER },
#ifndef NO_IRC
  { "act", (Function)cmd_act, NEED_OP },
#endif
  { "addlog", (Function)cmd_addlog, NEED_OP },
#ifndef NO_IRC
  { "adduser", (Function)cmd_adduser, NEED_MASTER },
#endif
  { "assoc", (Function)cmd_assoc, NEED_MASTER },
  { "away", (Function)cmd_away, 0 },
  { "banner", (Function)cmd_banner, NEED_MASTER },
  { "bans", (Function)cmd_bans, NEED_OP },
  { "binds", (Function)cmd_binds, NEED_MASTER },
  { "boot", (Function)cmd_boot, NEED_MASTER },
  { "botinfo", (Function)cmd_botinfo, 0 },
  { "bots", (Function)cmd_bots, 0 },
  { "bottree", (Function)cmd_bottree, 0 },
  { "chaddr", (Function)cmd_chaddr, NEED_MASTER },
#ifndef NO_IRC
  { "channel", (Function)cmd_channel, NEED_OP },
#endif
  { "chat", (Function)cmd_chat, 0 },
  { "chattr", (Function)cmd_chattr, NEED_MASTER },
  { "chemail", (Function)cmd_chemail, NEED_MASTER },
  { "chinfo", (Function)cmd_chinfo, NEED_MASTER },
  { "chnick", (Function)cmd_chnick, NEED_MASTER },
  { "chpass", (Function)cmd_chpass, NEED_MASTER },
  { "comment", (Function)cmd_comment, NEED_MASTER },
  { "console", (Function)cmd_console, NEED_OP },
  { "dccstat", (Function)cmd_dccstat, NEED_MASTER },
  { "debug", (Function)cmd_debug, NEED_MASTER },
#ifndef NO_IRC
  { "deop", (Function)cmd_deop, NEED_OP },
#endif
  { "die", (Function)cmd_die, NEED_OWNER },
#ifndef NO_IRC
  { "dump", (Function)cmd_dump, NEED_MASTER },
#endif
  { "echo", (Function)cmd_echo, 0 },
  { "email", (Function)cmd_email, 0 },
#ifndef NO_IRC
  { "files", (Function)cmd_files, 0 },
#endif
  { "flush", (Function)cmd_flush, NEED_MASTER },
  { "fries", (Function)cmd_fries, 0 },
  { "help", (Function)cmd_help, 0 },
  { "ignores", (Function)cmd_ignores, NEED_MASTER },
  { "info", (Function)cmd_info, 0 },
#ifndef NO_IRC
  { "invite", (Function)cmd_invite, NEED_OP },
  { "jump", (Function)cmd_jump, NEED_MASTER },
  { "kick", (Function)cmd_kick, NEED_OP },
  { "kickban", (Function)cmd_kickban, NEED_OP },
#endif
  { "link", (Function)cmd_link, NEED_MASTER },
  { "match", (Function)cmd_match, NEED_OP },
  { "me", (Function)cmd_me, 0 },
  { "motd", (Function)cmd_motd, 0 },
#ifndef NO_IRC
  { "msg", (Function)cmd_msg, NEED_OP },
#endif
  { "newpass", (Function)cmd_newpass, 0 },
  { "nick", (Function)cmd_nick, 0 },
  { "note", (Function)cmd_note, 0 },
  { "notes", (Function)cmd_notes, 0 },
#ifndef NO_IRC
  { "op", (Function)cmd_op, NEED_OP },
#endif
  { "quit", CMD_LEAVE, 0 },
  { "rehash", (Function)cmd_rehash, NEED_MASTER },
  { "relay", (Function)cmd_relay, NEED_MASTER },
  { "reload", (Function)cmd_reload, NEED_MASTER },
  { "reset", (Function)cmd_reset, NEED_MASTER },
  { "resetbans", (Function)cmd_resetbans, NEED_OP },
  { "restart", (Function)cmd_restart, NEED_MASTER },
  { "save", (Function)cmd_save, NEED_MASTER },
#ifndef NO_IRC
  { "say", (Function)cmd_say, NEED_OP },
  { "servers", (Function)cmd_servers, NEED_OP },
#endif
#ifdef ENABLE_TCL
  { "set", (Function)cmd_set, NEED_OWNER },
#endif
#ifdef ENABLE_SIMUL
  { "simul", (Function)cmd_simul, NEED_OWNER },
#endif
  { "status", (Function)cmd_status, NEED_MASTER },
#ifdef ENABLE_TCL
  { "tcl", (Function)cmd_tcl, NEED_OWNER },
#endif
#ifndef NO_IRC
  { "topic", (Function)cmd_topic, NEED_OP },
#endif
  { "trace", (Function)cmd_trace, NEED_MASTER },
  { "unlink", (Function)cmd_unlink, NEED_MASTER },
  { "who", (Function)cmd_who, 0 },
  { "whois", (Function)cmd_whois, NEED_OP },
  { "whom", (Function)cmd_whom, 0 },
  END_FIELD
};


#ifndef NO_IRC
/* bleh. */
int cmd_chdir(), cmd_desc(), cmd_get(), cmd_file_help(), cmd_hide(),
  cmd_unhide(), cmd_ls(), cmd_mv(), cmd_pwd(), cmd_rm(), cmd_cp(),
  cmd_mkdir(), cmd_rmdir(), cmd_pending(), cmd_cancel(), cmd_ln(),
  cmd_share(), cmd_unshare(), cmd_lsa();

/* FILE AREA COMMANDS */
/* function call should be:
   int cmd_whatever(idx,z,"parameters");
   as with msg commands, function is responsible for any logging
*/
cmd_t C_file[]={
  { "cancel", cmd_cancel, 0 },
  { "cd", cmd_chdir, 0 },
  { "chdir", cmd_chdir, 0 },
  { "cp", cmd_cp, NEED_MASTER },
  { "desc", cmd_desc, 0 },
  { "get", cmd_get, 0 },
  { "help", cmd_file_help, 0 },
  { "hide", cmd_hide, NEED_MASTER },
  { "ln", cmd_ln, 0 },
  { "ls", cmd_ls, 0 },
  { "lsa", cmd_lsa, 0 },
  { "mkdir", cmd_mkdir, NEED_MASTER },
  { "mv", cmd_mv, NEED_MASTER },
  { "note", (Function)cmd_note, 0 },        /* ditto */
  { "pending", cmd_pending, 0 },
  { "pwd", cmd_pwd, 0 },
  { "quit", CMD_LEAVE, 0 },
  { "rm", cmd_rm, NEED_MASTER },
  { "rmdir", cmd_rmdir, NEED_MASTER },
  { "share", cmd_share, NEED_MASTER },
  { "unhide", cmd_unhide, NEED_MASTER },
  { "unshare", cmd_unshare, NEED_MASTER },
  END_FIELD
};
#endif


/* this sucks!! */
int bot_pls_attr(), bot_pls_ban(), bot_killuser(), bot_link(),
  bot_pls_host(), bot_pls_ignore(), bot_mns_attr(), bot_mns_ban(),
  bot_mns_ignore(), bot_senduf(), bot_handshake(), bot_linked(),
  bot_bye(), bot_chat(), bot_chcomment(), bot_chemail(), bot_zapfbroad(),
  bot_chdccdir(), bot_chinfo(), bot_chhand(), bot_chpass(), bot_trying(),
  bot_newuser(), bot_ping(), bot_pong(), bot_end_trying(), bot_zapf(),
  bot_priv(), bot_reject(), bot_resync(), bot_resync_no(), bot_resyncq(),
  bot_trace(), bot_traced(), bot_ufno(), bot_ufyes(), bot_unlink(),
  bot_unlinked(), bot_userfileq(), bot_version(), bot_whoq(),
  bot_whom(), bot_who(), bot_nlinked(), bot_thisbot(), bot_infoq(),
  bot_motd(), bot_chan(), bot_actchan(), bot_chattr(), bot_pls_banchan(),
  bot_clrxtra(), bot_addxtra(), bot_assoc(), bot_mns_banchan(),
  bot_filereq(), bot_filereject(), bot_filesend(), bot_mns_host(),
  bot_ufsend(), bot_error(), bot_ufyes2(), bot_join(), bot_part(),
  bot_away(), bot_unaway(), bot_idle(), bot_pls_bothost(), bot_chaddr();

/* BOT COMMANDS */
/* function call should be:
   int bot_whatever(idx,z,"parameters");
*/
cmd_t C_bot[]={
  { "*trying", bot_end_trying, 0 },
  { "+ban", bot_pls_ban, 0 },
  { "+banchan", bot_pls_banchan, 0 },
  { "+bothost", bot_pls_bothost, 0 },
  { "+host", bot_pls_host, 0 },
  { "+ignore", bot_pls_ignore, 0 },
  { "-ban", bot_mns_ban, 0 },
  { "-banchan", bot_mns_banchan, 0 },
  { "-host", bot_mns_host, 0 },
  { "-ignore", bot_mns_ignore, 0 },
  { "actchan", bot_actchan, 0 },
  { "addxtra", bot_addxtra, 0 },
  { "assoc", bot_assoc, 0 },
  { "away", bot_away, 0 },
  { "bye", bot_bye, 0 },
  { "chaddr", bot_chaddr, 0 },
  { "chan", bot_chan, 0 },
  { "chat", bot_chat, 0 },
  { "chcomment", bot_chcomment, 0 },
  { "chdccdir", bot_chdccdir, 0 },
  { "chemail", bot_chemail, 0 },
  { "chattr", bot_chattr, 0 },
  { "chhand", bot_chhand, 0 },
  { "chinfo", bot_chinfo, 0 },
  { "chpass", bot_chpass, 0 },
  { "clrxtra", bot_clrxtra, 0 },
  { "error", bot_error, 0 },
  { "filereject", bot_filereject, 0 },
  { "filereq", bot_filereq, 0 },
  { "filesend", bot_filesend, 0 },
  { "handshake", bot_handshake, 0 },
  { "idle", bot_idle, 0 },
  { "info?", bot_infoq, 0 },
  { "join", bot_join, 0 },
  { "killuser", bot_killuser, 0 },
  { "link", bot_link, 0 },
  { "linked", bot_linked, 0 },
  { "motd", bot_motd, 0 },
  { "newuser", bot_newuser, 0 },
  { "nlinked", bot_nlinked, 0 },
  { "part", bot_part, 0 },
  { "ping", bot_ping, 0 },
  { "pong", bot_pong, 0 },
  { "priv", bot_priv, 0 },
  { "reject", bot_reject, 0 },
  { "resync!", bot_resync, 0 },
  { "resync-no", bot_resync_no, 0 },
  { "resync?", bot_resyncq, 0 },
  { "thisbot", bot_thisbot, 0 },
  { "trace", bot_trace, 0 },
  { "traced", bot_traced, 0 },
  { "trying", bot_trying, 0 },
  { "uf-no", bot_ufno, 0 },
  { "uf-yes", bot_ufyes, 0 },
  { "uf-yes2", bot_ufyes2, 0 },
  { "ufsend", bot_ufsend, 0 },
  { "unaway", bot_unaway, 0 },
  { "unlink", bot_unlink, 0 },
  { "unlinked", bot_unlinked, 0 },
  { "userfile?", bot_userfileq, 0 },
  { "version", bot_version, 0 },
  { "who", bot_who, 0 },
  { "who?", bot_whoq, 0 },
  { "whom", bot_whom, 0 },
  { "zapf", bot_zapf, 0 },
  { "zapf-broad", bot_zapfbroad, 0 },
  END_FIELD
};
