/*
   hash.c -- handles:
     (non-Tcl) procedure lookups for msg/dcc/file commands
     (Tcl) binding internal procedures to msg/dcc/file commands

   dprintf'ized, 15nov95
*/
/*
   This file is part of the eggdrop source code
   copyright (c) 1997 Robey Pointer
   and is distributed according to the GNU general public license.
   For full details, read the top of 'main.c' or the file called
   COPYING that was distributed with this code.
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include "../lush.h"
#include "eggdrop.h"
#include "cmdt.h"
#include "hash.h"
#include "proto.h"
#include "tclegg.h"

extern struct dcc_t dcc[];
extern int dcc_total;
extern int serv;
extern char cx_file[];
extern int cx_line;
extern Tcl_HashTable H_msg, H_dcc, H_fil;
extern int hashtot;


/* new hashing function */
void gotcmd(nick,from,msg,ignoring)
char *nick,*from,*msg; int ignoring;
{
  char code[512],hand[41],s[121],total[512];
  context;
  sprintf(s,"%s!%s",nick,from); strcpy(total,msg); rmspace(msg);
  nsplit(code,msg); get_handle_by_host(hand,s); rmspace(msg);
#ifndef TRIGGER_BINDS_ON_IGNORE
  if (!ignoring)
#endif
  check_tcl_msgm(code,nick,from,hand,msg);
  if (!ignoring) if (check_tcl_msg(code,nick,from,hand,msg)) return;
  if (ignoring) return;
  putlog(LOG_MSGS,"*","[%s!%s] %s",nick,from,total);
}

/* for dcc commands -- hash the function */
int got_dcc_cmd(idx,msg)
int idx; char *msg;
{
  char total[512],code[512];
  context;
  strcpy(total,msg); rmspace(msg); nsplit(code,msg); rmspace(msg);
  return check_tcl_dcc(code,idx,msg);
}

/* hash function for file area commands */
int got_files_cmd(idx,msg)
int idx; char *msg;
{
  char total[512],code[512];
  context;
  if (check_tcl_filt(idx,msg)) return 1;
  if (msg[0]=='.') strcpy(msg,&msg[1]);
  strcpy(total,msg); rmspace(msg); nsplit(code,msg); rmspace(msg);
  return check_tcl_fil(code,idx,msg);
}

/* hash function for tandem bot commands */
void dcc_bot(idx,msg)
int idx; char *msg;
{
  char total[512],code[512]; int i,f;
  context;
  strcpy(total,msg); nsplit(code,msg);
  f=0; i=0; while ((C_bot[i].access != -1) && (!f)) {
    if (strcasecmp(code,C_bot[i].name)==0) {
      /* found a match */
      (C_bot[i].func)(idx,msg); f=1;
    }
    i++;
  }
}


/* Tcl bots use the Tcl hash table for dcc and msg commands, so gotta */
/* copy the default hash tables into the Tcl one */
void init_builtins()
{
  int i,j,flags,new; Tcl_HashTable *ht=NULL; Tcl_HashEntry *he;
  tcl_cmd_t *tt; cmd_t *cc=NULL;
#ifdef NO_IRC
  ht=&H_dcc; cc=C_dcc; j=1; {
#else 
  for (j=0; j<3; j++) {
    switch(j) {
    case 0:
      ht=&H_msg; cc=C_msg; break;
    case 1:
      ht=&H_dcc; cc=C_dcc; break;
    case 2:
      ht=&H_fil; cc=C_file; break;
    }
#endif
    i=0; while (cc[i].access != (-1)) {
      flags=0;
      if (cc[i].access & NEED_PARTY) flags|=USER_PARTY;
      if (cc[i].access & NEED_XFER) flags|=USER_XFER;
      if (cc[i].access & NEED_OP) flags|=USER_OP;
      if (j==2) {
	if (cc[i].access & NEED_MASTER) flags|=USER_JANITOR;
      }
      else {
	if (cc[i].access & NEED_MASTER) flags|=USER_MASTER;
      }
      if (cc[i].access & NEED_OWNER) flags|=USER_OWNER;
      tt=(tcl_cmd_t *)tclcmd_alloc(strlen(cc[i].name)+2);
      tt->flags_needed=flags; tt->next=NULL;
      strcpy(tt->func_name,"*"); strcat(tt->func_name,cc[i].name);
      he=Tcl_CreateHashEntry(ht,cc[i].name,&new);
      if (!new) {
	/* append old entry */
	tcl_cmd_t *ttx=(tcl_cmd_t *)Tcl_GetHashValue(he);
	Tcl_DeleteHashEntry(he);
	tt->next=ttx;
      }
      Tcl_SetHashValue(he,tt);
      i++;
    }
  }
}
