/*
password.java  v2.0
Made by John Eriksson 1997  

john_eriksson_sw@hotmail.com

http://surf.to/bugbase

This code is free to use and modify!!!

EXAMPLE HTML CODE:
------------------

<center>
<applet code="password.class"  width=500 height=32>
<param name=root value="http://www.myhomepage.com/">
<param name=wrong value="http://www.myhomepage.com/wrong_pwd.html">
<param name=bgcolor value="ffffff">
<param name=fgcolor value="000000">
<param name=textfield value="40">
<param name=button value="Open">
<param name=font_size value="12">
<param name=font_face value="Courier">
<param name=title value="Enter password:">
</applet>
</center>
*/

import java.applet.*;
import java.awt.*;
import java.lang.*;
import java.net.*;
import java.io.*;
import java.util.*;

/*===================================================================================*/
/* THE MAIN CLASS FOR THIS APPLET
/*===================================================================================*/
public class password extends java.applet.Applet 
{
private Button b_open;
private TextField t_password;
private Label l_title;

private String root;
private int col;
private String title;
private String buttontxt;
private int bgcolor;
private int fgcolor;
private int fsize;
private String fface;
private String errorURL;

/*************************************************************************/
/* Init the display */
/*************************************************************************/
public void init() 
{
int loop;

   //*** Get parameters.
   String att = getParameter("root");
   root = (att == null) ? this.getDocumentBase().toString() : att;
   att = getParameter("textfield");
   col = (att == null) ? 20 : (Integer.valueOf(att).intValue());
   att = getParameter("font_size");
   fsize = (att == null) ? 11 : (Integer.valueOf(att).intValue());
   att = getParameter("font_face");
   fface = (att == null) ? "Arial" : att;
   att = getParameter("bgcolor");
   bgcolor = (att == null) ? Color.white.getRGB() : (Integer.parseInt(att, 16));
   att = getParameter("fgcolor");
   fgcolor = (att == null) ? Color.black.getRGB() : (Integer.parseInt(att, 16));
   att = getParameter("title");
   title = (att == null) ? "" : att;
   att = getParameter("button");
   buttontxt = (att == null) ? "OPEN" : att;
   att = getParameter("wrong");
   errorURL = (att == null) ? "" : att;

   //*** Set font.
   setFont(new Font(fface, Font.PLAIN, fsize));
   //*** Set background color.
   setBackground(new Color(bgcolor));

   //*** Create objects.
   b_open = new Button(buttontxt);
   t_password = new TextField(col);    
   l_title = new Label(title);

   //*** Set background color for text field.
   t_password.setBackground(Color.white);
   //*** Set forebround for title.
   l_title.setForeground(new Color(fgcolor));

   //*** Set echo character for textfield.
   t_password.setEchoCharacter('*');

   //*** Lets build teh layout.
   setLayout(new FlowLayout(FlowLayout.CENTER,3,3));

   //*** Add title if any.
   if(title.length()>0)
      add(l_title);
   //*** Add textfield and button.
   add(t_password);      
   add(b_open);      

   //*** Lets show our creation.
   show();
}

/*************************************************************************/
/* Check if an url exists */
/*************************************************************************/
public static boolean check_if_URL(String url)
{
StringTokenizer tok = new StringTokenizer(url);
String protocol = tok.nextToken(":");
String host = tok.nextToken(":/");
String uri;
int port = 80; 

   //*** Extract protocol, host and uri.
   if (tok.hasMoreTokens())
      uri = "/" + tok.nextToken(" ");
   else
      uri = "/";

   //*** Make the request.
   try {
      //*** Open socket to host.
      Socket clientSocket = new Socket(host, port);

      //*** Get output and inputstream.
      PrintStream outStream = new PrintStream(clientSocket.getOutputStream());
      DataInputStream inStream = new DataInputStream(clientSocket.getInputStream());

      //*** Send request to host.
      outStream.println("HEAD " + uri + " HTTP/1.0\n");

      StringTokenizer line = new StringTokenizer(inStream.readLine());
      String code = line.nextToken(" ");
             code = line.nextToken(" ");
	  
      if(Integer.parseInt(code)<200 || Integer.parseInt(code)>=300)
         return(false);

	  //*** So far so good...lets return true.
	  return(true);
   } 
   catch(IOException ioe) {
      return(false);
   } 
   catch(Exception e) {
      return(false);
   }
}

/************************************************************************/
/* Surf to error URL */
/************************************************************************/
void surfto_error()
{
   if(errorURL.length()>0) {
      try {
         getAppletContext().showDocument(new URL(errorURL),"_self");
      }
      catch (MalformedURLException e) {}   
   }
   else
      showStatus("Invalid password!");
}

/************************************************************************/
/* Surf to an URL */
/************************************************************************/
void surfto()
{
   if(t_password.getText().length()>0) {
      try{
         URL surftoURL = new URL(root+t_password.getText()+".html");
		 t_password.setText("");
        
         if(!check_if_URL(surftoURL.toString())) {
	        surfto_error();
         }
		 else {
            getAppletContext().showDocument(surftoURL,"_self");
		 }
      }
      catch (MalformedURLException e) { surfto_error(); }   
      catch (SecurityException e) { surfto_error(); }
      catch (IOException e) { surfto_error(); }
   }
}

/************************************************************************/
/* Handle all events */
/************************************************************************/
public boolean handleEvent(Event evt)
{
   //*** Handle key press in textfield.
   if(evt.id == Event.KEY_PRESS && evt.target == t_password && evt.key==10){
      surfto();
      return(true);
   }  
   return super.handleEvent(evt);
}

/************************************************************************/
/* Handle all actions */
/************************************************************************/
public boolean action(Event evt, Object arg) 
{
   //*** Handle button press.
   if (evt.target == b_open) {
      surfto();
      return true;
   }
   return(super.action(evt,arg));
}
}

