;*****************************************************************************
;
;   JXT_ME.CMD - MicroEMACS MACRO FUNCTIONS FOR
;
;       JCTN (TM) JAVA CLASS TREE NAVIGATOR
;
;   Copyright (C) Juergen Mueller (J.M.) 1992-1998
;   All rights reserved.
;
;   You are expressly prohibited from selling this software in any form,
;   distributing it with another product, or removing this notice.
;
;   This software and documentation is the confidential and proprietary 
;   information of Juergen Mueller ("Confidential Information").  
;   You shall not disclose such Confidential Information and shall use 
;   it only in accordance with the terms of the license agreement you 
;   entered into with Juergen Mueller.
;
;   Limited permission is given to registered JXT users to modify this
;   file for their own personal use only. This file may not be used for any
;   purpose other than in conjunction with the JXT software package.
;
;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
;   EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE
;   IMPLIED WARRANTIES OF MERCHANTIBILITY, FITNESS FOR A PARTICULAR
;   PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR
;   ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
;   OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. THE ENTIRE RISK
;   AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM AND DOCUMENTATION
;   IS WITH YOU.
;
;   written by: Juergen Mueller, Eastleighstrasse 14, 70806 Kornwestheim,
;               GERMANY
;
;   FILE       : JXT_ME.CMD
;   REVISION   : 05-Dec-1998
;                20:01:24
;
;*****************************************************************************

; NOTE: for OS/2 you should exchange "jctn" with "jctn4os2"
; NOTE: for DOS you should exchange "jctn" with "jctn16"

;*****************************************************************************
;**** write initial message ****
;*****************************************************************************
write-message "Loading JXT macro package"

;*****************************************************************************
;**** macro package initialization section ****
;*****************************************************************************
set %jxt_item ""                ; set internal variables
set %jxt_file ""
set %jxt_line ""
set %jxtn_cmd ""
set %char_set "_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

set %jct_base &env "JCTNBASE"   ; get environment variables, if set

;*****************************************************************************
;**** definition of user macros ****
;*****************************************************************************

;**** find function ****
store-procedure jct
        execute-procedure _extract_item         ; get tagged item
        execute-procedure _jxt_jct
!endm

;**** find function ****
store-procedure jctmark
        execute-procedure _extract_marked_item  ; get marked item
        execute-procedure _jxt_jct
!endm

;**** find function ****
store-procedure jctfind
        set %jxt_item "JCT function name: "
        set %jxt_item @%jxt_item                ; get user input
        execute-procedure _jxt_jct
!endm

;**** set JCT database name ****
store-procedure jctbase
        set %jct_base "JCT database name: "
        set %jct_base @%jct_base                ; get user input
!endm

;**** JCT file list
store-procedure jctfile
        write-message "Extracting JCT filelist"

        !if &not &seq &len %jct_base 0
          set %tmp &cat &cat "-f" %jct_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %jxtn_cmd &cat "jctn -F " %tmp
        pipe-command %jxtn_cmd          ; perform database access, shell command
!endm

;*****************************************************************************
;**** internal macro execution functions ****
;*****************************************************************************

;*****************************************************************************
;* JCT front-end *
;*****************************************************************************
store-procedure _jxt_jct
        !if &seq &len %jxt_item 0
          write-message "No function selected"
          !return
        !endif

        write-message &cat &cat "Searching for function: '" %jxt_item "'"

        !if &not &seq &len %jct_base 0
          set %tmp &cat &cat "-f" %jct_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %jxtn_cmd &cat &cat "jctn -b " %tmp %jxt_item
        execute-procedure _jxt_search                   ; start search
!endm

;*****************************************************************************
;* the database retrieval function *
;*****************************************************************************
store-procedure _jxt_search
        set %jxt_file ""                ; clear variables
        set %jxt_line ""

!force  pipe-command %jxtn_cmd          ; perform database access, shell command
        !if &seq $status FALSE
          !return
        !endif

!force  select-buffer command           ; get result buffer from pipe-command
        !if &seq $status FALSE
          !return
        !endif

!force  beginning-of-file               ; go to file begin
        !if &seq $status FALSE
          !return
        !endif

        set-mark                        ; extract target file name

!force  search-forward " "              ; search for first blank after file name
        !if &seq $status FALSE
          !return
        !endif

        backward-character
        copy-region
        set %jxt_file $kill             ; store target file name
        forward-character
        set-mark                        ; extract target file line
        end-of-line
        copy-region
        set %jxt_line $kill             ; store target file line

!force  delete-window                   ; delete command window
!force  delete-buffer command           ; delete command buffer
!force  next-buffer                     ; switch to next buffer just to hide command buf

        !if &not &exist %jxt_file       ; test if file exists
          write-message &cat &cat "Target file ~"" %jxt_file "~" not found"
          !return
        !endif

!force  find-file %jxt_file             ; open target file

        !if &seq $status TRUE
!force    goto-line %jxt_line           ; jump to target line

          !if &seq $status FALSE
            clear-message-line
            !return
          !endif

          delete-other-windows          ; just for safety
          redraw-display                ; center target line
          clear-message-line
        !endif
!endm

;*****************************************************************************
;* read search item from current buffer *
;*****************************************************************************
store-procedure _extract_item
        set %jxt_item ""                ; clear variable

        !if &seq &sindex %char_set &chr $curchar 0
          !return                       ; not on a valid character
        !endif

!force  end-of-word

        !while TRUE
!force  previous-word
!force  backward-character
        !if &seq &sindex %char_set &chr $curchar 0
!force    forward-character
          !break
        !endif
        !endwhile

        set-mark                        ; mark first item character

        !while TRUE
!force  end-of-word                     ; goto end of item
        !if &seq &sindex %char_set &chr $curchar 0
          !break
        !endif
        !endwhile

        copy-region
        set %jxt_item $kill             ; store item name
!endm

;*****************************************************************************
;* read marked search item *
;*****************************************************************************
store-procedure _extract_marked_item
        set %jxt_item ""                                ; clear variable
!force  copy-region
        set %jxt_item $kill                             ; store item name

        !if &not &seq &len %jxt_item 0
          set %jxt_item &cat &cat "~"" %jxt_item "~""   ; quote
        !endif
!endm

;*****************************************************************************
;* bind macros to WINDOWS menu, only if MicroEMACS for WINDOWS is present *
;*****************************************************************************
!if &seq $sres "MSWIN"          ; test, if this is running under MS Windows
  ; insert separator
  bind-to-menu  nop     ">&Miscellaneous>-@5"

  ; create a new underlying pop-up menu for the JCT macros
  macro-to-menu jct     ">&Miscellaneous>F&FT macros@6>JCT &function search@0"
  macro-to-menu jctmark "JCT function search &mark"
  macro-to-menu jctfind "JCT function search &prompt"
  macro-to-menu jctfile "JCT file&list"
  macro-to-menu jctbase "JCT data&base name"
!endif

;*****************************************************************************
;**** write final message ****
;*****************************************************************************
write-message "jxt macro package loaded"

;**** THIS IS THE END THIS IS THE END THIS IS THE END THIS IS THE END ****

