; Pextor 2.0 by Net Walker!
; You can use this code in your non-commercial projects.
; If you any of this routines, please let me know :)

.486P
LOCALS
JUMPS
.MODEL FLAT, STDCALL
UNICODE=0
INCLUDE W32.inc
INCLUDE ResDef.inc	; include resource definitions
INCLUDE	TlHelp32.asm	; Definitions for using Toolhelp (just the functions I nedded in this project)


EXTRN	wsprintf	: PROC
EXTRN	MakeMappedFile	: PROC	; MMFiles function
EXTRN	EndMappedFile	: PROC	; MMFiles function
EXTRN	ShowErrorMsg	: PROC	; MMFiles function
EXTRN	GetSizeOfFile	: PROC	; MMFiles function
EXTRN	SetFileSize	: PROC	; MMFiles function

.DATA

INCLUDE MainData.asm

.CODE
;-----------------------------------------------------------------------------
start:

	call    GetModuleHandle, 0          
        mov     hInst, eax 

; initialize the WndClass structure 
; Actually, we get the window class from a DIALOG (with CLASS directive) in the resource

	mov	wc.wc_cbSize, WNDCLASSEX_
	mov	wc.wc_style, CS_HREDRAW + CS_VREDRAW 
	mov	wc.wc_lpfnWndProc, offset WndProc
	mov	wc.wc_cbClsExtra, 0
	mov	wc.wc_cbWndExtra, DLGWINDOWEXTRA	; this is needed to use a dialogbox as
							; a window class
	mov	eax, hInst
	mov	wc.wc_hInstance, eax

; load main icon from resource
	call 	LoadIcon, hInst, IDI_ICON1
	mov	wc.wc_hIcon, eax
	mov	wc.wc_hIconSm, eax

; load a default cursor
  	call 	LoadCursor, NULL, IDC_ARROW
	mov	wc.wc_hCursor, eax
	
	mov	wc.wc_hbrBackground, COLOR_BACKGROUND
	mov	wc.wc_lpszMenuName, IDR_MENU1
	mov	wc.wc_lpszClassName, offset szMainClass

  	call 	RegisterClassEx, offset wc

; create the dialogbox that will work as the main window
	call	CreateDialogParam, hInst, offset szMainClass, 0, NULL, 0
	mov	hMain, eax

; get child control handles
	call 	GetDlgItem, hMain, ID_SOURCE
	mov	hSOURCE, eax
	call	GetDlgItem, hMain, ID_BROWSE1
	mov	hBROWSE1, eax
	call	GetDlgItem, hMain, ID_BROWSE2
	mov	hBROWSE2, eax
	call	GetDlgItem, hMain, ID_EXTRACT
	mov	hEXTRACT, eax
	call	GetDlgItem, hMain, ID_INFO
	mov	hINFO, eax
	call	GetDlgItem, hMain, ID_OBJECT
	mov	hOBJECT, eax
	call	GetDlgItem, hMain, ID_EXECUTE
	mov	hEXECUTE, eax
	call	GetDlgItem, hMain, ID_TARGET
	mov	hTARGET, eax
; get menuitem ("Action") handle
	call	GetMenu, hMain
	call	GetSubMenu, eax, 1
	mov	hActionMenu, eax

;Adjust some controls
	call 	SetFocus, hSOURCE
	call	SetWindowText, hTARGET, offset szDefaultHost
	call	EnableMenuItem, hActionMenu, 2, MF_GRAYED+MF_BYPOSITION
	call	EnableMenuItem, hActionMenu, 1, MF_GRAYED+MF_BYPOSITION
	
; make Status Bar
	call	CreateStatusWindow, WS_CHILD + WS_VISIBLE + 3, offset szStatusbarMsg1, hMain, 80	
	mov 	hStatus, eax
	

; Initialize ToolHelp32 functions
	call	InitToolHelp32

msg_loop:

        call    GetMessage, offset msg, 0, 0, 0
        cmp     ax, 0
        je      end_loop
	call	IsDialogMessage, hMain, offset msg	; put this if you dont want to let the 
	cmp	eax, TRUE				; system to handle TAB, ENTER, etc
	jz	msg_loop
        call    TranslateMessage, offset msg
        call    DispatchMessage, offset msg
        jmp     msg_loop

end_loop:
        call    ExitProcess, 0

;-----------------------------------------------------------------------------

WndProc          PROC   hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
		USES ebx, edi, esi		

	mov 	eax, hwnd	    
	mov 	g_hwnd,eax
	mov 	eax, wmsg
	mov 	g_wmsg, eax
	mov 	eax, wparam
	mov 	g_wparam, eax
	mov 	eax, lparam
	mov 	g_lparam, eax

	movzx 	eax, WORD PTR g_wmsg

	.IF ax==WM_DESTROY
	  call	wmdestroy

	.ELSEIF ax==WM_COMMAND
	  call	wmcommand
	  ret
	.ELSE
	  call	DefWindowProc, g_hwnd, g_wmsg, g_wparam, g_lparam
	  jmp	@@End

	.ENDIF
	xor	eax, eax
@@End:
	ret
WndProc         ENDP
;-------------------------------------------------------
wmdestroy	PROC
        call    PostQuitMessage, 0
        mov     eax, 0
        ret
wmdestroy	ENDP
;-------------------------------------------------------
wmcommand	PROC
	mov	ax, word ptr g_wparam
        .IF 	ax==ID_BROWSE1
	call	OpenDialog

	.ELSEIF ax==ID_EXTRACT
	call	Extract
	call	SetStatusText, hStatus, offset szStatusbarMsg1
	.ELSEIF	ax==ID_BROWSE1
	call	OpenDialog

	.ELSEIF	ax==IDM_EXIT
	call	ExitProcess,0

	.ELSEIF	ax==IDM_ABOUT
	call    DialogBoxParam, hInst, IDD_ABOUT, hMain, offset AboutDlg, 0

	.ELSEIF	ax==ID_BROWSE2
	call	SaveDialog

	.ELSEIF	ax==ID_EXECUTE
	call	ExecuteProcess

	.ELSEIF ax==ID_INFO
	call	GetInfo

	.ELSE	
	call	DefWindowProc, g_hwnd, g_wmsg, g_wparam, g_lparam
	jmp	@@End

	.ENDIF
	xor	eax, eax
@@End:
        ret
wmcommand 	ENDP

;------------------------------------------------------------------------
OpenDialog	PROC
; Fill OPENFILENAME Structure (OFN)
	mov	[OFN.on_lStructSize], OPENFILENAME_
	mov	eax, DWORD PTR [hMain]
	mov	[OFN.on_hwndOwner], eax
	mov    	eax, [hInst]
	mov	[OFN.on_hInstance], eax
	mov	[OFN.on_lpstrFilter], offset Filter
	mov 	[OFN.on_lpstrFile], offset szSourcePath
	mov	[OFN.on_nMaxFile], MAX_PATH-1
	mov 	[OFN.on_Flags], OFN_PATHMUSTEXIST+OFN_FILEMUSTEXIST + OFN_HIDEREADONLY
	call    GetOpenFileName, offset OFN
	cmp	eax, FALSE
	jz	EndOD
; Change EditBox text, state of "Execute" button and Combobox
	call	SetWindowText, hSOURCE, offset szSourcePath
	call	EnableWindow, hEXECUTE, FALSE
	call	SendMessage, hOBJECT, CB_RESETCONTENT, 0, 0
	call	EnableWindow, hOBJECT, FALSE
	call	EnableWindow, hEXTRACT, FALSE
; update combobox
	call	GetInfo
EndOD:
	ret
OpenDialog	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
SaveDialog	proc

; Fill OPENFILENAME Structure (OFN)
	mov	[OFN.on_lStructSize], OPENFILENAME_
	mov	eax, DWORD PTR [hMain]
	mov	[OFN.on_hwndOwner], eax
	mov    	eax, [hInst]
	mov	[OFN.on_hInstance], eax
	mov	[OFN.on_lpstrFilter], offset Filter
	mov 	[OFN.on_lpstrFile], offset szTargetPath
	mov	[OFN.on_nMaxFile], MAX_PATH-1
	mov 	[OFN.on_Flags], OFN_HIDEREADONLY
	call    GetSaveFileName, offset OFN
	cmp	eax, FALSE
	jz	EndSD
	call	SetWindowText, hTARGET, offset szTargetPath
EndSD:
	ret
SaveDialog	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
GetInfo	PROC
	pushad
; get filepath from editbox
	call	GetWindowText, hSOURCE, offset szSourcePath, MAX_PATH
	call	OpenPEFile		; Open file and get some PE info
	cmp	eax, FALSE
	jz	@@Error
 	call	UpdateCombo		; update combobox with Object's names
; adjust other controls (buttons, menus, statusbar)
	call	EnableWindow, hOBJECT, TRUE
	call	EnableWindow, hEXECUTE, TRUE
	call	EnableMenuItem, hActionMenu, 2, MF_GRAYED+MF_BYPOSITION		; extract
	call	EnableMenuItem, hActionMenu, 1, MF_ENABLED+MF_BYPOSITION	; Execute
	call	EnableMenuItem, hActionMenu, 0, MF_ENABLED+MF_BYPOSITION	; Info
	call	SetStatusText, hStatus, offset szStatusbarMsg2
	jmp	@@End

	
@@Error:
	call	SendMessage, hOBJECT, CB_RESETCONTENT, 0, 0
	call	EnableWindow, hEXTRACT, FALSE
	call	EnableWindow, hOBJECT, FALSE
	call	EnableWindow, hEXECUTE, FALSE
	call	EnableMenuItem, hActionMenu, 2, MF_GRAYED+MF_BYPOSITION		; extract
	call	EnableMenuItem, hActionMenu, 1, MF_GRAYED+MF_BYPOSITION		; Execute
	call	EnableMenuItem, hActionMenu, 0, MF_ENABLED+MF_BYPOSITION	; Info
@@End:
	popad
	ret
GetInfo	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
OpenPEFile	PROC		; Returns false if any error or not a PE file
	push	edx
; Create Memory Mapped File
	call	MakeMappedFile, 0, offset szSourcePath, 0 , OPEN_EXISTING
	cmp 	eax, FALSE
	jz	EndOF

@CheckPE:
	mov	ExeFileAddr, eax			; ExeFileAddr = begining of file in memory
	call	GetSizeOfFile, 0
	mov	FileSize, eax	
; Get some PE Header Parameters
	mov	eax, ExeFileAddr
	add	eax, 3Ch				; 3Ch = the place on .exe (MZ header) where we found the PEHeader offset
	mov	eax, dword ptr [eax]		
	cmp	eax, FileSize				; we dont wanna reference an invalid address (remember we are working with memory mapped file)
	jae	@NotPE
	add	eax, ExeFileAddr			; PEHeaderAddr=ExeFileAddr+PEHeaderOff
	mov	PEHeaderAddr, eax			; PEHeaderAddr = beggining of PE header in memory
 
; Check PE Signature
	cmp	dword ptr [eax], 00004550h
	jz	@GetParameters
@NotPE:
	call	ShowErrorMsg, offset ErrorMsg1
	mov	eax, FALSE
	jmp 	EndOF			

@GetParameters:
; Get ImageSize
	mov	eax, PEHeaderAddr
	mov	eax, [eax+50h]
	mov	ImageSize, eax
; get Total Header Size
	mov	eax, PEHeaderAddr
	mov	edx, [eax+84]
	mov	ExeHeaderSize, edx
; get Object Table position
	movzx	edx, word ptr [eax+20]	; get NTHeaderSize
	add	edx, 24			; aDD offset of Flag field
	add	edx, PEHeaderAddr
	mov	ObjTableAddr, edx
; get Number of Objects
	movzx	edx, word ptr [eax+6]
	mov	NumObj, dx
	cmp	IsLoaded, FALSE
	jz	AllocSpace
; clean previous allocated space (if any)
	call	GlobalUnlock, ObjTableAddr
	call	GlobalFree, ObjTableHandle

; allocate space for storing Object Table
AllocSpace:
	mov	eax, 40
	mul	dx		; eax= size of object table
	push	eax		; store Object Table size
	call	GlobalAlloc, GMEM_MOVEABLE+GMEM_ZEROINIT, eax
	mov	ObjTableHandle, eax
	call 	GlobalLock, eax
; copy Object Table to allocated space
	mov	esi, ObjTableAddr
	mov	edi, eax
	pop	ecx		; restore Object Table size
	cld
	rep 	movsb
	mov	ObjTableAddr, eax
; close file, in order to allow its execution.  No problem, since we already have what we need
	call	EndMappedFile, 00
	mov	eax, TRUE
EndOF:
	pop	edx
	ret

OpenPEFile	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
UpdateCombo	PROC 
	push	eax ecx esi
; clean ComboBox
	call	SendMessage, hOBJECT, CB_RESETCONTENT, 0, 0
; add "Main Module" string
	mov	esi, offset szMainModule
	call	SendMessage, hOBJECT, CB_ADDSTRING, 0, esi
;	call	SendMessage, hOBJECT, CB_SETITEMDATA, eax, esi	
; add "EXE Header" string
	mov	esi, offset szExeHeader
	call	SendMessage, hOBJECT, CB_ADDSTRING, 0, esi
;	call	SendMessage, hOBJECT, CB_SETITEMDATA, eax, esi	
; add Object Names + Object Table Entry's offset
	mov 	esi, ObjTableAddr
	movzx	ecx, NumObj
NextObjName:
	push	ecx
	call	SendMessage, hOBJECT, CB_ADDSTRING, 0, esi
	call	SendMessage, hOBJECT, CB_SETITEMDATA, eax, esi
	pop	ecx
	add	esi, 40
	loop	NextObjName
	call	SendMessage, hOBJECT, CB_SETCURSEL, 0, 0
	pop	esi ecx eax
	ret
UpdateCombo	ENDP

;------------------------------------------------------------------------


;------------------------------------------------------------------------
ExecuteProcess 	PROC
	pushad
	mov	StartupInfo.si_cb, STARTUPINFO_
	call	CreateProcess, offset szSourcePath, NULL , NULL, NULL, TRUE, NORMAL_PRIORITY_CLASS, NULL, NULL, offset StartupInfo, offset ProcessInfo 
	cmp	eax, FALSE
	jz	ProcessError

ProcessCreated:
; create a thead for monitoring process exiting
	call	CreateThread, NULL, 0, offset WaitForExit, 0, 0, offset ThreadID
	cmp	eax, FALSE
	jz	ThreadError

	mov	IsExecuting, TRUE
; get the image base of the file
; thats the only reason I have to use ToolHelp32 and Psapi in Pextor
	call	GetImageBase, ProcessInfo.pi_dwProcessId, offset szSourcePath
	cmp	eax, 0
	jz	ImageBaseError
	mov	ImageBase, eax

; update buttons
	call	EnableWindow, hEXECUTE, FALSE
	call	EnableWindow, hINFO, FALSE
	call	EnableWindow, hBROWSE1, FALSE
	call	EnableWindow, hEXTRACT, TRUE
	call	EnableMenuItem, hActionMenu, 2, MF_ENABLED+MF_BYPOSITION	; extract
	call	EnableMenuItem, hActionMenu, 1, MF_GRAYED+MF_BYPOSITION		; Execute
	call	EnableMenuItem, hActionMenu, 0, MF_GRAYED+MF_BYPOSITION		; Info
	call	SetFocus, hEXTRACT
; update Status bar text
	call	SetStatusText, hStatus, offset szStatusbarMsg3
	jmp 	@@End

ProcessError:
	call	ShowErrorMsg, offset ErrorProcess
	jmp	@@End
ThreadError:
	call	ShowErrorMsg, offset ErrorThread
	jmp	@@End	

ImageBaseError:
	call	ShowErrorMsg, offset ErrorImageBase

@@End:
	popad
	ret
ExecuteProcess		ENDP
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
GetImageBase	PROC	ProcessID: DWORD, ModuleName: DWORD
	push	ebx ecx edx esi edi

; get Snapshot32
	call	CreateToolhelp32Snapshot, TH32CS_SNAPMODULE, ProcessID
	cmp	eax, -1
	jz	@@Error
	mov	hSnapshot, eax

	mov	ModuleEntry32.me_dwSize, MODULEENTRY32_
	call	Module32First, hSnapshot, offset ModuleEntry32
@@Loop1:
	call	Module32Next, hSnapshot, offset ModuleEntry32
	cmp	eax, FALSE
	jz	@@Error
	call	StrCmp, offset ModuleEntry32.me_szExePath, ModuleName
	cmp	eax, FALSE
	jz	@@Loop1
	mov	eax, ModuleEntry32.me_modBaseAddr
	jmp	@@End

@@Error:
	mov	eax, 0
@@End:	
	push	eax
	call	CloseHandle, hSnapshot	
	pop	eax
	pop	edi esi edx ecx ebx
	ret
GetImageBase	ENDP
;------------------------------------------------------------------------


;-----------------------------------------------------------------------------	
Extract	PROC
	pushad
; verify if the user wants to extract Exe Header
	call	SendMessage, hOBJECT, CB_GETCURSEL, 0, 0
	.IF	eax==0
	  call	ExtractMainModule
	.ELSEIF eax==1
	  call	ExtractHeader
	.ELSE
	  call	ExtractObject
	.ENDIF
	popad
	ret
Extract	ENDP
;-----------------------------------------------------------------------------


;------------------------------------------------------------------------
ExtractMainModule	PROC
	pushad
	cmp	IsExecuting, FALSE
	jz	@@End
; verify if Host Filename is not empty
	call	GetWindowText, hTARGET, offset szTargetPath, MAX_PATH
	test	eax, eax
	jnz	GetMainModule
	call	ShowErrorMsg,  offset ErrorMsg2
	mov	eax, FALSE
	jmp	@@End
GetMainModule:
; first, open the tyarget file
	call	MakeMappedFile, 1, offset szTargetPath, ImageSize, CREATE_ALWAYS
	cmp 	eax, FALSE
	jz	@@End
	mov	HostFileAddr, eax
	
; read the process from memory, directly to the memory mapped file
	call	ReadProcessMemory, ProcessInfo.pi_hProcess, ImageBase, HostFileAddr, ImageSize, NULL
	cmp	eax, FALSE
	jnz	AdjustPeHeader
	call	ShowErrorMsg, offset ErrorReadMem
	jmp	@@End
AdjustPeHeader:

	call	AdjustDumpedPeHeader, HostFileAddr
	
; show Final Message	
	call	ExtractFileName, offset szSourcePath, offset szSourceName 
	call	wsprintf, offset StrBuffer, offset szMsgSuccess3, offset szTargetPath, ImageSize, ImageSize, offset szSourceName 
	add	esp, 24
	call	MessageBox, hMain, offset StrBuffer, offset szMainTitle, MB_OK
; clean dust
	call	EndMappedFile, 01
	
@@End:
	popad
	ret
ExtractMainModule	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
; using a file buffer pointer instead of info already got from the PeHeader, make this function more reusable ;)
AdjustDumpedPeHeader	PROC	FileAddr : DWORD
LOCAL	@@ObjTableAddr: DWORD
	pushad
; get Object Table Address
	mov	edx, FileAddr
	movzx 	ebx, word ptr [edx+3Ch]
	add	edx, ebx  		; edx = PeHeaderAddr
	movzx	ebx, word ptr [edx+14h]		; ebx = NtHeaderSize
	add	ebx, edx
	add	ebx, 24
	mov	@@ObjTableAddr, ebx
; adjust Object Entries
	movzx	ecx, word ptr [edx+06]	; ecx = number of PE Objects 
	mov	edi, @@ObjTableAddr
@@AdjustLoop:
	mov	edx, dword ptr [edi+12] ; edx = ObjectRVA
	mov	dword ptr [edi+20], edx ; puts ObjectRVA in PhysicalRVA	(thats my lazy approach)
; you could also adjust Physical Size, but Windows Loader do not cares about that (have you seen BC++ Builder files?)
	add	edi, 40			; edi points now to the other object entry
	loop	@@AdjustLoop
	popad
	ret
AdjustDumpedPeHeader	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------	
ExtractHeader		PROC
	pushad
	cmp	IsExecuting, FALSE
	jz	@@End
; verify if Host Filename is not empty
	call	GetWindowText, hTARGET, offset szTargetPath, MAX_PATH
	test	eax, eax
	jnz	GetHeader
	call	ShowErrorMsg,  offset ErrorMsg2
	mov	eax, FALSE
	jmp	@@End
GetHeader:

; allocate space to object that will be copied
	call	VirtualAlloc, NULL, ExeHeaderSize, MEM_COMMIT, PAGE_READWRITE	
	mov	HeaderBufferAddr, eax

; read object from memory image to allocated space
	call	ReadProcessMemory, ProcessInfo.pi_hProcess, ImageBase, HeaderBufferAddr, ExeHeaderSize, NULL
	cmp	eax, FALSE
	jnz	CreateHost
	call	ShowErrorMsg, offset ErrorReadMem
	jmp	@@End
CreateHost:
	call	MakeMappedFile, 1, offset szTargetPath, ExeHeaderSize, CREATE_ALWAYS
	cmp 	eax, FALSE
	jz	@@End
	mov	HostFileAddr, eax
; copy code
	mov	esi, HeaderBufferAddr			
	mov	ecx, ExeHeaderSize
	mov	edi, HostFileAddr
	cld
	rep	movsb

; show Final Message	
	call	ExtractFileName, offset szSourcePath, offset szSourceName
	call	wsprintf, offset StrBuffer, offset szMsgSuccess1, offset szTargetPath, ExeHeaderSize, ExeHeaderSize, offset szSourceName 
	add	esp, 24
	call	MessageBox, hMain, offset StrBuffer, offset szMainTitle, MB_OK
; clean dust
	call	EndMappedFile, 01
	call	VirtualFree, HeaderBufferAddr, ObjVirtualSize, MEM_DECOMMIT
@@End:
	popad
	ret

ExtractHeader	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------	
ExtractObject		PROC
	pushad

	cmp	IsExecuting, FALSE
	jz	@@End
; verify if Host Filename is not empty
	call	GetWindowText, hTARGET, offset szTargetPath, MAX_PATH
	test	eax, eax
	jnz	GetObjectParams
	call	ShowErrorMsg,  offset ErrorMsg2
	mov	eax, FALSE
	jmp	@@End
GetObjectParams:
; first, lets store some parameters
	call	SendMessage, hOBJECT, CB_GETCURSEL, 0, 0
	call	SendMessage, hOBJECT, CB_GETITEMDATA, eax, 0
	mov	edx, [eax+12]
	add	edx, ImageBase
	mov	ObjRVA, edx
	mov	edx, [eax+8]
	mov	ObjVirtualSize, edx
	mov	ObjectName, eax
; allocate space to object that will be copied
	call	VirtualAlloc, NULL, ObjVirtualSize, MEM_COMMIT, PAGE_READWRITE	
	mov	ObjBufferAddr, eax

; read object from memory image to allocated space
	call	ReadProcessMemory, ProcessInfo.pi_hProcess, ObjRVA, ObjBufferAddr, ObjVirtualSize, NULL
	cmp	eax, FALSE
	jnz	GetObjectSize
	call	ShowErrorMsg, offset ErrorReadMem
	jmp	@@End
GetObjectSize:
; get object real size
	mov	edi, ObjBufferAddr
	add	edi, ObjVirtualSize	
	dec 	edi			; set pointer to the end of object
	mov	ecx, ObjVirtualSize
	xor	eax, eax
	std
	repz	scasb
	inc	ecx
	mov	BytesToCopy, ecx
	cld		; if you dont restore the Direction Flag, Windows NT will
			; stop execution of this program.  Windows 95 doesnt cares! Why?

; get aligned object size (BytesToCopy)
	mov	eax, BytesToCopy
	mov 	ecx, 512
	xor	edx, edx
	div	ecx
	test	edx, edx
	jz	@@AlreadyFileAligned
	inc	eax
@@AlreadyFileAligned:
	mul 	ecx
	mov	AlignedCodeSize, eax
; Create Host file
	call	MakeMappedFile, 01, offset szTargetPath, AlignedCodeSize, CREATE_ALWAYS
	cmp 	eax, FALSE
	jz	@@End
	mov	HostFileAddr, eax
; copy code
	mov	esi, ObjBufferAddr			
	mov	ecx, BytesToCopy
	mov	edi, HostFileAddr
	cld
	rep	movsb
; zero pad host
	mov	ecx, AlignedCodeSize	; get size of host.exe
	sub	ecx, BytesToCopy	; sub code added
	xor 	eax, eax		; edi is already set from previous routine
	rep	stosb			; zero pad host's trailing

; show Final Message	
	call	wsprintf, offset StrBuffer, offset szMsgSuccess2, offset szTargetPath, AlignedCodeSize, BytesToCopy, ObjectName 
	add	esp, 24
	call	MessageBox, hMain, offset StrBuffer, offset szMainTitle, MB_OK
; clean dust
	call	EndMappedFile, 01
	call	VirtualFree, ObjBufferAddr, ObjVirtualSize, MEM_DECOMMIT
@@End:
	popad
	ret

ExtractObject	ENDP
;------------------------------------------------------------------------


;-----------------------------------------------------------------------------	
WaitForExit	PROC	ThreadParam : DWORD
	push	ebx ecx edx esi edi
	call	WaitForSingleObject, ProcessInfo.pi_hProcess, INFINITE
; process terminated....
	mov 	IsExecuting, FALSE	; just in case
; update buttons
	call	EnableWindow, hEXECUTE, TRUE
	call	EnableWindow, hINFO, TRUE
	call	EnableWindow, hBROWSE1, TRUE
	call	EnableWindow, hEXTRACT, FALSE
	call	EnableMenuItem, hActionMenu, 2, MF_GRAYED+MF_BYPOSITION		; extract
	call	EnableMenuItem, hActionMenu, 1, MF_ENABLED+MF_BYPOSITION	; Execute
	call	EnableMenuItem, hActionMenu, 0, MF_ENABLED+MF_BYPOSITION		; Info
	call	SetFocus, hEXECUTE	
; warn user
	call	MessageBeep, -1	

	pop	edi esi edx ecx ebx
	mov	eax, TRUE
	ret
WaitForExit	ENDP

;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
AboutDlg proc    hAbout:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	cmp	wmsg, WM_INITDIALOG
	mov 	eax, TRUE
	jz	Return	
	cmp	wmsg, WM_COMMAND
	jnz	Default
	cmp	wparam, IDOK
	jz 	AboutEnd
	cmp	wparam, IDCANCEL
	jnz 	Default
AboutEnd:
	call	EndDialog, hAbout, TRUE
	mov	eax, TRUE
	jmp	Return
Default:
      	mov     eax, FALSE       
Return:
      ret                     
AboutDlg endp
;-----------------------------------------------------------------------------


;Some common functions

;-----------------------------------------------------------------------------
;ShowDword	PROC	DwordToShow:DWORD
; I use this only for debugging purposes, specially when I dont have SoftIce loaded :)
;	pushad
;	call	VirtualAlloc, NULL, 100h, MEM_COMMIT, PAGE_READWRITE
;	mov	esi, eax
;	mov	dword ptr [esi], 5825h
;	mov	edi, esi
;	add	edi, 4
;	call	wsprintf, edi, esi, DwordToShow
;	add	esp, 12
;	call	MessageBox, NULL, edi, edi, MB_OK
;	call	VirtualFree, esi, 100h, MEM_DECOMMIT
;	popad
;	ret	
;ShowDword	ENDP
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
StrLen		PROC	StrOffset:DWORD
	push 	ecx edi
	mov	edi,	StrOffset
	xor	eax, eax
	mov	ecx, -1
	cld
	repnz	scasb
	not	ecx
	dec	ecx
	mov	eax, ecx
	pop	edi ecx
	ret
StrLen		ENDP
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
StrCmp	PROC	Str1 : DWORD, Str2 : DWORD
	push	edx esi edi
	call	StrUpper, Str1
	call	StrUpper, Str2
	mov	esi, Str1
	mov	edi, Str2
SearchLoop:
	mov	al, byte ptr [esi]
	cmp	al, 0			
	jz	EndCS
	cmp	byte ptr [edi], 0
	jz	EndCS
	cmp	al, byte ptr [edi]
	jnz	NotEqual 	
	mov	edx, TRUE
	inc 	esi
	inc 	edi
	jmp	SearchLoop
NotEqual:
	mov	edx, FALSE
EndCS:
	mov	eax, edx
	pop	edi esi edx
	ret
StrCmp	ENDP
;-----------------------------------------------------------------------------	


;-----------------------------------------------------------------------------
StrUpper	PROC 	Str1 : DWORD
	push	eax esi
	mov	esi, Str1
@@StrUpperLoop:
	lodsb
	cmp	al, 0
	jz	EndASU
	cmp	al, 'a'
	jb	@@StrUpperLoop
	cmp	al, 'z'
	ja	@@StrUpperLoop
	sub	byte ptr [esi-1], 20h
	jmp	@@StrUpperLoop
EndASU:
	pop	esi eax
	ret
StrUpper	ENDP
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
ExtractFileName	PROC	FilePath:DWORD, FileNameBuffer:DWORD
	push	ecx esi edi
	pushfd
; get String Size
	xor 	eax, eax
	mov	edi, FilePath
	mov	ecx, -1
	cld
	repnz	scasb
	not	ecx
	dec	edi
; back searching last "\"
	mov	al, "\"
	std
	repnz	scasb
	jnz	@@1
	inc	edi
@@1:
	inc	edi
; copy File name to buffer
	mov	esi, edi
	mov	edi, FileNameBuffer
	call	StrLen, esi
	inc	eax
	mov	ecx, eax
	rep	movsb 
	popfd
	pop	edi esi ecx
	ret
ExtractFileName	ENDP
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
SetStatusText	PROC	SbHandle:DWORD, TextOffset: DWORD
	pushad
	call	SendMessage, SbHandle, SB_SETTEXT, 0, NULL
	call	SendMessage, SbHandle, SB_SETTEXT, 0, TextOffset
	call	UpdateWindow, SbHandle
	popad
	ret
SetStatusText	ENDP
;-----------------------------------------------------------------------------

ends
end start

