.486P
LOCALS
JUMPS
.MODEL FLAT, STDCALL
UNICODE=0
INCLUDE	W32.inc

PUBLIC	MakeMappedFile
PUBLIC	EndMappedFile
PUBLIC	SetFileSize
PUBLIC	GetFileHandle
PUBLIC	GetSizeOfFile
PUBLIC	ShowErrorMsg
EXTRN	_wsprintfA	: PROC
.data

FileAttr	DD	0
FileHandle	DD	0
MemoryHandle	DD	0
MemoryAddress	DD	0
Buffer		DB	12*5 dup(0)		; Space for 5 file parameters
StrBuffer	DB	MAX_PATH dup(0)
; Error Messages
Caption		DB	"Error",0
ErrorMsg1	DB	"Cannot Open File <%s>",0
ErrorMsg2	DB	"File <%s> Not Found",0
ErrorMsg3	DB	"Cannot Create Memory Object For File <%s>",0
ErrorMsg4	DB	"Cannot Map View of File <%s>",0
ErrorMsg5	DB	"Invalid File Name",0
ErrorMsg6	DB	"Path For File <%s> Not Found ",0

;--------------------------------------------------------------------------------------
.code
MakeMappedFile	PROC	FileID:DWORD, FileNameOff:DWORD, Delta:DWORD, Flags:DWORD	
	push	ebx ecx
	mov	eax,	FileNameOff
	cmp	byte ptr [eax], 0
	jnz	@@ValidFileName
	call	ShowErrorMsg, offset ErrorMsg5
	jmp	@@ReturnError
@@ValidFileName:
	mov	eax, FileID
	mov	cl, 12
	mul	cl
	xor	ebx, ebx
	xchg	al, bl		; store variable offsets in ebx
	call	CreateFile, FileNameOff, GENERIC_READ + GENERIC_WRITE, FILE_SHARE_READ + FILE_SHARE_WRITE, NULL, Flags, FILE_ATTRIBUTE_NORMAL, 0
	cmp 	eax, INVALID_HANDLE_VALUE
	jnz	@@FileOpened
	call 	GetLastError
	cmp	eax, ERROR_FILE_NOT_FOUND
	jnz	@@1
	call	_wsprintfA, offset StrBuffer, offset ErrorMsg2, FileNameOff
	add	esp, 12
	call	ShowErrorMsg, offset StrBuffer
	jmp 	@@ReturnError
@@1:
	cmp	eax, ERROR_PATH_NOT_FOUND
	jnz	@@2
	call	_wsprintfA, offset StrBuffer, offset ErrorMsg6, FileNameOff
	add	esp, 12
	call	ShowErrorMsg, offset StrBuffer
	jmp	@@ReturnError	
@@2:	
	call	_wsprintfA, offset StrBuffer, offset ErrorMsg1, FileNameOff
	add	esp, 12
	call	ShowErrorMsg, offset StrBuffer
	
@@ReturnError:
	mov	eax, FALSE
	jmp	@@End

@@FileOpened:
	mov	dword ptr [FileHandle+ebx], eax

; adjust File Size
	call	GetFileSize, [FileHandle+ebx], NULL
	add	eax, Delta
	mov	ecx, eax		; ecx will hold filesize+delta
	call	SetFileSize, FileID, ecx
; create Memory Object
	call	CreateFileMapping, [FileHandle+ebx], NULL, PAGE_READWRITE, 0, 0, NULL
	test	eax, eax
	jnz	@@MapViewOfFile
	mov	eax, FileID
	call	EndMappedFile, eax
	call	_wsprintfA, offset StrBuffer, offset ErrorMsg3, FileNameOff
	add	esp, 12
	call	ShowErrorMsg, offset StrBuffer
	mov	eax, FALSE
	jmp	@@End
	
@@MapViewOfFile:
	mov	dword ptr [MemoryHandle+ebx], eax
	call	MapViewOfFile, [MemoryHandle+ebx], FILE_MAP_WRITE + FILE_MAP_READ, 0, 0, 0
	test	eax, eax
	jnz	@@Success
	mov	eax, FileID
	call	EndMappedFile, eax
	call	_wsprintfA, offset StrBuffer, offset ErrorMsg4, FileNameOff
	add	esp, 12
	call	ShowErrorMsg, offset StrBuffer
	mov	eax, FALSE
@@Success:
	mov	[MemoryAddress+ebx], eax
@@End:
	pop	ecx ebx
	ret
MakeMappedFile	ENDP
;--------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------
GetFileHandle		PROC	FileID:DWORD
	push	ecx
	xor	eax, eax		; better than movzx eax, FileID
	mov	eax, FileID
	mov	cl, 12
	mul	cl
	mov	eax, [FileHandle+eax]
	pop 	ecx
	ret	
GetFileHandle		ENDP
;--------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------
GetSizeOfFile		PROC	FileID:DWORD
	push	ebx ecx
	mov	eax, FileID
	mov	cl, 12
	mul	cl
	xor	ebx, ebx
	xchg	al, bl
	call	GetFileSize, [FileHandle+ebx], NULL
	pop	ecx ebx
	ret	
GetSizeOfFile		ENDP
;--------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------
SetFileSize		PROC	FileID:DWORD, NewSize:DWORD
	push	ebx ecx
	mov	eax, FileID
	mov	cl, 12
	mul	cl
	xor	ebx, ebx
	xchg	al, bl
	call	SetFilePointer, [FileHandle+ebx], NewSize, NULL, FILE_BEGIN
	call	SetEndOfFile, [FileHandle+ebx]
	pop	ecx ebx
	ret	
SetFileSize		ENDP
;--------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------
EndMappedFile		PROC	FileID:DWORD
	push	eax ebx ecx edx
	mov	eax, FileID
	mov	cl, 12
	mul	cl
	xor	ebx, ebx
	xchg	al, bl
	call	FlushViewOfFile, [MemoryAddress+ebx], 0
	call	UnmapViewOfFile, [MemoryAddress+ebx]
	call	CloseHandle, [MemoryHandle+ebx]
	call	CloseHandle, [FileHandle+ebx]
	pop	edx ecx ebx eax
	ret	
EndMappedFile		ENDP
;--------------------------------------------------------------------------------------


;--------------------------------------------------------------------------------------
ShowErrorMsg		PROC	MsgOff:DWORD
	push	eax
	call	MessageBeep, 0FFFFFFFFh
	call	MessageBox, NULL, MsgOff, offset Caption, MB_ICONHAND
	pop	eax
	ret	
ShowErrorMsg		ENDP
;--------------------------------------------------------------------------------------


END