#!/usr/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ forumdisplay.cgi -------------
#
#  This file contains the functionality for the UBB
#  individual forum page display.
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "Styles.file";
require "cookie-lib.pl";
require "ubb_library.pl";

};


print ("Content-type: text/html\n\n");


&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
			$category = $Value;
			$category =~ s/\/\\//g;
			$categoryCoded = &HTMLIFY($category);
			$categoryCoded =~ tr/ /+/;
			$category = &UNHTMLIFY($category);
	}
		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = &CleanThis($Value);
			$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = &CleanThis($Value);
			$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
			$Location = &CleanThis($Value);
			$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = &CleanThis($Value);
			$Interests = &PipeCleaner($Value);
	}
		if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}


#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;

if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$PageBackground");
}


$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

		$SubjectCoded = &HTMLIFY($TopicSubject);
		$SubjectCoded =~ tr/ /+/;
		


if (@in == 0) {
&Topics;
}
 
if ($in{'action'} eq "topics") {
 &Topics;
 }  


sub Topics {

&get_cookie;  #retrieves all current cookies
	$SessionLogin = "$cookie{sessionLogin}";
	$SessionLoginDT = "$cookie{sessionLoginDT}";

if ($DaysPrune eq "") {
$DaysPrune = "$cookie{DaysPrune}";
}
if ($DaysPrune eq "") {
$DaysPrune = $DaysPruneDefault;
}

if ($in{'start'} eq "here") {
	$AddNewSessionLogin = "true";
}

@thisforum = &GetForumRecord($number);
$category = $thisforum[0];

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;
$Forum = $thisforum[1];
$CustomTitle = $thisforum[9];
chomp($CustomTitle);
if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

@theprofile = &OpenProfile("$Moderator.cgi");
	
$ModeratorEmail = "$theprofile[2]";

#Check Announcements
&CheckAnnouncements("$number");

&TopicTopHTML;

&CurrentDate;

##### create new day summary file, if necessary
unless (-e "$ForumsPath/Forum$number/$RunOnDate.threads") {
my $CreateThreadFile = "yes";
&ForumSummary($number);
## REMOVE OLDER .threads file, if necessary
# @threadfiles contains list of all thread files
foreach $threadfile(@threadfiles) {
	if ($threadfile ne "$RonOnDate.threads") {
		unlink ("$ForumsPath/Forum$number/$threadfile");
	}
}
}  # end UNLESS THREADS SUMMARY EXISTS
##########

if ($CreateThreadFile ne "yes") {
#open thread file online
open (THREADS, "$ForumsPath/Forum$number/$RunOnDate.threads") or die("Unable to open thread summary file");
@thefinalarray = <THREADS>;
close (THREADS);
}
@finalarray = sort(@thefinalarray);

## @finalarray hold thread summary used to display page

$x = $number;
#set Days Prune variable to 3 digits for matching--

if ($DaysPrune == 1) {
	$Days1 = "SELECTED";
	 @finalarray = grep (/^000|001/, @finalarray);
}

if ($DaysPrune == 2) {
	$Days2 = "SELECTED";
	@finalarray = grep (/^(000|001|002)/, @finalarray);
}

if ($DaysPrune == 5) {
	$Days5 = "SELECTED";
		@finalarray = grep (/^(000|001|002|003|004|005)/, @finalarray);
}

if ($DaysPrune == 10) {
	$Days10 = "SELECTED";
		@finalarray = grep (/^(000|001|002|003|004|005|006|007|008|009|010)/, @finalarray);
}

if ($DaysPrune == 20) {
	$Days20 = "SELECTED";
}

if ($DaysPrune == 30) {
	$Days30 = "SELECTED";
}

if ($DaysPrune == 45) {
	$Days45 = "SELECTED";
}

if ($DaysPrune == 60) {
	$Days60 = "SELECTED";
}

if ($DaysPrune == 75) {
	$Days75 = "SELECTED";
}

if ($DaysPrune == 100) {
	$Days100 = "SELECTED";
}

if ($DaysPrune == 365) {
	$Days365 = "SELECTED";
}

&TopicMidHTML;

CHECKEACH: for $eachone(@finalarray) {

	@threadinfo = split(/\|\^\|/, $eachone);
	$ClosedItem = $threadinfo[7];
	
	if ($threadinfo[0] <= $DaysPrune) {
	#format date
	my $ThisMonth = substr($threadinfo[2], 4, 2);
	my $ThisYear = substr($threadinfo[2], 2, 2);
	my $ThisDay = substr($threadinfo[2], 6, 2);
	my $JYear = substr($threadinfo[2], 0, 4);
	$hour = substr($threadinfo[2], 8, 2);
	$min = substr($threadinfo[2], 10, 2);
	$HyphenIt = "$ThisMonth-$ThisDay-$ThisYear";
	
if ($DateFormat eq "US") {
	$TheDate = "$ThisMonth-$ThisDay-$ThisYear";
	$DateWording = "All dates are in Month-Day-Year format.";
	$DateSize = "2";
}
elsif ($DateFormat eq "Euro") {
	$TheDate = "$ThisDay-$ThisMonth-$ThisYear";
	$DateWording = "All dates are in Day-Month-Year format.";
	$DateSize = "2";
}
elsif ($DateFormat eq "USX") {
	$TheDate = &DateFormat("$HyphenIt", "USExpanded");

	$DateSize = "1";
} else {
	$TheDate = &DateFormat("$HyphenIt", "EuroExpanded");

		$DateSize = "1";
}
		
$TopicJulian = &jday($ThisMonth, $ThisDay, $JYear);
$JTime = ("$hour" . "$min");

$TopicJulian = ($TopicJulian + ($JTime * 0.0001));
#format time option 1
	if ($TimeFormat eq "24HR")  {
		$FormatTime = "$hour:$min";
	}
	&NormalTime;

#format time option 2
	if ($TimeFormat eq "AMPM")  {
		$FormatTime = "$hour:$min $AMPM";
	}

if ($SessionLogin eq "") {
	if ($ClosedItem =~ /X/) {
		$FolderIcon = "<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
	}  else {
		$FolderIcon = "<IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
	}
	
} else {

	if ($TopicJulian > $SessionLogin) {
		if ($ClosedItem =~ /X/) {
			$FolderIcon = "<IMG SRC=\"$NonCGIURL/redlockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
		}  else {
			$FolderIcon = "<IMG SRC=\"$NonCGIURL/closedb.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
		}
	$NewThreadPosts = "yes";

	}  else {

		if ($ClosedItem =~ /X/) {
			$FolderIcon = "<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
		}  else {
			$FolderIcon = "<IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
		}

	$NewThreadPosts = "no";
	}
}

&TopicGutsHTML;
}  else {   #if within prune range
last CHECKEACH;
}
}

&TopicBottomHTML;
&GetForumSelectList;
if ($SessionLogin ne "") {
&TopicBottom2JShtml;
}  else {
&TopicBottom2NonJShtml;
}

}  ## END TOPICS SR ####

sub CheckAnnouncements {
$ForumNumber = shift;

opendir (GETANNC, "$ForumsPath/Forum$ForumNumber/ANNC");
	@forummsgs = readdir(GETANNC);
closedir (GETANNC);

	@announcements = grep(/annc/, @forummsgs);

	#now we have all announcements in the forum
	#need to figure out which ones are live
	$NewAnnounce = "";
	
	for $eachannc(@announcements) {
		$Live = "";
		$Dead = "";
		($start, $end, $trash) = split("-", $eachannc);
		&DateCompare("$start", "$end");
		if ($Live eq "true") {
			push(@livelist, $eachannc);
		}	
	$StartJulian = ($StartJulian + .99);
		if ($StartJulian > $SessionLogin) {
			$NewAnnounce = "true";
		}
		if ($Dead eq "true") {
		unlink ("$ForumsPath/Forum$ForumNumber/ANNC/$eachannc");
		}
	} #end For $eachannc
	#now we have our list of announcements
	@thesortlist = sort(@livelist);	#sort list
	@sortlist = reverse(@thesortlist); #reverse it, latest first
	$ListTotal = @sortlist;
	
	if ($ListTotal < 1) {
		$AnnouncementBlock = "";
	} else {
		if ($NewAnnounce eq "true") {
	open (LATEST, "$ForumsPath/Forum$ForumNumber/ANNC/$sortlist[0]");
	@latest = <LATEST>;
	close (LATEST);
	$LatestTitle = $latest[1];
	chomp($LatestTitle);

			$AnnouncementBlock = "<IMG SRC=\"$NonCGIURL/newannounce.gif\" BORDER=0 ALT=\"New Announcement\" align=middle>&nbsp;&nbsp; <A HREF=\"ubbmisc.cgi?action=getannounce&ForumNumber=$number&Start=$StartJulian&End=$EndJulian&Session=$SessionLogin\">$LatestTitle</A>";

		}  else {
	open (LATEST, "$ForumsPath/Forum$ForumNumber/ANNC/$sortlist[0]");
	@latest = <LATEST>;
	close (LATEST);
	$LatestTitle = $latest[1];
	chomp($LatestTitle);

			$AnnouncementBlock = "<IMG SRC=\"$NonCGIURL/announce.gif\" BORDER=0 ALT=\"Announcements\" ALIGN=middle>&nbsp;&nbsp;<A HREF=\"ubbmisc.cgi?action=getannounce&ForumNumber=$number&Start=$StartJulian&End=$EndJulian&Session=$SessionLogin\">$LatestTitle</a>";
		}
	
	}
} #end CheckAnnouncements sr

# HTML SUBROUTINES ASSOCIATED WITH THE
# FORUM PAGE DISPLAY ARE LISTED BELOW---

sub TopicTopHTML {
print <<TOP;
<HTML>
<HEAD><TITLE>$BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var sessionLogin = escape("$SessionLogin");
var sessionLoginDT = escape("$SessionLoginDT");
var AddSessionInfo = escape("$AddNewSessionLogin");

expireDate = new Date;
expireDate.setYear(expireDate.getYear()+1);

if (AddSessionInfo == "true") {

var CookieLogin = escape("$LastLoginJulian");
var CookieLoginDT = escape("$LastLoginDT");

	  document.cookie = "lastLogin=" + CookieLogin + ";expires=" + expireDate.toGMTString() + ";";
  document.cookie = "LastLoginDT=" + CookieLoginDT + ";expires=" + expireDate.toGMTString() + ";";
	  document.cookie = "sessionLogin=" + sessionLogin + ";";
document.cookie = "sessionLoginDT=" + sessionLoginDT + ";";
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor" topmargin=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
$Header
<b>
TOP
}  ## END TOPIC TOP HTML sr

sub TopicMidHTML {
if ($CategoriesOnly eq "true") {
$FolderLine = qq(<IMG SRC="$NonCGIURL/tline.gif" WIDTH=12 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="Ultimate.cgi?action=intro&BypassCookie=true&category=$categoryCoded">$category</A><BR><IMG SRC="$NonCGIURL/tline3.gif" WIDTH=24 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;$Forum);

}  else {
$FolderLine = qq(<IMG SRC="$NonCGIURL/tline.gif" WIDTH=12 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;$Forum);
}

print <<OtherMiddle;
<center>
<table border=0 width=$TableWidth>
<tr>
<td align=left valign=top>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle" BORDER=0></A>
<BR>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$LinkColor"><B>$Forum</B>
<br><FONT size= "1" COLOR="$VisitedLinkColor">(moderated by <A HREF="mailto:$ModeratorEmail">$Moderator</A>)
<P>$AnnouncementBlock<BR>
</FONT></font>
</td>
<td valign=top nowrap><FONT SIZE="1" FACE="$FontFace">
<IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true"><ACRONYM TITLE="Return to summary page of all forums.">$BBName</ACRONYM></A>
<BR>
$FolderLine
<P>
<CENTER>
<FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="$CGIURL/postings.cgi?action=newtopic&number=$number&forum=$ForumCoded&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}"><IMG SRC="$NonCGIURL/$BBTopic"  BORDER=0 ALT="Post New Topic"></A></FONT>
<BR>
<A HREF="$CGIURL/ubbmisc.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}"><ACRONYM TITLE="Click here to edit your profile.">profile</ACRONYM></A> | <A HREF="$CGIURL/Ultimate.cgi?action=agree"><ACRONYM TITLE="Registration is free!">register</ACRONYM></A> | <A HREF="$CGIURL/ubbmisc.cgi?action=setprefs"><ACRONYM TITLE="Set your preferences.">prefs</ACRONYM></A> | <A HREF="$NonCGIURL/faq.html" target=_blank><ACRONYM TITLE="Frequently Asked Questions">faq</ACRONYM></A> | <A HREF="$CGIURL/search.cgi?action=intro"><ACRONYM TITLE="Perform a search by keyword, date, or name.">search</ACRONYM></A>
<p>
<FORM ACTION="forumdisplay.cgi" METHOD="GET">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="topics">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<SELECT NAME="DaysPrune">
	<OPTION value="1" $Days1>Show topics from last day
	<OPTION value="2" $Days2>Show topics from last 2 days
	<OPTION value="5" $Days5>Show topics from last 5 days
	<OPTION value="10" $Days10>Show topics from last 10 days
	<OPTION value="20" $Days20>Show topics from last 20 days
	<OPTION value="30" $Days30>Show topics from last 30 days
	<OPTION value="45" $Days45>Show topics from last 45 days
	<OPTION value="60" $Days60>Show topics from last 60 days
	<OPTION value="75" $Days75>Show topics from last 75 days
	<OPTION value="100" $Days100>Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
</SELECT>
<INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go">
</FORM>
</center>
</FONT>
</td></tr></table>

<table border=0 width=$TableWidth>
<tr $TableColorStrip>
<td>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor"><B>Topic</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor"><B>Originator</B></FONT>
</td>
<td><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor"><B>Replies</B></FONT>
</td>
<td NOWRAP><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor"><B>Last Post</B></FONT>
</td></tr>
OtherMiddle
}  ## END Middle HTML for Topic Page 

sub TopicGutsHTML {
print <<GUTS;
<TR>
<TD $AltColumnColor1>
$FolderIcon<FONT SIZE="$TextSize" FACE="$FontFace">&nbsp;
<A HREF="$NonCGIURL/Forum$number/HTML/$threadinfo[3]">$threadinfo[4]</A>
</FONT>
</td>
<td $AltColumnColor2>
<FONT SIZE="$TextSize" FACE="$FontFace">$threadinfo[6]</FONT>
</td>
<td align=center $AltColumnColor1>
<FONT SIZE="$TextSize" FACE="$FontFace">$threadinfo[5]</FONT>
</td>
<td NOWRAP $AltColumnColor2>
<FONT SIZE="$DateSize" FACE="$FontFace">$TheDate <FONT SIZE="$DateSize" FACE="$FontFace" COLOR="$TimeColor">$FormatTime</FONT></FONT>
</td></tr>
GUTS
}  ## END Guts HTML for Topic Page


sub TopicBottomHTML {
print<<BOTTOM
</table>
<br>
<table border=0 width=$TableWidth>
<tr><td align=left valign=top>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">All times are $TimeZone. $DateWording</FONT></td>
<td align=right NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FORM ACTION="Ultimate.cgi" METHOD="GET">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="Redirect">
<B>Hop to: </B><SELECT NAME="GoTo">
BOTTOM
} ## End TopicBottomNonIEhtml

sub TopicBottom2JShtml {
print<<TrueTopicBottom;
</SELECT><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go"></FORM></FONT></TD></tr></TABLE>
<P></center>
<img src="$NonCGIURL/closedb.gif" width=14 height=11 border=0 alt="No New Posts">&nbsp;&nbsp;Contains new posts since the last time you logged on.<BR>
<img src="$NonCGIURL/closed.gif" width=14 height=11 border=0 alt="No New Posts">&nbsp;&nbsp;No new posts since the last time you logged on.<BR>
<IMG SRC="$NonCGIURL/lock.gif" WIDTH=9 HEIGHT=11 BORDER=0 ALT="Closed Thread">&nbsp;&nbsp;A Closed thread - no new replies accepted.
<p>
<CENTER><A HREF="$CGIURL/postings.cgi?action=newtopic&number=$number&forum=$ForumCoded">Post New Topic</A><P>
TrueTopicBottom

&PageBottomHTML;
}

sub TopicBottom2NonJShtml {
print<<TrueTopicBottom;
</SELECT><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go"></FORM></FONT></TD></tr></TABLE>
</center>
<P><IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0 ALT=\"Open Thread Icon\">&nbsp;&nbsp;An Open Thread.<BR>
<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0 ALT=\"Closed Thread Icon\">&nbsp;&nbsp;A Closed thread - no new replies accepted.
<p>
<CENTER><A HREF="$CGIURL/postings.cgi?action=newtopic&number=$number&forum=$ForumCoded">Post New Topic</A><P>
TrueTopicBottom

&PageBottomHTML;
}

