#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998.
#
#       ------------ cpanel3.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "mods.file";
require "UltBB.setup";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\@/\\@/g;
			$BBRules = &ConvertReturns($BBRules);
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords = &EliminateReturns($censorwords);
			$censorwords =~ s/<BR>//ig;
			$censorwords =~ s/<P>//ig;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/<BR>//ig;
			$YourCopyrightNotice =~ s/<P>//ig;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
		#	$Header = &ConvertReturns($Header);
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
		#	$Footer = &ConvertReturns($Footer);
			$Footer =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	
	
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "UpdateType") {
			$UpdateType = $Value;
			}		
	if ($Name eq "TotalForums") {
			$TotalForums = $Value;
			}
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
		}
			if ($Name eq "Password") {
			$Password = $Value;
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}

if ($action eq "forums") {
&Forums;
}
if ($action eq "sendforums") {
&SendForums;
}
if ($action eq "addnewforum") {
&AddNewForum;
}
sub Forums {
# Verify that user is ADMIN first!
$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoForums;
	   }  else {
	   &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} #end Forums sr

sub DoForums {
# check to see how many forums are currently listed
	open (FORUMFILE, "$VariablesPath/forums.cgi");
			@forums = <FORUMFILE>;
	close (FORUMFILE);
		
		$ForumTotal = @forums;
	$StartPoint = $in{'StartPoint'};
	$EndPoint = $StartPoint + 10;		
	$RecordStart = $StartPoint + 1;
	
if ($EndPoint >= $ForumTotal) {
	$NoMore = "true";
	$EndPoint = $ForumTotal;
}
if (($NoMore eq "true") && ($StartPoint eq "0")) {
	$PrefixWord = "";
	$NextPoint = "";
	}
elsif ($ForumTotal >= ($EndPoint + 10)) {
	$NextTotal = "10";
	$PrefixWord = "Next";
	$NextPoint = $EndPoint;
}
elsif ($ForumTotal <= $EndPoint) {
	$PrefixWord = "Previous";
	$NextTotal = "10";
	$NextPoint = $StartPoint - 10;
}  else {
	$PrefixWord = "Next";
	$NextTotal = $ForumTotal - $EndPoint;
	$NextPoint = $EndPoint;
}

$PageTitle = "Set Forum Variables";
&HEADER2HTML;

if ($UserNameCheck ne "") {
$UserNameFill = "$UserNameCheck";
}  else {
$UserNameFill = "$UserName";
}
$UserNameFill =~ tr/ /+/;

if ($PasswordCheck ne "") {
$PasswordFill = "$PasswordCheck";
}  else {
$PasswordFill = "$Password";
}
$PasswordFill =~ tr/ /+/;


print<<ForumHTML;
<B>
You can easily assign/change forum names, descriptions, and properties through this control panel.  The UBB now supports unlimited forums, as well, so there is nothing to hold you back!
<P>
</B>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="3" FACE="Verdana, Arial" COLOR="#800000">Set Forum Variables Below</FONT></B></td><TD align=center><FONT SIZE="2" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
You currently have $ForumTotal total forums (either active or inactive).  Forums are listed in blocks of 10 per page.  If you need to add new forums, <A HREF="cpanel.cgi?action=addforums">click here</A>.
<center>
<table border=0 bgcolor="#dedfdf" width=95%>
<TR><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">Forums $RecordStart to $EndPoint (of $ForumTotal Total)</FONT></B></td>
<td align=center><FONT SIZE="2" FACE="Verdana, Arial">[ <A HREF="cpanel3.cgi?action=forums&UserName=$UserNameFill&Password=$PasswordFill&StartPoint=$NextPoint">$PrefixWord $NextTotal</A> ]</FONT></td></tr></table>
</center>
<BR>
<table border=0>
ForumHTML

	$ForumCounter = 0;
	for $forumline(@forums) {
		$ForumCounter++;
		if (($StartPoint < $ForumCounter) && ($ForumCounter <= $EndPoint)) {
	my $ForumActive = "";
	my $ForumInactive = "";
	my $HTMLOn = "";
	my $HTMLOff = "";
	my $UBBOn = "";
	my $UBBOff = "";
	my $RWOn = "";
	my $RWOff = "";
	my $UBBImagesOn = "";
	my $UBBImagesOff = "";
	my $ModNotifyOn = "";
	my $ModNotifyOff = "";

		@thisforum = split(/\|/, $forumline);
		chomp($thisforum[11]);
		chomp($thisforum[12]);
		if ($thisforum[3] eq "On") {
			$ForumActive = "CHECKED";
		}  else {
			$ForumInactive = "CHECKED";
		}
		if ($thisforum[4] eq "is") {
			$HTMLOn = "CHECKED";
		}  else {
			$HTMLOff = "CHECKED";
		}
		if ($thisforum[5] eq "is") {
			$UBBOn = "CHECKED";
		}  else {
			$UBBOff = "CHECKED";
		}
if ($thisforum[10] eq "OFF") {
			$UBBImagesOff = "CHECKED";
		}  else {
			$UBBImagesOn = "CHECKED";
		}

if ($thisforum[11] eq "yes") {
			$ModNotifyOn = "CHECKED";
		}  else {
			$ModNotifyOff = "CHECKED";
		}
			if ($thisforum[6] eq "yes") {
			$RWOn = "CHECKED";
		}  else {
			$RWOff = "CHECKED";
		}
	
			$TitleGraphic = "$thisforum[9]";


### If UBB Code is off, UBB Code for Images must also be off! ###
	if ($UBBOff eq "CHECKED") {
			$UBBImagesOn = "";
			$UBBImagesOff = "CHECKED";
		}
#############################################################

 
print<<ForumGuts;
<tr>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B>
<p>
<table border=0 bgcolor="#f7f7f7">
<TR>
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Name||$ForumCounter" VALUE="$thisforum[1]" SIZE=30 MAXLENGTH=100></td></tr>
<tr><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Category||$ForumCounter" VALUE="$thisforum[0]" SIZE=30 MAXLENGTH=100></td></tr>

<tr><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Custom Title Graphic:</B><BR>Leave field blank if you want to use your primary title graphic (set in the Styles area).</FONT></td>
<td><INPUT TYPE="TEXT" NAME="TitleGraphic||$ForumCounter" VALUE="$TitleGraphic" SIZE=30 MAXLENGTH=100></td></tr>


<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="On" $ForumActive> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="Off" $ForumInactive> Off</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is" $HTMLOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is not" $HTMLOff> No</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is" $UBBOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is not" $UBBOff> No</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages||$ForumCounter" VALUE="ON" $UBBImagesOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages||$ForumCounter" VALUE="OFF" $UBBImagesOff> No</B></FONT></td></tr>


<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification? <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">If yes, an email will be sent to the moderator every time someone posts a note to the forum.</FONT></B></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify||$ForumCounter" VALUE="yes" $ModNotifyOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify||$ForumCounter" VALUE="no" $ModNotifyOff> No</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access? <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">If yes, you will restrict ability to write to this forum to admins, moderators, and anyone with the password you select below.</FONT></B></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="RestrictWrite||$ForumCounter" VALUE="yes" $RWOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="RestrictWrite||$ForumCounter" VALUE="no" $RWOff> No</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access Password.  (Only necessary if Limited Write Access is chosen for this forum.</B></FONT></td><TD><INPUT TYPE="TEXT" NAME="ForumPW||$ForumCounter" VALUE="$thisforum[7]" SIZE=10 MAXLENGTH=25></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Description:</B></FONT></td><td><TEXTAREA NAME="Description||$ForumCounter" ROWS=3 COLS=30 wrap="VIRTUAL">$thisforum[2]</TEXTAREA></td></tr>
</table>
<P></FONT>
<br>
</B></FONT>
</td>
</tr>
ForumGuts
} # if greater than start point, less than end point
} #for forumline

print<<BottomForumHTML;
</table>
<BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendforums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint">
<INPUT TYPE="HIDDEN" NAME="ForumTotal" VALUE="$ForumTotal">
<INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="$PrefixWord">
<INPUT TYPE="HIDDEN" NAME="NextTotal" VALUE="$NextTotal">
<INPUT TYPE="HIDDEN" NAME="NextPoint" VALUE="$NextPoint">
<CENTER>
<P>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<P>
<FONT Size="1" FACE="Verdana, Arial" COLOR="#808000">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Variables Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Madrona Park, Inc., 1998.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML
}  ## END DoForums


sub HEADER2HTML {
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserNameCheck.value = getCookie("UserNameCP");
document.THEFORM.PasswordCheck.value = getCookie("PasswordCP");
	}  
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<p>
HEADER2HTML
} #end HEADERHTML2 sr


sub SendForums {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
$NameFound = "no";
if (-e "$MembersPath/$UserNameCheckFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserNameCheck.cgi");
			
	if ($PasswordCheck eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessForums;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END SendForums sr


sub DoProcessForums {
### write forum info to forums.cgi
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name =~ m/Name/) {
	($Trash, $ForumNumber) = split(/\|\|/, $Name);
	push (@AdjustForums, $ForumNumber);
	}
} # end foreach $row

# now we have list of forum numbers to adjust (e.g., 1 - 9)

#read current forum data
open (FORUMFILE, "$VariablesPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);

@forums = grep(/\|/, @forums);

#assemble new line for each revised forum
for $num(@AdjustForums) {

	$Found = "false";
	
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "Name||$num") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
		$Found = "true";
	}
	if ($Name eq "Category||$num") {
		$ThisCategory = $Value;
	}
	if ($Name eq "Status||$num") {
		$ThisStatus = $Value;
	}
	if ($Name eq "HTML||$num") {
		$ThisHTML = $Value;
	}
	if ($Name eq "UBB||$num") {
		$ThisUBB = $Value;
	}
	if ($Name eq "ModNotify||$num") {
		$ThisModNotify = $Value;
	}
if ($Name eq "UBBImages||$num") {
		$ThisUBBImages = $Value;
	}
	if ($Name eq "TitleGraphic||$num") {
		$TitleGraphic = $Value;
	}
	if ($Name eq "RestrictWrite||$num") {
		$ThisRestrictWrite = $Value;
	}
	if ($Name eq "ForumPW||$num") {
		$ThisForumPW = $Value;
	}
	if ($Name eq "Description||$num") {
		$ThisDescription = $Value;
		$ThisDescription =~ s/"/&quot;/g;
		$ThisDescription =~ s/\n\r\n//g;
		$ThisDescription =~ s/\n//g;
		$ThisDescription =~ s/\r//g;
		$ThisDescription =~ s/  / /g;
	}
} # end foreach $row2

$arrayrow = ($num - 1);

if ($Found eq "true") {
$forums[$arrayrow] = ("$ThisCategory|$ThisName|$ThisDescription|$ThisStatus|$ThisHTML|$ThisUBB|$ThisRestrictWrite|$ThisForumPW|$num|$TitleGraphic|$ThisUBBImages|$ThisModNotify\n");
}
}  #end for each @AdjustForum

#write to forums file

open (FORUMS, ">$VariablesPath/forums.cgi"); 
print FORUMS (@forums);
close (FORUMS);

$UserNameCoded = "$UserNameCheck";
$UserNameCoded =~ tr/ /+/;
$PasswordCoded = "$PasswordCheck";
$PasswordCoded =~ tr/ /+/;

$ConfirmLine = "The Ultimate Bulletin Board forums have been updated.<P>Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>Additional Forums to Edit: [ <A HREF=\"cpanel3.cgi?action=forums&UserName=$UserNameCoded&Password=$PasswordCoded&StartPoint=$in{'NextPoint'}\">$in{'PrefixWord'} $in{'NextTotal'}</A> ]";
&ConfirmHTML;
} ## END DO PROCESS FORUMS SR

sub AddNewForum {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoAddNewForum;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END AddNewForum sr

sub DoAddNewForum {
$ForumTotal = &GetTotalForums;
$ForumTotal++;
### write forum info to forums.cgi
	$Description = &decodeURL($in{'Description'});
		$Description =~ s/"/&quot;/g;
		$Description =~ s/\n\r\n//g;
		$Description =~ s/\n//g;
		$Description =~ s/\r//g;
		$Description =~ s/  / /g;
		
	$Name = &decodeURL($in{'Name'});
	$Name =~ s/"/&quot;/g;
	$Category = &decodeURL($in{'Category'});
	
$newforumline = ("$Category|$Name|$Description|$in{'Status'}|$in{'HTML'}|$in{'UBB'}|$in{'RestrictWrite'}|$in{'ForumPW'}|$ForumTotal|$in{'TitleGraphic'}|$in{'UBBImages'}|$in{'ModNotify'}");

#write to forums file

open (NEWFORUM, ">>$VariablesPath/forums.cgi"); 
print NEWFORUM ("$newforumline\n");
close (NEWFORUM);

#create new Forum Directory with permissions for UNIX servers
mkdir("$ForumsPath/Forum$in{'Number'}", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}");
mkdir("$ForumsPath/Forum$in{'Number'}/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/ANNC");

$ConfirmLine = "New forum successfully added!<P>";
&ConfirmHTML2;
} ## END DO ADD NEW FORUM SR
