#!/usr/bin/perl
#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ cpanel.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "mods.file";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";

};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);

	if ($Name eq "action") {
			$action = $Value;
	}
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
			}
	
	if ($Name eq "NN") {
			$NN = $Value;
			$NN =~tr/A-Z/a-z/;   
			}
	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/;  
		}
	if ($Name eq "UserName") {
			$UserName = $Value;
		}
	if ($Name eq "Password") {
			$Password = $Value;
		}
} #end foreach loop

if ($VariablesPath eq "") {
			$VariablesPath = $CGIPath;
		}
if ($action eq "setmods") {
   &SetMods;
}
if ($action eq "UpdateThreads") {
   &UpdateThreads;
}
if ($action eq "prune") {
   &Prune;
}

if ($action eq "index") {
   &Index;
}
if ($action eq "addforums") {
   &AddForums;
}
if ($action eq "variables") {
   &Variables;
}

if ($action eq "permissions") {
   &Permissions;
}

if ($action eq "env") {
   &Env;
}
if ($action eq "style") {
   &Styles;
}

if ($action eq "logintoforums") {
   &LogIntoForums;
}

if ($action eq "getbio4admin") {
   &GetBio4Admin;
}


sub UpdateThreads {
$PageTitle = "Update Threads";
&HEADERHTML;

print<<Threads;
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may update HTML threads. <P>
After you make changes to your control panel settings, these changes take affect immediately for all new pages.  Older HTML pages, however, are not updated until you update them here.  You should run this function after you have made all changes to your control panel settings.
</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doupdate">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<p>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Update Threads Now!">
</CENTER>

</FORM>
</BODY></HTML>
Threads

}  ## END UpdateThreads SR ##



sub Index {
$PageTitle = "Create/Update Index";
&HEADERHTML;

print<<Index;
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may set or update your index.  The index is used for all searches.  If you are upgrading from a version that did not have a search engine included, you MUST create your index before any searches will work.  Just click on the button below!  If you ever have problems, or if your index becomes corrupted for some reason, you can easily create it again here. Otherwise, you do not have to update your index... the UBB is always updating the index automatically, after you originally create it!</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doindex">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<p>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Create/Update Index Now!">
</CENTER>

</FORM>
</BODY></HTML>
Index

}  ## END INDEX SR ##


sub LogIntoForums {
$PageTitle = "Set Forum Variables";
&HEADERHTML;

print<<ForumLoginHTML;
To set/add forums or forum variables, you must be an administrator.  Please identify yourself below.
<P><center>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=1>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="forums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="0">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</center>
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Copyright, Madrona Park, Inc., 1998.
</FONT>
</CENTER>
</BODY>
</HTML>
ForumLoginHTML

}  # end logintoforums sr


sub Env {
print<<TOP;
<HTML><BODY BGCOLOR="#FFFFFF">
<BR><BR>
<CENTER><FONT SIZE="5" FACE="Courier New" ><B>Your Environmental Variables</b></FONT></CENTER>
<P>
<font face="Verdana, Arial" size="2">
Use these to help you figure out your absolute file paths, and other system information.<P>
<FONT face="Verdana, Arial" size="2" COLOR="#800000"><B>Perl Info:</b></FONT><BR>
You are using <b>Perl Version $]</b>
<P>
<FONT face-"Verdana, Arial" size="2" COLOR="#800000"><B>Your Environmental Variables:</b></FONT>
<BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#008080">Note: "DOCUMENT_ROOT" shows your absolute path to your root web directory.  "SCRIPT_FILENAME" shows you absolute path of your CGI directory.  If your SCRIPT_FILENAME shows "/www/whatever/whatever/cgi-bin/cpanel.cgi", your Absolute Path variable for your CGI directory would be "/www/whatever/whatever/cgi-bin".</FONT><P>
TOP
for $key (keys(%ENV)) {
printf("%-10.20s: <b>$ENV{$key}</B><BR>", $key);
}

print<<BOTTOM;
</FONT></BODY></HTML>
BOTTOM
}  # END ENV SR


sub Styles {


if ($profilegif eq "") {
	$profilegif = "profile.gif";
}
if ($mailgif eq "") {
	$mailgif = "email.gif";
}
if ($CopyrightTextColor eq "") {
	$CopyrightTextColor = "#C0C0C0";
}

if ($TextSize eq "") {
	$TextSize = "2";
}
if ($FontFace eq "") {
	$FontFace = "Verdana, Arial";
}

if ($TextColor eq "") {
	$TextColor = "#000000";
}
if ($LinkColor eq "") {
	$LinkColor = "#000080";
}
if ($VisitedLinkColor eq "") {
	$VisitedLinkColor = "#808000";
}

if ($TableStripTextColor eq "") {
	$TableStripTextColor = "#000080";
}


if ($BBTitle eq "") {
	$BBTitle = "bbtitle1.jpg";
}
if ($BBTopic eq "") {
	$BBTopic = "topic1.jpg";
}
if ($BBReply eq "") {
	$BBReply = "reply1.jpg";
}
if ($ThreadClosed eq "") {
	$ThreadClosed = "threadclose1.jpg";
}
if ($TableWidth eq "") {
	$TableWidth = "95%";
}
if ($TimeColor eq "") {
	$TimeColor = "#800080";
}
if ($BBTitleFontColor eq "") {
	$BBTitleFontColor = "#800000";
}
if ($PageBackground eq "") {
	$PageBackground = "";
} else {
	if ($PageBackground =~ /=/) {
($junk, $PB) = split (/=/, $PageBackground);
chomp($PB);
@pb = split(/\//, $PB);
$PageBackground = pop(@pb);
	}
}

if ($AltColumnColor1 eq "") {
	$AltColumnColor1 = "";
} else {
	if ($AltColumnColor1 =~ /=/) {
($junk, $AltColumnColor1) = split (/=/, $AltColumnColor1);
chomp($AltColumnColor1);
	}
}

if ($AltColumnColor2 eq "") {
	$AltColumnColor2 = "";
} else {
	if ($AltColumnColor2 =~ /=/) {
($junk, $AltColumnColor2) = split (/=/, $AltColumnColor2);
chomp($AltColumnColor2);
	}
}

if ($BGColor eq "") {
	$BGColor = "";
} else {
	if ($BGColor =~ /=/) {
($junk, $BGColor) = split (/=/, $BGColor);
chomp($BGColor);
	}
}

if ($TableColorStrip eq "") {
	$TableColorStrip = "";
} else {
	if ($TableColorStrip =~ /=/) {
($junk, $TableColorStrip) = split (/=/, $TableColorStrip);
chomp($TableColorStrip);
	}
}

if ($CategoryStripColor eq "") {
	$CategoryStripColor = "";
} else {
	if ($CategoryStripColor =~ /=/) {
($junk, $CategoryStripColor) = split (/=/, $CategoryStripColor);
chomp($CategoryStripColor);
	}
}

$PageTitle = "Set Fonts/Colors/Graphics";
&HEADERHTML;

print<<StyleHTML;
<B>
You can easily change the font face and/or color, graphics, and background colors used throughout your bulletin board using this control panel page.  Note: these changes affect only the bulletin board pages, not any of the control panel pages.  For all colors, we recommend using hexadecimal codes (i.e, #FFFFFF for "white", etc.).
</B>
</FONT>
<P>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">

<table border=0 >
<TR>
<TD colspan=3 bgcolor="#dedfdf">
<FONT FACE="Verdana" SIZE="2"><B>Color Options</B></FONT>
</TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Color</B><br>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">Format - #FFFFFF</FONT>
</FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="BGColorChoice" onChange="forms[0].BGColor.value=options[selectedIndex].value">
StyleHTML

&Colors;

print<<Style2;
<INPUT TYPE="TEXT" NAME="BGColor" VALUE="$BGColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TextColorChoice" onChange="forms[0].TextColor.value=options[selectedIndex].value">
Style2

&Colors;

print<<Style3;
<INPUT TYPE="TEXT" NAME="TextColor" VALUE="$TextColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Link Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="LinkColorChoice" onChange="forms[0].LinkColor.value=options[selectedIndex].value">
Style3

&Colors;

print<<Style4;
<INPUT TYPE="TEXT" NAME="LinkColor" VALUE="$LinkColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Visited Link Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="VisitedLinkColorChoice" onChange="forms[0].VisitedLinkColor.value=options[selectedIndex].value">
Style4

&Colors;

print<<Style5;
<INPUT TYPE="TEXT" NAME="VisitedLinkColor" VALUE="$VisitedLinkColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Header Strip Text Color </B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TableStripColorChoice" onChange="forms[0].TableStripTextColor.value=options[selectedIndex].value">
Style5

&Colors;

print<<Style6;
<INPUT TYPE="TEXT" NAME="TableStripTextColor" VALUE="$TableStripTextColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Header Strip Background Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TableColorStripChoice" onChange="forms[0].TableColorStrip.value=options[selectedIndex].value">
Style6

&Colors;

print<<Style7;
<INPUT TYPE="TEXT" NAME="TableColorStrip" VALUE="$TableColorStrip" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Color</B><br><FONT SIZE="1" COLOR="#800000" FACE="Verdana, Arial">Used for the time field on the main forum summary page and the forum pages and for the "posted by" line for each thread</FONT></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TimeColorChoice" onChange="forms[0].TimeColor.value=options[selectedIndex].value">
Style7

&Colors;

print<<Style8;
<INPUT TYPE="TEXT" NAME="TimeColor" VALUE="$TimeColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>First Alternating Table Column Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="AltColumnColor1Choice" onChange="forms[0].AltColumnColor1.value=options[selectedIndex].value">
Style8

&Colors;

print<<Style85;
<INPUT TYPE="TEXT" NAME="AltColumnColor1" VALUE="$AltColumnColor1" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Second Alternating Table Column Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="AltColumnColor2Choice" onChange="forms[0].AltColumnColor2.value=options[selectedIndex].value">
Style85

&Colors;

print<<Style9;
<INPUT TYPE="TEXT" NAME="AltColumnColor2" VALUE="$AltColumnColor2" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Category Strip Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="CategoryStripColorChoice" onChange="forms[0].CategoryStripColor.value=options[selectedIndex].value">
Style9

&Colors;

print<<Style10;
<INPUT TYPE="TEXT" NAME="CategoryStripColor" VALUE="$CategoryStripColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Copyright Text Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="CopyrightTextColorChoice" onChange="forms[0].CopyrightTextColor.value=options[selectedIndex].value">
Style10

&Colors;

print<<Style11;
<INPUT TYPE="TEXT" NAME="CopyrightTextColor" VALUE="$CopyrightTextColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>BB Title Font Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="BBTitleFontColorChoice" onChange="forms[0].BBTitleFontColor.value=options[selectedIndex].value">
Style11

&Colors;

print<<Style12;
<INPUT TYPE="TEXT" NAME="BBTitleFontColor" VALUE="$BBTitleFontColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr>
<td bgcolor="#dedfdf"colspan=3><B><FONT FACE="Verdana" SIZE="2">Miscellaneous Graphic Options</FONT></B></TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Font Face (e.g., Verdana)<FONT SIZE="1" FACE="Verdanam, Arial" color="#FF0000"><br>We recommend you use a backup font as well.  For example: to use Verdana as your first choice, with Arial as a conditional font for those users that don't have Verdana as a font on their system, you would type "Verdana, Arial")</FONT></B><br></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="FontFace" VALUE="$FontFace" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Width</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">You may use either exact pixels (recommended: 600) or a percentage (recommended: 90%)</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TableWidth" VALUE="$TableWidth" SIZE=5 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">We recommend using size 2... but depending on your font face, you may want to alter this.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TextSize" VALUE="$TextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Graphic</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">Not recommended to be used, but you can add a background graphic to your pages.  If you do so, you should upload the graphic into your NON CGI directory and place the name of the background graphic in this field.  For example, background.gif.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="PageBackground" VALUE="$PageBackground" SIZE=30 MAXLENGTH=200>
</td></tr>
</table>

<P>

<TABLE BORDER=0>
<tr>
<td bgcolor="#dedfdf"colspan=3><B><FONT FACE="Verdana" SIZE="2"> Graphic Images</B>
<P>
You can choose from 6 coordinated graphic sets, or substitute your own graphics. There are 3 main graphics used- the title or logo graphic that appears at the top of most pages, a "Post New Topic" graphic, a "Post Reply" graphic, and a "Closed Thread" graphic.  All graphics available were created by the very talented <A HREF="mailto:kvail\@prime-web.com">Karen Vail</A>.
<P>
The graphic sets are pictured <A HREF="$NonCGIURL/graphicsets.html">here</A>.  To use one of these graphics, just type in the name of the graphic in the corresponding field.  To use one of your own graphics, type in its own unique name in the corresponding field.  Also, if you use your own graphics, be sure to FTP the images into your Non CGI directory.
<P>
Recommended graphic sizes: if you are creating your own graphics, we recommend that the following sizes (in pixels) be used (in order to fit with layout of the BB): <ul>
<LI> Title/logo graphic- 300 wide by 75 high 
<LI> Post New Topic graphic - 80 wide by 17 high
<LI> Post Reply graphic - 75 wide by 17 high
<LI> Thread Close graphic - 75 wide by 17 high
</ul><br>
Don't forget: if you are using your own custom graphics instead of one of the standard graphics shown above, be sure to upload (FTP) your custom graphics to your UBB NON CGI directory.
</FONT></TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Title Graphic:</B></FONT></td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTitle" VALUE="$BBTitle" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post New Topic Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTopic" VALUE="$BBTopic" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post Reply Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBReply" VALUE="$BBReply" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Thread Closed Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="ThreadClosed" VALUE="$ThreadClosed" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Profile Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="profilegif" VALUE="$profilegif" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="mailgif" VALUE="$mailgif" SIZE=25 MAXLENGTH=50>
</td></tr>
</table>

<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendstyle">

<CENTER>

<FONT COLOR="#FF0000" face="Verdana, Arial" Size="2">Verify Your Identify<BR>  (only administrators can make these changes)<br></FONT>
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Style Changes Now">

</FORM>

<BR><BR><BR>

</CENTER>

<CENTER><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Madrona Park, Inc., 1998.</FONT></CENTER>
</BODY>
</HTML>
Style12
}  ## END Styles subroutine

sub AddForums {

# check to see how many forums are currently listed
	open (FORUMFILE, "$VariablesPath/forums.cgi");
			@forums = <FORUMFILE>;
	close (FORUMFILE);
		
		$ForumTotal = @forums;
		$ForumCounter = $ForumTotal + 1;
$PageTitle = "Add New Forum";
&HEADERHTML;

print<<ForumHTML;
<B>
You can add a new forum by completing the form below.  You currently have $ForumTotal forums.  
<P>
</B>
<P>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<FONT COLOR="#FF0000">First Identify Yourself (only administrators can add new forums)<br></FONT>
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<hr>
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="3" FACE="Verdana, Arial" COLOR="#800000">Set New Forum Variables Below</FONT></B></td><TD align=center><FONT SIZE="2" FACE="Verdana, Arial">[<A HREF="forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
<table border=0>
<tr>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B>
<BR>
<table border=0 bgcolor="#f7f7f7">
<TR>
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Name" Value="Forum Name" SIZE=30 MAXLENGTH=100></td></tr>
<tr><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Category" VALUE="" SIZE=30 MAXLENGTH=100></td></tr>

<tr><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Custom Title Graphic:</B><BR>Leave field blank if you want to use your primary title graphic (set in the Styles area).</FONT></td>
<td><INPUT TYPE="TEXT" NAME="TitleGraphic" VALUE="" SIZE=30 MAXLENGTH=100></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status" VALUE="On" CHECKED> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status" VALUE="Off"> Off</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML" VALUE="is" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML" VALUE="is not"> No</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB" VALUE="is" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB" VALUE="is not"> No
</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages" VALUE="ON" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages" VALUE="OFF"> No
</B></FONT></td></tr>


<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification?<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">If yes, an email will be sent to the moderator every time someone posts a note to the forum.</FONT></B></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify" VALUE="yes"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify" VALUE="no" CHECKED> No</B></FONT></td></tr>

<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access? <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">If yes, you will restrict ability to write to this forum to admins, moderators, and anyone with the password you select below.</FONT></B></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="RestrictWrite" VALUE="yes"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="RestrictWrite" VALUE="no" CHECKED> No</B></FONT></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Limited Write Access Password.  (Only necessary if Limited Write Access is chosen for this forum.</B></FONT></td><TD><INPUT TYPE="TEXT" NAME="ForumPW" SIZE=10 MAXLENGTH=25></td></tr>
<TR><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Description:</B></FONT></td><td><TEXTAREA NAME="Description" ROWS=3 COLS=30 wrap="VIRTUAL">Forum Description Goes Here!</TEXTAREA></td></tr>
</table>
</FONT>
<br>
</B></FONT>
</td>
</tr>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="addnewforum">
<INPUT TYPE="HIDDEN" NAME="Number" VALUE="$ForumCounter">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Forum Variables Now">
</FORM>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Madrona Park Inc., 1998.</FONT>
</CENTER></font>
</BODY>
</HTML>
ForumHTML
}  ## END AddForums

sub Permissions {
$PageTitle = "Permissions Center";
&HEADERHTML;

print<<permissHTML;
If you are an authorized administrator, you can change the access permissions for any BB user.   Enter information for at least one of the fields below to conduct a search for a user.  Search is not case-sensitive.
<P>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="getmatches">
<BLOCKQUOTE>
<FONT SIZE="2" face="Verdana, Arial"><B>Identify Yourself Below (case sensitive)</B></FONT><BR>
<TABLE BORDER=0>
<tr bgcolor="#DEDFDF"><td><FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<tr bgcolor="#dedfdf">
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Password</B></FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=15 MAXLENGTH=15></td>
</tr>
</table>
<P>
<FONT SIZE="2" face="Verdana, Arial"><B>Conduct Member Search:</B></FONT>
<TABLE BORDER=1>
<TR bgcolor="#CCCC99">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="2" FACE="Verdana, Arial"><B>User Name</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="NN" VALUE="" SIZE=25 MAXLENGTH=25></td></tr>
<TR bgcolor="#CCCC99">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="2" FACE="Verdana, Arial"><B>Email Address</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Email" VALUE="" SIZE=30 MAXLENGTH=70></td></tr>
<TR bgcolor="#CCCC99">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="2" FACE="Verdana, Arial"><B>Number of Posts</B></FONT></td>
<td><SELECT NAME="Math">
	<OPTION VALUE="GT"> \>=
	<OPTION VALUE="LT"> \<=
	<OPTION VALUE="EQ"> ==

</SELECT>
<INPUT TYPE="TEXT" NAME="Posts" VALUE="" SIZE=3 MAXLENGTH=5></td></tr>
</table>
<BR>
<table border=2>
<tr>
<td width=25 bgcolor="#CCCC99"><INPUT TYPE="CHECKBOX" NAME="ViewEntire" VALUE="Yes"></td>
<td bgcolor="#dedfdf">
<FONT SIZE="2" face="Verdana, Arial"><B>If you want to view the entire list of users rather than conduct a search, check this box (not recommended for large membership sites since it could take a long time to process).</B></FONT></td></tr></table>
</BLOCKQUOTE>
<br><br>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Search Now">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Erase Search Fields">
</CENTER></form>
<br><br>
<CENTER><B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></B>
<br><br>Powered by: <FONT SIZE="2" FACE="Verdana" COLOR="#C0C0C0">Ultimate Bulletin Board, 
&copy; Madrona Park, Inc., 1998.
</FONT></CENTER>
</FONT>
</BODY>
</HTML>
permissHTML
} ## END Permissions ##

sub Variables {
$PageTitle = "Set Variables";
&HEADERHTML;

print<<VARHTML;
As an authorized administrator, you may customize your bulletin board on the fly, without having to edit a variable file by hand.  There are many different kinds of variables, all customizable by you, but they fall into three primary groups: general variables, forum variables, and style variables.
<p>
To configure your bulletin board variables for the first time, <A HREF="cpanel2.cgi?action=DoGenVars">click here</A>.
<P>
To revise existing variables, you must first identify yourself, so that we can verify your status as an administrator.

<P><center>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=1>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendvarID">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</center>
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Copyright, Madrona Park, Inc., 1998.
</FONT>
</CENTER>
</BODY>
</HTML>
VARHTML
}


sub SetMods {
$PageTitle = "Set Moderators";
&HEADERHTML;

print<<ModTOP;

<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may set moderators.  Identify yourself below.</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="mods">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<p>
<center>
<table border=0 width=95% cellpadding=5>
<TR bgcolor="#EFF5F3">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Forum Name</B></FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Current Moderator</B></FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Change to:</B></FONT>
</td>
ModTOP

#get current moderator info
$ForumTotal = &GetTotalForums;

for ($x = 1; $x <= $ForumTotal; $x++) {

@thisforum = &GetForumRecord($x);

$ForumName = "$thisforum[1]";
$Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;

print<<MIDMOD;
<TR bgcolor="#F7F7F7">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$ForumName</B></FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$Moderator</FONT>
</td>
<td>
<INPUT TYPE="HIDDEN" NAME="OldMod$x" VALUE="$Moderator">
<INPUT TYPE="TEXT" NAME="NewMod$x" VALUE="$Moderator" SIZE=25 MAXLENGTH=25>
</td>
MIDMOD

} ##END FOREACH $line


print<<TRUEBOTTOM;
</table>
<P>
<CENTER>

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Changes">
</CENTER>

</FORM>
</BODY></HTML>
TRUEBOTTOM

}  ## END SET MODS SR ##


sub Prune {
$PageTitle = "Edit/Delete/Prune Messages";
&HEADERHTML;

print<<PruneHTML;

<B><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">Note: only moderators and administrators may edit or prune messages.  Moderators may only make changes for their particular forums.  Identify yourself below.</FONT></B>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)" >
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<p>

<FONT SIZE="2" FACE="Verdana" COLOR="#800000"><B>What would you like to do? (Select one.)</B>
<p>
</FONT>
<table border=0 cellpadding=10>
<TR>
<td>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Prune" CHECKED>
</td>
<td><FONT SIZE="2" FACE="Verdana"><B><FONT COLOR="#000080">Prune Messages</FONT> - a mass-delete function that will delete all messages from a forum or forums based on a time-period cut-off that you select.</B></FONT>
</td>
<TR>
<td>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Edit">
</td>
<td><FONT SIZE="2" FACE="Verdana"><B><FONT COLOR="#000080">Edit/Delete A Message</FONT> - edit or delete a particular message.  If you edit, a note will appear on the message that it has been altered by an administrator/moderator.</B></FONT>
</td>
</table>
<p>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Choice">

</center>
</FORM>
</BODY></TABLE>
PruneHTML
}  ## END Prune SR

sub HEADERHTML {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserName.value = getCookie("UserNameCP");
document.THEFORM.Password.value = getCookie("PasswordCP");
	}  else {
	document.THEFORM.UserName.focus();
}
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
HEADER
} #end HEADERHTML sr

sub GetBio4Admin {

@thisprofile = &OpenProfile("$UserName.cgi");

$EmailField = "<A HREF=\"mailto:$thisprofile[2]\">$thisprofile[2]</A>";

&ViewBioCPHTML;
}  ## END GET BIO sr


sub ViewBioCPHTML {

print <<BioHTML;
<HTML>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Profile for $thisprofile[0]</B></FONT>
<HR>
<BLOCKQUOTE>
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Date Registered:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$DateRegistered</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Status:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[8]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Total Posts:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[7]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Current Email:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$EmailField</FONT>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><A HREF="$thisprofile[3]" target=_top>$thisprofile[3]</A></font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[5]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Location:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[6]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[9]</font>
</td></tr>
</table>
</BLOCKQUOTE>
<HR>
</BODY></HTML>
BioHTML
}  ## END View BIO HTML sr

sub Colors {
print<<TheColors;
<OPTION value="" selected> Select New Color?
		<OPTION value="#ffffff" > White
        <OPTION value="#ff0000" > Red
        <OPTION value="#00ff00" > Green 
        <OPTION value="#0000ff" > Blue 
        <OPTION value="#ff00ff" > Magenta 
        <OPTION value="#00ffff" > Cyan
        <OPTION value="#ffff00" > Yellow 
        <OPTION value="#000000" > Black 
        <OPTION value="#70db93" > Aquamarine 
        <OPTION value="#a62a2a" > Brown 
        <OPTION value="#b87333" > Copper
        <OPTION value="#ff7f00" > Coral
        <OPTION value="#871f78" > Dark Purple
        <OPTION value="#97694f" > Dark Tan
        <OPTION value="#238e23" > Forest Green
        <OPTION value="#cd7f32" > Gold
        <OPTION value="#a8a8a8" > Grey
        <OPTION value="#9f9f5f" > Khaki
        <OPTION value="#c0d9d9" > Light Blue
		<OPTION value="#808000" > Light Copper
        <OPTION value="#cccccc" > Light Grey
        <OPTION value="#ffffcc" > Light Yellow
        <OPTION value="#32cd32" > Lime Green
        <OPTION value="#8e236b" > Maroon
        <OPTION value="#2f2f4f" > Midnight Blue
		<OPTION value="#000080" > Navy Blue
        <OPTION value="#ff7f00" > Orange
        <OPTION value="#8FBC8F" > Pale Green
        <OPTION value="#BC8F8F" > Pink
        <OPTION value="#E6E8fA" > Silver
        <OPTION value="#3299CC" > Sky Blue
		<OPTION value="#F7F7F7" > UBB Col1 Grey
		<OPTION value="#DEDFDF" > UBB Col2 Grey
        <OPTION value="#CC3299" > Violet
		<OPTION value="" > Other (type code)... 
			</SELECT>&nbsp;&nbsp;
TheColors
} # end colors sr
