/*#############################################################################
# RASMNGR.H
#
# RAS Connection Manager Control DLL
#
# SCA Software International S.A.
# http://www.scasoftware.com
# scaadmin@scasoftware.com
#
#############################################################################*/

#ifndef __RASMNGRDLL_H__
#define __RASMNGRDLL_H__

// Error code
#define RASCONTROL_SUCCESS        0
#define RASCONTROL_NOSERVER       1
#define RASCONTROL_TOOFAST        2
#define RASCONTROL_NOTREGISTERED  3

// Connection status
#define ST_CONFIGURATION    0
#define ST_IDLE             1
#define ST_CONNECTING       2
//#define ST_CONNECTED      3
#define ST_DISCONNECTING    4
//#define ST_DISCONNECTED   5
#define ST_ONLINE           6

typedef struct TAG_INFO {
  UINT Status;            // One of connection status constants
  BOOL ManualCall;        // TRUE for manual call, FALSE for automatic call
  CHAR LoginName[64];     // Login name
  CHAR EntryName[128];    // Phonebook entry name
  CHAR ClientIP[16];      // Local machine TCP/IP address
  CHAR ServerIP[16];      // Remote machine TCP/IP address
} INFO;

int __stdcall RASConnManDial(BOOL *success);
int __stdcall RASConnManHangup(BOOL *success);
int __stdcall RASConnManInfo(BOOL *success, INFO *info);
int __stdcall RASConnManStart(void);
int __stdcall RASConnManQuit(BOOL *success);

#endif

/*#############################################################################
# End of file RASMNGR.H
#############################################################################*/
