// ControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Control.h"
#include "ControlDlg.h"

#include "..\rasmngr\rasmngr.h"

#pragma comment (lib, "..\\rasmngr\\RasMngr.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg dialog

CControlDlg::CControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
	DDX_Control(pDX, IDC_COMMAND, CommandEd);
	DDX_Control(pDX, IDC_STATUS, StatusEd);
	DDX_Control(pDX, IDC_RETCODE, RetcodeEd);
	DDX_Control(pDX, IDC_SERVER, ServerEd);
	DDX_Control(pDX, IDC_LOGIN_NAME, LoginNameEd);
	DDX_Control(pDX, IDC_ENTRY_NAME, EntryNameEd);
	DDX_Control(pDX, IDC_CLIENT, ClientEd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_DIAL, OnDial)
	ON_BN_CLICKED(IDC_HANGUP, OnHangup)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_INFO, OnInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg message handlers

BOOL CControlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
  clearFields();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CControlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CControlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

LPCTSTR explainReturnCode(int retcode)
{
  char *text[] = {
    "Success",
    "Server not running",
    "Functions called too fast",
    "Server not registered in registry"
  };
  return (LPCTSTR)text[retcode];
}

LPCTSTR explainMode(int mode)
{
  char *text[] = {
    "Configuration",
    "Idle",
    "Connecting",
    "",
    "Disconnecting",
    "",
    "Online"
  };
  return (LPCTSTR)text[mode];
}

LPCTSTR explainSuccess(BOOL success)
{
  if (success) {
    return (LPCTSTR)"Command accepted";
  } else {
    return (LPCTSTR)"Command not accepted";
  }
}

void CControlDlg::clearFields(void)
{
  RetcodeEd.SetWindowText("");  
  CommandEd.SetWindowText("");
  StatusEd.SetWindowText("");
  LoginNameEd.SetWindowText("");
  EntryNameEd.SetWindowText("");
  ClientEd.SetWindowText("");
  ServerEd.SetWindowText("");
}

void CControlDlg::OnDial() 
{
  BOOL success;
  clearFields();
  int retcode = RASConnManDial(&success);
  RetcodeEd.SetWindowText(explainReturnCode(retcode));  
  CommandEd.SetWindowText(explainSuccess(success));
}

void CControlDlg::OnHangup() 
{
  BOOL success;
  clearFields();
  int retcode = RASConnManHangup(&success);
  RetcodeEd.SetWindowText(explainReturnCode(retcode));  
  CommandEd.SetWindowText(explainSuccess(success));
}

void CControlDlg::OnStart() 
{
  clearFields();
  int retcode = RASConnManStart();
  RetcodeEd.SetWindowText(explainReturnCode(retcode));  
  CommandEd.SetWindowText("NA");
}

void CControlDlg::OnQuit() 
{
  BOOL success;
  clearFields();
  int retcode = RASConnManQuit(&success);
  RetcodeEd.SetWindowText(explainReturnCode(retcode));  
  CommandEd.SetWindowText(explainSuccess(success));
}

void CControlDlg::OnInfo() 
{
  BOOL success;
  INFO info;
  clearFields();
  int retcode = RASConnManInfo(&success,&info);
  RetcodeEd.SetWindowText(explainReturnCode(retcode));  
  CommandEd.SetWindowText(explainSuccess(success));
  if (retcode == RASCONTROL_SUCCESS) {
    StatusEd.SetWindowText(explainMode(info.Status));
    LoginNameEd.SetWindowText(info.LoginName);
    EntryNameEd.SetWindowText(info.EntryName);
    ClientEd.SetWindowText(info.ClientIP);
    ServerEd.SetWindowText(info.ServerIP);
  }
}
