//This test program shows how to use flash
//and uses 'write_flash' and 'write_flash' calls
//provided in the 'flash.c' file
//The flash from 0 to FLASH_SIZE is filled and tested
//by numbers. By the end the blinkind of the LED
//connected to B7 indicates success and blinking
//of all LEDs connected to B0-B7 indicates failure

#include "flash.h"

#define FLASH_SIZE 64

//a short delay
void delay( void )
{
    char i = 0, j;
    while( i++ < 150 )
    {
        j = 0;
        while( j++ < 200 )
            nop();
    }
}

main()
{
    char i, a, err = 0;

    disable_interrupt( GIE );
    set_bit( STATUS, RP0 );
    set_tris_b( 0 );
    clear_bit( STATUS, RP0 );
    output_port_b( 0 );

    for( i = 0; i < FLASH_SIZE; i++ )
    {
        write_flash( i, i*2 );
        a = read_flash( i );
        if( a != i*2 )
        {
            err = 1;
            break;
        }
    }

    while( 1 )
    {
        if( err )
        {
            output_port_b( 0 );
            delay();
            output_port_b( 255 );
        }
        else
        {
            output_high_port_b( 7 );
            delay();
            output_low_port_b( 7 );
        }
        delay();
    }
}
