unit FrmMan;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UserMan, StdCtrls, NetApi32, AdvApi32, NTCommon, Menus, FrNew, FrGroup;

type
  TFrmManager = class(TForm)
    UserMan: TNTUserMan;
    cmbComputers: TComboBox;
    Label1: TLabel;
    rbLocal: TRadioButton;
    rbGlobal: TRadioButton;
    lbxGroups: TListBox;
    Label2: TLabel;
    lbxUsers: TListBox;
    MainMenu1: TMainMenu;
    Menu1: TMenuItem;
    NewUser1: TMenuItem;
    NewGroup1: TMenuItem;
    N1: TMenuItem;
    mniDelete: TMenuItem;
    Propertiy1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure rbLocalClick(Sender: TObject);
    procedure NewUser1Click(Sender: TObject);
    procedure NewGroup1Click(Sender: TObject);
    procedure lbxGroupsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Menu1Click(Sender: TObject);
    procedure mniDeleteClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Propertiy1Click(Sender: TObject);
    procedure lbxUsersClick(Sender: TObject);
    procedure lbxGroupsClick(Sender: TObject);
    procedure cmbComputersChange(Sender: TObject);
    procedure cmbComputersExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmManager: TFrmManager;

implementation

uses FrProper, NT_vs_95;

{$R *.DFM}

procedure TFrmManager.FormCreate(Sender: TObject);
var
  List: TStringList;
begin
  List :=  UserMan.GetServers('');
  try
  cmbComputers.Items.Assign(List);
  if not IsWindowsNT then
    cmbComputers.ItemIndex := cmbComputers.Items.IndexOf(UserMan.GetPrimaryDomainServerName);
  finally
  List.Free;
  end;
  rbLocalClick(nil);
end;

procedure TFrmManager.rbLocalClick(Sender: TObject);
begin
  UserMan.MachineName := Trim(cmbComputers.Text);
  if rbLocal.Checked then lbxGroups.Items.Assign(UserMan.LocalGroups) else
    if rbGlobal.Checked then lbxGroups.Items.Assign(UserMan.GlobalGroups);
  if lbxGroups.Items.Count > 0 then lbxGroups.ItemIndex := 0;
  lbxUsers.Items.Assign(UserMan.Users);
  if lbxUsers.Items.Count > 0 then lbxUsers.ItemIndex := 0;
end;

procedure TFrmManager.NewUser1Click(Sender: TObject);
begin
  with TFrmNew.Create(nil) do
    try
    Caption := 'New user';
    if ShowModal = mrOk then
      begin
      UserMan.Users.Add(Edit1.Text);
      rbLocalClick(nil);
      end;
    finally
    Free;
    end;
end;

procedure TFrmManager.NewGroup1Click(Sender: TObject);
begin
  with TFrmNew.Create(nil) do
    try
    Caption := 'New user';
    if ShowModal = mrOk then
      begin
      if rbLocal.Checked then UserMan.LocalGroups.Add(Edit1.Text);
      if rbGlobal.Checked then UserMan.GlobalGroups.Add(Edit1.Text);
      rbLocalClick(nil);
      end;
    finally
    Free;
    end;

end;

procedure TFrmManager.lbxGroupsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  S: string;
begin
  with Control as TListBox do
    begin
    Canvas.Font.Assign(Font);
    with Canvas do
      if (odFocused in State) then
        begin Brush.Color := clActiveCaption; Font.Color   := clWhite end
      else
      if (odSelected in State) then
        begin Brush.Color := clGray; Font.Color   := clWhite end
      else begin Brush.Color := clWindow;   Font.Color   := clBlack; end;
    Canvas.FillRect(Rect);
    S := Items[Index];
    Canvas.TextRect(Rect, Rect.Left+1, Rect.Top, S);
    end;
end;

procedure TFrmManager.Menu1Click(Sender: TObject);
begin
  mniDelete.Enabled := (ActiveControl = lbxGroups) or (ActiveControl = lbxUsers);
  Propertiy1.Enabled := mniDelete.Enabled;
end;

procedure TFrmManager.mniDeleteClick(Sender: TObject);
begin
  if (ActiveControl = lbxUsers) and (lbxUsers.Items.Count > 0) then
    UserMan.Users.Delete(lbxUsers.ItemIndex)
  else
  if (ActiveControl = lbxGroups) and (lbxGroups.Items.Count > 0) then
    begin
    if rbLocal.Checked then UserMan.LocalGroups.Delete(lbxGroups.ItemIndex);
    if rbGlobal.Checked then UserMan.GlobalGroups.Delete(lbxGroups.ItemIndex);
    end;
  rbLocalClick(nil);
end;

procedure TFrmManager.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TFrmManager.Propertiy1Click(Sender: TObject);
begin
 if (ActiveControl = lbxUsers) then 
  with TFrmProperty.Create(nil) do
    try
    ShowModal;
    finally
    Free;
    end;

 if (ActiveControl = lbxGroups) then 
  with TFrmGroups.Create(nil) do
    try
    ShowModal;
    finally
    Free;
    end;
end;

procedure TFrmManager.lbxUsersClick(Sender: TObject);
begin
  UserMan.UserName := lbxUsers.Items[lbxUsers.ItemIndex];
end;

procedure TFrmManager.lbxGroupsClick(Sender: TObject);
begin
  if rbLocal.Checked then UserMan.LocalGroupName := lbxGroups.Items[lbxGroups.ItemIndex];
  if rbGlobal.Checked then UserMan.GlobalGroupName := lbxGroups.Items[lbxGroups.ItemIndex];
end;

procedure TFrmManager.cmbComputersChange(Sender: TObject);
begin
  (Sender as TControl).Tag := 1;
end;

procedure TFrmManager.cmbComputersExit(Sender: TObject);
begin
  if cmbComputers.Tag > 0 then
    begin
    cmbComputers.Tag := 0;
    rbLocalClick(nil);
    end;
end;

end.
