unit FrRSecur;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, NTCommon, AbstrSec, RegSecur, ExtCtrls, FrRBrows;

type
  TFrmRegSecurity = class(TForm)
    NTRegSecurity1: TNTRegSecurity;
    Label1: TLabel;
    cmbComputer: TComboBox;
    pclAccess: TPageControl;
    tbsAllowedAccess: TTabSheet;
    pnlAccess: TPanel;
    gbxPermissions: TGroupBox;
    rbxFullPermission: TRadioButton;
    rbnOther: TRadioButton;
    lvUsers: TListView;
    grbFlags: TGroupBox;
    cbxObjectInherit: TCheckBox;
    cbxContainer: TCheckBox;
    cbxInheritOnly: TCheckBox;
    cbxNoPropogate: TCheckBox;
    cbxSuccessAudit: TCheckBox;
    cbxFailureAudit: TCheckBox;
    pnlButtons: TPanel;
    btnAdd: TButton;
    btnDelete: TButton;
    tbsDeniedAccess: TTabSheet;
    tbsSystemAlarm: TTabSheet;
    tbsOwnership: TTabSheet;
    pnlOwner: TPanel;
    btnTakeOwnerShip: TButton;
    cbxKamQueryValue: TCheckBox;
    cbxKamSetValue: TCheckBox;
    cbxKamCreateSubKey: TCheckBox;
    cbxKamEnumSubKey: TCheckBox;
    cbxKamNotify: TCheckBox;
    cbxKamCreateLink: TCheckBox;
    cbxKamDelete: TCheckBox;
    cbxKamWriteDAC: TCheckBox;
    cbxKamWriteOwner: TCheckBox;
    cbxKamReadControl: TCheckBox;
    Label2: TLabel;
    cmbRootKey: TComboBox;
    Label3: TLabel;
    edtRegistryPath: TEdit;
    btnBrowse: TButton;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure pclAccessChange(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure cmbComputerChange(Sender: TObject);
    procedure cmbRootKeyChange(Sender: TObject);
    procedure edtRegistryPathExit(Sender: TObject);
    procedure edtRegistryPathKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnTakeOwnerShipClick(Sender: TObject);
    procedure lvUsersChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure cbxObjectInheritClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure lvUsersEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure lvUsersEdited(Sender: TObject; Item: TListItem;
      var S: String);
  private
    { Private declarations }
    OldName: string;
    procedure OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
    procedure SetCheckBoxState(AControl: TCheckBox; State: boolean);
    procedure SetRadioButState(AControl: TRadioButton; State: boolean);
  public
    { Public declarations }
    List: TAccessList;
    procedure RefreshInfo;
  end;

var
  FrmRegSecurity: TFrmRegSecurity;

implementation

{$R *.DFM}
Uses NT_vs_95;

function PermissionsToStr(AMask: DWORD): string;
begin
  Result := '';
  if kamQueryValue     and AMask <> 0 then Result := Result + 'Q';
  if kamSetValue       and AMask <> 0 then Result := Result + 'S';
  if kamCreateSubKey   and AMask <> 0 then Result := Result + 'C';
  if kamEnumSubKey     and AMask <> 0 then Result := Result + 'E';
  if kamNotify         and AMask <> 0 then Result := Result + 'N';
  if kamCreateLink     and AMask <> 0 then Result := Result + 'L';
  if kamDelete         and AMask <> 0 then Result := Result + 'D';
  if kamWriteDAC       and AMask <> 0 then Result := Result + 'W';
  if kamWriteOwner     and AMask <> 0 then Result := Result + 'O';
  if kamReadControl    and AMask <> 0 then Result := Result + 'R';
  if kamFullControl    and AMask <> 0 then Result := 'F';
end;

function FlagsToStr(AFlags: TAceFlags): string;
begin
  Result := '';
  if acfObjInherit in AFlags then Result := Result + 'O';
  if acfContainer  in AFlags then Result := Result + 'C';
  if acfInheritOnly in AFlags then Result := Result + 'I';
  if acfNoPropogate in AFlags then Result := Result + 'N';
  if acfSuccAudit in AFlags then Result := Result + 'S';
  if acfFailAudit in AFlags then Result := Result + 'F';
end;


procedure TFrmRegSecurity.FormCreate(Sender: TObject);
var
  List: TStringList;
begin
  Application.OnShowHint := OnShowHint;
  cmbRootKey.ItemIndex := 2;
  List :=  NTRegSecurity1.GetServers('');
  try
  cmbComputer.Items.Assign(List);
  if not IsWindowsNT then
    cmbComputer.ItemIndex := cmbComputer.Items.IndexOf(NTRegSecurity1.GetPrimaryDomainServerName);
  finally
  List.Free;
  end;
  NTRegSecurity1.MachineName := cmbComputer.Text;
  RefreshInfo;
end;

procedure TFrmRegSecurity.OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
begin
  HintInfo.HintPos.X := HintInfo.HintControl.ClientOrigin.X+20;
  HintInfo.HintPos.Y := HintInfo.HintControl.ClientOrigin.Y;
  CanShow := true;
end;

procedure TFrmRegSecurity.pclAccessChange(Sender: TObject);
begin
  if (pclAccess.ActivePage <> tbsOwnership) then
    begin
    pnlButtons.Parent := pclAccess.ActivePage;
    pnlAccess.Parent  := pclAccess.ActivePage;
    end;
  RefreshInfo;
end;

procedure TFrmRegSecurity.RefreshInfo;
var
  i: integer;
begin
  List := nil;
  lvUsers.Items.Clear;
  if pclAccess.ActivePage = tbsAllowedAccess then List := NTRegSecurity1.AccessAllowed;
  if pclAccess.ActivePage = tbsDeniedAccess  then List := NTRegSecurity1.AccessDenied;
  if pclAccess.ActivePage = tbsSystemAlarm   then try List := NTRegSecurity1.SystemAudit; except List := nil; end;
  pnlOwner.Caption := NTRegSecurity1.KeyOwner;

  if List <> nil then
    for i := 0 to List.Count - 1 do with lvUsers.Items.Add do
      begin
      Caption := List[i].UserName;
      SubItems.Add(PermissionsToStr(List[i].Mask));
      SubItems.Add(FlagsToStr(List[i].Flags));
      end;

  pnlAccess.Enabled := lvUsers.Items.Count > 0;
  SetRadioButState(rbxFullPermission,  false);
  SetRadioButState(rbnOther,           false);
  SetCheckBoxState(cbxKamQueryValue,   false);
  SetCheckBoxState(cbxKamSetValue,     false);
  SetCheckBoxState(cbxKamCreateSubKey, false);
  SetCheckBoxState(cbxKamEnumSubKey,   false);
  SetCheckBoxState(cbxKamNotify,       false);
  SetCheckBoxState(cbxKamCreateLink,   false);
  SetCheckBoxState(cbxKamDelete,       false);
  SetCheckBoxState(cbxKamWriteDAC,     false);
  SetCheckBoxState(cbxKamWriteOwner,   false);
  SetCheckBoxState(cbxKamReadControl,  false);

  btnDelete.Enabled       := lvUsers.Items.Count > 0;
  cbxSuccessAudit.Enabled := pclAccess.ActivePage = tbsSystemAlarm;
  cbxFailureAudit.Enabled := pclAccess.ActivePage = tbsSystemAlarm;
end;

procedure TFrmRegSecurity.SetCheckBoxState(AControl: TCheckBox; State: boolean);
var
  Event: TNotifyEvent;
begin
  Event := AControl.OnClick;
  AControl.OnClick := nil;
  AControl.Checked := State;
  AControl.OnClick := Event;
end;

procedure TFrmRegSecurity.SetRadioButState(AControl: TRadioButton; State: boolean);
var
  Event: TNotifyEvent;
begin
  Event := AControl.OnClick;
  AControl.OnClick := nil;
  AControl.Checked := State;
  AControl.OnClick := Event;
end;


procedure TFrmRegSecurity.btnBrowseClick(Sender: TObject);
begin
  with TFrmRegBrowser.Create(nil) do
    try
    NTRegSecurity1.CurrentPath := edtRegistryPath.Text;
    Component := NTRegSecurity1;
    if ShowModal = mrOk then
      begin
      edtRegistryPath.Text := NTRegSecurity1.CurrentPath;
      RefreshInfo;
      end;
    finally
    Free;
    end;
end;

procedure TFrmRegSecurity.cmbComputerChange(Sender: TObject);
begin
  NTRegSecurity1.MachineName := cmbComputer.Text;
  RefreshInfo;
end;

procedure TFrmRegSecurity.cmbRootKeyChange(Sender: TObject);
begin
  NTRegSecurity1.Rootkey := GetRootValue(cmbRootKey.Text);
  RefreshInfo;
end;

procedure TFrmRegSecurity.edtRegistryPathExit(Sender: TObject);
begin
  RefreshInfo;
end;

procedure TFrmRegSecurity.edtRegistryPathKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if Key = VK_RETURN then
    begin
    NTRegSecurity1.CurrentPath := edtRegistryPath.Text;
    ActiveControl := pclAccess.ActivePage;
    end;
end;

procedure TFrmRegSecurity.btnTakeOwnerShipClick(Sender: TObject);
begin
  NTRegSecurity1.TakeOwnership;
  RefreshInfo;
end;

procedure TFrmRegSecurity.lvUsersChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  AMask:  DWORD;
  AFlags: TAceFlags;
  IsFullControl: boolean;
begin
  if (lvUsers.Items.Count = 0) or (lvUsers.Selected = nil) then Exit;
  AMask  := List[lvUsers.Selected.Index].Mask;
  AFlags := List[lvUsers.Selected.Index].Flags;
  IsFullControl := kamFullControl and AMask <> 0;

  SetRadioButState(rbxFullPermission, IsFullControl);
  SetRadioButState(rbnOther, not IsFullControl);
  SetCheckBoxState(cbxKamQueryValue,   (kamQueryValue   and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamSetValue,     (kamSetValue     and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamCreateSubKey, (kamCreateSubKey and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamEnumSubKey,   (kamEnumSubKey   and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamNotify,       (kamNotify       and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamCreateLink,   (kamCreateLink   and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamDelete,       (kamDelete       and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamWriteDAC,     (kamWriteDAC     and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamWriteOwner,   (kamWriteOwner   and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxKamReadControl,  (kamReadControl  and AMask > 0) and not IsFullControl);

  SetCheckBoxState(cbxObjectInherit, acfObjInherit in AFlags);
  SetCheckBoxState(cbxContainer, acfContainer in AFlags);
  SetCheckBoxState(cbxInheritOnly, acfInheritOnly in AFlags);
  SetCheckBoxState(cbxNoPropogate, acfNoPropogate in AFlags);
  SetCheckBoxState(cbxSuccessAudit, acfSuccAudit in AFlags);
  SetCheckBoxState(cbxFailureAudit, acfFailAudit in AFlags);
end;

procedure TFrmRegSecurity.cbxObjectInheritClick(Sender: TObject);
var
  AMask:  DWORD;
  AFlags: TAceFlags;
  index:  integer;
begin
  if (lvUsers.Selected = nil) or (List = nil) then Exit;
  AMask := 0;
  AFlags := [];
  if (Sender is TCheckBox) and (TCheckBox(Sender).Parent = gbxPermissions) then
    begin
    SetRadioButState(rbxFullPermission, false);
    SetRadioButState(rbnOther, true);
    end;

  if cbxKamQueryValue.Checked then    AMask := AMask or kamQueryValue;
  if cbxKamSetValue.Checked then      AMask := AMask or kamSetValue;
  if cbxKamCreateSubKey.Checked then  AMask := AMask or kamCreateSubKey;
  if cbxKamEnumSubKey.Checked then    AMask := AMask or kamEnumSubKey;
  if cbxKamNotify.Checked then        AMask := AMask or kamNotify;
  if cbxKamCreateLink.Checked then    AMask := AMask or kamCreateLink;
  if cbxKamDelete.Checked then        AMask := AMask or kamDelete;
  if cbxKamWriteDAC.Checked then      AMask := AMask or kamWriteDAC;
  if cbxKamWriteOwner.Checked then    AMask := AMask or kamWriteOwner;
  if cbxKamReadControl.Checked then   AMask := AMask or kamReadControl;
  if rbxFullPermission.Checked then   AMask := kamFullControl;

  if cbxObjectInherit.Checked then AFlags := AFlags + [acfObjInherit];
  if cbxContainer.Checked then AFlags := AFlags + [acfContainer];
  if cbxInheritOnly.Checked then AFlags := AFlags + [acfInheritOnly];
  if cbxNoPropogate.Checked then AFlags := AFlags + [acfNoPropogate];
  if cbxSuccessAudit.Checked then AFlags := AFlags + [acfSuccAudit];
  if cbxFailureAudit.Checked then AFlags := AFlags + [acfFailAudit];

  index := lvUsers.Selected.Index;
  List[Index].Mask := AMask;
  List[Index].Flags := AFlags;
    
  RefreshInfo;
  lvUsers.Selected := lvUsers.Items[index];
end;

procedure TFrmRegSecurity.btnAddClick(Sender: TObject);
begin
  if (List = nil) then Exit;
  List.Add(GetEveryOneName(''), 0, []);
  RefreshInfo;
  lvUsers.Selected := lvUsers.Items[lvUsers.Items.Count - 1];
end;

procedure TFrmRegSecurity.btnDeleteClick(Sender: TObject);
begin
  if (lvUsers.Items.Count = 0) or
     (lvUsers.Selected = nil) or
     (List = nil) then Exit;
  List.Delete(lvUsers.Selected.Index);
  RefreshInfo;
end;

procedure TFrmRegSecurity.lvUsersEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  OldName := lvUsers.Selected.Caption;
end;

procedure TFrmRegSecurity.lvUsersEdited(Sender: TObject; Item: TListItem;
  var S: String);
var
  index: integer;
begin
  index := lvUsers.Selected.Index;
  try
  List[Index].UserName := S;
  except
  S := OldName; raise;
  end;
end;

end.
