unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ComCtrls, ExtCtrls, WinSVC, TService, NTCommon;

type
  TFrmServiceManager = class(TForm)
    lbxServices: TListBox;
    Label1: TLabel;
    cbxDevices: TCheckBox;
    btnRefresh: TButton;
    btnNewService: TButton;
    BtnDelete: TButton;
    btnProperties: TButton;
    btnClose: TButton;
    btnStart: TButton;
    btnStop: TButton;
    tmrWait: TTimer;
    cbxReadOnly: TCheckBox;
    NTService: TNTService;
    cmbComputer: TComboBox;
    procedure btnRefreshClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbxDevicesClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure lbxServicesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BtnDeleteClick(Sender: TObject);
    procedure btnNewServiceClick(Sender: TObject);
    procedure btnPropertiesClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure lbxServicesClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure tmrWaitTimer(Sender: TObject);
    procedure cbxReadOnlyClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetButtonStates;
    procedure Wait;
  public
    { Public declarations }
    List: TEnumList;
  end;

var
  FrmServiceManager: TFrmServiceManager;

implementation

{$R *.DFM}

Uses
  FrmNewSc, FrmProp, NT_vs_95;


procedure TFrmServiceManager.btnRefreshClick(Sender: TObject);
var
  AType: TEnumSevices;
  i: integer;
begin
  NTService.ActiveManager := false;
  AType := [PROCESS];
  if cbxDevices.Checked then AType := AType + [DRIVER];
  NTService.MachineName := Trim(cmbComputer.Text);
  NTService.ManagerAccess := [M_CONNECT, M_ENUMERATE_SERVICE];
  if List <> nil then begin List.Free; List := nil; end;
  lbxServices.Clear;
  List := NTService.GetServiceList([STATE_ACTIVE, STATE_INACTIVE], AType);
  for i := 0 to List.Count - 1 do lbxServices.Items.Add(List[i].ServiceName);
  NTService.ActiveManager := false;
  if lbxServices.Items.Count > 0 then lbxServices.ItemIndex := 0;
  SetButtonStates;  
end;

procedure TFrmServiceManager.FormCreate(Sender: TObject);
var
  List: TStringList;
begin
  with lbxServices do
   ItemHeight := Canvas.TextHeight('A')+2;
//  Animate1.Left := ClientWidth - Animate1.Width;

  List := NTService.GetServers('');
  try
  cmbComputer.Items.Assign(List);
  finally
  List.Free;
  end;
  if not IsWindowsNT then cmbComputer.Text := GetPrimaryDomainServerName;
  btnRefreshClick(nil);
end;

procedure TFrmServiceManager.FormDestroy(Sender: TObject);
begin
  List.Free;
end;

procedure TFrmServiceManager.cbxDevicesClick(Sender: TObject);
begin
  btnRefreshClick(nil);
end;

procedure TFrmServiceManager.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmServiceManager.lbxServicesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  S: string;
  i: integer;
begin
  if (odSelected in State) or (odFocused in State) then
    begin
    lbxServices.Canvas.Brush.Color := clActiveCaption;
    lbxServices.Canvas.Pen.Color := clWhite;
    end else
    begin
    lbxServices.Canvas.Brush.Color := clWindow;
    lbxServices.Canvas.Pen.Color := clBlack;
    end;
  lbxServices.Canvas.FillRect(Rect);
  lbxServices.Canvas.TextRect(Rect, Rect.Left + 1, Rect.Top, List[Index].DisplayedName);
  case List[Index].CurrentState of
   STOPPED:           S := ' Stopped';
   START_PENDING:     S := ' Starting';
   STOP_PENDING:      S := ' Stopping';
   RUNNING:           S := ' Running';
   CONTINUE_PENDING:  S := ' Continueing';
   PAUSE_PENDING:     S := ' Pausing';
   PAUSED:            S := ' Paused';
   else S := ' Unknown';
  end;
  i := lbxServices.Canvas.TextWidth(S);
  Rect.Left := Rect.Right - i;
  lbxServices.Canvas.TextRect(Rect, Rect.Left + 1, Rect.Top, S);
end;

procedure TFrmServiceManager.BtnDeleteClick(Sender: TObject);
begin
  if Application.MessageBox('Are you sure to delete service ?. It may cause system damage !',
                'Warning', IDOK	+ IDCANCEL) = IDCANCEL then Exit;
  NTService.ManagerAccess := [M_CONNECT, M_ENUMERATE_SERVICE];
  NTService.ServiceAccess := [S_ALL_ACCESS];
  NTService.ServiceName   := List[lbxServices.ItemIndex].ServiceName;
  NTService.ActiveManager := true;
  NTService.ActiveService := true;
  NTService.DeleteService;
  NTService.ActiveService := false;
  NTService.ActiveManager := false;
  wait;
  btnRefreshClick(nil);
  Application.MessageBox('The specified service has been marked for deletion.', 'Information', IDOK);
end;

procedure TFrmServiceManager.btnNewServiceClick(Sender: TObject);
begin
  with TFrmNewSevice.Create(nil) do
    try
    if ShowModal = mrOk then
      with NTService do
      begin
      ManagerAccess    := [M_CONNECT, M_CREATE_SERVICE];
      ServiceType      := [WIN32_OWN_PROCESS];
      ErrorControl     := ERROR_NORMAL;
      ServiceName      := EdtServiceName.Text;
      DisplayName      := EdtDisplayName.Text;
      BinaryPathNAme   := EdtFileName.Text;
      ServiceStartName := 'LocalSystem';
      case rgbStartType.ItemIndex of
        0: StartType := AUTO_START;
        1: StartType := DEMAND_START;
        2: StartType := DISABLED;
      end;
      ActiveManager := true;
      CreateService;
      ActiveManager := false;
      wait;
      btnRefreshClick(nil);
      Application.MessageBox('The service has been created successefuly.', 'Information', IDOK);
      end;
    finally
    free;
    end;
end;

procedure TFrmServiceManager.btnPropertiesClick(Sender: TObject);
var
 AServiceType: TServiceTypes;
begin
  with TFrmProperty.Create(nil) do
    try
    btnChange.Enabled := not cbxReadOnly.Checked;
    EdtServiceName.Text := List[lbxServices.ItemIndex].ServiceName;
    NTService.ServiceName   := EdtServiceName.Text;
    NTService.ManagerAccess := [M_CONNECT];
    NTService.ServiceAccess := [S_QUERY_CONFIG];
    NTService.ActiveManager := true;
    NTService.ActiveService := true;
    EdtDisplayName.Text     := NTService.DisplayName;
    EdtBinaryFile.Text      := NTService.BinaryPathName;
    try NTService.GetOrderGroupList(cmbLoadOrder.Items); except end;
    cmbLoadOrder.Text       := NTService.LoadOrder;
    edtOrderWithinGroup.Text := IntToStr(NTService.TagId);
    memDependencies.Lines.Assign(NTService.Dependencies);
    edtAccount.Text         := NTService.ServiceStartName;
    edtPassword.Text        := '****************';
    edtAccount.Tag          := 0;
    edtPassword.Tag         := 0;

    if NTService.StartType = BOOT_START then rgpStartup.ItemIndex := 0 else
    if NTService.StartType = SYSTEM_START then rgpStartup.ItemIndex := 1 else
    if NTService.StartType = AUTO_START then rgpStartup.ItemIndex := 2 else
    if NTService.StartType = DEMAND_START then rgpStartup.ItemIndex := 3 else
    if NTService.StartType = DISABLED then rgpStartup.ItemIndex := 4;

    if NTService.ErrorControl = ERROR_IGNORE then rgpError.ItemIndex := 0 else
    if NTService.ErrorControl = ERROR_NORMAL then rgpError.ItemIndex := 1 else
    if NTService.ErrorControl = ERROR_SEVERE then rgpError.ItemIndex := 2 else
    if NTService.ErrorControl = ERROR_CRITICAL then rgpError.ItemIndex := 3;

    cbxKernelDriver.Checked := KERNEL_DRIVER in NTService.ServiceType;
    cbxFileDriver.Checked := FILE_SYSTEM_DRIVER in NTService.ServiceType;
    cbxAdapter.Checked := ADAPTER in NTService.ServiceType;
    cbxRecognizer.Checked := RECOGNIZER_DRIVER in NTService.ServiceType;
    cmbWin32Own.Checked := WIN32_OWN_PROCESS in NTService.ServiceType;
    cbxWin32Shared.Checked := WIN32_SHARE_PROCESS in NTService.ServiceType;
    cbxInteractive.Checked := INTERACTIVE_PROCESS in NTService.ServiceType;

    NTService.ActiveService := false;
    NTService.ActiveManager := false;
    if ShowModal = mrOk then
      if Application.MessageBox('Are you sure to change service properties?. It may cause system damage !',
                'Warning', MB_OKCANCEL	) = IDOK then
        begin
        NTService.ManagerAccess := [M_CONNECT, M_MODIFY_BOOT_CONFIG];
        NTService.ServiceAccess := [S_ALL_ACCESS];
        NTService.ActiveManager := true;
        NTService.ActiveService := true;

        try
        AServiceType := [];
        if cbxKernelDriver.Checked then AServiceType := AServiceType +[KERNEL_DRIVER];
        if cbxFileDriver.Checked   then AServiceType := AServiceType +[FILE_SYSTEM_DRIVER];
        if cbxAdapter.Checked      then AServiceType := AServiceType +[ADAPTER];
        if cbxRecognizer.Checked   then AServiceType := AServiceType +[RECOGNIZER_DRIVER];
        if cmbWin32Own.Checked     then AServiceType := AServiceType +[WIN32_OWN_PROCESS];
        if cbxWin32Shared.Checked  then AServiceType := AServiceType +[WIN32_SHARE_PROCESS];
        if cbxInteractive.Checked  then AServiceType := AServiceType +[INTERACTIVE_PROCESS];
        NTService.ServiceType := AServiceType;

        case rgpStartup.ItemIndex of
         0: NTService.StartType := BOOT_START;
         1: NTService.StartType := SYSTEM_START;
         2: NTService.StartType := AUTO_START;
         3: NTService.StartType := DEMAND_START;
         4: NTService.StartType := DISABLED;
        end;
        
        case rgpError.ItemIndex of
         0: NTService.ErrorControl := ERROR_IGNORE;
         1: NTService.ErrorControl := ERROR_NORMAL;
         2: NTService.ErrorControl := ERROR_SEVERE;
         3: NTService.ErrorControl := ERROR_CRITICAL;
        end; 

        NTService.BinaryPathName      := EdtBinaryFile.Text;
        NTService.DisplayName         := EdtDisplayName.Text;
        NTService.LoadOrder           := cmbLoadOrder.Text;
        NTService.Dependencies        := memDependencies.Lines;
        if  (edtAccount.Tag > 0) or (edtPassword.Tag > 0) then
          begin
          NTService.Password            := edtPassword.Text;
          NTService.ServiceStartName    := edtAccount.Text;
          end;

        finally
        NTService.ActiveService := false;
        NTService.ActiveManager := false;
        end;

        wait;
        btnRefreshClick(nil);
        end;
    finally
    Free;
    end;
end;


procedure TFrmServiceManager.btnStartClick(Sender: TObject);
begin
  wait;
  NTService.ManagerAccess := [M_CONNECT, M_ENUMERATE_SERVICE];
  NTService.ServiceAccess := [S_ALL_ACCESS];
  NTService.ServiceName   := List[lbxServices.ItemIndex].ServiceName;
  NTService.ActiveManager := true;
  NTService.ActiveService := true;
  NTService.StartService;
  NTService.ActiveService := false;
  NTService.ActiveManager := false;
  btnRefreshClick(nil);
end;

procedure TFrmServiceManager.lbxServicesClick(Sender: TObject);
begin
  SetButtonStates;
end;

procedure TFrmServiceManager.SetButtonStates;
begin
  if (List <> nil) and (List.Count > 0) then
    begin
    if List[lbxServices.ItemIndex].CurrentState = STOPPED then
      begin
      BtnStart.Enabled := true;
      BtnStop.Enabled := false;
      end;
    if List[lbxServices.ItemIndex].CurrentState = RUNNING then
      begin
      BtnStart.Enabled := false;
      BtnStop.Enabled := true;
      end;
    end else
    begin
    BtnStart.Enabled := false;
    BtnStop.Enabled := false;
    end;


end;


procedure TFrmServiceManager.btnStopClick(Sender: TObject);
begin
  NTService.ManagerAccess := [M_CONNECT, M_ENUMERATE_SERVICE];
  NTService.ServiceAccess := [S_ALL_ACCESS];
  NTService.ActiveManager := true;
  NTService.ServiceName   := List[lbxServices.ItemIndex].ServiceName;
  NTService.ActiveService := true;
  NTService.ControlService(CONTROL_STOP);
  NTService.ActiveService := false;
  NTService.ActiveManager := false;
  wait;
  btnRefreshClick(nil);
end;

procedure TFrmServiceManager.Wait;
var
  i: integer;
begin
//  Animate1.Visible := true;
//  Animate1.Active  := true;
  for i := 0 to ControlCount - 1 do
    if Controls[i] is TButton then (Controls[i] as TButton).Enabled := false;
  tmrWait.Enabled := true;
end;


procedure TFrmServiceManager.tmrWaitTimer(Sender: TObject);
var
  i: integer;
begin
  tmrWait.Enabled := false;
  for i := 0 to ControlCount - 1 do
    if Controls[i] is TButton then (Controls[i] as TButton).Enabled := true;
  btnRefreshClick(nil);
  cbxReadOnlyClick(nil);
  SetButtonStates;
//  Animate1.Visible := false;
//  Animate1.Active  := false;
end;

procedure TFrmServiceManager.cbxReadOnlyClick(Sender: TObject);
begin
  btnDelete.Enabled := not cbxReadOnly.Checked;
  btnNewService.Enabled := not cbxReadOnly.Checked;
end;

end.
