unit FrProp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, FilSecur, NTCommon, AbstrSec;

type
  TFrmSecProperty = class(TForm)
    pclAccess: TPageControl;
    BtnClose: TButton;
    tbsAllowedAccess: TTabSheet;
    tbsDeniedAccess: TTabSheet;
    tbsSystemAlarm: TTabSheet;
    tbsOwnership: TTabSheet;
    pnlAccess: TPanel;
    gbxPermissions: TGroupBox;
    rbxFullPermission: TRadioButton;
    pnlButtons: TPanel;
    btnAdd: TButton;
    btnDelete: TButton;
    btnTakeOwnerShip: TButton;
    pnlOwner: TPanel;
    cbxRead: TCheckBox;
    cbxWrite: TCheckBox;
    cbxExecute: TCheckBox;
    cbxDelete: TCheckBox;
    cbxPermission: TCheckBox;
    cbxOwnership: TCheckBox;
    rbnOther: TRadioButton;
    lvUsers: TListView;
    grbFlags: TGroupBox;
    cbxObjectInherit: TCheckBox;
    cbxContainer: TCheckBox;
    cbxInheritOnly: TCheckBox;
    cbxNoPropogate: TCheckBox;
    cbxSuccessAudit: TCheckBox;
    cbxFailureAudit: TCheckBox;
    procedure pclAccessChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnTakeOwnerShipClick(Sender: TObject);
    procedure cbxReadClick(Sender: TObject);
    procedure lvUsersChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure lvUsersEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure lvUsersEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
  private
    { Private declarations }
    OldName: string;
    procedure SetCheckBoxState(AControl: TCheckBox; State: boolean);
    procedure SetRadioButState(AControl: TRadioButton; State: boolean);
  public
    { Public declarations }
    List: TAccessList;
    procedure RefreshInfo;
  end;

var
  FrmSecProperty: TFrmSecProperty;

implementation

{$R *.DFM}

Uses FrFileS, NT_vs_95;

function PrmissionsToStr(AMask: DWORD): string;
begin
  Result := '';
  if famRead and AMask <> 0 then Result := Result + 'R';
  if famWrite and AMask <> 0 then Result := Result + 'W';
  if famExecute and AMask <> 0 then Result := Result + 'X';
  if famDelete and AMask <> 0 then Result := Result + 'D';
  if famPermissions and AMask <> 0 then Result := Result + 'P';
  if famOwnership and AMask <> 0 then Result := Result + 'O';
  if famFullControl and AMask <> 0 then Result := 'F';
end;

function FlagsToStr(AFlags: TAceFlags): string;
begin
  Result := '';
  if acfObjInherit in AFlags then Result := Result + 'O';
  if acfContainer  in AFlags then Result := Result + 'C';
  if acfInheritOnly in AFlags then Result := Result + 'I';
  if acfNoPropogate in AFlags then Result := Result + 'N';
  if acfSuccAudit in AFlags then Result := Result + 'S';
  if acfFailAudit in AFlags then Result := Result + 'F';
end;

procedure TFrmSecProperty.pclAccessChange(Sender: TObject);
begin
  if (pclAccess.ActivePage <> tbsOwnership) then
    begin
    pnlButtons.Parent := pclAccess.ActivePage;
    pnlAccess.Parent  := pclAccess.ActivePage;
    end;
  RefreshInfo;
end;

procedure TFrmSecProperty.RefreshInfo;
var
  i: integer;
begin
  List := nil;
  with FrmFileSecurity do
    begin
    if pclAccess.ActivePage = tbsAllowedAccess then List := FileSecurity1.AccessAllowed;
    if pclAccess.ActivePage = tbsDeniedAccess  then List := FileSecurity1.AccessDenied;
    if pclAccess.ActivePage = tbsSystemAlarm   then try List := FileSecurity1.SystemAudit; except List := nil; end;
    pnlOwner.Caption := FileSecurity1.FileOwner;
    end;
    
  lvUsers.Items.Clear;
  if List <> nil then
    for i := 0 to List.Count - 1 do with lvUsers.Items.Add do
       begin
       Caption := List[i].UserName;
       SubItems.Add(PrmissionsToStr(List[i].Mask));
       SubItems.Add(FlagsToStr(List[i].Flags));
       end;

  pnlAccess.Enabled := lvUsers.Items.Count > 0;
  SetRadioButState(rbxFullPermission, false);
  SetRadioButState(rbnOther, false);  
  SetCheckBoxState(cbxRead, false);
  SetCheckBoxState(cbxWrite, false);
  SetCheckBoxState(cbxExecute, false);
  SetCheckBoxState(cbxDelete, false);
  SetCheckBoxState(cbxPermission, false);
  SetCheckBoxState(cbxOwnership, false);

  btnDelete.Enabled       := lvUsers.Items.Count > 0;
  cbxSuccessAudit.Enabled := pclAccess.ActivePage = tbsSystemAlarm;
  cbxFailureAudit.Enabled := pclAccess.ActivePage = tbsSystemAlarm;
end;

procedure TFrmSecProperty.FormCreate(Sender: TObject);
begin
  pclAccess.ActivePage := tbsAllowedAccess;
  RefreshInfo;
  lvUsers.Columns[2].Width := lvUsers.ClientWidth + 1;
  lvUsers.Columns[1].Width := lvUsers.ClientWidth - lvUsers.Columns[0].Width;
  Caption := FrmFileSecurity.FileSecurity1.FileName;
end;

procedure TFrmSecProperty.btnTakeOwnerShipClick(Sender: TObject);
begin
  FrmFileSecurity.FileSecurity1.TakeOwnership;
  RefreshInfo;
end;

procedure TFrmSecProperty.cbxReadClick(Sender: TObject);
var
  AMask: DWORD;
  AFlags: TAceFlags;
  index: integer;
begin
  if (lvUsers.Selected = nil) or (List = nil) then Exit;
  AMask := 0;
  AFlags := [];
  if (Sender is TCheckBox) and (TCheckBox(Sender).Parent = gbxPermissions) then
    begin
    SetRadioButState(rbxFullPermission, false);
    SetRadioButState(rbnOther, true);
    end;
    
  if cbxRead.Checked then AMask := AMask or famRead;
  if cbxWrite.Checked then AMask := AMask or famWrite;
  if cbxExecute.Checked then AMask := AMask or famExecute;
  if cbxDelete.Checked then AMask := AMask or famDelete;
  if cbxPermission.Checked then AMask := AMask or famPermissions;
  if cbxOwnership.Checked then AMask := AMask or famOwnership;
  if rbxFullPermission.Checked then AMask := famFullControl;

  if cbxObjectInherit.Checked then AFlags := AFlags + [acfObjInherit];
  if cbxContainer.Checked then AFlags := AFlags + [acfContainer];
  if cbxInheritOnly.Checked then AFlags := AFlags + [acfInheritOnly];
  if cbxNoPropogate.Checked then AFlags := AFlags + [acfNoPropogate];
  if cbxSuccessAudit.Checked then AFlags := AFlags + [acfSuccAudit];
  if cbxFailureAudit.Checked then AFlags := AFlags + [acfFailAudit];

  index := lvUsers.Selected.Index;
  List[Index].Mask := AMask;
  List[Index].Flags := AFlags;
    
  RefreshInfo;
  lvUsers.Selected := lvUsers.Items[index];
end;

procedure TFrmSecProperty.lvUsersChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  AMask:  DWORD;
  AFlags: TAceFlags;
  IsFullControl: boolean;
begin
  if (lvUsers.Items.Count = 0) or (lvUsers.Selected = nil) then Exit;
  AMask  := List[lvUsers.Selected.Index].Mask;
  AFlags := List[lvUsers.Selected.Index].Flags;
  IsFullControl := AMask and famFullControl <> 0;

  SetRadioButState(rbxFullPermission, IsFullControl);
  SetCheckBoxState(cbxRead,       (famRead and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxWrite,      (famWrite and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxExecute,    (famExecute and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxDelete,     (famDelete and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxPermission, (famPermissions and AMask > 0) and not IsFullControl);
  SetCheckBoxState(cbxOwnership,  (famOwnership and AMask > 0) and not IsFullControl);

  SetCheckBoxState(cbxObjectInherit, acfObjInherit in AFlags);
  SetCheckBoxState(cbxContainer, acfContainer in AFlags);
  SetCheckBoxState(cbxInheritOnly, acfInheritOnly in AFlags);
  SetCheckBoxState(cbxNoPropogate, acfNoPropogate in AFlags);
  SetCheckBoxState(cbxSuccessAudit, acfSuccAudit in AFlags);
  SetCheckBoxState(cbxFailureAudit, acfFailAudit in AFlags);
end;

  procedure TFrmSecProperty.SetCheckBoxState(AControl: TCheckBox; State: boolean);
var
  Event: TNotifyEvent;
begin
  Event := AControl.OnClick;
  AControl.OnClick := nil;
  AControl.Checked := State;
  AControl.OnClick := Event;
end;

  procedure TFrmSecProperty.SetRadioButState(AControl: TRadioButton; State: boolean);
var
  Event: TNotifyEvent;
begin
  Event := AControl.OnClick;
  AControl.OnClick := nil;
  AControl.Checked := State;
  AControl.OnClick := Event;
end;

procedure TFrmSecProperty.lvUsersEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  OldName := lvUsers.Selected.Caption;
end;

procedure TFrmSecProperty.lvUsersEdited(Sender: TObject; Item: TListItem;
  var S: String);
var
  index: integer;
begin
  index := lvUsers.Selected.Index;
  try
  List[Index].UserName := S;
  except
  S := OldName; raise;
  end;
end;


procedure TFrmSecProperty.btnAddClick(Sender: TObject);
var
  AUserName: string;
begin
  if (List = nil) then Exit;
  if IsWindowsNT then AUserName := GetEveryOneName('') else
     AUserName := GetEveryOneName(FrmFileSecurity.FileSecurity1.MachineName);
  List.Add(AUserName, 0, []);
  RefreshInfo;
  lvUsers.Selected := lvUsers.Items[lvUsers.Items.Count - 1];
end;

procedure TFrmSecProperty.btnDeleteClick(Sender: TObject);
begin
  if (lvUsers.Items.Count = 0) or
     (lvUsers.Selected = nil) or
     (List = nil) then Exit;
  List.Delete(lvUsers.Selected.Index);
  RefreshInfo;
end;

end.
