unit FrmList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  EventLog, StdCtrls, NtCommon, Registry, ComCtrls, Menus, Grids, FrmConn, FrAbout;

type
  TFrmLog = class(TForm)
    HeaderControl1: THeaderControl;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    mniLog: TMenuItem;
    Application1: TMenuItem;
    Security1: TMenuItem;
    System1: TMenuItem;
    N1: TMenuItem;
    Backup1: TMenuItem;
    mniClear: TMenuItem;
    N2: TMenuItem;
    Connect1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Grid1: TStringGrid;
    Open1: TMenuItem;
    EventLog: TNTEventLog;
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure HeaderControl1SectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure HeaderControl1SectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Application1Click(Sender: TObject);
    procedure Backup1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure mniClearClick(Sender: TObject);
    procedure Connect1Click(Sender: TObject);
    procedure EventLogChange(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Grid1DrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
  private
    { Private declarations }
    Items: TList;
    procedure ClearItems;
    procedure RereadEventLog;
    procedure FillGrid;
    procedure OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);

  public
    { Public declarations }
  end;

var
  FrmLog: TFrmLog;

implementation                   

{$R *.DFM}

Uses NT_vs_95;

const
  Sortings:    array[0..6] of byte = (0, 255, 0, 0, 0, 0, 0);
  Headers:     array[0..6] of string = ('','Time ', 'Source ', 'Category ','Event ','User ', 'Computer ');
  CurrentSort: integer=1;
  FormCaption = 'Event reader ';
   
function CompareEvents(Item1, Item2: Pointer): integer;
var
  P1, P2: TEventItem;
begin
  P1 := TEventItem(Item1);
  P2 := TEventItem(Item2);
  Result := 0;
  case CurrentSort of
   0: if P1.EventType > P2.EventType then Result := 1 else if P1.EventType < P2.EventType then Result := -1; 
   1: if P1.TimeGenerated > P2.TimeGenerated then Result := 1 else if P1.TimeGenerated < P2.TimeGenerated then Result := -1;
   2: if P1.SourceName > P2.SourceName then Result := 1 else if P1.SourceName < P2.SourceName then Result := -1;
   3: if P1.EventCategory > P2.EventCategory then Result := 1 else if P1.EventCategory < P2.EventCategory then Result := -1;
   4: if Word(P1.EventId) > word(P2.EventId) then Result := 1 else if Word(P1.EventId) < word(P2.EventId) then Result := -1;
   5: if P1.UserName > P2.UserName then Result := 1 else if P1.UserName < P2.UserName then Result := -1;
   6: if P1.ComputerName > P2.ComputerName then Result := 1 else if P1.ComputerName < P2.ComputerName then Result := -1;
  end;
  if Sortings[CurrentSort] = 0 then begin if Result = 1 then Result := -1 else if Result = -1 then Result := 1; end;
end;

procedure TFrmLog.FormCreate(Sender: TObject);
begin
  Items := TList.Create;
  Application.OnShowHint := OnShowHint;
  Application.HintHidePause := 100000;
  if not IsWindowsNT then Connect1Click(nil);
  EventLog.Active := true;
  RereadEventLog;
  HeaderControl1SectionClick(HeaderControl1, HeaderControl1.Sections[1]);
end;

procedure TFrmLog.RereadEventLog;
var
  i: integer;
  Obj: TEventItem;
begin
 Caption := FormCaption + EventLog.MachineName +'\'+ EventLog.SourceName;
 StatusBar1.SimpleText := '';
 ClearItems;
// EventLog.Items[EventLog.Count - 1]; // this line makes event log read all th items at once
 for i := 0 to EventLog.Count - 1 do
   begin
   Obj := TEventItem.Create(EventLog);
   Obj.Assign(EventLog.Objects[i]);
   Items.Add(Obj);
   end;
 Items.Sort(CompareEvents);
end;

procedure TFrmLog.FillGrid;
var
  i, j: integer;
begin
 Grid1.RowCount  := Items.Count;
 for i := 0 to Grid1.RowCount - 1 do for j := 0 to Grid1.ColCount - 1 do Grid1.Cells[j, i] := '';
 for i := 0 to Items.Count - 1 do
   with TEventItem(Items[i]) do
     begin
       case EventType of
       EVT_SUCCESS, EVT_INFORMATION, EVT_AUDIT_SUCCESS: Grid1.Cells[0, i] := IntToStr(clGreen);
       EVT_WARNING:                                     Grid1.Cells[0, i] := IntToStr(clYellow);
       EVT_ERROR, EVT_AUDIT_FAILURE:                    Grid1.Cells[0, i] := IntToStr(clRed);
       end;
     Grid1.Cells[1, i] := DateTimeToStr(TimeGenerated);
     Grid1.Cells[2, i] := SourceName;
     Grid1.Cells[3, i] := IntToStr(EventCategory);
     Grid1.Cells[4, i] := IntToStr(Word(EventId));
     Grid1.Cells[5, i] := UserName;
     Grid1.Cells[6, i] := ComputerName;
     end;
end;

procedure TFrmLog.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TFrmLog.HeaderControl1SectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
  Ch: char;
begin
  for i := 0 to HeaderControl.Sections.Count - 1 do
    begin
    if HeaderControl.Sections[i] = Section then
      begin
      CurrentSort := i;
      Sortings[i] := Sortings[i] XOR 255;
      if Sortings[i] > 0 then Ch := '+' else Ch := '-';
      end else Ch := #0;
    HeaderControl.Sections[i].Text := Headers[i]+Ch;
    end;
  Items.Sort(CompareEvents);
  FillGrid;
end;

procedure TFrmLog.HeaderControl1SectionResize(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  for i := 0 to HeaderControl.Sections.Count - 1 do
    Grid1.ColWidths[i] := HeaderControl.Sections[i].Width-1;
  Grid1.ColWidths[Grid1.ColCount-1] := 1000;
end;

procedure TFrmLog.FormResize(Sender: TObject);
begin
  HeaderControl1SectionResize(HeaderControl1, nil);
  Grid1.Refresh;
end;

procedure TFrmLog.FormDestroy(Sender: TObject);
begin
  ClearItems;
  Items.Free;
  EventLog.Active := false;
end;

procedure TFrmLog.OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
begin
  if Items.Count > 0 then
    begin
    HintStr := EventLog.Items[TEventItem(Items[Grid1.Row]).Number];
    HintStr := HintStr + #$0D#$0A#$0D#$0A+' Message has '+
               IntToStr(EventLog.Objects[TEventItem(Items[Grid1.Row]).Number].DataLength) +' bytes of data';
    HintInfo.HintPos.x := Grid1.ClientOrigin.x+10;
    HintInfo.HintPos.Y := Grid1.ClientOrigin.Y+(Grid1.Row - Grid1.TopRow+1)* Grid1.DefaultRowHeight;
    if (HintInfo.HintPos.Y > Grid1.ClientOrigin.Y + Grid1.ClientHeight+10) or
       (HintInfo.HintPos.Y < Grid1.ClientOrigin.Y +10) then CanShow := false;
    end else CanShow := false;
end;

procedure TFrmLog.Application1Click(Sender: TObject);
var
  i: integer;
begin
  EventLog.Active     := false;
  for i := 0 to mniLog.Count -1 do mniLog.Items[i].Checked := false;
  (Sender as TMenuItem).Checked := true;
  EventLog.SourceName := (Sender as TMenuItem).Caption;
  EventLog.Active     := true;
  RereadEventLog;
  FillGrid;
end;

procedure TFrmLog.Backup1Click(Sender: TObject);
begin
  With TSaveDialog.Create(nil) do
    try
    Filter     := 'Event Log files (*.EVT)|*.EVT|All files (*.*)|*.*';
    DefaultExt := 'EVT';
    if Execute then
      begin
      EventLog.BackupFileName := FileName;
      EventLog.BackupEventLog;
      end;
    finally
    EventLog.BackupFileName := '';
    Free;
    end;
end;

procedure TFrmLog.Open1Click(Sender: TObject);
begin
  With TOpenDialog.Create(nil) do
    try
    Filter     := 'Event Log files (*.EVT)|*.EVT|All files (*.*)|*.*';
    DefaultExt := 'EVT';
    if Execute then
      begin
      EventLog.BackupFileName := FileName;
      EventLog.Active := false;
      EventLog.Active := true;
      RereadEventLog;
      FillGrid;
      Caption := FormCaption + FileName;
      mniClear.Enabled := false;
      end;
    finally
    Free;
    end;
end;

procedure TFrmLog.mniClearClick(Sender: TObject);
begin
  if Application.MessageBox('Are you shure to delete all items from event log ?', 'Confirmation',
                            MB_OkCancel) = IDCancel then Exit;
  EventLog.Clear;
  RereadEventLog;
  FillGrid;
end;

procedure TFrmLog.Connect1Click(Sender: TObject);
begin
  with TFrmConnect.Create(nil) do
    try
    if ShowModal = mrOk then
      begin
      EventLog.Active := false;
      EventLog.BackupFileName := '';
      EventLog.MachineName := cmbName.Text;
      ClearItems;
      EventLog.Active := true;
      RereadEventLog;
      end;
    finally
    FillGrid;
    Release;
    end;
end;

procedure TFrmLog.EventLogChange(Sender: TObject);
begin
 Beep;
 StatusBar1.SimpleText := 'New item in the Event log !';
end;

procedure TFrmLog.About1Click(Sender: TObject);
begin
  with TFrmAbout.Create(nil) do
    try
    ShowModal;
    finally
    Release;
    end;
end;

procedure TFrmLog.ClearItems;
var
  i: integer;
begin
  for i := 0 to Items.Count - 1 do TObject(Items[i]).Free;
  Items.Clear;
end;

procedure TFrmLog.Grid1DrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
begin
  if Col = 0 then
    begin
    Grid1.Canvas.Brush.Color := StrToIntDef(Grid1.Cells[Col, Row], 0);
    Grid1.Canvas.FillRect(Rect);
    end
end;

end.
