unit FrWrite;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EventLog, NTCommon;

type
  TForm1 = class(TForm)
    EventLog1: TNTEventLog;
    Memo1: TMemo;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Button1: TButton;
    CheckBox1: TCheckBox;
    Button2: TButton;
    Label3: TLabel;
    cmbComputers: TComboBox;
    procedure CheckBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses NT_vs_95;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  EventLog1.IncludeUserName := CheckBox1.Checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  List: TStringList;
begin
  ComboBox1.ItemIndex := 0;
  List := EventLog1.GetServers('');
  try
  cmbComputers.Items.Assign(List);
  if not IsWindowsNT then
    cmbComputers.ItemIndex := cmbComputers.Items.IndexOf(EventLog1.GetPrimaryDomainServerName);
  finally
  List.Free;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  EventLog1.MachineName := cmbComputers.Text;
  EventLog1.Active := true;
  EventLog1.Add(WordToEventType(ComboBox1.ItemIndex), Memo1.Text);
  EventLog1.Active := false;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Obj: TEventItem;
  I: integer;
begin
  EventLog1.MachineName := cmbComputers.Text;
  EventLog1.Active := true;
  Obj := TEventItem.Create(nil);
  With Obj do
  try
    EventID       :=  1000;
    EventType     :=  WordToEventType(ComboBox1.ItemIndex);
    Strings.Assign(Memo1.Lines);
    EventCategory :=  2;
    i             :=  1;
    SetData(@i, SizeOf(i));
    EventLog1.AddObject(Obj);
  finally
  Obj.Free;
  EventLog1.Active := false;
  end;
end;

end.
