#!/usr/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ ubbmisc.cgi -------------
#
#  This file contains miscellaneous functionality for the UBB.
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "mail-lib.pl";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";

};

if (($UseEmail eq "ON") && ($SMTPEmail eq "On")) {
use Socket;
}

&ReadParse;

print ("Content-type: text/html\n\n");

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
			$category = $Value;
	}
		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = &CleanThis($Value);
			$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = &CleanThis($Value);
			$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
			$Location = &CleanThis($Value);
			$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = &CleanThis($Value);
			$Interests = &PipeCleaner($Value);
	}
		if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$PageBackground");
}

$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

		$SubjectCoded = &HTMLIFY($TopicSubject);
		$SubjectCoded =~ tr/ /+/;


if ($in{'action'} eq "sockettest") {
 &SocketTest;
 }  
if ($in{'action'} eq "processclose") {
 &ProcessClose;
 }  

if ($in{'action'} eq "getannounce") {
 &GetAnnounce;
 }
  
if ($in{'action'} eq "getbio") {
 &GetBio;
 } 
 
if ($in{'action'} eq "editbio") {
 &EditBio;
 } 
if ($in{'action'} eq "setprefs") {
 &SetPrefs;
 } 
 if ($in{'action'} eq "PrefsSubmit") {
 &PrefsSubmit;
 } 
if ($in{'action'} eq "checkbioid") {
&CheckBioID;
 } 
 
if ($in{'action'} eq "modifybio") {
   &ModifyBio;
 }
  
  if ($in{'action'} eq "RegSubmit") {
 &RegSubmit;
 }
 if ($in{'action'} eq "pwrequest") {
 &PWRequest;
 } 
sub GetBio {
@thisprofile = &OpenProfile("$UserName.cgi");
$EmailView = $thisprofile[11];
$Signature = $thisprofile[12];
chomp($Signature);

if (($EmailBlock eq "ON") || ($EmailView eq "no")) {
$EmailField = "Not available.";
}  else {
$EmailField = "<A HREF=\"mailto:$thisprofile[2]\">$thisprofile[2]</A>";
}
&ViewBioHTML;
}  ## END GET BIO sr

sub CheckBioID {
if (($in{'UserName'} eq "") || ($in{'Password'} eq "")) {
&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
} else {

$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

	if ($NameFound eq "yes") {
		#Check Password Now
		
	@thisprofile = &OpenProfile("$UserName.cgi");
	
         if ($in{'Password'} eq "$thisprofile[1]") {
		     $pwmatch = "true";
			 $Password = $thisprofile[1];
			 $Email = $thisprofile[2];
			 $URL = $thisprofile[3];
			 $Occupation = $thisprofile[5];
			 $Location = $thisprofile[6];
			 $Interests = $thisprofile[9];
			 $Status = $thisprofile[8];
			 $TotalPosts = $thisprofile[7];
			 $Permissions = $thisprofile[4];
			$DateRegistered = $thisprofile[10];
	$EmailView = $thisprofile[11];
	$Signature = $thisprofile[12];
	chomp($Signature);
            &ProcessEdit;
         }
    } ## END IF MEMBER = Username.cgi condition

if ($NameFound ne "yes") {
   &StandardHTML("We have no one registered with that user name.  Use your back button to try again.");
}
if (($NameFound eq "yes") && ($pwmatch ne "true")) {
   	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
}
} # end check for missing fields
}  ## END CheckBioID SR ###


sub ModifyBio {
if (($Email eq "") || ($in{'NewPassword'} eq "") || ($Email !~ /\@/)) {
&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
 }  else {
 
## Confirm UserName and Password to prevent hacking

&OpenProfile("$UserName.cgi");  #returns @profileinfo
$CurrentEmail = "$profileinfo[2]";
$Permissions = "$profileinfo[4]";
$TotalPosts = "$profileinfo[7]";
$Status = "$profileinfo[8]";
$DateRegistered = "$profileinfo[10]";
chomp($DateRegistered);

if ($profileinfo[1] eq "$in{'Password'}") {

## check for duplicate email addresses, if applicable

if ($EmailCheck eq "true") {
&GetMemberListArray;
$duplicate = "";

CHECKEMAIL: for $checkemails(@members) {

open (MEM, "$MembersPath/$checkemails") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profileEM = split (/\|/, $checkemail[0]);
	
if (($Email eq "$profileEM[2]") && ($UserName ne "$profileEM[0]")) {
$duplicate = "yes";
last CHECKEMAIL;
}
} # end for $checkemails

}  #END if Email check eq TRUE

if ($duplicate eq "yes") { 
	&StandardHTML("You cannot use the email address you tried to use.  Another registered user is already using it.");
} else {
# if email verify is on, then we can't let users change
# email address without sending a new password generated
# by system to them
$Password = "$in{'NewPassword'}";
$ModifyWarning = "";

if (($CurrentEmail ne "$Email") && ($UseEmail eq "ON") && ($EmailVerify eq "ON")){
#generate new password
$NewPassword = &GeneratePassword;
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your New Password";
$message = "Hello!\n\r\nBecause you just modified your email address, we have sent you a new password to use for your registration on $BBName.  Your registration information is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $NewPassword\nYour Email Address of record is now: $Email";
$Password = "$NewPassword";
$ModifyWarning = "Note: Because you changed your email address, and because we require email verification, a new password has been issued to you.  This new password has been sent to: $Email.  You may change your password, but you may not change your password and email address at the same time.  Thank you!"; 
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
}  

$Signature = "$in{'Signature'}";
$Signature =~ s/(<IMG SRC)(.*?)(>)//isg;
$Signature =~ s/</&lt;/g;
$Signature =~ s/>/&gt;/g;

$Signature = &ConvertReturns("$Signature");
$OverrideImages = "yes";
$Signature = &UBBCode("$Signature");

&Lock("lock.file");
##print profile fields to file
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") || die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("$Permissions|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("$TotalPosts|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$Interests|");
	print MEMBERSHIP ("$DateRegistered|");
	print MEMBERSHIP ("$in{'EmailView'}|");
	print MEMBERSHIP ("$Signature\n");
close (MEMBERSHIP);
&Unlock("lock.file");
#confirm processing to user, provide links to other places

&BioModifyConfirmHTML;
}
}  else  {
&StandardHTML("Sorry, but you seem to be trying to hack into someone else's profile.  You can not edit someone's profile without knowing their password.");
}

}
}  ## END Modify Bio SR
sub GetAnnounce {
$ForumNumber = $in{'ForumNumber'};
opendir (GETANNC, "$ForumsPath/Forum$ForumNumber/ANNC");
	my @forummsgs = readdir(GETANNC);
closedir (GETANNC);

	my @announcements = grep(/annc/, @forummsgs);
	#now we have all announcements in the forum
	my $announce = "";
	foreach $announce(@announcements) {
		my ($start, $end, $trash) = split("-", $announce);
		&DateCompare("$start", "$end");
		if ($Live eq "true") {
			$sortline = ("$StartJulian|$announce");
			push(@livelist, $sortline);
		}	
	} #end foreach $announce
	$listtotal = @livelist;
	
@sortlist = sort(@livelist);  #the sorted list of announcements
@sortlist = reverse(@sortlist);
#now we need to print the announcements

#set variables needed for announcement page
@thisforum = &GetForumRecord($ForumNumber);

$Moderator = ("Forum" . "$ForumNumber" . "Moderator");
$Moderator = $$Moderator;
$Forum = $thisforum[1];
$CustomTitle = $thisforum[9];
chomp($CustomTitle);
if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}
@theprofile = &OpenProfile("$Moderator.cgi");
$ModeratorEmail = "$theprofile[2]";
$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

&AnnounceTopHTML;       

$AltColor = "$AltColumnColor1";

#print each announcement
foreach $liveannounce(@sortlist) {
($StartCheck, $anncfile) = split(/\|/, $liveannounce);

open (ANNC, "$ForumsPath/Forum$ForumNumber/ANNC/$anncfile");
	@anncinfo = <ANNC>;
close (ANNC);
#format end date
($startdate, $enddate, $trash2) = split("-", $anncfile);
my $StartMonth = substr($startdate, 0, 2);
my $StartDay = substr($startdate, 2, 2);
my $StartYear = substr($startdate, 6, 2);
my $EndMonth = substr($enddate, 0, 2);
my $EndDay = substr($enddate, 2, 2);
my $EndYear = substr($enddate, 6, 2);
if ($DateFormat eq "US") {
$FormatStart = ("$StartMonth/$StartDay/$StartYear");
$FormatEnd = ("$EndMonth/$EndDay/$EndYear");
}  else {
$FormatStart = ("$StartDay/$StartMonth/$StartYear");
$FormatEnd = ("$EndDay/$EndMonth/$EndYear");
}


my $Author = $anncinfo[0];
my $Subject = $anncinfo[1];
my $Status = $anncinfo[2];
my $ForumList = $anncinfo[3];
my $Message	 = $anncinfo[4];
chomp($Author);
chomp($Subject);
chomp($Status);
chomp($ForumList);
chomp($Message);

$StartCheck = ($StartCheck + .99);
if ($StartCheck >= $in{'Session'}) {
$NewGIF = "<IMG SRC=\"$NonCGIURL/posticonnew.gif\"  BORDER=0 ALT=\"New Announcement!\">";
}  else {
$NewGIF = "<IMG SRC=\"$NonCGIURL/posticon.gif\"  BORDER=0 ALT=\"Old Announcement\">";
}


print<<LINE;
<TR $AltColor>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
$Subject
</font>
</td>
<TD valign=top>
<FONT SIZE="1" FACE="$FontFace">
$NewGIF posted by $Author&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace" COLOR="$LinkColor">($FormatStart through $FormatEnd)</FONT><HR>
<FONT SIZE="$TextSize" FACE="$FontFace">$Message</FONT>
</FONT>
<BR>
</td>
</tr>
LINE

if ($AltColor eq "$AltColumnColor1") {
$AltColor = "$AltColumnColor2"
} else {
$AltColor = "$AltColumnColor1"
}
} #end foreach $liveannounce

print <<ALMOSTBOTTOM;
</table><br>

<IMG SRC="$NonCGIURL/posticonnew.gif" BORDER=0 ALT="New Announcement">&nbsp;&nbsp;New Announcement (since you last visited)<BR>
<IMG SRC="$NonCGIURL/posticon.gif" BORDER=0 ALT="New Announcement">&nbsp;&nbsp;Old Announcement <P><center>
ALMOSTBOTTOM

&PageBottomHTML;    #in ubb_library.pl
} #end GetAnnounce sr

sub ProcessClose {

	if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") )  {
			&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
		} else {
# verify admin or mod status

$NameFound = "no";
  if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
    } 

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$UserName.cgi");
	
	if ($in{'Password'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	
	#get moderator for this forum
	$Moderator = ("Forum" . "$number" . "Moderator");
	$Moderator = $$Moderator;

	   if (($AdminStatus eq "true") || ($Moderator eq "$UserName")) {

#open ubb file
@thisthread = &OpenThread("$topic");
@stats = split(/\|\|/, $thisthread[0]);
$Notes = $stats[1];
chomp($stats[4]);


#prepare new stats line
$StatsLine = "A||X||$stats[2]||$stats[3]||$stats[4]";

foreach $row(@thisthread) {
chomp($row);
if ($row =~ m/^A/) {
	push(@revised, $StatsLine);
}  else {
	push(@revised, $row);
}
}

# update ubb file
&Lock("lock.file");
open (FORUM, ">$ForumsPath/Forum$number/$topic"); 
foreach $ubbline(@revised) {
chomp($ubbline);
print FORUM ("$ubbline\n");
}
close (FORUM);
&Unlock("lock.file");


# Send confirmation screen
&Forward("forumdisplay.cgi?action=topics&DaysPrune=$DaysPrune&number=$number&forum=$ForumCoded", "The following thread has been closed:<P>
<font color=\"$LinkColor\"></FONT>$TopicSubject<P>You are being automatically transported to the $Forum forum.");

# re-do the HTML page associated with this file
&CreateThreadHTML("Forum$number", "$topic");

#update threads summary file
&CurrentDate;
&AdjustForClose($number, $topic);

	   }  else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	   
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
	
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} # end missing fields check
} # end process close sr

## HTML CODE ####
  
sub EditBio {
print<<EDITbioHTML;
<HTML>
<HEAD><TITLE>$BBName - Edit Profile</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="3" FACE="$FontFace" COLOR="$TextColor">
$Header
</font>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>Modify Your Profile</B></FONT>
<p>
<FONT SIZE="$TextSize" FACE="$FontFace">
It is your responsibility to keep your profile information up-to-date.  Do not ask the administrator or moderators to do this for you.
<p>
To modify your current profile information, please identify yourself below.

<p>
<FORM ACTION="ubbmisc.cgi" METHOD="POST" NAME="EditProfile">
<table border=0>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>UserName</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="Ultimate.cgi?action=lostpw">Forget your password?</A></font>
</td></tr>
</table>
<center>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="checkbioid">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</center>

</form>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.EditProfile.UserName.focus();
	} else {
	document.EditProfile.UserName.value = getCookie("UserName");
document.EditProfile.Password.value = getCookie("Password");
	}
}  else {
document.EditProfile.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<P>
If you have previously registered, but forgotten your password, <A HREF="Ultimate.cgi?action=lostpw">click here</A>.
<P>
<center>
$Footer
</center>
</FONT>
</BODY></HTML>
EDITbioHTML

}  ##END EDIT BIO SR

sub BioModifyConfirmHTML {
print<<HTML;
<HTML>
<HEAD><TITLE>
Member Profile Modification Confirmation</title>
<script language="JavaScript"> 
<!-- HIDE

expireDate = new Date;
expireDate.setYear(expireDate.getYear()+1);

var nameStorage = getCookie("NameStorage");

var CookieName = escape("$UserName");
var CookiePW = escape("$in{'NewPassword'}");

	if (nameStorage == "no") {
	  	document.cookie = "UserName=" + CookieName + ";";
		document.cookie = "Password=" + CookiePW + ";";
	}
	if (nameStorage == "yes") {
	  	document.cookie = "UserName=" + CookieName + ";expires=" + expireDate.toGMTString() + ";";
document.cookie = "Password=" + CookiePW + ";expires=" + expireDate.toGMTString() + ";";
	}
	if (nameStorage == null) {
	  	document.cookie = "UserName=" + CookieName + ";";
		document.cookie = "Password=" + CookiePW + ";";
	}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</head>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor"><BR><BR>
<p><FONT SIZE="$TextSize" FACE="$FontFace"><B>
Thank you, $UserName.  Your profile has been successfully updated.
<P>
$ModifyWarning
<P>
<table border=0>
<TR>
<TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Return to:</B></FONT></td>
<td valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true">Forums Summary Page</A>
<BR><A HREF="$CGIURL/ubbmisc.cgi?action=editbio">
Edit Your Profile</a>
<BR>
<A HREF="$NonCGIURL/faq.html" target=_blank>Help/FAQ</A>

</B></FONT>

</td></tr></table>
</B>
</FONT>
</body>
</html>
HTML
}  ## END Bio Modify Confirmation sr



sub SetPrefs {
print<<PrefsHTML;
<HTML>
<HEAD>
	<TITLE>$BBName Preferences</TITLE>

</HEAD>
 <BODY $BGColor $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="+1" FACE="$FontFace" COLOR="$LinkColor"><B>
Bulletin Board Preferences

</B></FONT>
<P>
<table border=0>
<tr>
<TD><FONT SIZE="$TextSize" FACE="$FontFace">
<B>You may customize this bulletin board to reflect your preferences.  Currently, there are two preferences that you can set.
<P><ul>


<LI>the option to store your username and password in memory for one year (you won't have to type your name/password at all during that year).  If you check no, your username and password will be saved after you type it once, but only for that browser session (no long-term memory)
<LI>the standard number of days (history) for viewing topics
<BR><BR>
</ul>
</B></FONT>
</td></tr>
</table>
<CENTER>
<FORM NAME="PREFS" METHOD=POST ACTION="ubbmisc.cgi">
<table border=0>

<tr $AltColumnColor1>
<FORM NAME="PREFS" METHOD=POST ACTION="ubbmisc.cgi">
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Store Username & Password in browser memory for 1 year (otherwise you will have to type your username and password once per browser session)</B></FONT></TD>
<TD valign=top><CENTER><FONT SIZE="$TextSize" FACE="$FontFace"><INPUT TYPE="RADIO" NAME="NameStorage" VALUE="yes">
 yes <INPUT TYPE="RADIO" NAME="NameStorage" VALUE="no"> no</font>
</CENTER> </TD>
</TR>

<TR $AltColumnColor2>
	<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Default Topic View:</B></FONT></TD>
	<TD valign=top><CENTER><SELECT NAME="DaysPrune">
	<OPTION value="1">Show topics from last day
	<OPTION value="2">Show topics from last 2 days
	<OPTION value="5">Show topics from last 5 days
	<OPTION value="10">Show topics from last 10 days
	<OPTION value="20">Show topics from last 20 days
	<OPTION value="30">Show topics from last 30 days
	<OPTION value="45">Show topics from last 45 days
	<OPTION value="60">Show topics from last 60 days
	<OPTION value="75">Show topics from last 75 days
	<OPTION value="100">Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
	</SELECT>
</CENTER>
	
 </TD></tr>
</TABLE>
</center>
<BR><BR><CENTER>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="PrefsSubmit">

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Preferences">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Reset">

</CENTER></FORM>
<BR><BR>
<FONT SIZE="1" FACE="$FontFace"><B>Note: Your preferences are stored as cookies in your browser.  Thus, you must be using a cookies-enabled browser (Netscape and Microsoft Internet Explorer both support cookies).  If your browser does not support cookies or you have the cookies option turned off in your browser preferences, the settings you make above will not take affect.  Also, please note that the settings are set to last for one year.  After each year, you will have to reset your preferences.</B></FONT>
<BR>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
if (document.cookie) {
	if (dc.length > 0) {  
	var DaysPrune = getCookie("DaysPrune");
		var NameStorage = getCookie("NameStorage");

	if (NameStorage == "yes") {
		document.PREFS.NameStorage[0].checked = true;
		} else {
		document.PREFS.NameStorage[1].checked = true;
	}
	if (DaysPrune == "1") {
		document.PREFS.DaysPrune[0].selected = true;
	}
	if (DaysPrune == "2") {
		document.PREFS.DaysPrune[1].selected = true;
	}
	if (DaysPrune == "5") {
		document.PREFS.DaysPrune[2].selected = true;
	}
	if (DaysPrune == "10") {
		document.PREFS.DaysPrune[3].selected = true;
	}
	if (DaysPrune == "20") {
		document.PREFS.DaysPrune[4].selected = true;
	}
	if (DaysPrune == "30") {
		document.PREFS.DaysPrune[5].selected = true;
	}
	if (DaysPrune == "45") {
		document.PREFS.DaysPrune[6].selected = true;
	}
	if (DaysPrune == "60") {
		document.PREFS.DaysPrune[7].selected = true;
	}
	if (DaysPrune == "75") {
		document.PREFS.DaysPrune[8].selected = true;
	}
	if (DaysPrune == "100") {
		document.PREFS.DaysPrune[9].selected = true;
	}
		if (DaysPrune == "360") {
		document.PREFS.DaysPrune[10].selected = true;
	}
}  else {
document.PREFS.DaysPrune[4].selected = true;
}
}  else {
document.PREFS.DaysPrune[4].selected = true;

}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//STOP HIDING-->
</SCRIPT>

<center>
$Footer
</center>
</font>

</BODY>
</HTML>
PrefsHTML
}  ## END Set Prefs SR ##


sub PrefsSubmit {
print<<CONFIRMHTML;
<HTML><HEAD>
<meta http-equiv="Refresh" content="3; URL=$CGIURL/Ultimate.cgi">
<SCRIPT LANGUAGE="JavaScript">
<!--HIDE
expireDate = new Date;
expireDate.setYear(expireDate.getYear()+1);
 
var DaysPrune = escape("$in{'DaysPrune'}");
var NameStorage = escape("$in{'NameStorage'}");

document.cookie = "DaysPrune=" + DaysPrune + ";expires=" + expireDate.toGMTString() + ";";
document.cookie = "NameStorage=" + NameStorage + ";expires=" + expireDate.toGMTString() + ";";

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

</HEAD>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Your preferences have been set.  You are being automatically transported to the bulletin board introductory page.  Please wait three seconds.
<P>
<BR><BR>
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">Click here if you do not want to wait any longer (or if your browser does not automatically forward you).</A>
</B><br><br>
</FONT>
</ul></body></html>
CONFIRMHTML
}

sub ViewBioHTML {

if ($thisprofile[10] eq "") {
$DateRegistered = "Not available.";
}  else {
$DateRegistered = "$thisprofile[10]";
}

print <<BioHTML;
<HTML>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Profile for $thisprofile[0]</B></FONT>
<HR>
<BLOCKQUOTE>
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Date Registered:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$DateRegistered</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Status:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[8]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Total Posts:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[7]</FONT>
</td></tr>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Current Email:</B></FONT></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$EmailField</FONT>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor"><A HREF="$thisprofile[3]" target=_top>$thisprofile[3]</A></font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[5]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Location:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[6]</font>
</td></tr>
<TR>
<td><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests:</B></font></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$thisprofile[9]</font>
</td></tr>
</table>
</BLOCKQUOTE>
<HR>
</BODY></HTML>
BioHTML
}  ## END View BIO HTML sr

sub ProcessEdit {

if ($EmailView eq "no") {
	$EVno = "CHECKED";
} else {
	$EVyes = "CHECKED";
}

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$WarningHTML = "Warning: Because we require email verification, if you change your email address, a new password will be created for you and emailed to the new email address you list.  Thus, do not change your email address unless you can retrieve email from it to get your new password.";
}  else {
$WarningHTML = "";
}
	$Signature = &EditUBBConvert("$Signature");
	$Signature =~ s/<p>/\n\r\n/isg;
	$Signature =~ s/<br>/\n/isg;
	if ($AllowSignature eq "YES") {
		$SigStatus = "enabled";
	}	else {
		$SigStatus = "not enabled";
	}
print<<EditHTML;
<HTML>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="3" FACE="$FontFace" COLOR="$TextColor">
$Header

<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>Modify Your Profile</B></FONT>
<p><FONT SIZE="$TextSize" FACE="$FontFace">
Thank you! We have confirmed your identity, $UserName ($Status).
<p>
Feel free to modify any of the fields below.
<p><b>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$WarningHTML</FONT></b>
<P>
</FONT>
<FORM ACTION="ubbmisc.cgi" METHOD="POST">
<table border=0>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Email Address</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Email" VALUE="$Email" SIZE=30 MAXLENGTH=155>
</td></tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Password</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="NewPassword" VALUE="$Password" SIZE=30 MAXLENGTH=155>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Homepage</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="URL" VALUE="$URL" SIZE=30 MAXLENGTH=200>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Occupation</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Occupation" VALUE="$Occupation" SIZE=30 MAXLENGTH=100>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">City, State, Country</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Location" VALUE="$Location" SIZE=30 MAXLENGTH=150>
</td></tr>
<tr>
<td>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Interests</FONT></B>
</td>
<td>
<INPUT TYPE="TEXT" NAME="Interests" VALUE="$Interests" SIZE=50 MAXLENGTH=200>
</td></tr>
<tr>
<td valign=top>
<B><FONT SIZE="$TextSize" FACE="$FontFace">Signature</FONT></B><BR><FONT SIZE="1" FACE="$FontFace">Note: The Signature feature is currently $SigStatus by this bulletin board's administrator.  You may use <A HREF="$NonCGIURL/ubbcode.html">UBB Code</A> in this field, but not HTML.   The UBB Code Image tag is not permitted, however.</font>
</td>
<td>
<TEXTAREA NAME="Signature" ROWS=3 COLS=25>$Signature
</TEXTAREA>
</td></tr>
<tr>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Keep your email address viewable to other users when you post notes?</B></FONT></TD>
<TD valign=top><CENTER><FONT SIZE="$TextSize" FACE="$FontFace"><INPUT TYPE="RADIO" NAME="EmailView" VALUE="yes" $EVyes>
 yes <INPUT TYPE="RADIO" NAME="EmailView" VALUE="no" $EVno> no</font>
</CENTER> </TD>
</TR>
</table>
<center>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="modifybio">
<INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserName">
<INPUT TYPE="HIDDEN" NAME="Password" VALUE="$in{'Password'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Modifications">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields"><center>
$Footer
</center>
</form></font>
</BODY></HTML>
EditHTML
}  ##END Process Edit SR


sub AnnounceTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>$BBName Announcements</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor" topmargin=0>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header
<table border=0 width=$TableWidth>
<tr>
<td align=left valign=top>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle" BORDER=0></A>
<BR>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$LinkColor"><B>$Forum</B>
<br><FONT size= "1" COLOR="$VisitedLinkColor">(moderated by <A HREF="mailto:$ModeratorEmail">$Moderator</A>)
</FONT></font>
</td>
<td valign=top nowrap><FONT SIZE="1" FACE="$FontFace">
<IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">$BBName</A>
<br>
<IMG SRC="$NonCGIURL/tline.gif" WIDTH=12 HEIGHT=12 BORDER=0><IMG SRC="$NonCGIURL/open.gif" WIDTH=15 HEIGHT=11 BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$ForumNumber">$Forum</a>
<P><CENTER><BR>
<A HREF="$CGIURL/ubbmisc.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}"><ACRONYM TITLE="Click here to edit your profile.">profile</ACRONYM></A> | <A HREF="$CGIURL/Ultimate.cgi?action=agree"><ACRONYM TITLE="Registration is free!">register</ACRONYM></A> | <A HREF="$CGIURL/ubbmisc.cgi?action=setprefs"><ACRONYM TITLE="Set your preferences.">prefs</ACRONYM></A> | <A HREF="$NonCGIURL/faq.html" target=_blank><ACRONYM TITLE="Frequently Asked Questions">faq</ACRONYM></A> | <A HREF="$CGIURL/search.cgi?action=intro"><ACRONYM TITLE="Perform a search by keyword, date, or name.">search</ACRONYM></A>
</center>
</FONT>
</td></tr></table>
<P>
<B>Current Announcements: $listtotal</B>
<br>
Note: Announcements are made by bulletin board administrators and moderators only.  You may not reply to these announcements.  
<P>
<table border=0 width=$TableWidth>
<TR $TableColorStrip>
<TD width=35%><FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">
Subject</font>
</td>
<td>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">Announcement</FONT>
</td>
</tr>
TOP
} #end AnnounceTopHTML sr



sub RegSubmit {

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {

	if ( ($in{'UserName'} eq "") || ($in{'Email'} eq "") || ($in{'Email'} !~ /\@/) )  {
		&StandardHTML("You did not properly complete all required form fields!  Remember that you must enter a valid email address.  Please go back and re-enter.");
		} else {
		&GoAhead;
	}

} else {

	if ( ($in{'UserName'} eq "") || ($in{'Email'} !~ /\@/) || 	($in{'Password'} eq "") || ($PasswordConfirm eq "") )  {
		&StandardHTML("You did not properly complete all required form fields!  Remember that you must enter a valid email address.  Please go back and re-enter.");
	}  else {
	
		if ($in{'Password'} eq "$PasswordConfirm") {
			&GoAhead; 
			}  else {
			&StandardHTML("Registration Failed!<P>You failed to type the same password twice on the registration form.  Please go back and try again.<P>Use your back button to try again.");
		}
	}
}
}  ## END RegSubmit SR ##


sub GoAhead  {	
#check for illegal (non alphanumeric characters)
$_ = "$UserNameFile";
if ((m/\W+/) || (m/\b[_]/) || (m/[_]\b/) || (m/_{2,}/)) {
&StandardHTML("The User Name you attempted to register is illegal for one of the following reasons:<P><blockquote>1.  You may have included an illegal character in your User Name.  You should only use letters, numbers, or spaces (apostrophes, for example, are not permitted). You may not begin or end a User Name with a space.  You may not have two or more consecutive spaces.<p>2.  You may have attempted to use a name that doesn't include any letters or numbers.</B></blockquote><p><CENTER>Use your back button to try again.</center>");
}  else {
#check to make sure Username is unique

&GetMemberListArray;

$LCUNFile = "$UserNameFile"; #Get ready to lower case it
	$LCUNFile =~ tr/A-Z/a-z/; #convert to lc for check
$duplicate = "no";


CHECKDUPES: for $checkthis(@members) {
	$checkthisLC = "$checkthis";
	$checkthisLC =~ tr/A-Z/a-z/; #convert to lc for check
	if ($checkthisLC eq "$LCUNFile.cgi") {
		$duplicate = "yes";
		&StandardHTML("Someone else has already registered that UserName.  Please try again.  Use your back button.");
		last CHECKDUPES;
	}
#CHECK to make sure email isn't a duplicate too

if (($duplicate ne "yes") && ($EmailCheck eq "true")) {

open (MEM, "$MembersPath/$checkthis") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profile = split (/\|/, $checkemail[0]);
	
if ($Email eq "$profile[2]") {
$duplicate = "yes";
	&StandardHTML("Someone else has already registered that email address.  Please try again.  Use your back button.");
}
}  #END if duplicate ne yes

}  # end checkdupes loop

if ($duplicate ne "yes") {

	if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {

#generate password
$Password = &GeneratePassword;
}  else {
$Password = "$in{'Password'}";
}

# Get Today's Date so we can log the date of registration

&GetDateTime;

#Prepare Signature - prevent HTML, strip returns, do UBB Code

@censored = split(/ /, $censorwords);
$Signature = &CensorCheck("$in{'Signature'}");
$Signature =~ s/(<IMG SRC)(.*?)(>)//isg;

$Signature =~ s/</&lt;/g;
$Signature =~ s/>/&gt;/g;


$SignatureHTML = &ConvertReturns("$Signature");
$OverrideImages = "yes";
$SignatureHTML = &UBBCode("$SignatureHTML");

## APPEND NEW REGISTRATION TO REG FILE
&Lock ("lock.file");
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");
	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("Write|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("0|");
	print MEMBERSHIP ("Junior Member|");
	print MEMBERSHIP ("$Interests|");
	print MEMBERSHIP ("$HyphenDate|");
	print MEMBERSHIP ("$in{'EmailView'}|");
	print MEMBERSHIP ("$SignatureHTML\n");
close (MEMBERSHIP);
&Unlock ("lock.file");

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your Password";
$message = "Hello!\n\r\nThank you for registering on $BBName.  Your registration is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $Password\nYour Email Address of record is: $Email\n\r\n  Note that you change this password online using the \"edit profile\" button on our bulletin board.  If you change your registered email address, however, a new random password will be emailed to you so that we can verify any new email address you use.\n\r\nAgain, thank you for registering.";
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}

$RegWording1 = "You have successfully registered your User Name for $BBName. ";
$RegWording2 = "Your password has been emailed to you at $Email";
&PrintRegistrationHTML;
}  else {
$RegWording1 = "You have successfully registered your User Name and Password for $BBName. ";
$RegWording2 = "$in{'Password'}";

&PrintRegistrationHTML;
	} # end use email/verify on check
} ### end if dupe ne yes

} # end if/else /m
}  # end GoAhead subroutine

sub PrintRegistrationHTML {
print <<HTML;
<HTML>
<HEAD><TITLE>
User Registration Confirmation</title></head>
 <BODY $BGColor $PageBackground  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header
<table border=0>
<tr><td colspan=2>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Congratulations!
<P>
$RegWording1  Feel free to post messages on any of our forums.  Your registration information is listed below.</B></FONT>
</td></tr>
<tr>
<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>User Name</B></FONT></TD>
<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$UserName</font>
 </TD>
</tr>

<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Password</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$RegWording2</font>
 </TD>
</tr>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Email</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Email</font>
 </TD>
</TR>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>City, State, Country</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Location</font>
 </TD>
</TR>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Occupation</font>
 </TD>
</tr>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$Interests</font>
 </TD>
</tr>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$URL</font>
 </TD>
</tr>

<TR>
	<TD $AltColumnColor1 valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Signature</B></FONT></TD>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$SignatureHTML</font>
 </TD>
</tr>

</TABLE>
<p><FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">Click here to enter the Bulletin Board now!</A><br><br>
</FONT>
<br><br><br><br>.

<SCRIPT LANGUAGE="JavaScript">
<!--HIDE
expireDate = new Date;
expireDate.setYear(expireDate.getYear()+1);

var DaysPrune = escape("$in{'DaysPrune'}");
var NameStorage = escape("$in{'NameStorage'}");
var CookieName = escape("$in{'UserName'}");
var CookiePW =  escape("$in{'Password'}");
var EmailVerify = escape("$EmailVerify");

document.cookie = "DaysPrune=" + DaysPrune + ";expires=" + expireDate.toGMTString() + ";";
document.cookie = "NameStorage=" + NameStorage + ";expires=" + expireDate.toGMTString() + ";";
 
if (EmailVerify == "OFF") {
if (NameStorage == "no") {
	  	document.cookie = "UserName=" + CookieName + ";";
		document.cookie = "Password=" + CookiePW + ";";
	}
if (NameStorage == "yes") {
	  	document.cookie = "UserName=" + CookieName + ";expires=" + expireDate.toGMTString() + ";";
document.cookie = "Password=" + CookiePW + ";expires=" + expireDate.toGMTString() + ";";
	}
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<center>
$Footer
</center></font></body></html>
HTML
} ## END Print Registration sr

sub PWRequest {
# Find the right registration
&GetMemberListArray;  # returns @members array
$Found = "";
CHECKPROFILES: foreach $eachmember(@members) {
				
			@thisprofile = &OpenProfile("$eachmember");
			
				if ($thisprofile[2] eq "$sendto") {
					$YourName = "$thisprofile[0]";
					$YourPassword = "$thisprofile[1]";
					$Found = "yes";
					last CHECKPROFILES;
				}
}

if ($Found eq "yes") {

#Send the Email

$from = "$BBEmail";
$subject = "Your UserName and Password - $BBName";
$message = ("Here is the registration information you requested for $BBName. \n\n Your UserName is: $YourName\n Your Password is: $YourPassword \n\n This bulletin board is located at $CGIURL/Ultimate.cgi \n\nThank you!");
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
#Notify user that email has been sent
&Forward("Ultimate.cgi?action=intro&BypassCookie=true", "Your username and password for this bulletin board have just been emailed to you!<P>You are now being automatically returned to the main forums page.");

}  else {
&StandardHTML("We have no one registered with the email address you listed.  Use your back button to try again.");
}
} #end PWRequest sr

sub AdjustForClose {
$number = shift;
$ThreadFile = shift;

##### create new day summary file, if necessary
unless (-e "$ForumsPath/Forum$number/$RunOnDate.threads") {
my $CreateThreadFile = "yes";
&ForumSummary($number);
}  # end UNLESS THREADS SUMMARY EXISTS
##########

if ($CreateThreadFile ne "yes") {
($threadnum, $junk) = split(/\./, $ThreadFile);

#open thread summary file
open (SUMM, "$ForumsPath/Forum$number/$RunOnDate.threads");
@threadsum = <SUMM>;
close (SUMM);

foreach $checkthis(@threadsum) {
chomp($checkthis);
@checkit = split(/\|\^\|/, $checkthis);

	if ($checkit[3] eq "$threadnum.html") {
		$checkit[7] = "X";
		$newline = join("|^|", @checkit);	
		push(@updatedts, $newline);
	}  else {
		push(@updatedts, $checkthis);
	}
}  # end foreach @threadsum

## @updated contains revised thread summary file

@updatedts = sort(@updatedts);

# print finalarray to file
&Lock("lock.file");
open (THREADS, ">$ForumsPath/Forum$number/$RunOnDate.threads") or die("Unable to open thread summary file");
foreach $one(@updatedts) {
chomp($one);
print THREADS ("$one\n");
}
close (THREADS);
&Unlock("lock.file");

chmod (0666, "$ForumsPath/Forum$number/$RunOnDate.threads");
} #end if day's thread summary does not have to totally created

}  # end Adjust For Close sr

sub SocketTest {
&StandardHTML("The Socket module is installed on your web server.  You may use the Socket option for performing UBB email functions.<P>Use your back button to return to the Variables page.");
}